/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.file.sidebar;

import java.io.IOException;
import java.util.EventObject;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.mvc.base.BaseView;
import kd.bos.mvc.list.ListView;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.swc.hsas.business.salaryfile.SWCSalaryFileServiceHelper;
import kd.swc.hsas.business.salaryfile.SalaryFileSubTableServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCStringUtils;

public abstract class AbstractSalaryFileSubTableHisEdit
extends AbstractBasePlugIn {
    protected static final String ENTRY_ENTITY = "entryentity";
    protected static final String ENTRY_ENTITY_SIZE = "entryentitysize";
    private static final Log LOGGER = LogFactory.getLog(AbstractSalaryFileSubTableHisEdit.class);
    private static final String ADVCONTOOLBARAP = "advcontoolbarap";
    private static final String DELETEENTRY = "deleteentry";
    private static final String BOID = "boId";
    private static final String BAR_SAVE = "bar_save";

    public void registerListener(EventObject event) {
        super.registerListener(event);
        this.addItemClickListeners(new String[]{ADVCONTOOLBARAP});
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "deleteentry": {
                SWCPageCache pageCache = new SWCPageCache(this.getView());
                pageCache.put("isChanged", (Object)Boolean.TRUE);
                break;
            }
        }
    }

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        String entityId = this.getView().getEntityId();
        String boId = this.getModel().getDataEntity().getString("boid");
        String salaryFileId = (String)this.getView().getFormShowParameter().getCustomParam("salaryfileid");
        String personId = (String)this.getView().getFormShowParameter().getCustomParam("personid");
        if (!SWCStringUtils.isEmpty((String)salaryFileId) && !SWCStringUtils.isEmpty((String)personId)) {
            this.embedSalaryFilePreview(personId, salaryFileId);
        }
        String curEntityId = SalaryFileSubTableServiceHelper.getCurrEntity((String)entityId);
        this.addDataMutexLock(curEntityId, boId);
    }

    private void addDataMutexLock(String entityId, String boId) {
        String groupId = MutexHelper.getMutexGroupId((String)entityId, (String)"modify");
        try (DataMutex dataMutex = DataMutex.create();){
            Map<String, String> lockInfo = this.getMutexLockInfo(entityId, boId, groupId, dataMutex);
            if (null != lockInfo && !lockInfo.isEmpty()) {
                this.getView().setEnable(Boolean.FALSE, new String[]{BAR_SAVE});
                this.showMutexNotification(lockInfo);
            } else {
                this.getPageCache().put(BOID, boId);
                this.addMutexLock(entityId, boId, groupId, dataMutex);
            }
        }
        catch (IOException er) {
            LOGGER.error((Throwable)er);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate source = (FormOperate)args.getSource();
        OperateOption option = source.getOption();
        option.setVariableValue("pageId", this.getView().getPageId());
        source.setOption(option);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        DynamicObjectCollection entryentity;
        int size;
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = args.getOperateKey();
        if ("saveafteraudit".equals(operateKey)) {
            OperationResult operationResult = args.getOperationResult();
            if (operationResult != null && operationResult.isSuccess()) {
                this.refreshParentPage();
                this.pageRelease(null);
                String newPkId = operate.getOption().getVariableValue("newPkId", null);
                this.refreshCurrentPage(newPkId);
            }
        } else if ("newentry".equals(operateKey) && (size = (entryentity = this.getModel().getEntryEntity(ENTRY_ENTITY)).size()) > 0) {
            SWCSalaryFileServiceHelper.setCurrencyIntoEntryentity((IFormView)this.getView(), (int)size);
        }
    }

    private void refreshCurrentPage(Object newPkId) {
        if (newPkId == null) {
            return;
        }
        BaseView view = (BaseView)this.getView();
        BaseShowParameter showParameter = (BaseShowParameter)view.getFormShowParameter();
        showParameter.setPkId(newPkId);
        view.cacheFormShowParameter();
        view.load(newPkId);
    }

    private void refreshParentPage() {
        IFormView view = this.getView();
        IFormView parentView = view.getParentView();
        if (parentView instanceof ListView) {
            parentView.invokeOperation("refresh");
            view.sendFormAction(parentView);
        }
    }

    private void showMutexNotification(Map<String, String> lockInfo) {
        Map userInfo;
        String userId = lockInfo.get("userid");
        String operateKey = lockInfo.get("opkey");
        if (!SWCStringUtils.isEmpty((String)userId) && SWCStringUtils.equals((String)operateKey, (String)"modify") && null != (userInfo = UserServiceHelper.getUserInfoByID((long)Long.parseLong(userId)))) {
            String userName = (String)userInfo.get("name");
            if (!SWCStringUtils.isEmpty((String)userName)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"{0}\uff1a\u6b63\u5728\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u5f53\u524d\u65e0\u6cd5\u8fdb\u884c\u4fee\u6539\u3002", (String)"AbstractSalaryFileSubTableHisEdit_0", (String)"swc-hsas-formplugin", (Object[])new Object[]{userName}));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u8bb0\u5f55\u6b63\u5728\u88ab\u5176\u4ed6\u7528\u6237\u7f16\u8f91\uff0c\u65e0\u6cd5\u8fdb\u884c\u4fee\u6539\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"AbstractSalaryFileSubTableHisEdit_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void embedSalaryFilePreview(String personId, String salaryFileId) {
        if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get("emBedPageId"))) {
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("infoflex");
        showParameter.setFormId("hsas_personfile_preview");
        showParameter.setCustomParam("personid", (Object)personId);
        showParameter.setCustomParam("salaryfileid", (Object)salaryFileId);
        showParameter.setSendToClient(true);
        this.getView().showForm(showParameter);
        String pageId = showParameter.getPageId();
        this.getPageCache().put("emBedPageId", pageId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pageRelease(EventObject eventObject) {
        String boId = this.getPageCache().get(BOID);
        if (!SWCStringUtils.isEmpty((String)boId)) {
            String curEntityId = SalaryFileSubTableServiceHelper.getCurrEntity((String)this.getView().getEntityId());
            DataMutex dataMutex = DataMutex.create();
            try {
                dataMutex.release(boId, curEntityId, "modify");
            }
            finally {
                try {
                    dataMutex.close();
                }
                catch (IOException ioException) {
                    LOGGER.error((Throwable)ioException);
                }
            }
        }
    }

    private Map<String, String> getMutexLockInfo(String entityId, String pkId, String groupId, DataMutex dataMutex) {
        return dataMutex.getLockInfo(pkId, groupId, entityId);
    }

    private void addMutexLock(String entityId, String pkId, String groupId, DataMutex dataMutex) {
        dataMutex.require(pkId, groupId, entityId, "modify");
    }
}

