/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.file.sidebar;

import java.util.Collections;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.swc.hsas.business.salaryfile.DefaultEmptyPage;
import kd.swc.hsas.common.enums.DefaultEmptyPageEnum;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCBaseDataHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class SalaryFileSidePlugin
extends AbstractFormPlugin {
    private static final String FLEX_LIST = "flexlist";
    private static final String FLEX_EMPTY = "flexempty";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Boolean isShowLogicDelete = (Boolean)this.getModel().getValue("isshowlogicdelete");
        if (null != isShowLogicDelete) {
            this.showFormView(isShowLogicDelete);
        }
    }

    private void showFormView(boolean isShowLogicDelete) {
        String pageName = (String)this.getView().getFormShowParameter().getCustomParam("currentRelatePage");
        Object salaryFileObj = this.getView().getParentView().getModel().getValue("salaryfile");
        this.showTargetList(pageName, salaryFileObj, isShowLogicDelete);
        if (!SWCStringUtils.equals((String)"hsas_empposorgrel_enthis", (String)pageName)) {
            IFormView view = this.getView();
            if (this.isContainData(pageName, salaryFileObj, isShowLogicDelete)) {
                view.setVisible(Boolean.FALSE, new String[]{FLEX_EMPTY});
                view.setVisible(Boolean.TRUE, new String[]{FLEX_LIST});
            } else {
                DefaultEmptyPage defaultEmptyPage = new DefaultEmptyPage(DefaultEmptyPageEnum.VIEW_DATA_PAGE_TYPE, FLEX_EMPTY, ShowType.InContainer);
                view.showForm(defaultEmptyPage.getFormShowParameter());
                view.setVisible(Boolean.FALSE, new String[]{FLEX_LIST});
                view.setVisible(Boolean.TRUE, new String[]{FLEX_EMPTY});
            }
        }
    }

    private void showTargetList(String pageName, Object salaryFileObj, boolean isShowLogicDelete) {
        IFormView view = this.getView();
        if (!SWCStringUtils.isEmpty((String)pageName) && null != salaryFileObj) {
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.InContainer);
            showParameter.getOpenStyle().setTargetKey(FLEX_LIST);
            showParameter.setFormId("hsbp_nosearch_list");
            showParameter.setBillFormId(pageName);
            showParameter.setLookUp(false);
            showParameter.setCustomParam("nofilter", (Object)Boolean.TRUE);
            showParameter.setCustomParam("notOpenDefaultHyperLink", (Object)"number");
            showParameter.setCustomParam("removeHrDatastatusFilter", (Object)Boolean.TRUE);
            QFilter qFilter = this.getListQFilter(pageName, salaryFileObj, isShowLogicDelete);
            if (null != qFilter) {
                ListFilterParameter filterParams = showParameter.getListFilterParameter();
                filterParams.setQFilters(Collections.singletonList(qFilter));
            }
            SWCPageCache pageCache = new SWCPageCache(view);
            pageCache.put(FLEX_LIST, (Object)showParameter.getPageId());
            showParameter.setCustomParam("option", (Object)"showhisversion");
            showParameter.setCustomParam("hisinfolist", (Object)"hisinfolist");
            QFilter qFilter1 = new QFilter("boid", "=", ((DynamicObject)salaryFileObj).get("id"));
            QFilter qFilter2 = new QFilter("iscurrentversion", "=", (Object)Boolean.FALSE);
            showParameter.getListFilterParameter().getQFilters().add(qFilter2);
            view.showForm((FormShowParameter)showParameter);
        }
    }

    private boolean isContainData(String pageName, Object salaryFileObj, boolean isShowLogicDelete) {
        boolean isContainData = false;
        QFilter qFilter = this.getListQFilter(pageName, salaryFileObj, isShowLogicDelete);
        if (null != qFilter) {
            SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(pageName);
            isContainData = serviceHelper.isExists(new QFilter[]{qFilter});
        }
        return isContainData;
    }

    private QFilter getListQFilter(String pageName, Object salaryFileObj, boolean isShowLogicDelete) {
        QFilter qFilter = null;
        if ("hsas_salaryfile".equals(pageName)) {
            qFilter = new QFilter("boid", "=", ((DynamicObject)salaryFileObj).get("id"));
            if (!isShowLogicDelete) {
                qFilter.and(new QFilter("datastatus", "!=", (Object)"-2"));
            }
        } else {
            qFilter = BaseDataHisHelper.getHisVerFilter();
            QFilter filter = new QFilter("pagenumber", "=", (Object)pageName);
            DynamicObject setDy = BusinessDataServiceHelper.loadSingle((String)"hsbs_filedetaildisplayset", (String)"dataquerytype,mainpropkey,entitytype.relatepageinfo.id", (QFilter[])new QFilter[]{filter});
            if (setDy == null) {
                String fileProp = SWCBaseDataHelper.getEntityPropKey((String)pageName, (String)"hsas_salaryfile");
                if (fileProp != null) {
                    qFilter.and(fileProp, "=", ((DynamicObject)salaryFileObj).get("id"));
                } else {
                    qFilter.and(QFilter.of((String)"1 != 1", (Object[])new Object[0]));
                }
            } else {
                String dataQueryType = setDy.getString("dataquerytype");
                String mainpropkey = setDy.getString("mainpropkey");
                String mainEntityId = setDy.getString("entitytype.relatepageinfo.id");
                if (SWCStringUtils.isEmpty((String)mainpropkey) && "1".equals(dataQueryType)) {
                    mainpropkey = SWCBaseDataHelper.getEntityPropKey((String)pageName, (String)mainEntityId);
                }
                if (SWCStringUtils.isEmpty((String)mainpropkey)) {
                    qFilter.and(QFilter.of((String)"1 != 1", (Object[])new Object[0]));
                } else if ("1".equals(dataQueryType)) {
                    qFilter.and(mainpropkey, "=", (Object)((DynamicObject)salaryFileObj).getLong("boid"));
                } else if ("2".equals(dataQueryType)) {
                    qFilter.and(mainpropkey, "=", (Object)((DynamicObject)salaryFileObj).getLong("employee.id"));
                } else if ("3".equals(dataQueryType)) {
                    qFilter.and(mainpropkey, "=", (Object)((DynamicObject)salaryFileObj).getLong("person.id"));
                }
            }
            if (!isShowLogicDelete) {
                qFilter.and(new QFilter("datastatus", "!=", (Object)"-2"));
            }
        }
        return qFilter;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        switch (e.getProperty().getName()) {
            case "isshowlogicdelete": {
                this.showFormView((Boolean)e.getChangeSet()[0].getNewValue());
                break;
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        IFormView listView;
        IFormView view = this.getView();
        SWCPageCache pageCache = new SWCPageCache(view);
        String flexListId = (String)pageCache.get(FLEX_LIST, String.class);
        if (!SWCStringUtils.isEmpty((String)flexListId) && null != (listView = view.getView(flexListId))) {
            switch (evt.getItemKey()) {
                case "tblrefresh": {
                    Boolean isShowLogicDelete = (Boolean)this.getModel().getValue("isshowlogicdelete");
                    if (null == isShowLogicDelete) break;
                    this.showFormView(isShowLogicDelete);
                    break;
                }
            }
        }
    }
}

