/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.file.subpage;

import java.text.MessageFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.history.model.SWCHisBaseConstants;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class ItemGroupConfigEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final String ITEM_GRP = "itemgrp";
    private static final Log LOG = LogFactory.getLog(ItemGroupConfigEdit.class);

    public void afterBindData(EventObject e) {
        String type = (String)this.getModel().getValue("type");
        this.getView().setVisible(Boolean.valueOf(SWCStringUtils.equals((String)type, (String)"1")), new String[]{ITEM_GRP});
        BasedataEdit typeControl = (BasedataEdit)this.getControl(ITEM_GRP);
        typeControl.setMustInput(SWCStringUtils.equals((String)type, (String)"1"));
        Boolean isHisPage = (Boolean)this.getView().getFormShowParameter().getCustomParam("ishispage");
        if (isHisPage != null && isHisPage.booleanValue()) {
            this.setBsed();
        }
    }

    private void setBsed() {
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (key = formOperate.getOperateKey()) {
            case "formsave": 
            case "save": 
            case "saveafteraudit": {
                Date bsed;
                String type = (String)this.getModel().getValue("type");
                DynamicObject itemgrp = (DynamicObject)this.getModel().getValue(ITEM_GRP);
                if (SWCStringUtils.equals((String)type, (String)"1") && itemgrp == null) {
                    args.setCancel(true);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9879\u76ee\u8d44\u683c\u7ec4\u3002", (String)"ItemGroupConfigEdit_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                }
                if ((bsed = this.getModel().getDataEntity().getDate("bsed")) == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u751f\u6548\u65e5\u671f\u201d\u3002", (String)"ItemGroupConfigEdit_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (SWCStringUtils.isEmpty((String)type)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u9879\u76ee\u8d44\u683c\u7ec4\u7c7b\u578b\u201d\u3002", (String)"ItemGroupConfigEdit_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (this.checkItemGrpCfgBsed()) {
                    args.setCancel(true);
                    this.getModel().setValue(ITEM_GRP, null);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u9879\u76ee\u8d44\u683c\u7ec4\u5728\u5f53\u524d\u65e5\u671f\u672a\u751f\u6548\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"ItemGroupConfigEdit_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                }
                if (this.validateDate()) break;
                args.setCancel(true);
                break;
            }
        }
    }

    private boolean validateDate() {
        String salaryFileId = (String)this.getView().getFormShowParameter().getCustomParam("salaryfileid");
        if (SWCStringUtils.isEmpty((String)salaryFileId)) {
            return true;
        }
        SWCDataServiceHelper salaryFileHisOrm = new SWCDataServiceHelper("hsas_salaryfile");
        QFilter qFilter = new QFilter("id", "=", (Object)Long.valueOf(salaryFileId));
        DynamicObject salaryFileObj = salaryFileHisOrm.queryOne("bsed,bsled", new QFilter[]{qFilter});
        if (null == salaryFileObj) {
            String message = ResManager.loadKDString((String)"\u8be5\u4eba\u5458\u85aa\u8d44\u6863\u6848\u5df2\u88ab\u5220\u9664\uff0c\u4e0d\u80fd\u4fdd\u5b58\u3002", (String)"ItemGroupConfigEdit_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(message);
            return false;
        }
        BaseDataHisHelper.addHisVerFilter((QFilter)qFilter);
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)SWCHisBaseConstants.getValidStatus());
        DynamicObject[] salaryFileHis = salaryFileHisOrm.query("bsed,bsled", new QFilter[]{qFilter, dataStatusFilter});
        if (null == salaryFileHis || salaryFileHis.length < 1) {
            return true;
        }
        Date startDate = null;
        Date endDate = null;
        for (int i = 0; i < salaryFileHis.length; ++i) {
            DynamicObject obj = salaryFileHis[i];
            Date start = obj.getDate("bsed");
            Date end = obj.getDate("bsled");
            if (null == startDate || startDate.compareTo(start) > 0) {
                startDate = start;
            }
            if (null != endDate && endDate.compareTo(end) >= 0) continue;
            endDate = end;
        }
        if (null == startDate || null == endDate) {
            return true;
        }
        DynamicObject data = this.getModel().getDataEntity();
        Date bsed = data.getDate("bsed");
        if (bsed.compareTo(startDate) < 0) {
            this.getView().showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"\u9879\u76ee\u8d44\u683c\u7ec4\u7684\u751f\u6548\u65e5\u671f{0}\u4e0d\u5141\u8bb8\u8d85\u51fa\u85aa\u8d44\u6863\u6848\u7684\u751f\u6548\u65e5\u671f\u8303\u56f4\u201c{1} - {2}\u201d\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u65e5\u671f\u6216\u66f4\u65b0\u85aa\u8d44\u6863\u6848\u3002", (String)"ItemGroupConfigEdit_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]), SWCDateTimeUtils.formatDate((Date)bsed), SWCDateTimeUtils.formatDate((Date)startDate), SWCDateTimeUtils.formatDate((Date)endDate)));
            return false;
        }
        return true;
    }

    public void registerListener(EventObject e) {
        BasedataEdit control = (BasedataEdit)this.getControl(ITEM_GRP);
        control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        ChangeData changeData = e.getChangeSet()[0];
        switch (key = e.getProperty().getName()) {
            case "type": {
                String areatype = (String)changeData.getNewValue();
                BasedataEdit typeControl = (BasedataEdit)this.getControl(ITEM_GRP);
                if (SWCStringUtils.equals((String)areatype, (String)"1")) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{ITEM_GRP});
                    typeControl.setMustInput(true);
                    break;
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{ITEM_GRP});
                typeControl.setMustInput(false);
                this.getModel().setValue(ITEM_GRP, null);
                break;
            }
        }
    }

    private boolean checkItemGrpCfgBsed() {
        Date itemGrpCfgBsed = (Date)this.getModel().getValue("bsed");
        DynamicObject itemGrpObj = (DynamicObject)this.getModel().getValue(ITEM_GRP);
        String pointType = (String)this.getModel().getValue("type");
        boolean isInvalidItemGrpCfgBsed = false;
        if (SWCStringUtils.equals((String)pointType, (String)"1") && itemGrpCfgBsed != null && itemGrpObj != null) {
            Date itemGrpHisFirstBsed = itemGrpObj.getDate("firstbsed");
            isInvalidItemGrpCfgBsed = itemGrpHisFirstBsed == null || itemGrpCfgBsed.before(itemGrpHisFirstBsed);
        }
        return isInvalidItemGrpCfgBsed;
    }

    private Date getItemGrpValidFirstBsed(DynamicObject itemGrpObj) {
        SWCDataServiceHelper itemGroupHisHelper = new SWCDataServiceHelper("hsas_itemgroup");
        QFilter idFilter = new QFilter("boid", "=", (Object)itemGrpObj.getLong("id"));
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)SWCHisBaseConstants.getValidStatus());
        BaseDataHisHelper.addHisVerFilter((QFilter)dataStatusFilter);
        DynamicObject itemGroupHisObj = itemGroupHisHelper.queryOne("bsed", new QFilter[]{idFilter, dataStatusFilter}, "bsed asc");
        return itemGroupHisObj.getDate("bsed");
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name;
        switch (name = beforeF7SelectEvent.getProperty().getName()) {
            case "itemgrp": {
                Date bsed = (Date)this.getModel().getValue("bsed");
                if (bsed == null) {
                    beforeF7SelectEvent.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u751f\u6548\u65e5\u671f\u3002", (String)"ItemGroupConfigEdit_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    return;
                }
                SWCDataServiceHelper salayfileHelper = new SWCDataServiceHelper("hsas_salaryfile");
                String salaryfileIdStr = (String)this.getView().getFormShowParameter().getCustomParam("salaryfileid");
                Long salaryFileId = Long.valueOf(salaryfileIdStr);
                DynamicObject salaryFile = salayfileHelper.queryOne("id,payrollregion.id", (Object)salaryFileId);
                if (salaryFile == null) {
                    beforeF7SelectEvent.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6863\u6848\u5df2\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u88ab\u5176\u4ed6\u4eba\u5220\u9664\u4e86\u3002", (String)"ItemGroupConfigEdit_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    return;
                }
                Long payrollregion = salaryFile.getLong("payrollregion.id");
                QFilter filter = new QFilter("country", "=", (Object)payrollregion).or(new QFilter("areatype", "=", (Object)"1"));
                beforeF7SelectEvent.addCustomQFilter(filter);
                beforeF7SelectEvent.addCustomQFilter(new QFilter("firstbsed", "<=", (Object)bsed));
                HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)"hsas_salaryfile", (String)"47150e89000000ac");
                if (permOrgs.hasAllOrgPerm()) break;
                List allOrgList = permOrgs.getHasPermOrgs();
                beforeF7SelectEvent.addCustomQFilter(new QFilter("org", "in", (Object)allOrgList));
                break;
            }
        }
    }
}

