/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.file.subpage;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.paysalarysetting.PaySalarySettingHelper;
import kd.swc.hsas.business.salaryfile.SWCSalaryFileServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class SalaryFileCommonValidateEdit
extends SWCDataBaseEdit
implements BeforeF7SelectListener {
    private static final String SALARY_ITEM_SHOW = "salaryitemshow";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl("salaryitem");
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        if (SALARY_ITEM_SHOW.equals(fieldKey)) {
            Object newValue = changeData.getNewValue();
            if ("1".equals(newValue)) {
                this.showF7SelectListForm("salaryitem", "hsbs_salaryitem");
                Object oldValue = changeData.getOldValue();
                this.getView().getPageCache().put("salaryitemmark", oldValue == null ? null : oldValue.toString());
                IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                int index = proxy.getEntryState("entryentity").getFocusRow();
                this.getView().getPageCache().put("salaryitemIndex", String.valueOf(index));
            } else {
                this.getModel().beginInit();
                this.getModel().setValue("salaryitem", null);
                this.getModel().setValue("salaryitemmark", newValue);
                this.getModel().endInit();
                this.getView().updateView("entryentity");
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId;
        super.closedCallBack(event);
        switch (actionId = event.getActionId()) {
            case "salaryitem": {
                ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)event.getReturnData();
                this.setRowValue(selectedRows);
                break;
            }
        }
    }

    private void showF7SelectListForm(String sign, String formId) {
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)formId, (boolean)false);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sign));
        String pageNumber = this.getView().getEntityId();
        if (!SWCStringUtils.equals((String)pageNumber, (String)"hsas_costallot")) {
            List qFilters = showParameter.getListFilterParameter().getQFilters();
            qFilters.add(SWCSalaryFileServiceHelper.filterSalaryItem((IDataModel)this.getModel()));
            this.pageSpecialFilter(qFilters);
            showParameter.setListFilterParameter(new ListFilterParameter(qFilters, null));
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void setRowValue(ListSelectedRowCollection selectedRows) {
        int salaryitemIndex = Integer.parseInt(this.getView().getPageCache().get("salaryitemIndex"));
        if (selectedRows != null && !selectedRows.isEmpty()) {
            ListSelectedRow selectedRow = selectedRows.get(0);
            this.getModel().beginInit();
            this.getModel().setValue(SALARY_ITEM_SHOW, (Object)selectedRow.getName(), salaryitemIndex);
            this.getModel().setValue("salaryitemmark", (Object)"1", salaryitemIndex);
            this.getModel().setValue("salaryitem", selectedRow.getPrimaryKeyValue(), salaryitemIndex);
            this.getModel().endInit();
        } else {
            this.getModel().beginInit();
            this.getModel().setValue(SALARY_ITEM_SHOW, (Object)this.getView().getPageCache().get("salaryitemmark"), salaryitemIndex);
            this.getModel().endInit();
        }
        PaySalarySettingHelper.rebuildData((IFormView)this.getView());
    }

    private void pageSpecialFilter(List<QFilter> qFilters) {
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter amountFilter = new QFilter("datatype.showtype", "=", (Object)"amount");
        qFilters.add(statusFilter);
        qFilters.add(enableFilter);
        qFilters.add(amountFilter);
        String pageNumber = this.getView().getEntityId();
        QFilter fixedItemFilter = new QFilter("isfixeditem", "=", (Object)"1");
        switch (pageNumber) {
            case "hsas_paysetting": 
            case "hsas_paysettinghis_m": {
                List<Long> payoutItemIdList = this.queryPayoutItemIdList();
                QFilter payoutItemFilter = new QFilter("id", "in", payoutItemIdList);
                qFilters.add(payoutItemFilter);
                qFilters.remove(0);
                break;
            }
        }
    }

    private List<Long> queryPayoutItemIdList() {
        DynamicObject salaryFile = (DynamicObject)this.getModel().getValue("salaryfile");
        if (salaryFile == null) {
            return null;
        }
        Long payrollgroupId = salaryFile.getLong("payrollgroup.id");
        List<Long> calRuleIdList = this.queryCalRuleInGroup(payrollgroupId);
        List<Long> payOutItemIdList = this.queryPayOutItemIdList(calRuleIdList);
        return payOutItemIdList;
    }

    private List<Long> queryPayOutItemIdList(List<Long> calRuleIdList) {
        DynamicObject[] calRuleVList;
        ArrayList<Long> payOutItemIdList = new ArrayList<Long>();
        SWCDataServiceHelper helper_calv = new SWCDataServiceHelper("hsas_calrule");
        String selectProperties = "calruleitementry.salaryitem,calruleitementry.ispayoutitem";
        QFilter filter_calv = new QFilter("boid", "in", calRuleIdList);
        QFilter[] filters = new QFilter[]{filter_calv};
        for (DynamicObject rule : calRuleVList = helper_calv.query(selectProperties, filters)) {
            DynamicObjectCollection calruleitementry = rule.getDynamicObjectCollection("calruleitementry");
            for (DynamicObject entry : calruleitementry) {
                boolean ispayoutitem = entry.getBoolean("ispayoutitem");
                if (!ispayoutitem) continue;
                Long itemId = entry.getLong("salaryitem.id");
                payOutItemIdList.add(itemId);
            }
        }
        return payOutItemIdList;
    }

    private List<Long> queryCalRuleInGroup(Long payrollgroupId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_payrollgrp");
        boolean isExists = helper.isExists((Object)payrollgroupId);
        if (!isExists) {
            return null;
        }
        String selectProperties = "payrollsceneentry.payrollscene";
        DynamicObject group = helper.queryOne(selectProperties, (Object)payrollgroupId);
        ArrayList<Long> ruleList = new ArrayList<Long>();
        DynamicObjectCollection fixedPeriodCalruleEntry = group.getDynamicObjectCollection("payrollsceneentry");
        for (DynamicObject col : fixedPeriodCalruleEntry) {
            Long defRuleId = col.getLong("payrollscene.calrule.id");
            ruleList.add(defRuleId);
        }
        return ruleList;
    }
}

