/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.file.subpage;

import com.alibaba.fastjson.JSON;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.CreateDateProp;
import kd.bos.entity.property.CreaterProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.ModifierProp;
import kd.bos.entity.property.ModifyDateProp;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.AdvContainer;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MainOrgEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.AfterChangeMainOrgEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.MainOrgChangeListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.operation.OperationServiceImpl;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.swc.hsas.business.file.SalaryFilePermissionHelper;
import kd.swc.hsas.business.paysalarysetting.PaySalarySettingHelper;
import kd.swc.hsas.business.paysalarysetting.paysetting.entity.ErrorResultObserver;
import kd.swc.hsas.business.paysalarysetting.paysetting.entity.UpdatePaySettingDTO;
import kd.swc.hsas.business.paysalarysetting.paysetting.entity.UpdatePaySettingEnum;
import kd.swc.hsas.business.paysalarysetting.paysetting.updateobject.UpdateCoverStrategy;
import kd.swc.hsas.business.salaryfile.SWCSalaryFileServiceHelper;
import kd.swc.hsas.business.salaryfile.SalaryFileDBHelper;
import kd.swc.hsas.business.salaryfile.SalaryFileEmpPosOrgRelHelper;
import kd.swc.hsas.business.salaryfile.SalaryFileHelper;
import kd.swc.hsas.business.salaryfile.SalaryTaxFileRelViewHelper;
import kd.swc.hsas.common.dto.PersonRangeDTO;
import kd.swc.hsas.common.utils.BaseResult;
import kd.swc.hsas.common.utils.SalaryFileUtils;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.history.model.SWCHisBaseConstants;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;
import org.apache.commons.collections4.MapUtils;

public class SalaryFileEdit
extends SWCDataBaseEdit
implements BeforeF7SelectListener,
MainOrgChangeListener {
    private static final Log LOG = LogFactory.getLog(SalaryFileEdit.class);
    private static final String KEY_ADVYOOLBAR = "advtoolbar";
    private static final String KEY_EMPLOYEE = "employee";
    private static final String KEY_EMPPOSINFO = "empposinfo";
    private static final String KEY_PAYROLLGROUP = "payrollgroup";
    private static final String KEY_PAYROLLREGION = "payrollregion";
    private static final String KEY_SALARYCALCSTYLE = "salarycalcstyle";
    private static final String KEY_BSED = "bsed";
    private static final String IS_SET_OLD_VALUE = "isSetEmployeeToOldValue";
    private static final String CALLBACKID_MYMESSAGE = "callbackid";
    private static final String CALLBACKID_BIZNOTUSE = "callback_HasNotUseBizData";
    private static final String CALLBACKID_BEFOREEMPSTARTDATE = "callback_beforeEmpStartDate_save";
    private static final String CALLBACKID_BEFOREEMPSTARTDATEAUDIT = "callback_beforeEmpStartDate_saveafteraudit";
    private static final String CALLBACKID_VALIDATEDEPEMP = "callback_validateDepemp";
    private static final String CALLBACKID_VALIDATE_PAYENDDATE = "callback_validatePayEndDate";
    private static final String IS_CONTINUE_BIZNOTUSE = "is_continue_biznotuse";
    private static final String IS_CONTINUE_VALIDATEDEPEMP = "is_continue_validateDepemp";
    private static final String IS_CONTINUE_VALIDATE_PAYENDDATE = "is_continue_validatePayEndDate";
    private static final String CALLBACK_REGION = "callbackRegion";
    private static final String CALLBACK_ORG = "callbackOrg";
    public static final String CLOSE_CALL_BACK_UPDATE_PAY_END_DATE = "CLOSE_CALL_BACK_UPDATE_PAY_END_DATE";
    public static final String CALLBACK_DEPEMPF7QUERYLISTF7 = "CallBack_DepempF7QueryListF7";

    public void initialize() {
        MainOrgEdit mainOrgEdit;
        MainEntityType dataEntityType = this.getModel().getDataEntityType();
        String mainOrgKey = dataEntityType.getMainOrg();
        if (StringUtils.isNotEmpty((CharSequence)mainOrgKey) && (mainOrgEdit = (MainOrgEdit)this.getView().getControl(mainOrgKey)) != null) {
            mainOrgEdit.addMainOrgChangeListener((MainOrgChangeListener)this);
        }
    }

    public void beforeBindData(EventObject eventObject) {
        String addtaxfilecheckbox = this.getView().getPageCache().get("addtaxfilecheckbox");
        if ("true".equals(addtaxfilecheckbox)) {
            this.getModel().setValue("addtaxfilecheckbox", (Object)addtaxfilecheckbox);
        }
        this.opButtonControl();
        this.getView().setEnable(Boolean.FALSE, new String[]{KEY_EMPPOSINFO});
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (!dataEntity.getBoolean("isescrowstaff")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"isescrowstaff"});
        }
        List empgoupIds = SWCPermissionServiceHelper.getEmpgroupByAppNumber((String)"hsas");
        QFilter qFilter = new QFilter("id", "in", (Object)empgoupIds);
        BasedataEdit empgoupEdit = (BasedataEdit)this.getControl("empgroup");
        empgoupEdit.setQFilter(qFilter);
        Boolean isHisPage = (Boolean)this.getView().getFormShowParameter().getCustomParam("ishispage");
        if (isHisPage != null && isHisPage.booleanValue()) {
            this.setHisPage();
        }
        this.getModel().setDataChanged(false);
    }

    public void afterBindData(EventObject e) {
        DynamicObject empPosInfo = this.getModel().getDataEntity().getDynamicObject(KEY_EMPPOSINFO);
        if (!SWCObjectUtils.isEmpty((Object)empPosInfo) && "-1".equals(empPosInfo.getString("datastatus"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6863\u6848\u4e3b\u8981\u5c97\u4f4d\u5df2\u5e9f\u5f03\uff0c\u8bf7\u53ca\u65f6\u4fee\u6539\u3002", (String)"SalaryFileEdit_15", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        }
    }

    private void setHisPage() {
        Object hisId = this.getView().getFormShowParameter().getCustomParam("salaryFileVid");
        SWCDataServiceHelper salaryFileHisHelper = new SWCDataServiceHelper("hsas_salaryfile");
        QFilter idFilter = new QFilter("id", "=", hisId);
        DynamicObject salaryFileHisObj = salaryFileHisHelper.queryOne(SWCHisBaseDataHelper.getSelectProperties((String)"hsas_salaryfile"), new QFilter[]{idFilter});
        this.getModel().beginInit();
        Map fieldProps = EntityMetadataCache.getDataEntityType((String)"hsas_salaryfile").getFields();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry prop : fieldProps.entrySet()) {
            this.getModel().setValue((String)prop.getKey(), salaryFileHisObj.get((String)prop.getKey()));
            if (sb.length() >= 1) {
                sb.append(',');
            }
            sb.append((String)prop.getKey());
        }
        this.getModel().endInit();
        this.getView().updateView(sb.toString());
        this.getView().getFormShowParameter().setCustomParam("fromPage", (Object)"fromHisAction");
        this.getView().cacheFormShowParameter();
    }

    private void opButtonControl() {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_ADVYOOLBAR});
            this.getView().setVisible(Boolean.FALSE, new String[]{"managingscopehbss"});
            long regionId = this.getModel().getDataEntity().getLong("payrollregion.id");
            boolean enableTaxCal = SalaryTaxFileRelViewHelper.enableTaxCal((long)regionId);
            boolean hasTaxFileAddPerm = SalaryTaxFileRelViewHelper.hasTaxFileAddPerm();
            if (!enableTaxCal || !hasTaxFileAddPerm) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"addtaxfilecheckbox", "addtaxfileflex"});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"addtaxfilecheckbox", "addtaxfileflex"});
            AdvContainer fileAdvconap = (AdvContainer)this.getView().getControl("advconap");
            fileAdvconap.setCollapseable(true);
        }
        SalaryTaxFileRelViewHelper.showOrHideTaxFile((IFormView)this.getView());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_PAYROLLGROUP, KEY_ADVYOOLBAR});
        BasedataEdit empPosOrgRel = (BasedataEdit)this.getView().getControl(KEY_EMPPOSINFO);
        empPosOrgRel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        OrgEdit orgEdit = (OrgEdit)this.getControl("org");
        orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit adminOrg = (BasedataEdit)this.getControl("adminorg");
        adminOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit payrollGroup = (BasedataEdit)this.getView().getControl(KEY_PAYROLLGROUP);
        payrollGroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit empgroup = (BasedataEdit)this.getControl("empgroup");
        empgroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit payRollRegion = (BasedataEdit)this.getControl(KEY_PAYROLLREGION);
        payRollRegion.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit salaryCalcStyle = (BasedataEdit)this.getControl(KEY_SALARYCALCSTYLE);
        salaryCalcStyle.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit depEmp = (BasedataEdit)this.getControl("depemp");
        depEmp.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit employee = (BasedataEdit)this.getControl(KEY_EMPLOYEE);
        employee.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        this.getView().getPageCache().put("addtaxfilecheckbox", this.getModel().getDataEntity().getString("addtaxfilecheckbox"));
        FormOperate operate = (FormOperate)args.getSource();
        switch (operate.getOperateKey()) {
            case "save": {
                if (!this.validateBsedField()) {
                    args.setCancel(true);
                    return;
                }
                if (!this.validatePartTimeCombineField()) {
                    args.setCancel(true);
                    return;
                }
                if (!this.getModel().getDataEntity().getBoolean("addtaxfilecheckbox")) break;
                if (!SalaryTaxFileRelViewHelper.standardValidate((IFormView)this.getView())) {
                    args.setCancel(true);
                    return;
                }
                BaseResult result = SalaryTaxFileRelViewHelper.saveTaxFile((IFormView)this.getView(), (long)0L, (int)1, (boolean)true);
                if (result.isSuccess()) break;
                this.getView().showErrorNotification(result.getMessage());
                args.setCancel(true);
                return;
            }
            case "saveafteraudit": {
                if (!this.validateBsedField()) {
                    args.setCancel(true);
                }
                if (!this.validateBizData()) {
                    args.setCancel(true);
                }
                if (!args.isCancel() && !this.validatePayEndDate()) {
                    args.setCancel(true);
                }
                operate.getOption().setVariableValue("pageStatus", (String)this.getView().getFormShowParameter().getCustomParam("status"));
                break;
            }
            case "savetaxfile": {
                BaseResult result;
                if (!SalaryTaxFileRelViewHelper.standardValidate((IFormView)this.getView())) {
                    args.setCancel(true);
                    break;
                }
                Long salaryFileId = (Long)this.getView().getFormShowParameter().getCustomParam("salaryFileId");
                if (salaryFileId == null || Long.valueOf(0L).equals(salaryFileId)) {
                    String salaryFileIdStr = this.getView().getPageCache().get("salaryFileId");
                    if (salaryFileIdStr == null) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u4eba\u5458\u85aa\u8d44\u6863\u6848\u4fe1\u606f\u3002", (String)"SalaryFileTaxAddNewPlugin_11", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    salaryFileId = Long.valueOf(salaryFileIdStr);
                }
                if ((result = SalaryTaxFileRelViewHelper.saveTaxFile((IFormView)this.getView(), (long)salaryFileId, (int)3, (boolean)true)).isSuccess()) {
                    this.getView().returnDataToParent(result.getData());
                    this.getView().getPageCache().put("afterconfirm", "true");
                    this.getView().close();
                    break;
                }
                args.setCancel(true);
                if (result.isContinue()) {
                    this.getView().showTipNotification(result.getMessage());
                    break;
                }
                this.getView().showErrorNotification(result.getMessage());
                break;
            }
        }
    }

    private boolean validatePayEndDate() {
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        Boolean validatePayEndDateFlag = (Boolean)pageCache.get(IS_CONTINUE_VALIDATE_PAYENDDATE, Boolean.class);
        if (validatePayEndDateFlag != null && validatePayEndDateFlag.booleanValue()) {
            this.getPageCache().remove(IS_CONTINUE_VALIDATE_PAYENDDATE);
            return true;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String payStatus = dataEntity.getString("paystatus");
        if (!"0".equals(payStatus)) {
            return true;
        }
        Long boid = dataEntity.getLong("boid");
        Date bsed = dataEntity.getDate(KEY_BSED);
        Date bsled = dataEntity.getDate("bsled");
        if (bsled == null) {
            bsled = SWCDateTimeUtils.getMaxBsled();
        }
        long depEmpId = dataEntity.getLong("depemp.id");
        Date date = SWCDateTimeUtils.addDay((Date)bsed, (long)-1L);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_empposorgrel");
        QFilter fileIdFilter = new QFilter("salaryfile", "=", (Object)boid);
        DynamicObject[] depEmpDys = helper.query("entryentity,entryentity.workrole,entryentity.workrole.number,entryentity.payenddate,entryentity.paystartdate", new QFilter[]{fileIdFilter});
        if (depEmpDys == null || depEmpDys.length != 1) {
            LOG.info("calDateFromDepemp depEmpDys.length != 1");
            return true;
        }
        boolean payEndDateFlag = SalaryFileEdit.getPayEndDateFlag(depEmpId, date, depEmpDys);
        if (!payEndDateFlag) {
            return true;
        }
        Map<String, Date> dateMap = this.calDateFromDepemp(depEmpId, depEmpDys);
        Date max = (Date)MapUtils.getObject(dateMap, (Object)"max");
        Date min = (Date)MapUtils.getObject(dateMap, (Object)"min");
        Date startDate = dataEntity.getDate("depemp.startdate");
        Set<String> depEmpValidateMsgSet = this.getDepEmpValidateMsg();
        if (!(min != null && SWCDateTimeUtils.dayAfter((Date)min, (Date)date) || SWCDateTimeUtils.dayAfter((Date)startDate, (Date)date) || max != null && SWCDateTimeUtils.dayBefore((Date)bsled, (Date)max))) {
            this.showUpdatePayEndDateConfirm(depEmpValidateMsgSet, bsed, bsled);
            return false;
        }
        this.showNormalConfirm(bsed, bsled, depEmpValidateMsgSet);
        return false;
    }

    private Map<String, Date> calDateFromDepemp(long depEmpId, DynamicObject[] depEmpDys) {
        DynamicObjectCollection entryentity = depEmpDys[0].getDynamicObjectCollection("entryentity");
        Date maxDate = null;
        Date minDate = null;
        for (DynamicObject entry : entryentity) {
            long wrId = entry.getLong("workrole.id");
            if (wrId != depEmpId) continue;
            Date payEndDate = entry.getDate("payenddate");
            Date payStartDate = entry.getDate("paystartdate");
            maxDate = this.getMaxDate(maxDate, payEndDate);
            minDate = this.getMinDate(minDate, payStartDate);
        }
        HashMap<String, Date> result = new HashMap<String, Date>(16);
        result.put("max", maxDate);
        result.put("min", minDate);
        return result;
    }

    private Date getMinDate(Date first, Date second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        return SWCDateTimeUtils.dayBefore((Date)first, (Date)second) ? first : second;
    }

    private Date getMaxDate(Date first, Date second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        return SWCDateTimeUtils.dayAfter((Date)first, (Date)second) ? first : second;
    }

    private boolean getBsledFlag(long depEmpId, Date bsled, DynamicObject[] depEmpDys) {
        boolean isBefore = true;
        block0: for (DynamicObject biz : depEmpDys) {
            DynamicObjectCollection entryentity = biz.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryentity) {
                Date payEndDate;
                long wrId = entry.getLong("workrole.id");
                if (wrId != depEmpId || !SWCDateTimeUtils.dayBefore((Date)bsled, (Date)(payEndDate = entry.getDate("payenddate")))) continue;
                isBefore = false;
                continue block0;
            }
        }
        return isBefore;
    }

    private static boolean getPayStartDateFlag(long depEmpId, Date date, DynamicObject[] depEmpDys) {
        boolean isBefore = false;
        block0: for (DynamicObject biz : depEmpDys) {
            DynamicObjectCollection entryentity = biz.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryentity) {
                Date payStartDate;
                long wrId = entry.getLong("workrole.id");
                if (wrId != depEmpId || SWCDateTimeUtils.dayAfter((Date)(payStartDate = entry.getDate("paystartdate")), (Date)date)) continue;
                isBefore = true;
                continue block0;
            }
        }
        return isBefore;
    }

    private static boolean getPayEndDateFlag(long depEmpId, Date date, DynamicObject[] depEmpDys) {
        boolean flag = false;
        block0: for (DynamicObject biz : depEmpDys) {
            DynamicObjectCollection entryentity = biz.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryentity) {
                Date payenddate;
                long wrId = entry.getLong("workrole.id");
                if (wrId != depEmpId || !SWCDateTimeUtils.dayBefore((Date)date, (Date)(payenddate = entry.getDate("payenddate")))) continue;
                flag = true;
                continue block0;
            }
        }
        return flag;
    }

    private void showNormalConfirm(Date bsed, Date bsled, Set<String> depEmpValidateMsgSet) {
        String title = ResManager.loadKDString((String)"\u6863\u6848\u5728\u4e3b\u8981\u5c97\u4f4d\u7b97\u85aa\u5f00\u59cb\u65e5\u671f\u6216\u4e3b\u8981\u5c97\u4f4d\u5f00\u59cb\u65e5\u671f\u524d\u505c\u6b62\u7b97\u85aa\uff0c\u786e\u8ba4\u7ee7\u7eed\uff1f", (String)"SalaryFileEdit_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        String msg = null;
        if (CollectionUtils.isEmpty(depEmpValidateMsgSet)) {
            msg = ResManager.loadKDString((String)"\u6863\u6848\u7248\u672c\u5f53\u524d\u72b6\u6001\u4e3a\u201c\u505c\u6b62\u7b97\u85aa\u201d\uff0c\u4e14\u6863\u6848\u751f\u6548\u65e5\u671f\u2264\u5173\u8054\u7ec4\u7ec7\u56e2\u961f\u4e3b\u8981\u5c97\u4f4d\u7684\u7b97\u85aa\u5f00\u59cb\u65e5\u671f\u6216\u4e3b\u8981\u5c97\u4f4d\u7684\u5f00\u59cb\u65e5\u671f\uff08\u5982\u57fa\u4e8e\u5f53\u524d\u4e3b\u8981\u5c97\u4f4d\u9700\u521b\u5efa\u5176\u4ed6\u85aa\u8d44\u6838\u7b97\u7ec4\u7684\u6863\u6848\uff0c\u8bf7\u624b\u52a8\u66f4\u65b0\u7b97\u85aa\u7ed3\u675f\u65e5\u671f\uff09\u3002", (String)"SalaryFileEdit_12", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        } else {
            String bsedStr = HRInteDateTimeUtil.formatDate((String)"hsas_salaryfile", (String)KEY_BSED, (Date)bsed);
            String bsledStr = HRInteDateTimeUtil.formatDate((String)"hsas_salaryfile", (String)"bsled", (Date)bsled);
            msg = ResManager.loadKDString((String)"1. \u6863\u6848\u7248\u672c\u5f53\u524d\u72b6\u6001\u4e3a\u201c\u505c\u6b62\u7b97\u85aa\u201d\uff0c\u4e14\u6863\u6848\u751f\u6548\u65e5\u671f\u2264\u5173\u8054\u7ec4\u7ec7\u56e2\u961f\u4e3b\u8981\u5c97\u4f4d\u7684\u7b97\u85aa\u5f00\u59cb\u65e5\u671f/\u5f00\u59cb\u65e5\u671f\uff08\u5982\u57fa\u4e8e\u5f53\u524d\u4e3b\u8981\u5c97\u4f4d\u9700\u521b\u5efa\u5176\u4ed6\u85aa\u8d44\u6838\u7b97\u7ec4\u7684\u6863\u6848\uff0c\u8bf7\u624b\u52a8\u66f4\u65b0\u7b97\u85aa\u7ed3\u675f\u65e5\u671f\uff09\uff1b{3}2. {0}\u81f3{1}\u5b58\u5728\u7b97\u85aa\u4e2d\u7684\u5173\u8054\u7ec4\u7ec7\u56e2\u961f\u4fe1\u606f {2}\uff0c\u4fdd\u5b58\u540e\u5173\u8054\u7ec4\u7ec7\u56e2\u961f\u4fe1\u606f\u5c06\u65e0\u6cd5\u7528\u4e8e\u7b97\u85aa\u3002", (String)"SalaryFileEdit_13", (String)"swc-hsas-formplugin", (Object[])new Object[]{bsedStr, bsledStr, String.join((CharSequence)"\u3001", depEmpValidateMsgSet), System.lineSeparator()});
        }
        HashMap<Integer, String> param = new HashMap<Integer, String>(16);
        param.put(1, ResManager.loadKDString((String)"\u786e\u8ba4", (String)"SalaryFileEdit_14", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        this.getView().showConfirm(title, msg, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(CALLBACKID_VALIDATE_PAYENDDATE, (IFormPlugin)this), param, "false");
        this.getPageCache().remove(IS_CONTINUE_VALIDATE_PAYENDDATE);
    }

    private void showUpdatePayEndDateConfirm(Set<String> depEmpValidateMsgSet, Date bsed, Date bsled) {
        String title = ResManager.loadKDString((String)"\u505c\u6b62\u7b97\u85aa\u540e\u7684\u6863\u6848\u7248\u672c\u5c06\u65e0\u6cd5\u7b97\u85aa\uff0c\u786e\u8ba4\u7ee7\u7eed\uff1f", (String)"SalaryFileEdit_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        String msg = null;
        if (CollectionUtils.isEmpty(depEmpValidateMsgSet)) {
            msg = ResManager.loadKDString((String)"\u5982\u679c\u9700\u8981\u57fa\u4e8e\u5f53\u524d\u4e3b\u8981\u5c97\u4f4d\u521b\u5efa\u5176\u4ed6\u85aa\u8d44\u6838\u7b97\u7ec4\u7684\u6863\u6848\uff0c\u8bf7\u9009\u62e9\u66f4\u65b0\u5e76\u4fdd\u5b58\uff1b\u66f4\u65b0\u540e\uff0c\u6863\u6848\u751f\u6548\u65e5\u671f\u5c06\u4e3a\u5f53\u524d\u65e5\u671f\u7684\u524d\u4e00\u5929\uff0c\u60a8\u4e5f\u53ef\u4ee5\u624b\u52a8\u66f4\u65b0\u3002", (String)"SalaryFileEdit_10", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        } else {
            String bsedStr = HRInteDateTimeUtil.formatDate((String)"hsas_salaryfile", (String)KEY_BSED, (Date)bsed);
            String bsledStr = HRInteDateTimeUtil.formatDate((String)"hsas_salaryfile", (String)"bsled", (Date)bsled);
            msg = ResManager.loadKDString((String)"1. {0}\u81f3{1}\u5b58\u5728\u7b97\u85aa\u4e2d\u7684\u5173\u8054\u7ec4\u7ec7\u56e2\u961f\u4fe1\u606f {2}\uff0c\u4fdd\u5b58\u540e\u5173\u8054\u7ec4\u7ec7\u56e2\u961f\u4fe1\u606f\u5c06\u65e0\u6cd5\u7528\u4e8e\u7b97\u85aa\uff1b<p>2. \u5982\u57fa\u4e8e\u5f53\u524d\u4e3b\u8981\u5c97\u4f4d\u9700\u521b\u5efa\u5176\u4ed6\u85aa\u8d44\u6838\u7b97\u7ec4\u7684\u6863\u6848\uff0c\u8bf7\u9009\u62e9\u66f4\u65b0\u5e76\u4fdd\u5b58\uff0c\u5c06\u66f4\u65b0\u4e3a\u6863\u6848\u751f\u6548\u65e5\u671f-1\uff0c\u60a8\u4e5f\u53ef\u4ee5\u540e\u7eed\u624b\u52a8\u66f4\u65b0\u3002", (String)"SalaryFileEdit_11", (String)"swc-hsas-formplugin", (Object[])new Object[]{bsedStr, bsledStr, String.join((CharSequence)"\u3001", depEmpValidateMsgSet), System.lineSeparator()});
        }
        this.showUpdateConfirmPage(title, msg);
        this.getPageCache().remove(IS_CONTINUE_VALIDATE_PAYENDDATE);
    }

    private void showUpdateConfirmPage(String title, String content) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("hsas_salaryconfirmpage");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setHasRight(true);
        formShowParameter.setCustomParam("title", (Object)title);
        formShowParameter.setCustomParam("content", (Object)content);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSE_CALL_BACK_UPDATE_PAY_END_DATE));
        this.getView().showForm(formShowParameter);
    }

    private boolean validateBizData() {
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        Boolean isContinueBiznotuse = (Boolean)pageCache.get(IS_CONTINUE_BIZNOTUSE, Boolean.class);
        if (isContinueBiznotuse != null && isContinueBiznotuse.booleanValue()) {
            this.getPageCache().remove(IS_CONTINUE_BIZNOTUSE);
            return true;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String payStatus = dataEntity.getString("paystatus");
        if (!"0".equals(payStatus)) {
            return true;
        }
        Date bsed = dataEntity.getDate(KEY_BSED);
        Date bsled = dataEntity.getDate("bsled");
        HashMap<String, Comparable<Long>> param = new HashMap<String, Comparable<Long>>(16);
        param.put("fileId", Long.valueOf(dataEntity.getLong("boid")));
        param.put(KEY_BSED, bsed);
        param.put("bsled", bsled);
        LOG.info(String.valueOf(JSON.toJSON(param)));
        Map result = (Map)SWCMServiceUtils.invokeSWCService((String)"hsas", (String)"IBizDataService", (String)"validateBizDataNotUse", (Object[])new Object[]{param});
        LOG.info(String.valueOf(JSON.toJSON((Object)result)));
        boolean isHasNotUseBizData = (Boolean)result.get("isHasNotUseBizData");
        if (isHasNotUseBizData) {
            String bsedStr = HRInteDateTimeUtil.formatDate((String)"hsas_salaryfile", (String)KEY_BSED, (Date)bsed);
            String bsledStr = HRInteDateTimeUtil.formatDate((String)"hsas_salaryfile", (String)"bsled", (Date)bsled);
            String msg = ResManager.loadKDString((String)"\u8be5\u85aa\u8d44\u6863\u6848\u5728 {0} \u81f3 {1} \u5185\u5b58\u5728\u672a\u88ab\u6d88\u8d39\u7684\u975e\u5faa\u73af\u4e1a\u52a1\u6570\u636e\uff0c\u8fd9\u90e8\u5206\u4e1a\u52a1\u6570\u636e\u5c06\u4e0d\u4f1a\u7528\u4e8e\u7b97\u85aa\uff0c\u786e\u8ba4\u7ee7\u7eed\uff1f", (String)"SalaryFileEdit_5", (String)"swc-hsas-formplugin", (Object[])new Object[]{bsedStr, bsledStr});
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CALLBACKID_BIZNOTUSE, (IFormPlugin)this));
            return false;
        }
        return true;
    }

    private Set<String> getDepEmpValidateMsg() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String payStatus = dataEntity.getString("paystatus");
        if (!"0".equals(payStatus)) {
            return Collections.emptySet();
        }
        Long boid = dataEntity.getLong("boid");
        Date bsed = dataEntity.getDate(KEY_BSED);
        Date bsled = dataEntity.getDate("bsled");
        if (bsled == null) {
            bsled = SWCDateTimeUtils.getMaxBsled();
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_empposorgrel");
        QFilter fileIdFilter = new QFilter("salaryfile", "=", (Object)boid);
        QFilter bsedFilter = new QFilter("entryentity.paystartdate", "<=", (Object)bsled);
        QFilter bsledFilter = new QFilter("entryentity.payenddate", ">=", (Object)bsed);
        DynamicObject[] dmpEmpDys = helper.query("entryentity,entryentity.workrole,entryentity.workrole.number", new QFilter[]{fileIdFilter, bsedFilter, bsledFilter});
        String intervalMsg = "\uff0c";
        if (dmpEmpDys != null && dmpEmpDys.length >= 1) {
            HashSet<String> workRoleNumberSet = new HashSet<String>(16);
            for (DynamicObject biz : dmpEmpDys) {
                DynamicObjectCollection entryentity = biz.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entryentity) {
                    workRoleNumberSet.add(entry.getString("workrole.number"));
                }
            }
            return workRoleNumberSet;
        }
        return Collections.emptySet();
    }

    private boolean validatePartTimeCombineField() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Long id = dataEntity.getLong("id");
        Long personId = dataEntity.getLong("employee.person.id");
        Long orgId = dataEntity.getLong("org.id");
        Long payRollGroupId = 0L;
        Object payrollgroupObj = dataEntity.get(KEY_PAYROLLGROUP);
        if (payrollgroupObj instanceof DynamicObject) {
            payRollGroupId = ((DynamicObject)payrollgroupObj).getLong("id");
        } else if (payrollgroupObj instanceof Long) {
            payRollGroupId = (Long)payrollgroupObj;
        }
        Long payRollRegionId = dataEntity.getLong("payrollregion.id");
        LOG.info("validatePartTimeCombineField,personId={},orgId={},payRollGroupId={},payRollRegionId={}", new Object[]{personId, orgId, payRollGroupId, payRollRegionId});
        DynamicObject existFile = SalaryFileDBHelper.getInstance().validateSalaryfileUnique(personId, orgId, payRollGroupId, payRollRegionId, id);
        if (existFile != null) {
            LOG.info("validatePartTimeCombineField,personId={},orgId={},payRollGroupId={},payRollRegionId={}", new Object[]{personId, orgId, payRollGroupId, payRollRegionId});
            String msg = ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u5df2\u5b58\u5728\u85aa\u8d44\u6838\u7b97\u7ec4\u4e3a{2}\u7684\u85aa\u8d44\u6863\u6848{3}\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\uff0c\u8bf7\u4fee\u6539\u85aa\u8d44\u6863\u6848\u3002", (String)"SalaryFileSaveValidator_10", (String)"swc-hsas-opplugin", (Object[])new Object[]{dataEntity.get("employee.person.name"), dataEntity.get("employee.empnumber"), dataEntity.get("payrollgroup.name"), existFile.get("number")});
            this.getView().showErrorNotification(msg);
            return false;
        }
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        this.getModel().beginInit();
        this.getModel().setValue("addtaxfilecheckbox", (Object)this.getView().getPageCache().get("addtaxfilecheckbox"));
        this.getModel().endInit();
        FormOperate operate = (FormOperate)args.getSource();
        OperationResult operationResult = args.getOperationResult();
        switch (args.getOperateKey()) {
            case "edit": {
                this.getView().setVisible(Boolean.FALSE, new String[]{KEY_EMPPOSINFO});
                this.getView().setEnable(Boolean.FALSE, new String[]{"bsled"});
                break;
            }
            case "save": {
                if (null == operationResult || !operationResult.isSuccess()) break;
                this.afterSaveDoOperation();
                long salaryFileId = this.getModel().getDataEntity().getLong("id");
                BaseResult result = SalaryTaxFileRelViewHelper.saveTaxFile((IFormView)this.getView(), (long)salaryFileId, (int)3, (boolean)false);
                if (!result.isSuccess()) {
                    operationResult.setSuccess(false);
                    operationResult.setMessage(result.getMessage());
                    this.getView().showErrorNotification(result.getMessage());
                    break;
                }
                String customStatus = (String)this.getView().getFormShowParameter().getCustomParam("customStatus");
                if ("ADDNEW".equals(customStatus)) {
                    this.getView().returnDataToParent((Object)this.getModel().getDataEntity().getLong("id"));
                    this.getView().getPageCache().put("afterconfirm", "true");
                    this.getView().close();
                    break;
                }
                if (this.getView().getParentView() != null) {
                    SalaryFileUtils.refreshSalaryFilePreview((IFormView)this.getView().getParentView(), (IFormView)this.getView());
                }
                String salaryFileVidNew = operate.getOption().getVariableValue("newPkId", null);
                this.updatePreview(salaryFileVidNew);
                break;
            }
            case "saveafteraudit": {
                if (null != operationResult && operationResult.isSuccess()) {
                    SalaryFileUtils.refreshSalaryFilePreview((IFormView)this.getView().getParentView(), (IFormView)this.getView());
                    SalaryFileUtils.refreshSalaryFileRightPage((IFormView)this.getView().getParentView(), (IFormView)this.getView(), (String)args.getOperateKey());
                    String salaryFileVidNew = operate.getOption().getVariableValue("newPkId", null);
                    this.updatePreview(salaryFileVidNew);
                }
                this.getModel().setValue("isupdatepayenddate", (Object)Boolean.FALSE);
                break;
            }
            case "modifyafteraudit": {
                this.setFieldEnable();
                break;
            }
            case "audit": {
                ValidateResultCollection validateResult;
                String message = operationResult.getMessage();
                if (!SWCStringUtils.isNotEmpty((String)message) || !message.contains("filecertwarn") || !(validateResult = args.getOperationResult().getValidateResult()).isSuccess()) break;
                String result = message.replace("filecertwarn", "");
                operationResult.setMessage(result);
                break;
            }
        }
    }

    private void afterSaveDoOperation() {
        LOG.info("SalaryPaySetting.afterSaveDoOperation...00000......");
        OperationResult validateOperationResult = new OperationResult();
        validateOperationResult.setSuccess(true);
        validateOperationResult.setBillCount(1);
        long salaryFileId = this.getModel().getDataEntity().getLong("id");
        Long paySettingId = ORM.create().genLongId("hsas_paysetting");
        this.addNewPaySalarySetting(paySettingId, salaryFileId, validateOperationResult);
        LOG.info("SalaryPaySetting.afterSaveDoOperation...11111......");
        if (!validateOperationResult.isSuccess()) {
            LOG.info("SalaryPaySetting.afterSaveDoOperation error \uff1a{}", (Object)validateOperationResult.getMessage());
        }
    }

    private void addNewPaySalarySetting(Long pkId, Long salaryFileId, OperationResult validateOperationResult) {
        DynamicObject salaryFile = PaySalarySettingHelper.querySalaryFileInfoById((long)salaryFileId);
        Long countryId = salaryFile.getLong("payrollregion.id");
        long groupId = salaryFile.getLong("payrollgroup.id");
        DynamicObject calCurrency = PaySalarySettingHelper.getSalaryFileCalCurrency((Long)groupId);
        DynamicObject paySettingRule = PaySalarySettingHelper.getAuditAndEnableData((Long)salaryFile.getLong("org.id"), (Long)countryId);
        Long personId = salaryFile.getLong("person.id");
        List perBankCardList = PaySalarySettingHelper.queryBankCardAllInfoByPersonId((Long)personId);
        HashMap personFileInfo = new HashMap(16);
        PaySalarySettingHelper.getSalaryFilePersonRangeRule((DynamicObject)paySettingRule, Collections.singletonList(salaryFileId), personFileInfo);
        PersonRangeDTO personRangeDTO = (PersonRangeDTO)personFileInfo.get(salaryFileId);
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_paysetting");
        DynamicObject paySalarySettingObj = serviceHelper.generateEmptyDynamicObject();
        DynamicObjectCollection paySettingEntryDyCollection = paySalarySettingObj.getDynamicObjectCollection("entryentity");
        paySalarySettingObj.set("salaryfile", (Object)this.genEmptyDyobjWithPkId("hsas_salaryfile", salaryFileId));
        paySalarySettingObj.set("id", (Object)pkId);
        paySalarySettingObj.set("entryentity", (Object)paySettingEntryDyCollection);
        this.setDyobjDefVal(paySalarySettingObj, "hsas_paysetting");
        UpdatePaySettingDTO updatePaySetting = new UpdatePaySettingDTO(Boolean.FALSE, salaryFile, paySalarySettingObj, UpdatePaySettingEnum.UPDATE_COVER, paySettingRule, perBankCardList, calCurrency);
        updatePaySetting.setPersonRange(personRangeDTO);
        HashSet<Long> groupIdSet = new HashSet<Long>(16);
        groupIdSet.add(groupId);
        updatePaySetting.setSalaryItem((Set)PaySalarySettingHelper.getPayRollGroupAndItemMap(groupIdSet).get(groupId));
        ErrorResultObserver observer = new ErrorResultObserver();
        UpdateCoverStrategy strategy = new UpdateCoverStrategy(observer);
        boolean isUpdate = strategy.strategyMethod(updatePaySetting);
        if (!isUpdate) {
            return;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("firstsave", "true");
        option.setVariableValue("ignore_validator", "1");
        OperationServiceImpl opImpl = new OperationServiceImpl();
        OperationResult operationResult = opImpl.localInvokeOperation("save", new DynamicObject[]{paySalarySettingObj}, option);
        this.collectOperationResult(validateOperationResult, operationResult);
    }

    private void collectOperationResult(OperationResult validateOperationResult, OperationResult operationResult) {
        if (!operationResult.isSuccess()) {
            validateOperationResult.setSuccess(false);
            List operateInfos = operationResult.getAllErrorOrValidateInfo();
            for (IOperateInfo operateInfo : operateInfos) {
                validateOperationResult.addErrorInfo((OperateErrorInfo)operateInfo);
            }
            String msg = operationResult.getMessage();
            if (!SWCStringUtils.isEmpty((String)msg)) {
                validateOperationResult.setMessage(msg);
            }
        }
    }

    private DynamicObject genEmptyDyobjWithPkId(String entityId, Long pkId) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(entityId);
        DynamicObject dyobj = serviceHelper.generateEmptyDynamicObject();
        dyobj.set("id", (Object)pkId);
        return dyobj;
    }

    private void setDyobjDefVal(DynamicObject dyobj, String entityId) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
        Map allFields = mainEntityType.getAllFields();
        allFields.forEach((fieldKey, dp) -> {
            if (!"entryentity".equals(dp.getParent().getName())) {
                if (dp instanceof CreateDateProp || dp instanceof ModifyDateProp) {
                    dyobj.set(fieldKey, (Object)new Date());
                } else if (dp instanceof CreaterProp || dp instanceof ModifierProp) {
                    dyobj.set(fieldKey, (Object)RequestContext.get().getUserId());
                } else if (dp instanceof FieldProp) {
                    dyobj.set(fieldKey, ((FieldProp)dp).getDefValue());
                }
            }
        });
    }

    private void setFieldEnable() {
        this.getView().setEnable((Boolean)this.getModel().getValue("isescrowstaff"), new String[]{"isescrowstaff"});
    }

    private void updatePreview(Object salaryFileVidNew) {
        IFormView view = this.getView();
        OperateOption opParam = OperateOption.create();
        opParam.setVariableValue("afterSaveOrChange", "true");
        if (salaryFileVidNew != null) {
            opParam.setVariableValue("salaryFileVidNew", String.valueOf(salaryFileVidNew));
        }
        if (view.getParentView() != null) {
            view.getParentView().invokeOperation("refresh", opParam);
            view.sendFormAction(view.getParentView());
        }
    }

    public void afterChangeMainOrg(AfterChangeMainOrgEventArgs args) {
        this.getModel().getDataEntity().set(KEY_PAYROLLGROUP, null);
        this.getView().updateView(KEY_PAYROLLGROUP);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldKey = args.getProperty().getName();
        ChangeData changeData = args.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        switch (fieldKey) {
            case "employee": {
                if (this.getPageCache().get(IS_SET_OLD_VALUE) == null) break;
                this.getPageCache().remove(IS_SET_OLD_VALUE);
                return;
            }
            case "org": {
                this.checkConfirmPage(oldValue, true);
                break;
            }
            case "isescrowstaff": {
                this.clickIsEscrowStaff();
                break;
            }
            case "adminorg": {
                this.changeAdminOrg(args);
                break;
            }
            case "payrollregion": {
                this.checkConfirmPage(oldValue, false);
                break;
            }
            case "bsed": {
                break;
            }
            case "depemp": {
                this.onDepEmpPropertyChanged(args);
                break;
            }
        }
        SalaryTaxFileRelViewHelper.propertyOfSalaryChanged((IFormView)this.getView(), (String)fieldKey, (Object)newValue, (Object)oldValue);
    }

    private void onDepEmpPropertyChanged(PropertyChangedArgs e) {
        long employeeIdNew;
        ChangeData[] changeSet = e.getChangeSet();
        DynamicObject newDepEmpValue = (DynamicObject)changeSet[0].getNewValue();
        long employeeId = this.getModel().getDataEntity().getLong("employee.id");
        long l = employeeIdNew = newDepEmpValue == null ? 0L : newDepEmpValue.getLong("employee.id");
        if (newDepEmpValue != null && employeeId != employeeIdNew) {
            this.getModel().beginInit();
            this.getModel().setValue(KEY_EMPLOYEE, (Object)employeeIdNew);
            this.getModel().endInit();
        }
        this.setEmpPosOrgRelValue(newDepEmpValue);
        this.setAdminOrgValue(newDepEmpValue);
        this.setManagingScope(newDepEmpValue);
    }

    private void setAdminOrgValue(DynamicObject newValue) {
        if (newValue == null) {
            this.getModel().setValue("adminorg", null);
            this.getModel().setValue(KEY_BSED, null);
            return;
        }
        Long adminOrgId = newValue.getLong("adminorg.id");
        Set permOrgIds = SalaryFilePermissionHelper.getOrgIdsByPermissionId((String)"47156aff000000ac");
        if (permOrgIds == null || permOrgIds.contains(adminOrgId)) {
            this.getModel().setValue("adminorg", (Object)adminOrgId);
        } else {
            this.getModel().setValue("adminorg", null);
        }
        this.getModel().setValue(KEY_BSED, (Object)newValue.getDate("startdate"));
    }

    private void setEmpPosOrgRelValue(DynamicObject newValue) {
        QFilter dataStatusFilter;
        QFilter isCurrentVersionFilter;
        if (newValue == null) {
            this.getModel().setValue(KEY_EMPPOSINFO, null);
            return;
        }
        long depEmpId = newValue.getLong("id");
        long employeeId = newValue.getLong("employee.id");
        if (employeeId == 0L) {
            return;
        }
        SWCDataServiceHelper empPosOrgRelHr = new SWCDataServiceHelper("hsas_empposorgrelhr");
        QFilter depEmpIdFilter = new QFilter("depemp.id", "=", (Object)depEmpId);
        DynamicObject[] empPosOrgs = empPosOrgRelHr.query("adminorgvid", new QFilter[]{depEmpIdFilter, isCurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1"), dataStatusFilter = new QFilter("datastatus", "=", (Object)"1")});
        if (empPosOrgs != null && empPosOrgs.length > 0) {
            this.getModel().setValue(KEY_EMPPOSINFO, empPosOrgs[0].getPkValue());
            this.getModel().setValue("adminorgvid", empPosOrgs[0].get("adminorgvid"));
        }
    }

    private void checkConfirmPage(Object oldValue, boolean isOrg) {
        boolean condition;
        Object payrollgroup = this.getModel().getDataEntity().get(KEY_PAYROLLGROUP);
        Object salaryCalcStyle = this.getModel().getDataEntity().get(KEY_SALARYCALCSTYLE);
        boolean bl = condition = null == payrollgroup && null == salaryCalcStyle || null == oldValue;
        if (condition) {
            return;
        }
        Object regionId = ((DynamicObject)oldValue).get("id");
        String customValue = "";
        if (regionId != null) {
            customValue = String.valueOf(regionId);
        }
        String tips = ResManager.loadKDString((String)"\u66f4\u6539\u540e\uff0c\u4f1a\u6e05\u7a7a\u201c\u85aa\u8d44\u6838\u7b97\u7ec4\u201d\u3001\u201c\u7b97\u53d1\u85aa\u65b9\u5f0f\u201d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"SalaryFileAddNewPlugin_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        if (isOrg) {
            this.getView().showConfirm(tips, "", MessageBoxOptions.OKCancel, null, new ConfirmCallBackListener(CALLBACK_ORG), null, customValue);
        } else {
            this.getView().showConfirm(tips, "", MessageBoxOptions.OKCancel, null, new ConfirmCallBackListener(CALLBACK_REGION), null, customValue);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        switch (messageBoxClosedEvent.getCallBackId()) {
            case "continue_close": {
                if (messageBoxClosedEvent.getResult() != MessageBoxResult.Yes) break;
                SWCPageCache pageCache = new SWCPageCache(this.getView());
                pageCache.put("afterconfirm", (Object)Boolean.TRUE);
                this.getModel().setDataChanged(false);
                this.getView().invokeOperation("close");
                break;
            }
            case "callbackRegion": {
                this.confirmAfterModify(messageBoxClosedEvent, false);
                break;
            }
            case "callbackOrg": {
                this.confirmAfterModify(messageBoxClosedEvent, true);
                break;
            }
            case "VALUE_NOT_SAME_TIPS": {
                messageBoxClosedEvent.getCustomVaule();
                break;
            }
            case "callback_HasNotUseBizData": {
                this.confirmAfterBizNotUse(messageBoxClosedEvent);
                break;
            }
            case "callback_beforeEmpStartDate_save": {
                this.confirmAfterBeforeEmpStartDate(messageBoxClosedEvent);
                break;
            }
            case "callback_beforeEmpStartDate_saveafteraudit": {
                this.confirmAfterBeforeEmpStartDate(messageBoxClosedEvent);
                break;
            }
            case "callback_validateDepemp": {
                this.confirmAfterValidateDepemp(messageBoxClosedEvent);
                break;
            }
            case "callback_validatePayEndDate": {
                this.confirmAfterValidatePayEndDate(messageBoxClosedEvent);
                break;
            }
        }
    }

    private void confirmAfterValidatePayEndDate(MessageBoxClosedEvent messageBoxClosedEvent) {
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        IDataModel model = this.getModel();
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            pageCache.put(CALLBACKID_BEFOREEMPSTARTDATE, (Object)Boolean.TRUE);
            pageCache.put(IS_CONTINUE_BIZNOTUSE, (Object)Boolean.TRUE);
            pageCache.put(IS_CONTINUE_VALIDATE_PAYENDDATE, (Object)Boolean.TRUE);
            pageCache.put(IS_CONTINUE_VALIDATEDEPEMP, (Object)Boolean.TRUE);
            String customVaule = messageBoxClosedEvent.getCustomVaule();
            Boolean flag = false;
            if (!SWCStringUtils.isEmpty((String)customVaule)) {
                flag = Boolean.parseBoolean(customVaule);
            }
            model.setValue("isupdatepayenddate", (Object)flag);
            this.getView().invokeOperation("saveafteraudit");
        } else if (messageBoxClosedEvent.getResult() == MessageBoxResult.No) {
            pageCache.put(CALLBACKID_BEFOREEMPSTARTDATE, (Object)Boolean.TRUE);
            pageCache.put(IS_CONTINUE_BIZNOTUSE, (Object)Boolean.TRUE);
            pageCache.put(IS_CONTINUE_VALIDATE_PAYENDDATE, (Object)Boolean.TRUE);
            pageCache.put(IS_CONTINUE_VALIDATEDEPEMP, (Object)Boolean.TRUE);
            model.setValue("isupdatepayenddate", (Object)false);
            this.getView().invokeOperation("saveafteraudit");
        } else {
            this.getPageCache().remove(IS_CONTINUE_VALIDATE_PAYENDDATE);
        }
    }

    private void confirmAfterValidateDepemp(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            SWCPageCache pageCache = new SWCPageCache(this.getView());
            pageCache.put(CALLBACKID_BEFOREEMPSTARTDATE, (Object)Boolean.TRUE);
            pageCache.put(IS_CONTINUE_BIZNOTUSE, (Object)Boolean.TRUE);
            pageCache.put(IS_CONTINUE_VALIDATEDEPEMP, (Object)Boolean.TRUE);
            this.getView().invokeOperation("saveafteraudit");
        }
    }

    private void confirmAfterBizNotUse(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            SWCPageCache pageCache = new SWCPageCache(this.getView());
            pageCache.put(CALLBACKID_BEFOREEMPSTARTDATE, (Object)Boolean.TRUE);
            pageCache.put(IS_CONTINUE_BIZNOTUSE, (Object)Boolean.TRUE);
            this.getView().invokeOperation("saveafteraudit");
        }
    }

    private void confirmAfterBeforeEmpStartDate(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            SWCPageCache pageCache = new SWCPageCache(this.getView());
            pageCache.put(CALLBACKID_BEFOREEMPSTARTDATE, (Object)Boolean.TRUE);
            String callBackId = messageBoxClosedEvent.getCallBackId();
            if (CALLBACKID_BEFOREEMPSTARTDATE.equals(callBackId)) {
                this.getView().invokeOperation("save");
            } else if (CALLBACKID_BEFOREEMPSTARTDATEAUDIT.equals(callBackId)) {
                this.getView().invokeOperation("saveafteraudit");
            }
        }
    }

    private void confirmAfterModify(MessageBoxClosedEvent event, boolean isOrg) {
        if (MessageBoxResult.Cancel.equals((Object)event.getResult())) {
            IDataModel model = this.getModel();
            model.beginInit();
            if (isOrg) {
                model.setValue("org", (Object)event.getCustomVaule());
            } else {
                model.setValue(KEY_PAYROLLREGION, (Object)event.getCustomVaule());
            }
            model.endInit();
            this.getView().updateView("org");
            this.getView().updateView(KEY_PAYROLLREGION);
        } else {
            this.getModel().getDataEntity().set(KEY_PAYROLLGROUP, null);
            this.getModel().getDataEntity().set(KEY_SALARYCALCSTYLE, null);
            this.getModel().getDataEntity().set("paystatus", null);
            this.getView().updateView(KEY_PAYROLLGROUP);
            this.getView().updateView("paysubject");
            this.getView().updateView(KEY_SALARYCALCSTYLE);
            this.getView().updateView("paystatus");
        }
    }

    private void setManagingScope(Object newValue) {
        if (null == newValue) {
            return;
        }
        DynamicObject fileDy = this.getModel().getDataEntity();
        SalaryFileHelper.setManagingScope((DynamicObject[])new DynamicObject[]{fileDy});
        this.getModel().setValue("managingscope", fileDy.get("managingscope.id"));
        this.getView().updateView("managingscope");
        this.getView().updateView("managingscopehbss");
    }

    private boolean validateBsedField() {
        Date empEndDate;
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        Boolean isContinue = (Boolean)pageCache.get(CALLBACKID_BEFOREEMPSTARTDATE, Boolean.class);
        if (isContinue != null && isContinue.booleanValue()) {
            this.getPageCache().remove(CALLBACKID_BEFOREEMPSTARTDATE);
            return true;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Date bsedDate = dataEntity.getDate(KEY_BSED);
        if (bsedDate == null) {
            return true;
        }
        bsedDate = SalaryFileEmpPosOrgRelHelper.getDateDay((Date)bsedDate);
        Date empStartDate = dataEntity.getDate("depemp.startdate");
        if (empStartDate != null) {
            empStartDate = SalaryFileEmpPosOrgRelHelper.getDateDay((Date)empStartDate);
        }
        empEndDate = (empEndDate = dataEntity.getDate("depemp.enddate")) == null ? SalaryFileEmpPosOrgRelHelper.getMaxDate() : SalaryFileEmpPosOrgRelHelper.getDateDay((Date)empEndDate);
        String status = this.getStatus();
        Boolean saveCondition = "A".equals(status) && (empStartDate != null && SWCDateTimeUtils.dayBefore((Date)bsedDate, (Date)empStartDate) || empEndDate != null && SWCDateTimeUtils.dayAfter((Date)bsedDate, (Date)empEndDate));
        if (saveCondition.booleanValue()) {
            String msg = ResManager.loadKDString((String)"\u6863\u6848\u751f\u6548\u65e5\u671f{0}\u8d85\u51fa\u6240\u9009\u4e2d\u7684\u5c97\u4f4d\u7684\u65e5\u671f\u8303\u56f4{1} \u81f3 {2}\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"SalaryFileEdit_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            String bsedDateStr = HRInteDateTimeUtil.formatDate((String)"hsas_salaryfile", (String)KEY_BSED, (Date)bsedDate);
            String empStartDateStr = HRInteDateTimeUtil.formatDate((String)"hsas_depemp", (String)"startdate", (Date)empStartDate);
            String empEndDateStr = HRInteDateTimeUtil.formatDate((String)"hsas_depemp", (String)"enddate", (Date)empEndDate);
            this.getView().showConfirm(MessageFormat.format(msg, bsedDateStr, empStartDateStr, empEndDateStr), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CALLBACKID_BEFOREEMPSTARTDATE, (IFormPlugin)this));
            return false;
        }
        Boolean auditCondition = empStartDate != null && "C".equals(status) && SWCDateTimeUtils.dayBefore((Date)bsedDate, (Date)empStartDate);
        if (auditCondition.booleanValue()) {
            String msg = ResManager.loadKDString((String)"\u6863\u6848\u751f\u6548\u65e5\u671f{0}\u65e9\u4e8e\u6240\u9009\u7684\u5c97\u4f4d\u7684\u5f00\u59cb\u65e5\u671f{1}\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"SalaryFileEdit_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            String bsedDateStr = HRInteDateTimeUtil.formatDate((String)"hsas_salaryfile", (String)KEY_BSED, (Date)bsedDate);
            String empStartDateStr = HRInteDateTimeUtil.formatDate((String)"hsas_depemp", (String)"startdate", (Date)empStartDate);
            this.getView().showConfirm(MessageFormat.format(msg, bsedDateStr, empStartDateStr), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CALLBACKID_BEFOREEMPSTARTDATEAUDIT, (IFormPlugin)this));
            return false;
        }
        return true;
    }

    private String getStatus() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String status = (String)customParams.get("status");
        if (status == null) {
            status = this.getView().getModel().getDataEntity().getString("status");
        }
        return status;
    }

    private void changeAdminOrg(PropertyChangedArgs e) {
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        if (this.getModel().getDataEntity().getBoolean("isescrowstaff")) {
            DynamicObject emp = (DynamicObject)newValue;
            if (null != emp && emp.getLong("id") == this.getModel().getDataEntity().getLong("depemp.orgteam.id")) {
                this.setValueWithoutPropertyChanged("isescrowstaff", Boolean.FALSE);
                this.getView().setEnable(Boolean.FALSE, new String[]{"isescrowstaff"});
            }
        } else if (null != oldValue && null != newValue && oldValue != newValue) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"isescrowstaff"});
            this.setValueWithoutPropertyChanged("isescrowstaff", Boolean.TRUE);
        }
    }

    private void clickIsEscrowStaff() {
        this.setValueWithoutPropertyChanged("adminorg", this.getModel().getDataEntity().getLong("depemp.orgteam.id"));
        this.getView().setEnable(Boolean.FALSE, new String[]{"isescrowstaff"});
    }

    private void setValueWithoutPropertyChanged(String fieldKey, Object value) {
        this.getModel().beginInit();
        this.getModel().setValue(fieldKey, value);
        this.getModel().endInit();
        this.getView().updateView(fieldKey);
    }

    private void addSalaryStyleFilter(BeforeF7SelectEvent arg) {
        DynamicObject orgDynamicObject = this.getModel().getDataEntity().getDynamicObject("org");
        DynamicObject regionDynamicObject = this.getModel().getDataEntity().getDynamicObject(KEY_PAYROLLREGION);
        if (regionDynamicObject != null) {
            QFilter countryQFilter = new QFilter("country", "=", regionDynamicObject.getPkValue());
            QFilter countryTypeQFilter = new QFilter("countrytype", "=", (Object)"1");
            arg.addCustomQFilter(countryQFilter.or(countryTypeQFilter));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg) {
        String fieldKey;
        switch (fieldKey = arg.getProperty().getName()) {
            case "payrollgroup": {
                this.openPayrollGroup(arg);
                break;
            }
            case "empposinfo": {
                this.validateBeforeSelectEmpposorgrel(arg);
                break;
            }
            case "payrollregion": {
                this.addPayRollRegionFilter(arg);
                break;
            }
            case "salarycalcstyle": {
                this.addSalaryStyleFilter(arg);
                break;
            }
            case "depemp": {
                arg.getCustomQFilters().add(this.getDepEmpFilter());
                break;
            }
            case "employee": {
                if ("setItemByNumber".equals(arg.getSourceMethod())) break;
                arg.setCancel(true);
                this.showDepempF7QueryListF7();
                break;
            }
        }
    }

    private void showDepempF7QueryListF7() {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setFormId("hsas_depempf7querylistf7");
        listShowParameter.setBillFormId("hsas_depempf7querylist");
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss inlineStyleCss = new StyleCss();
        inlineStyleCss.setHeight("680");
        inlineStyleCss.setWidth("1200");
        listShowParameter.getOpenStyle().setInlineStyleCss(inlineStyleCss);
        listShowParameter.setMultiSelect(false);
        listShowParameter.setLookUp(true);
        listShowParameter.setAppId("hsas");
        listShowParameter.setShowTitle(false);
        listShowParameter.setHasRight(true);
        listShowParameter.getListFilterParameter().setFilter(this.getDepEmpFilter());
        listShowParameter.getListFilterParameter().setFilter(this.getDataRuleForBdProp(KEY_EMPPOSINFO, "hsas_empposorgrelhr"));
        listShowParameter.getListFilterParameter().setFilter(this.getDataRuleForBdProp("depemp", null));
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_DEPEMPF7QUERYLISTF7));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private QFilter getDataRuleForBdProp(String propFullKey, String queryEntity) {
        boolean isSuperUser = SWCPermissionServiceHelper.isSuperUser();
        QFilter empposFilter = SWCPermissionServiceHelper.getDataRuleForBdProp((long)RequestContext.get().getCurrUserId(), (String)"/UHMBBGZQ65X", (String)"hsas_salaryfile", (String)propFullKey, (String)"47150e89000000ac");
        if (!isSuperUser && empposFilter != null) {
            empposFilter.__setProperty(queryEntity == null ? empposFilter.getProperty() : queryEntity + "." + empposFilter.getProperty());
            for (QFilter.QFilterNest tmpFilter : empposFilter.getNests(true)) {
                tmpFilter.getFilter().__setProperty(queryEntity == null ? tmpFilter.getFilter().getProperty() : queryEntity + "." + tmpFilter.getFilter().getProperty());
            }
            return empposFilter;
        }
        return null;
    }

    private QFilter getDepEmpFilter() {
        QFilter classifyNumberFilter;
        DynamicObjectCollection dynamicObjectCollection;
        QFilter employeeIdFilter;
        SWCDataServiceHelper empPosOrgRelOrm;
        DynamicObject dynamicObject;
        QFilter returnFilter = QFilter.of((String)" 1 = 1", (Object[])new Object[0]);
        String permEntity = "hsas_salaryfile";
        String permItemId = "47150e89000000ac";
        Set adminOrgIds = SWCPermissionServiceHelper.getAuthorizedAdminOrgsF7((Long)RequestContext.get().getCurrUserId(), (String)"/UHMBBGZQ65X", (String)permEntity, (String)permItemId, (String)"depemp.orgteam");
        if (adminOrgIds != null && adminOrgIds.size() >= 1) {
            String propKey = SalaryFilePermissionHelper.getAdminorgPermPropKey();
            if ("adminorgvid".equals(propKey)) {
                returnFilter.and(new QFilter("hsas_empposorgrelhr.adminorgvid.id", "in", (Object)adminOrgIds));
            } else {
                returnFilter.and(new QFilter("orgteam.id", "in", (Object)adminOrgIds));
            }
        }
        this.dealPermWhenAdminorgVid(returnFilter);
        long salaryFileId = this.getModel().getDataEntity().getLong("id");
        Set<Object> workRoleIds = new HashSet(16);
        if (salaryFileId > 0L && (dynamicObject = (empPosOrgRelOrm = new SWCDataServiceHelper("hsas_empposorgrel")).queryOne("id,workrole", new QFilter[]{employeeIdFilter = new QFilter("salaryfile.id", "=", (Object)salaryFileId)})) != null && !CollectionUtils.isEmpty((Collection)(dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity")))) {
            workRoleIds = dynamicObjectCollection.stream().map(item -> item.getLong("workrole.id")).filter(item -> item > 0L).collect(Collectors.toSet());
        }
        QFilter isTimeRemainedFilter = new QFilter("istimeremained", "!=", (Object)"0");
        QFilter filter = classifyNumberFilter = new QFilter("otclassify.id", "in", (Object)new Long[]{1010L});
        DynamicObject fileDy = this.getModel().getDataEntity();
        DynamicObject employee = fileDy.getDynamicObject(KEY_EMPLOYEE);
        if (fileDy.getLong("id") != 0L && employee != null) {
            QFilter personIdQFilter = new QFilter("employee.person.id", "=", employee.get("person.id"));
            filter.and(personIdQFilter);
        }
        if (SalaryFileEmpPosOrgRelHelper.isValidateDepEmpDateForFronted()) {
            filter.and(isTimeRemainedFilter);
        }
        if (!CollectionUtils.isEmpty(workRoleIds)) {
            QFilter idFilter = new QFilter("id", "in", workRoleIds);
            returnFilter.and(idFilter.or(filter));
        } else {
            returnFilter.and(filter);
        }
        return returnFilter;
    }

    private void dealPermWhenAdminorgVid(QFilter returnFilter) {
        String propKey = SalaryFilePermissionHelper.getAdminorgPermPropKey();
        if (!"adminorgvid".equals(propKey)) {
            return;
        }
        Set adminOrgIds = SWCPermissionServiceHelper.getAdminOrgSetByPermItem((String)"/UHMBBGZQ65X", (String)"hsas_salaryfile", (String)"47150e89000000ac", (String)"adminorgvid");
        if (adminOrgIds != null) {
            QFilter adminOrgPremFilter = new QFilter("adminorgvid", "in", (Object)adminOrgIds);
            adminOrgPremFilter.and("datastatus", "in", (Object)SWCHisBaseConstants.getValidStatus());
            SWCDataServiceHelper empPosOrgRelHrOrm = new SWCDataServiceHelper("hsas_empposorgrelhr");
            DynamicObject[] empArr = empPosOrgRelHrOrm.query("depemp.id", adminOrgPremFilter.toArray());
            Set depempIds = Arrays.stream(empArr).map(emp -> emp.getLong("depemp.id")).collect(Collectors.toSet());
            returnFilter.and(new QFilter("id", "in", depempIds));
        }
    }

    private void addPayRollRegionFilter(BeforeF7SelectEvent arg) {
        Set countrySetByPermItem = SWCPermissionServiceHelper.getCountrySetByPermItem((String)"/UHMBBGZQ65X", (String)"hsas_salaryfile", (String)"47156aff000000ac");
        if (!SWCPermissionServiceHelper.isSuperUser() && countrySetByPermItem != null) {
            arg.addCustomQFilter(new QFilter("id", "in", (Object)countrySetByPermItem));
        }
    }

    private void openPayrollGroup(BeforeF7SelectEvent arg) {
        long orgId = this.getModel().getDataEntity().getLong("org.id");
        if (orgId == 0L) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7\u540e\uff0c\u518d\u9009\u62e9\u201c\u85aa\u8d44\u6838\u7b97\u7ec4\u201d\u3002", (String)"SalaryFileAddNewPlugin_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            arg.setCancel(true);
            return;
        }
        long countryId = this.getModel().getDataEntity().getLong("payrollregion.id");
        if (0L == countryId) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53d1\u85aa\u7ba1\u7406\u5c5e\u5730\u540e\u518d\u9009\u62e9\u201c\u85aa\u8d44\u6838\u7b97\u7ec4\u201d\u3002", (String)"SalaryFileAddNewPlugin_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            arg.setCancel(true);
            return;
        }
        QFilter countryFilter = new QFilter("country.id", "=", (Object)countryId);
        QFilter bizOrgFilter = new QFilter("org.id", "=", (Object)orgId);
        Date date = this.getModel().getDataEntity().getDate(KEY_BSED);
        if (date != null) {
            bizOrgFilter.and(new QFilter("firstbsed", "<=", (Object)date));
        }
        ListShowParameter param = (ListShowParameter)arg.getFormShowParameter();
        param.getListFilterParameter().getQFilters().add(countryFilter);
        param.getListFilterParameter().getQFilters().add(bizOrgFilter);
    }

    private void validateBeforeSelectEmpposorgrel(BeforeF7SelectEvent arg) {
        long employeeId = this.getModel().getDataEntity().getLong("employee.id");
        List empList = SWCSalaryFileServiceHelper.getEmpList((long)employeeId, null);
        arg.setCustomQFilters(empList);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        SWCDataServiceHelper depHelper;
        DynamicObject newDepEmpValue;
        Object[] primaryKeyValues;
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (CLOSE_CALL_BACK_UPDATE_PAY_END_DATE.equalsIgnoreCase(actionId)) {
            returnData = (Map)closedCallBackEvent.getReturnData();
            String action = MapUtils.getString((Map)returnData, (Object)"action", (String)"cancel");
            SWCPageCache pageCache = new SWCPageCache(this.getView());
            IDataModel model = this.getModel();
            if ("ok".equalsIgnoreCase(action)) {
                pageCache.put(CALLBACKID_BEFOREEMPSTARTDATE, (Object)Boolean.TRUE);
                pageCache.put(IS_CONTINUE_BIZNOTUSE, (Object)Boolean.TRUE);
                pageCache.put(IS_CONTINUE_VALIDATE_PAYENDDATE, (Object)Boolean.TRUE);
                pageCache.put(IS_CONTINUE_VALIDATEDEPEMP, (Object)Boolean.TRUE);
                Boolean isUpdatePayEndDate = MapUtils.getBoolean((Map)returnData, (Object)"isUpdatePayEndDate", (Boolean)Boolean.FALSE);
                model.setValue("isupdatepayenddate", (Object)isUpdatePayEndDate);
                this.getView().invokeOperation("saveafteraudit");
            } else {
                this.getPageCache().remove(IS_CONTINUE_VALIDATE_PAYENDDATE);
            }
        }
        if (CALLBACK_DEPEMPF7QUERYLISTF7.equalsIgnoreCase(actionId) && null != (returnData = closedCallBackEvent.getReturnData()) && Objects.nonNull(primaryKeyValues = ((ListSelectedRowCollection)returnData).getPrimaryKeyValues()) && Objects.nonNull(newDepEmpValue = (depHelper = new SWCDataServiceHelper("hsas_depemp")).queryOne("employee, employee.person.id, person, person.personindexid", primaryKeyValues[0]))) {
            this.getPageCache().put(IS_SET_OLD_VALUE, "true");
            this.getModel().setValue(KEY_EMPLOYEE, newDepEmpValue.get(KEY_EMPLOYEE));
            this.getModel().setValue("person", newDepEmpValue.get("person"));
            this.getModel().setValue("depemp", newDepEmpValue.get("id"));
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        IFormView view = this.getView();
        SWCPageCache pageCache = new SWCPageCache(view);
        Boolean isContinueClose = (Boolean)pageCache.get("afterconfirm", Boolean.class);
        if (null == isContinueClose || !isContinueClose.booleanValue()) {
            IFormView taxFileView;
            IDataModel dataModel = this.getModel();
            boolean dataChanged = false;
            StringBuilder query = new StringBuilder();
            String titleHeader = ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"SalaryFileTaxAddNewPlugin_22", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            if (view.getFormShowParameter().getCustomParam("salaryFileId") == null && view.getPageCache().get("salaryFileId") == null && (dataChanged = view.getModel().getDataChanged())) {
                DynamicObject dataEntity = this.getModel().getDataEntity(false);
                DataEntityState dataEntityState = dataEntity.getDataEntityState();
                DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
                dataEntityState.setBizChanged(((IDataEntityProperty)properties.get((Object)"number")).getOrdinal(), false);
                dataEntityState.setBizChanged(((IDataEntityProperty)properties.get((Object)"managingscope_id")).getOrdinal(), false);
                dataEntityState.setBizChanged(((IDataEntityProperty)properties.get((Object)"empposinfo_id")).getOrdinal(), false);
                dataEntityState.setBizChanged(((IDataEntityProperty)properties.get((Object)"adminorgvid_id")).getOrdinal(), false);
                dataModel.getDataChanged();
                String salaryTitleHeader = ResManager.loadKDString((String)"\u4eba\u5458\u85aa\u8d44\u6863\u6848", (String)"SalaryFileTaxAddNewPlugin_23", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                String changeDesc = dataModel.getChangeDesc().replace(titleHeader, salaryTitleHeader);
                query.append(changeDesc);
            }
            if (dataModel.getDataEntity().getBoolean("addtaxfilecheckbox") && (taxFileView = view.getView(view.getPageCache().get("taxFilePageId"))) != null) {
                boolean taxChanged = taxFileView.getModel().getDataChanged();
                boolean bl = dataChanged = dataChanged || taxChanged;
                if (taxChanged) {
                    if (query.length() > 0) {
                        query.append("\r\n");
                    }
                    String taxTitleHeader = ResManager.loadKDString((String)"\u4eba\u5458\u4e2a\u7a0e\u6863\u6848", (String)"SalaryFileTaxAddNewPlugin_24", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                    query.append(taxFileView.getModel().getChangeDesc().replace(titleHeader, taxTitleHeader));
                }
            }
            if (e.isCheckDataChange() && dataChanged) {
                ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener("continue_close", (IFormPlugin)this);
                HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(4);
                btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"SalaryFileAddNewPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"SalaryFileAddNewPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                MessageBoxOptions options = MessageBoxOptions.OKCancel;
                String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"SalaryFileAddNewPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                msg = StringUtils.isNotBlank((CharSequence)msg) ? msg.replaceAll("\\\\r\\\\n", "\r\n") : msg;
                view.showConfirm(msg, query.toString(), options, ConfirmTypes.Save, confirmCallBack, btnNameMaps);
                e.setCancel(true);
            }
        } else {
            pageCache.remove("afterconfirm");
        }
    }
}

