/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.file.subpage;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsas.business.dataport.PersonImportHelper;
import kd.swc.hsas.business.salaryfile.SalaryTaxFileRelViewHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.taxservice.TaxCalServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;

public class SalaryFileExportPlugin
extends AbstractListPlugin {
    private static final String EVENT_COMMFIREEXPORT = "commfireExport";
    private static final String CONTINUE_IMPORT_TAXFILE = "continueImportTaxFile";

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operKey;
        super.afterDoOperation(args);
        switch (operKey = args.getOperateKey()) {
            case "donothing_import": {
                this.importData();
                break;
            }
            case "export_template": {
                this.exportByImportTemplate();
                break;
            }
            case "import_taxfile": {
                if (!this.hasTaxFileAddPerm()) break;
                this.checkEnableCal();
                break;
            }
            case "importdetail_taxfile": {
                if (!this.hasTaxFileAddPerm()) break;
                this.openImportDetail();
                break;
            }
        }
    }

    private boolean hasTaxFileAddPerm() {
        if (!SalaryTaxFileRelViewHelper.hasTaxFileAddPerm()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u4eba\u5458\u4e2a\u7a0e\u6863\u6848\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\u3002", (String)"SalaryFileTaxAddNewPlugin_34", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void openImportDetail() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setFormId("bos_list");
        showParameter.setBillFormId("bos_importlog");
        showParameter.setCaption(ResManager.loadKDString((String)"\u4eba\u5458\u4e2a\u7a0e\u6863\u6848\u5bfc\u5165\u7ed3\u679c", (String)"SalaryFileExportPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        String mainEntityName = EntityMetadataCache.getDataEntityType((String)"hsas_taxfiletmp").getDisplayName().toString();
        QFilter filter = new QFilter("name", "=", (Object)mainEntityName);
        filter.and("billno", "like", (Object)"IMPORT_hsas_taxfiletmp_%");
        ListFilterParameter filterParameter = new ListFilterParameter((List)Lists.newArrayList((Object[])new QFilter[]{filter}), null);
        showParameter.setListFilterParameter(filterParameter);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void importData() {
        FormShowParameter importShowParameter = new FormShowParameter();
        importShowParameter.setCustomParam("entityid", (Object)((IListView)this.getView()).getBillFormId());
        importShowParameter.setCustomParam("hastaxfileperm", (Object)Boolean.valueOf(this.getPageCache().get("hastaxfileperm")));
        importShowParameter.setFormId("hsas_person_importstart");
        importShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        importShowParameter.setCaption(ResManager.loadKDString((String)"\u4eba\u5458\u85aa\u8d44\u6863\u6848\u5bfc\u5165\u8d77\u59cb\u9875", (String)"SalaryFileList_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        this.getView().showForm(importShowParameter);
    }

    private void onlyImportTaxfile() {
        FormShowParameter importShowParameter = new FormShowParameter();
        importShowParameter.setCustomParam("entityid", (Object)"hsas_taxfiletmp");
        importShowParameter.setCustomParam("hastaxfileperm", new SWCPageCache(this.getView()).get("hastaxfileperm", Boolean.TYPE));
        importShowParameter.setFormId("hsas_person_importstart");
        importShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        importShowParameter.setCaption(ResManager.loadKDString((String)"\u4eba\u5458\u4e2a\u7a0e\u6863\u6848\u5bfc\u5165\u8d77\u59cb\u9875", (String)"SalaryFileExportPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        this.getView().showForm(importShowParameter);
    }

    private void exportByImportTemplate() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        ArrayList selectIds = new ArrayList(selectedRows.size());
        selectedRows.forEach(obj -> selectIds.add((Long)obj.getPrimaryKeyValue()));
        BillList billList = (BillList)this.getView().getControl("billlistap");
        int count = billList.queryBillDataCount();
        if (selectIds.size() == 0) {
            String message = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u5c06\u5bfc\u51fa%d\u5f20\u5355\u636e\uff0c\u662f\u5426\u5bfc\u51fa\uff1f", (String)"PersonStartImportPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]), count);
            this.getView().showConfirm(message, MessageBoxOptions.YesNo, new ConfirmCallBackListener(EVENT_COMMFIREEXPORT, (IFormPlugin)this));
            this.getPageCache().put("total", String.valueOf(count));
            return;
        }
        this.getPageCache().put("selectIds", SerializationUtils.toJsonString(selectIds));
        this.getPageCache().put("total", String.valueOf(selectIds.size()));
        PersonImportHelper.openExportingPage((boolean)false, (IFormView)this.getView());
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (e.getResult() == MessageBoxResult.Yes) {
            if (EVENT_COMMFIREEXPORT.equals(e.getCallBackId())) {
                PersonImportHelper.openExportingPage((boolean)true, (IFormView)this.getView());
            }
            if (CONTINUE_IMPORT_TAXFILE.equals(e.getCallBackId())) {
                this.onlyImportTaxfile();
            }
        }
    }

    private void checkEnableCal() {
        ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
        if (!CollectionUtils.isEmpty((Collection)selectedRows)) {
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salaryfile");
            Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
            QFilter filter = new QFilter("id", "in", (Object)primaryKeyValues);
            Object[] dys = helper.query("payrollregion.id, payrollregion.name", new QFilter[]{filter});
            if (!ArrayUtils.isEmpty((Object[])dys)) {
                HashSet payrollregionNames = Sets.newHashSetWithExpectedSize((int)dys.length);
                for (Object dy : dys) {
                    Boolean calEnable;
                    if (payrollregionNames.contains(dy.getString("payrollregion.name")) || (calEnable = TaxCalServiceHelper.getTaxCalEnableStatusByCountryId((long)dy.getLong("payrollregion.id"))).booleanValue()) continue;
                    payrollregionNames.add(dy.getString("payrollregion.name"));
                }
                if (!CollectionUtils.isEmpty((Collection)payrollregionNames)) {
                    String errorPayrollregionNames = String.join((CharSequence)"\uff0c", payrollregionNames);
                    String format = MessageFormat.format(ResManager.loadKDString((String)"\u56fd\u5bb6/\u5730\u533a\u201c{0}\u201d\u6ca1\u6709\u542f\u7528\u4e2a\u7a0e\u4e91\u670d\u52a1\uff0c\u65e0\u6cd5\u65b0\u589e\u8be5\u56fd\u5bb6/\u5730\u533a\u7684\u4eba\u5458\u4e2a\u7a0e\u6863\u6848\uff0c\u662f\u5426\u7ee7\u7eed?", (String)"SalaryFileExportPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]), errorPayrollregionNames);
                    this.getView().showConfirm(format, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONTINUE_IMPORT_TAXFILE));
                } else {
                    this.onlyImportTaxfile();
                }
            }
        } else {
            this.onlyImportTaxfile();
        }
    }
}

