/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.file.subpage;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.metadata.form.control.BarItemAp;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.swc.hsas.business.paysalarysetting.PaySalarySettingHelper;
import kd.swc.hsas.business.salaryfile.SalaryFileSubTableServiceHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseList;

public class SalaryFileItemGrpCfgList
extends SWCDataBaseList {
    private static final String OP_MODIFY = "donothing_modify";
    private static final String IMPORT_DATA = "do_importdata";

    public void registerListener(EventObject args) {
        super.registerListener(args);
        this.addClickListeners(new String[]{IMPORT_DATA});
    }

    public void setFilter(SetFilterEvent args) {
        if (args.getQFilters() == null) {
            return;
        }
        HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)"hsas_itemgrpcfg", (String)"47150e89000000ac");
        if (!permOrgs.hasAllOrgPerm()) {
            args.getQFilters().add(new QFilter("salaryfile.org", "in", (Object)permOrgs.getHasPermOrgs()));
        }
        if (BaseDataHisHelper.isHisList((IFormView)this.getView()) && this.getView().getFormShowParameter().getCustomParam("nofilter") == null) {
            QFilter qFilterStatus = new QFilter("salaryfile.status", "=", (Object)"C");
            args.getQFilters().add(qFilterStatus);
        }
        BaseDataHisHelper.removeDefaultHRQFilter((IFormView)this.getView(), (List)args.getQFilters());
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        IFormView view = this.getView();
        boolean isHisList = BaseDataHisHelper.isHisList((IFormView)this.getView());
        if (isHisList) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"listoperatecol"});
            Container toolBar = (Container)view.getControl("toolbarap");
            if (toolBar == null) {
                return;
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"confirmchange", "deletehisbtn", "tblrefreshhis", "tblclosehis"});
            toolBar.deleteControls(new String[]{"bar_hischange", "baritemap_refresh", "tblclosehisnew"});
            ArrayList items = Lists.newArrayListWithExpectedSize((int)16);
            this.genModifyBtn(items);
            this.genRefreshBtn(items);
            this.genCloseBtn(items);
            toolBar.addControls((List)items);
        }
    }

    private void genModifyBtn(List<Map<String, Object>> items) {
        BarItemAp confirmChangeBtn = new BarItemAp();
        confirmChangeBtn.setKey("bar_hischange");
        confirmChangeBtn.setName(new LocaleString(ResManager.loadKDString((String)"\u4fee\u6539", (String)"SalaryFilePaySettingList_4", (String)"swc-hsas-formplugin", (Object[])new Object[0])));
        confirmChangeBtn.setOperationKey(OP_MODIFY);
        items.add(confirmChangeBtn.createControl());
    }

    private void genRefreshBtn(List<Map<String, Object>> items) {
        BarItemAp insertDataBtn = new BarItemAp();
        insertDataBtn.setKey("baritemap_refresh");
        insertDataBtn.setName(new LocaleString(ResManager.loadKDString((String)"\u5237\u65b0", (String)"FormulaSettingEdit_33", (String)"swc-hsas-formplugin", (Object[])new Object[0])));
        insertDataBtn.setOperationKey("refresh");
        items.add(insertDataBtn.createControl());
    }

    private void genCloseBtn(List<Map<String, Object>> items) {
        BarItemAp closeBtn = new BarItemAp();
        closeBtn.setKey("tblclosehisnew");
        closeBtn.setName(new LocaleString(ResManager.loadKDString((String)"\u9000\u51fa", (String)"FormulaSettingEdit_34", (String)"swc-hsas-formplugin", (Object[])new Object[0])));
        closeBtn.setOperationKey("close");
        items.add(closeBtn.createControl());
    }

    private void jumpToPaySettingHisModify(BeforeDoOperationEventArgs args) {
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection selectIds = listview.getSelectedRows();
        boolean isVerifyPassed = SalaryFileSubTableServiceHelper.verifyPermAndIsSelected((BeforeDoOperationEventArgs)args, (IFormView)this.getView(), (ListSelectedRowCollection)selectIds, (String)"hsas_itemgrpcfg");
        if (!isVerifyPassed) {
            return;
        }
        Object pkId = selectIds.getPrimaryKeyValues()[0];
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(listview.getBillFormId());
        DynamicObject salaryfileSubObj = serviceHelper.queryOne("id, boid, datastatus, salaryfile", pkId);
        isVerifyPassed = SalaryFileSubTableServiceHelper.verifyHisDataStatus((BeforeDoOperationEventArgs)args, (IFormView)this.getView(), (DynamicObject)salaryfileSubObj);
        if (!isVerifyPassed) {
            return;
        }
        String userId = SalaryFileSubTableServiceHelper.getDataMutexLockUserId((String)pkId.toString(), (String)"hsas_itemgrpcfghis");
        if (!SWCStringUtils.isEmpty((String)userId)) {
            Map userMap = UserServiceHelper.getUserInfoByID((long)Long.parseLong(userId));
            String tip = ResManager.loadKDString((String)"{0} \u6b63\u5728PC\u7aef\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"SalaryFileItemGrpCfgList_2", (String)"swc-hsas-formplugin", (Object[])new Object[]{userMap.get("name")});
            this.getView().showTipNotification(tip);
            return;
        }
        StringBuilder caption = new StringBuilder(this.getView().getFormShowParameter().getCaption());
        caption.append('-').append(salaryfileSubObj.getString("salaryfile.person.name"));
        BaseShowParameter parameter = SalaryFileSubTableServiceHelper.getBaseShowParameter((String)pkId.toString(), (String)"hsas_itemgrpcfghis", (DynamicObject)salaryfileSubObj);
        if (parameter != null) {
            parameter.setCaption(caption.toString());
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        String fieldName;
        super.filterContainerBeforeF7Select(args);
        switch (fieldName = args.getFieldName()) {
            case "salaryitem.id": 
            case "salaryitem.name": {
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                this.setAmoutFilter(qFilters);
                args.getCustomQFilters().addAll(qFilters);
                break;
            }
        }
    }

    private void setAmoutFilter(List<QFilter> qFilters) {
        QFilter amountFilter = new QFilter("datatype.number", "=", (Object)"1020_S");
        QFilter enableFilter = new QFilter("enable", "!=", (Object)"2");
        qFilters.add(enableFilter);
        qFilters.add(amountFilter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (SWCStringUtils.equals((String)operateKey, (String)OP_MODIFY)) {
            this.jumpToPaySettingHisModify(args);
        } else if (SWCStringUtils.equals((String)operateKey, (String)IMPORT_DATA)) {
            FormShowParameter importShowParameter = new FormShowParameter();
            importShowParameter.setCustomParam("BillFormId", (Object)((IListView)this.getView()).getBillFormId());
            importShowParameter.setFormId("hsas_importpaysetting");
            importShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            importShowParameter.setCaption(ResManager.loadKDString((String)"\u9879\u76ee\u8d44\u683c\u7ec4\u8bbe\u7f6e\u5bfc\u5165\u8d77\u59cb\u9875", (String)"SalaryFileItemGrpCfgList_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            importShowParameter.setCustomParam("OperateKey", (Object)IMPORT_DATA);
            importShowParameter.setCustomParam("ImportPlugin", (Object)"kd.swc.hsas.formplugin.web.file.subpage.ItemGroupMultiBoBatchImportPlugin");
            importShowParameter.setCustomParam("ListName", (Object)ResManager.loadKDString((String)"\u9879\u76ee\u8d44\u683c\u7ec4\u8bbe\u7f6e", (String)"SalaryFileItemGrpCfgList_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            importShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hsas_importpaysetting"));
            importShowParameter.setCustomParam("RealPermissionEntityId", (Object)"hsas_itemgrpcfg");
            this.getView().showForm(importShowParameter);
        }
    }

    public void packageData(PackageDataEvent e) {
        super.packageData(e);
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        String fieldKey = columnDesc.getFieldKey();
        if (fieldKey.equals("dynamictextlistcolumnap")) {
            e.setFormatValue((Object)PaySalarySettingHelper.getSalaryItemName((DynamicObject)e.getRowData()));
        }
        if (fieldKey.equals("payamount")) {
            DynamicObject rowData = e.getRowData();
            BigDecimal payAmount = rowData.getBigDecimal("entryentity.payamount");
            BigDecimal bigDecimal = payAmount.stripTrailingZeros();
            e.setFormatValue((Object)(BigDecimal.ZERO.compareTo(payAmount) == 0 ? null : bigDecimal));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("hsas_importpaysetting".equals(actionId)) {
            this.getView().invokeOperation("refresh");
        }
    }
}

