/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.file.subpage;

import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.IEntityOperate;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Container;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.control.BarItemAp;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.hr.hbp.business.util.HRBaseDataConfigUtil;
import kd.swc.hsas.business.file.PersonCertCommonHelper;
import kd.swc.hsas.business.file.SalaryFilePermissionHelper;
import kd.swc.hsas.business.paysalarysetting.paysetting.UpdatePaySettingService;
import kd.swc.hsas.business.salaryfile.SWCSalaryFileServiceHelper;
import kd.swc.hsas.business.salaryfile.SalaryTaxFileRelViewHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCCertCommonHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.taxservice.TaxCalServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class SalaryFileList
extends AbstractListPlugin {
    private static final Log log = LogFactory.getLog(SalaryFileList.class);
    public static final String ADD_NEW_TAX = "addnewtax";
    public static final String SWC_HSAS_FORM_PLUGIN = "swc-hsas-formplugin";
    public static final String OP_DONOTHING_SALARYFILEHIS = "donothing_salaryfilehis";
    private static final Log LOGGER = LogFactory.getLog(SalaryFileList.class);
    private static final String DATA_LIMIT_SHOW_PROCESS = "1000";
    private static final String ISSECONDCONFIRM = "isSecondConfirm";
    private static final String OP_DONOTHING_UPDATEPAYSETTING = "donothing_updatepaysetting";
    private static final SWCDataServiceHelper FILE_SERVICE_HELPER = new SWCDataServiceHelper("hsas_salaryfile");
    private FilterContainerInitArgs initArgs;

    private boolean hasTaxPerm() {
        return SalaryTaxFileRelViewHelper.hasTaxFileAddPerm();
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"deletehisbtn", "confirmchange", "listoperatecol"});
        this.hideCol(args);
        this.createBillListHisBtnBar();
    }

    private void createBillListHisBtnBar() {
        IFormView view = this.getView();
        boolean isHisList = BaseDataHisHelper.isHisList((IFormView)this.getView());
        if (isHisList) {
            Container toolBar = (Container)view.getControl("toolbarap");
            if (toolBar == null) {
                return;
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblrefreshhis", "tblclosehis"});
            toolBar.deleteControls(new String[]{"tblrefreshhis", "tblclosehis", "export", "exportdetails", "baritemap_refresh", "tblclosehisnew"});
            ArrayList items = Lists.newArrayListWithExpectedSize((int)16);
            this.genExportBtn(items);
            this.genRefreshBtn(items);
            this.genCloseBtn(items);
            toolBar.addControls((List)items);
        }
    }

    private void genExportBtn(List<Map<String, Object>> items) {
        BarItemAp confirmChangeBtn = new BarItemAp();
        confirmChangeBtn.setKey("export");
        confirmChangeBtn.setName(new LocaleString(ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e", (String)"SalaryFileList_24", (String)SWC_HSAS_FORM_PLUGIN, (Object[])new Object[0])));
        confirmChangeBtn.setOperationKey("exportlistbyselectfields");
        items.add(confirmChangeBtn.createControl());
        BarItemAp exportdetailsBtn = new BarItemAp();
        exportdetailsBtn.setKey("exportdetails");
        exportdetailsBtn.setName(new LocaleString(ResManager.loadKDString((String)"\u67e5\u770b\u5bfc\u51fa\u7ed3\u679c", (String)"SalaryFileList_25", (String)SWC_HSAS_FORM_PLUGIN, (Object[])new Object[0])));
        exportdetailsBtn.setOperationKey("exportdetails");
        items.add(exportdetailsBtn.createControl());
    }

    private void genRefreshBtn(List<Map<String, Object>> items) {
        BarItemAp insertDataBtn = new BarItemAp();
        insertDataBtn.setKey("baritemap_refresh");
        insertDataBtn.setName(new LocaleString(ResManager.loadKDString((String)"\u5237\u65b0", (String)"FormulaSettingEdit_33", (String)SWC_HSAS_FORM_PLUGIN, (Object[])new Object[0])));
        insertDataBtn.setOperationKey("refresh");
        items.add(insertDataBtn.createControl());
    }

    private void genCloseBtn(List<Map<String, Object>> items) {
        BarItemAp closeBtn = new BarItemAp();
        closeBtn.setKey("tblclosehisnew");
        closeBtn.setName(new LocaleString(ResManager.loadKDString((String)"\u9000\u51fa", (String)"FormulaSettingEdit_34", (String)SWC_HSAS_FORM_PLUGIN, (Object[])new Object[0])));
        closeBtn.setOperationKey("close");
        items.add(closeBtn.createControl());
    }

    private void hideCol(BeforeCreateListColumnsArgs args) {
        List columnList = args.getListColumns();
        Iterator it = columnList.iterator();
        boolean isCurrList = BaseDataHisHelper.isCurrList((IFormView)this.getView());
        boolean needAudit = HRBaseDataConfigUtil.getAudit((String)"hsas_salaryfile");
        while (it.hasNext()) {
            IListColumn col = (IListColumn)it.next();
            String fieldKey = col.getListFieldKey();
            if (needAudit && isCurrList && "salaryfile.status".equals(fieldKey)) {
                it.remove();
            }
            if (isCurrList || !"versionsource".equals(fieldKey)) continue;
            it.remove();
        }
    }

    public void beforeBindData(EventObject eventObject) {
        boolean hasPerm = this.hasTaxPerm();
        boolean noPermBtnHide = this.isNoPermBtnHide();
        this.getPageCache().put("hastaxfileperm", String.valueOf(hasPerm));
        if (!"hsas_apphome".equals(this.getView().getFormShowParameter().getParentFormId())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"taxfilegroup", "newmainjobfile"});
        } else if (((ListShowParameter)this.getView().getFormShowParameter()).isLookUp() || !hasPerm && noPermBtnHide) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"taxfilegroup"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"taxfilegroup"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operKey = formOperate.getOperateKey();
        boolean isHisList = BaseDataHisHelper.isHisList((IFormView)this.getView());
        ArrayList<String> hisOpList = new ArrayList<String>(4);
        hisOpList.add("exportlistbyselectfields");
        hisOpList.add("exportdetails");
        hisOpList.add("refresh");
        hisOpList.add("close");
        if (isHisList && !hisOpList.contains(operKey) && !operKey.contains("ext")) {
            args.setCancel(true);
            return;
        }
        switch (operKey) {
            case "donothing_delete": {
                this.getProgressBar(formOperate);
                break;
            }
            case "donothing_newtaxfile": {
                Boolean calEnable;
                if (!this.hasTaxPerm()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u4eba\u5458\u4e2a\u7a0e\u6863\u6848\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\u3002", (String)"SalaryFileTaxAddNewPlugin_34", (String)SWC_HSAS_FORM_PLUGIN, (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
                if (selectedRows.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"SalaryFileTaxAddNewPlugin_37", (String)SWC_HSAS_FORM_PLUGIN, (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                if (selectedRows.size() > 1) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u521b\u5efa\u4eba\u5458\u4e2a\u7a0e\u6863\u6848\uff0c\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u3002", (String)"SalaryFileTaxAddNewPlugin_14", (String)SWC_HSAS_FORM_PLUGIN, (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_salaryfile");
                Object primaryKeyValue = selectedRows.get(0).getPrimaryKeyValue();
                DynamicObject dynamicObject = serviceHelper.queryOne(primaryKeyValue);
                if (dynamicObject == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u85aa\u8d44\u6863\u6848\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SalaryFileTaxAddNewPlugin_20", (String)SWC_HSAS_FORM_PLUGIN, (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                String status = dynamicObject.getString("status");
                if ("E".equals(status)) {
                    String statusDesc = "";
                    ComboProp statusProp = (ComboProp)dynamicObject.getDataEntityType().getProperties().get((Object)"status");
                    List comboItems = statusProp.getComboItems();
                    for (ValueMapItem comboItem : comboItems) {
                        if (!comboItem.getValue().equals(status)) continue;
                        statusDesc = comboItem.getName().getLocaleValue();
                    }
                    this.getView().showErrorNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u85aa\u8d44\u6863\u6848\u72b6\u6001\u4e3a%s\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\u4eba\u5458\u4e2a\u7a0e\u6863\u6848\u3002", (String)"SalaryFileTaxAddNewPlugin_21", (String)SWC_HSAS_FORM_PLUGIN, (Object[])new Object[0]), statusDesc));
                    args.setCancel(true);
                }
                if ((calEnable = TaxCalServiceHelper.getTaxCalEnableStatusByCountryId((long)dynamicObject.getLong("payrollregion.id"))).booleanValue()) break;
                this.getView().showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"\u56fd\u5bb6/\u5730\u533a\u201c{0}\u201d\u6ca1\u6709\u542f\u7528\u4e2a\u7a0e\u4e91\u670d\u52a1\uff0c\u65e0\u6cd5\u65b0\u589e\u8be5\u56fd\u5bb6/\u5730\u533a\u7684\u4eba\u5458\u4e2a\u7a0e\u6863\u6848\u3002", (String)"SalaryFileList_23", (String)SWC_HSAS_FORM_PLUGIN, (Object[])new Object[0]), dynamicObject.getLocaleString("payrollregion.name")));
                args.setCancel(true);
                break;
            }
            case "donothing_salaryfilehis": {
                String caption = ResManager.loadKDString((String)"\u4eba\u5458\u85aa\u8d44\u6863\u6848\u5386\u53f2", (String)"SalaryFileList_19", (String)SWC_HSAS_FORM_PLUGIN, (Object[])new Object[0]);
                ListShowParameter showParam = BaseDataHisHelper.getOpenHisListPageParam((IFormView)this.getView(), (String)"hsas_salaryfile", null, (boolean)true, (String)caption);
                showParam.setFormId("hsas_salaryfiletreelist");
                this.getView().showForm((FormShowParameter)showParam);
                break;
            }
            case "donothing_updatepaysetting": {
                String isSendConfirm = formOperate.getOption().getVariableValue(ISSECONDCONFIRM, "");
                if (!SWCStringUtils.isEmpty((String)isSendConfirm)) break;
                this.openUpdatePaySettingConfirmForm();
                args.setCancel(true);
                break;
            }
        }
        if ("audit".equals(formOperate.getOperateKey())) {
            formOperate.getOption().setVariableValue("batchop_batchsize", String.valueOf(1000));
        }
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        List qFilters = setFilterEvent.getQFilters();
        if (qFilters == null) {
            return;
        }
        LOGGER.info("------------\u85aa\u8d44\u6863\u6848-\u8fc7\u6ee4----------------\u5165\u53c2\uff1a{}", (Object)setFilterEvent.getQFilters());
        String hisinfolist = (String)this.getView().getFormShowParameter().getCustomParam("hisinfolist");
        if (SWCStringUtils.isNotEmpty((String)hisinfolist)) {
            qFilters.add(BaseDataHisHelper.getHisVerFilter());
            String orderBy = setFilterEvent.getOrderBy();
            if (SWCStringUtils.isNotEmpty((String)orderBy)) {
                setFilterEvent.setOrderBy(orderBy + ",bsed DESC");
            }
        }
        if (BaseDataHisHelper.isHisList((IFormView)this.getView()) && this.getView().getFormShowParameter().getCustomParam("nofilter") == null) {
            QFilter qFilterStatus = new QFilter("salaryfile.status", "=", (Object)"C");
            qFilters.add(qFilterStatus);
        }
        BaseDataHisHelper.removeDefaultHRQFilter((IFormView)this.getView(), (List)qFilters);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operKey;
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operKey = args.getOperateKey()) {
            case "donothing_newmainjobfile": {
                this.openAddNewSingleSalaryFile("A");
                break;
            }
            case "donothing_newtaxfile": {
                this.openAddNewSingleTaxFile();
                break;
            }
            case "donothing_delete": {
                ((IEntityOperate)formOperate).setCancelRefresh(false);
                break;
            }
            case "donothing_updatepaysetting": {
                OperationResult opResult = args.getOperationResult();
                if (!opResult.getSuccessPkIds().isEmpty()) {
                    List salaryFileList = opResult.getSuccessPkIds().stream().map(data -> (Long)data).collect(Collectors.toList());
                    UpdatePaySettingService service = new UpdatePaySettingService();
                    CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "hsas_paysettingupdateprog");
                    service.openUpdatePaySettingProgress(salaryFileList.size(), this.getView(), closeCallBack);
                    String isManuallyModify = this.getView().getPageCache().get("ismanuallymodify");
                    service.updatePaySetting(salaryFileList, this.getView().getPageId(), Boolean.valueOf(isManuallyModify));
                }
                this.getView().getPageCache().remove("ismanuallymodify");
                break;
            }
            case "audit": {
                OperationResult operationResult = args.getOperationResult();
                String message = operationResult.getMessage();
                if (!SWCStringUtils.isNotEmpty((String)message) || !message.contains("filecertwarn")) break;
                ValidateResultCollection validateResult = args.getOperationResult().getValidateResult();
                if (validateResult.isSuccess()) {
                    operationResult.setShowMessage(false);
                }
                String result = message.replace("filecertwarn", "");
                this.getView().showSuccessNotification(result);
                break;
            }
        }
    }

    private void openUpdatePaySettingConfirmForm() {
        long userId = RequestContext.get().getCurrUserId();
        boolean hasPerm = SWCPermissionServiceHelper.hasPermByPermItemNum((long)userId, (String)"/UHMBBGZQ65X", (String)"hsas_salaryfile", (String)"HRQXX0165");
        if (!hasPerm) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u4eba\u5458\u85aa\u8d44\u6863\u6848\u201d\u7684\u201c\u66f4\u65b0\u53d1\u653e\u8bbe\u7f6e\u201d\u6743\u9650\u3002", (String)"SalaryFileList_18", (String)SWC_HSAS_FORM_PLUGIN, (Object[])new Object[0]));
            return;
        }
        ISWCAppCache appCache = SWCAppCache.get((String)"hsas");
        String updatStatus = (String)appCache.get("updatepaysettinglock", String.class);
        if ("1".equals(updatStatus)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u653e\u8bbe\u7f6e\u6279\u91cf\u66f4\u65b0\u4e2d\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85\u3002", (String)"SalaryFileList_17", (String)SWC_HSAS_FORM_PLUGIN, (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId("hsas_paysettingconfirm");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "hsas_paysettingconfirm");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void getProgressBar(FormOperate formOperate) {
        OperateOption option = formOperate.getOption();
        option.setVariableValue("batchop_batchsize", DATA_LIMIT_SHOW_PROCESS);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        String caption = null;
        switch (itemKey) {
            case "salarystd": {
                this.openSubPageList("hsas_salarystd");
                break;
            }
            case "paysetting": {
                this.openSubPageList("hsas_paysetting");
                break;
            }
            case "paysettinghis": {
                caption = ResManager.loadKDString((String)"\u85aa\u8d44\u53d1\u653e\u8bbe\u7f6e\u5386\u53f2", (String)"SalaryFileList_21", (String)SWC_HSAS_FORM_PLUGIN, (Object[])new Object[0]);
                BaseDataHisHelper.openHisListPage((IFormView)this.getView(), (String)"hsas_paysetting", null, (boolean)false, (String)caption);
                break;
            }
            case "itemgroup": {
                this.openSubPageList("hsas_itemgrpcfg");
                break;
            }
            case "itemgroupversion": {
                caption = ResManager.loadKDString((String)"\u9879\u76ee\u8d44\u683c\u7ec4\u8bbe\u7f6e\u5386\u53f2", (String)"SalaryFileList_20", (String)SWC_HSAS_FORM_PLUGIN, (Object[])new Object[0]);
                BaseDataHisHelper.openHisListPage((IFormView)this.getView(), (String)"hsas_itemgrpcfg", null, (boolean)false, (String)caption);
                break;
            }
            default: {
                if (itemKey.contains("addcertto")) {
                    int num = Integer.parseInt(itemKey.split("addcertto")[1]);
                    this.addCertToNum(num);
                }
                if (itemKey.equals("addcert")) {
                    this.openAddCertF7();
                }
                if (itemKey.equals("querycertnum")) {
                    ArrayList personIndexIds = new ArrayList(1);
                    Map resultMap = PersonCertCommonHelper.verifyCertForApply(personIndexIds);
                    Map checkCountMap = (Map)resultMap.get("msg");
                    this.getView().showMessage((String)checkCountMap.get("certDetailMessage"));
                }
                if (itemKey.contains("updatecert")) {
                    SWCMServiceUtils.invokeSWCService((String)"hsbs", (String)"IHSBSService", (String)"updateCertDetail", (Object[])new Object[]{"518"});
                    SWCMServiceUtils.invokeSITService((String)"sitbs", (String)"ISITBSService", (String)"updateCertDetail", (Object[])new Object[]{"519"});
                }
                if (!itemKey.contains("releaselock")) break;
                String entityId = ((ListView)this.getView()).getBillFormId();
                String accountId = RequestContext.get().getAccountId();
                String groupId = MutexHelper.getMutexGroupId((String)entityId, (String)"modify");
                String type = accountId + "_datalock_" + entityId + "_" + groupId;
                DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("dataMutex-pagecache", new DistributeCacheHAPolicy(true, true));
                ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
                Object salaryFileId = selectedRows.get(0).getPrimaryKeyValue();
                cache.remove(type, String.valueOf(salaryFileId));
            }
        }
    }

    private void openAddCertF7() {
        ListShowParameter formShowParameter = new ListShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("bos_listf7");
        StyleCss css = new StyleCss();
        css.setWidth("960px");
        css.setHeight("580px");
        formShowParameter.getOpenStyle().setInlineStyleCss(css);
        formShowParameter.setShowTitle(false);
        formShowParameter.setHasRight(true);
        formShowParameter.setBillFormId("hsas_salaryfile");
        formShowParameter.setLookUp(true);
        formShowParameter.setMultiSelect(true);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addcertCallBack"));
        SWCDataServiceHelper certHelper = new SWCDataServiceHelper("hsbs_certdetail");
        DynamicObject[] certDys = certHelper.query("pid", new QFilter[0]);
        Set certIds2 = Arrays.stream(certDys).map(dy -> dy.getLong("pid")).collect(Collectors.toSet());
        QFilter qFilter2 = new QFilter("person.personindexid", "not in", certIds2);
        formShowParameter.getListFilterParameter().getQFilters().add(qFilter2);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private void addCertToNum(int num) {
        SWCDataServiceHelper fserviceHelper = new SWCDataServiceHelper("hsas_salaryfile");
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        DynamicObject[] fileDys = fserviceHelper.query("person.personindexid", new QFilter[]{qFilter});
        Set requireCertIds = Arrays.stream(fileDys).map(dy -> dy.getLong("person.personindexid")).collect(Collectors.toSet());
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_personhr");
        DynamicObject[] fileDys2 = serviceHelper.query("personindexid", new QFilter[0], null, 6000);
        Set requireCertIds2 = Arrays.stream(fileDys2).map(dy -> dy.getLong("personindexid")).collect(Collectors.toSet());
        SWCDataServiceHelper certHelper = new SWCDataServiceHelper("hsbs_certdetail");
        DynamicObject[] certDys = certHelper.query("pid", new QFilter[0]);
        Set certIds2 = Arrays.stream(certDys).map(dy -> dy.getLong("pid")).collect(Collectors.toSet());
        ArrayList<Long> requireCertIds3 = new ArrayList<Long>(16);
        for (Long id : requireCertIds2) {
            if (requireCertIds.contains(id) || certIds2.contains(id)) continue;
            if (certDys.length + requireCertIds3.size() >= num) break;
            requireCertIds3.add(id);
        }
        SWCCertCommonHelper.updateCert((String)"/UHMBBGZQ65X", (String)"hsas_salaryfile", new ArrayList(requireCertIds3));
    }

    private void openAddNewSingleSalaryFile(String empType) {
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("hsas_salaryfile");
        StyleCss css = new StyleCss();
        css.setWidth("1180px");
        css.setHeight("420px");
        showParameter.getOpenStyle().setInlineStyleCss(css);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.setCustomParam("emptype", (Object)empType);
        showParameter.setPermissionItemId("47156aff000000ac");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addnew"));
        showParameter.setCustomParam("customHREntityNumber", (Object)"hsas_salaryfile");
        showParameter.setCustomParam("customHRPermItemId", (Object)"47156aff000000ac");
        showParameter.setCustomParam("customStatus", (Object)OperationStatus.ADDNEW.name());
        SalaryTaxFileRelViewHelper.resetHeight((FormShowParameter)showParameter);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void openAddNewSingleTaxFile() {
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("hsas_salaryfile");
        StyleCss css = new StyleCss();
        css.setWidth("1180px");
        css.setHeight("628px");
        showParameter.getOpenStyle().setInlineStyleCss(css);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.setPermissionItemId("47156aff000000ac");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ADD_NEW_TAX));
        ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
        Object salaryFileId = selectedRows.get(0).getPrimaryKeyValue();
        showParameter.setCustomParam("salaryFileId", salaryFileId);
        showParameter.setPkId(salaryFileId);
        showParameter.setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u4eba\u5458\u4e2a\u7a0e\u6863\u6848", (String)"SalaryFileTaxAddNewPlugin_28", (String)SWC_HSAS_FORM_PLUGIN, (Object[])new Object[0]));
        SalaryTaxFileRelViewHelper.resetHeight((FormShowParameter)showParameter);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String colKey;
        switch (colKey = args.getFieldName()) {
            case "number": {
                LOGGER.info("SalaryFileList.billListHyperLinkClick.NUMBER begin...1");
                ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
                if (listShowParameter.isLookUp()) break;
                LOGGER.info("SalaryFileList.billListHyperLinkClick.NUMBER begin...2");
                this.openSalaryFileFormView(args);
                break;
            }
        }
    }

    private void openSalaryFileFormView(HyperLinkClickArgs hyperLinkClickArgs) {
        hyperLinkClickArgs.setCancel(true);
        LOGGER.info("billListHyperLinkClick.NUMBER begin...3");
        this.checkSalaryFilePerm();
        LOGGER.info("billListHyperLinkClick.NUMBER begin...4");
        BillList list = (BillList)hyperLinkClickArgs.getHyperLinkClickEvent().getSource();
        Long pkId = (Long)list.getFocusRowPkId();
        LOGGER.info("billListHyperLinkClick.NUMBER begin...5");
        SWCSalaryFileServiceHelper.assembleSalaryFileDataAndOpenFormView((Long)pkId, (IFormView)this.getView(), (String)this.getReadOnlyParam(pkId));
    }

    private String getReadOnlyParam(Long pkId) {
        FormShowParameter parameter;
        String readOnly = "false";
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salaryfile");
        DynamicObject salaryFileDyobj = helper.queryOne("datastatus", (Object)pkId);
        if (salaryFileDyobj == null) {
            return "true";
        }
        String datastatus = salaryFileDyobj.getString("datastatus");
        if ("-2".equals(datastatus) || "-1".equals(datastatus)) {
            return "true";
        }
        for (IFormView view = this.getView(); view != null; view = view.getViewNoPlugin(parameter.getParentPageId())) {
            parameter = view.getFormShowParameter();
            if (!"hsas_filerightpage".equals(parameter.getFormId())) continue;
            Object isOnlyView = parameter.getCustomParam("isOnlyView");
            if (isOnlyView == null) {
                return readOnly;
            }
            return String.valueOf(isOnlyView);
        }
        return readOnly;
    }

    private void checkSalaryFilePerm() {
        if (!this.checkPermission("47150e89000000ac", "hsas_salaryfile")) {
            String message = SWCPermissionServiceHelper.getNoPermTips((String)ResManager.loadKDString((String)"\u6863\u6848\u67e5\u770b", (String)"SalaryFileList_2", (String)SWC_HSAS_FORM_PLUGIN, (Object[])new Object[0]));
            throw new KDBizException(message);
        }
    }

    private boolean checkPermission(String permItemId, String entityName) {
        return SWCPermissionServiceHelper.hasPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)"/UHMBBGZQ65X", (String)entityName, (String)permItemId);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData = closedCallBackEvent.getReturnData();
        switch (closedCallBackEvent.getActionId()) {
            case "addnew": {
                Long pkId = (Long)closedCallBackEvent.getReturnData();
                if (null == pkId || pkId == 0L) break;
                SWCSalaryFileServiceHelper.assembleSalaryFileDataAndOpenFormView((Long)pkId, (IFormView)this.getView());
                break;
            }
            case "addnewtax": {
                Object taxFileId = closedCallBackEvent.getReturnData();
                if (SWCObjectUtils.isEmpty((Object)taxFileId)) break;
                DynamicObject taxFileTemp = (DynamicObject)closedCallBackEvent.getReturnData();
                SalaryTaxFileRelViewHelper.showTaxFilePreview((long)taxFileTemp.getLong("taxfile"), (long)taxFileTemp.getLong("taxregion.id"), (int)1, (IFormView)this.getView(), (boolean)false);
                break;
            }
            case "hsas_paysettingconfirm": {
                Map confirmReturnData = (Map)closedCallBackEvent.getReturnData();
                if (SWCObjectUtils.isEmpty((Object)confirmReturnData)) {
                    return;
                }
                String opKey = (String)confirmReturnData.get("opkey");
                if (!"btnok".equals(opKey)) break;
                boolean isManuallyModify = (Boolean)confirmReturnData.get("ismanuallymodify");
                this.getView().getPageCache().put("ismanuallymodify", String.valueOf(isManuallyModify));
                OperateOption option = OperateOption.create();
                option.setVariableValue(ISSECONDCONFIRM, opKey);
                this.getView().invokeOperation(OP_DONOTHING_UPDATEPAYSETTING, option);
                break;
            }
            case "hsas_paysettingupdateprog": {
                UpdatePaySettingService service = new UpdatePaySettingService();
                service.openPaySettingList(this.getView(), (Map)closedCallBackEvent.getReturnData());
                break;
            }
            case "addcertCallBack": {
                ListSelectedRowCollection listSelectedRows = (ListSelectedRowCollection)returnData;
                if (listSelectedRows == null) {
                    return;
                }
                QFilter sFilter = new QFilter("id", "in", (Object)listSelectedRows.getPrimaryKeyValues());
                DynamicObject[] fileDys = FILE_SERVICE_HELPER.query("person.personindexid", new QFilter[]{sFilter});
                Set indexIds = Arrays.stream(fileDys).map(dy -> dy.getLong("person.personindexid")).collect(Collectors.toSet());
                SWCCertCommonHelper.updateCert((String)"/UHMBBGZQ65X", (String)"hsas_salaryfile", new ArrayList(indexIds));
                break;
            }
        }
    }

    private void openSubPageList(String formId, boolean isLeftTree) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        if (isLeftTree) {
            showParameter.setFormId("hsas_salaryfiletreelist");
        } else {
            showParameter.setFormId("bos_list");
        }
        String newPageId = formId + this.getView().getPageId();
        showParameter.setPageId(newPageId);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void openSubPageList(String formId) {
        this.openSubPageList(formId, false);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        this.initArgs = args;
        List commonFilterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilterColumnList) {
            String fieldName = filterColumn.getFieldName();
            if (!fieldName.startsWith("payrollgroup")) continue;
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            QFilter qFilter = new QFilter("status", "=", (Object)"C");
            qFilter.and("enable", "=", (Object)"1");
            BaseDataHisHelper.addHisCurrFilter((QFilter)qFilter);
            String appId = EntityMetadataCache.getDataEntityType((String)"hsas_salaryfile").getAppId();
            QFilter permFilter = SWCPermissionServiceHelper.getDataRuleForBdProp((String)appId, (String)"hsas_salaryfile", (String)"payrollgroup");
            if (permFilter != null) {
                qFilter.and(permFilter);
            }
            ArrayList<DynamicObject> groups = new ArrayList<DynamicObject>(10);
            String orgId = this.getPageCache().get("org.id");
            if (orgId != null) {
                qFilter.and("org.id", "=", (Object)Long.valueOf(orgId));
                DynamicObject[] groupArr = BusinessDataServiceHelper.load((String)"hsas_payrollgrp", (String)"id,name", (QFilter[])qFilter.toArray());
                groups.addAll(Arrays.asList(groupArr));
            } else {
                HasPermOrgResult hasPermOrgResult = SalaryFilePermissionHelper.getBusinessUnitPermissionResult();
                List bosPermOrgIds = hasPermOrgResult.getHasPermOrgs();
                if (!hasPermOrgResult.hasAllOrgPerm()) {
                    List subList = Lists.partition((List)bosPermOrgIds, (int)10000);
                    for (List tempList : subList) {
                        QFilter groupFilter = new QFilter("org.id", "in", (Object)tempList);
                        DynamicObject[] groupArr = BusinessDataServiceHelper.load((String)"hsas_payrollgrp", (String)"id,name", (QFilter[])new QFilter[]{qFilter, groupFilter});
                        groups.addAll(Arrays.asList(groupArr));
                    }
                } else {
                    DynamicObject[] groupArr = BusinessDataServiceHelper.load((String)"hsas_payrollgrp", (String)"id,name", (QFilter[])qFilter.toArray());
                    groups.addAll(Arrays.asList(groupArr));
                }
            }
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(10);
            for (DynamicObject group : groups) {
                ComboItem item2 = new ComboItem();
                item2.setCaption(new LocaleString(group.getString("name")));
                item2.setValue(group.getString("id"));
                comboItems.add(item2);
            }
            commonFilterColumn.setComboItems(comboItems);
        }
        List filterColumns = args.getCommonFilterColumns();
        boolean isExists = false;
        for (FilterColumn filterColumn : filterColumns) {
            if (!"salaryfile.status".equals(filterColumn.getFieldName())) continue;
            isExists = true;
        }
        boolean isCurrList = BaseDataHisHelper.isCurrList((IFormView)this.getView());
        boolean needAudit = HRBaseDataConfigUtil.getAudit((String)"hsas_salaryfile");
        if (isCurrList && !needAudit && !isExists) {
            CommonFilterColumn filterColumn = new CommonFilterColumn();
            filterColumn.setFieldName("salaryfile.status");
            filterColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6863\u6848\u72b6\u6001", (String)"SalaryFileList_26", (String)SWC_HSAS_FORM_PLUGIN, (Object[])new Object[0])));
            String billFormId = ((ListView)this.getView()).getListModel().getDataEntityType().getName();
            ArrayList combos = new ArrayList();
            List valueMapItemList = ((ComboProp)EntityMetadataCache.getDataEntityType((String)billFormId).getFields().get("status")).getComboItems();
            valueMapItemList.removeIf(item -> "A".equals(item.getValue()) || "B".equals(item.getValue()));
            valueMapItemList.forEach(valueMapItem -> {
                ComboItem item = new ComboItem();
                item.setCaption(valueMapItem.getName());
                item.setValue(valueMapItem.getValue());
                combos.add(item);
            });
            filterColumn.setComboItems(combos);
            ArrayList defaultValues = Lists.newArrayListWithCapacity((int)16);
            defaultValues.add("C");
            filterColumn.setDefaultValues((List)defaultValues);
            filterColumn.setMulti(true);
            filterColumn.setMustInput(false);
            filterColumn.setCustom(true);
            filterColumns.add(filterColumn);
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        List customfilters = (List)filterValues.get("customfilter");
        if (customfilters != null) {
            String orgIdStr = null;
            List groupIdStrs = null;
            Map filterItemGroup = null;
            for (Map filterItem : customfilters) {
                String fieldName = ((List)filterItem.get("FieldName")).get(0).toString();
                List item = (List)filterItem.get("Value");
                if (fieldName.startsWith("org")) {
                    if (!item.isEmpty() && !"".equals(item.get(0))) {
                        orgIdStr = item.get(0).toString();
                        this.getPageCache().put(fieldName, orgIdStr);
                    } else {
                        this.getPageCache().remove(fieldName);
                    }
                }
                if (!fieldName.startsWith("payrollgroup")) continue;
                filterItemGroup = filterItem;
                if (item.isEmpty() || "".equals(item.get(0))) continue;
                groupIdStrs = item;
            }
            if (groupIdStrs != null && orgIdStr != null) {
                DynamicObject[] groups;
                QFilter qFilter = new QFilter("status", "=", (Object)"C");
                qFilter.and("enable", "=", (Object)"1");
                BaseDataHisHelper.addHisCurrFilter((QFilter)qFilter);
                qFilter.and("org", "=", (Object)Long.valueOf(orgIdStr));
                ArrayList groupIds = new ArrayList(groupIdStrs.size());
                groupIdStrs.forEach(idStr -> groupIds.add(Long.valueOf(String.valueOf(idStr))));
                qFilter.and("id", "in", groupIds);
                String appId = EntityMetadataCache.getDataEntityType((String)"hsas_salaryfile").getAppId();
                QFilter permFilter = SWCPermissionServiceHelper.getDataRuleForBdProp((String)appId, (String)"hsas_salaryfile", (String)"payrollgroup");
                if (permFilter != null) {
                    qFilter.and(permFilter);
                }
                if ((groups = BusinessDataServiceHelper.load((String)"hsas_payrollgrp", (String)"id,name", (QFilter[])qFilter.toArray())).length == 0) {
                    customfilters.remove(filterItemGroup);
                }
            }
            this.filterContainerInit(this.initArgs);
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        String fieldName = args.getFieldName();
        List empGroupFilters = args.getQfilters();
        switch (fieldName) {
            case "empgroup.id": 
            case "empgroup.name": {
                List empgoupIds = (List)SWCMServiceUtils.invokeHRMPService((String)"hbss", (String)"IHBSSService", (String)"getEmpgroupByAppNumber", (Object[])new Object[]{"hsas"});
                QFilter empGroupFilter = new QFilter("id", "in", (Object)empgoupIds);
                empGroupFilters.add(empGroupFilter);
                break;
            }
            case "payrollgroup.id": 
            case "payrollgroup.name": {
                String orgId;
                HasPermOrgResult hasPermOrgResult = SalaryFilePermissionHelper.getBusinessUnitPermissionResult();
                List bosPermOrgIds = hasPermOrgResult.getHasPermOrgs();
                if (!hasPermOrgResult.hasAllOrgPerm()) {
                    QFilter groupFilter = new QFilter("org.id", "in", (Object)bosPermOrgIds);
                    empGroupFilters.add(groupFilter);
                }
                if ((orgId = this.getPageCache().get("org.id")) == null) break;
                QFilter groupFilter = new QFilter("org.id", "=", (Object)Long.valueOf(orgId));
                empGroupFilters.add(groupFilter);
                break;
            }
        }
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        String fieldName;
        super.filterColumnSetFilter(args);
        switch (fieldName = args.getFieldName()) {
            case "empgroup.name": {
                List empGroupFilters = args.getQFilters();
                List empgoupIds = (List)SWCMServiceUtils.invokeHRMPService((String)"hbss", (String)"IHBSSService", (String)"getEmpgroupByAppNumber", (Object[])new Object[]{"hsas"});
                QFilter empGroupFilter = new QFilter("id", "in", (Object)empgoupIds);
                empGroupFilters.add(empGroupFilter);
                break;
            }
        }
    }

    private boolean isNoPermBtnHide() {
        String appId = "83bfebc8000037ac";
        AppParam apm = new AppParam();
        apm.setAppId(appId);
        apm.setOrgId(Long.valueOf(RequestContext.get().getOrgId()));
        Map paramWhole = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)apm);
        if (paramWhole == null) {
            log.info("SalaryFileList.isNoPermBtnHide paramWhole is null");
            return false;
        }
        Object isNoPermBtnHideObj = paramWhole.get("enable_nopermbtnhide");
        if (isNoPermBtnHideObj == null) {
            log.info("SalaryFileList.isNoPermBtnHide isNoPermBtnHideObj is null");
            return false;
        }
        return (Boolean)isNoPermBtnHideObj;
    }
}

