/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.file.subpage;

import java.util.EventObject;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.file.SalaryFilePermissionHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCAdminOrgTreeListF7Plugin;

public class SalaryFileTreeListF7Plugin
extends SWCAdminOrgTreeListF7Plugin {
    private static final String BTNOK = "btnok";
    private static final String BILLLISTAP = "billlistap";

    public void initializeTree(EventObject e) {
        String propKey = SalaryFilePermissionHelper.getAdminorgPermPropKey();
        this.getView().getFormShowParameter().setCustomParam("listPermProKey", (Object)propKey);
        this.getView().getFormShowParameter().setCustomParam("chkshowdisable", (Object)Boolean.TRUE);
        super.initializeTree(e);
        this.addClickListeners(new String[]{BTNOK});
    }

    protected String getEntityNumber() {
        return null;
    }

    protected String getParentF7PropWrap(ListShowParameter listParameter) {
        String f7PropCtrl;
        String parentFormId = listParameter.getParentFormId();
        if ("hsas_salarydetailrpt".equals(parentFormId) || "hsas_salarysumrpt".equals(parentFormId)) {
            return "adminorg";
        }
        if ("bos_list".equals(parentFormId)) {
            parentFormId = ((ListView)this.getView().getView(listParameter.getParentPageId())).getBillFormId();
        }
        if (this.getEntityNumber() != null) {
            parentFormId = this.getEntityNumber();
        }
        if ((f7PropCtrl = this.queryAdminOrgCtrl(parentFormId)) == null) {
            parentFormId = (String)this.getView().getViewNoPlugin(listParameter.getParentPageId()).getFormShowParameter().getCustomParam("customHREntityNumber");
            f7PropCtrl = this.queryAdminOrgCtrl(parentFormId);
        }
        String f7Prop = "salaryfile.adminorg";
        if (f7PropCtrl != null) {
            f7Prop = f7PropCtrl;
        }
        return f7Prop;
    }

    private String queryAdminOrgCtrl(String entityNumber) {
        if (entityNumber == null) {
            return null;
        }
        SWCDataServiceHelper ctrlOrm = new SWCDataServiceHelper("hrcs_entityctrl");
        QFilter dimFilter = new QFilter("entitytype", "=", (Object)entityNumber);
        Set<Long> dimensions = this.getAdminDimension();
        dimFilter.and("entryentity.dimension.id", "in", dimensions);
        DynamicObjectCollection ctrls = ctrlOrm.queryOriginalCollection("id,entryentity.propkey,entryentity.crossot", new QFilter[]{dimFilter});
        if (ctrls == null || ctrls.size() == 0) {
            return null;
        }
        for (DynamicObject ctrl : ctrls) {
            BasedataProp prop;
            String f7Prop = ctrl.getString("entryentity.propkey");
            IDataEntityProperty mainEntityType = (IDataEntityProperty)EntityMetadataCache.getDataEntityType((String)entityNumber).getFields().get(f7Prop.replace(".adminorgvid", "").replace(".adminorg", ""));
            if (!(mainEntityType instanceof BasedataProp) || !"hsas_salaryfile".equals((prop = (BasedataProp)mainEntityType).getBaseEntityId())) continue;
            return f7Prop;
        }
        return null;
    }

    private Set<Long> getAdminDimension() {
        SWCDataServiceHelper dimOrm = new SWCDataServiceHelper("hrcs_dimension");
        QFilter dimFilter = new QFilter("teamtype", "=", (Object)1010L);
        DynamicObjectCollection dims = dimOrm.queryOriginalCollection("id", new QFilter[]{dimFilter});
        return dims.stream().map(dim -> dim.getLong("id")).collect(Collectors.toSet());
    }

    public void beforeClick(BeforeClickEvent evt) {
        BillList bill;
        ListSelectedRowCollection selectedRows;
        super.beforeClick(evt);
        Button bt = (Button)evt.getSource();
        String key = bt.getKey();
        String parentFormId = this.getView().getFormShowParameter().getParentFormId();
        if (BTNOK.equals(key) && SWCStringUtils.isNotEmpty((String)parentFormId) && "hsas_accresultlist".equals(parentFormId) && (selectedRows = (bill = (BillList)this.getView().getControl(BILLLISTAP)).getSelectedRows()) != null && selectedRows.size() > 10000) {
            evt.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u591a\u9009\u62e910000\u6761\u6570\u636e\u3002", (String)"SalaryFileTreeListF7Plugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
    }
}

