/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.file.subpage.paysetting;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.swc.hsas.business.paysalarysetting.paysetting.entity.PaySettingUpdateProgressInfo;
import kd.swc.hsbp.common.cache.SWCAppCache;

public class PaySettingUpdateBallTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(PaySettingUpdateBallTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        PaySettingUpdateProgressInfo progressInfo;
        String recordId = (String)map.get("recordId");
        String key = String.format(Locale.ROOT, "paySettingUpdateProgress_%s", recordId);
        int preProgress = 0;
        Date preChangeTime = new Date();
        StringBuilder messageSb = new StringBuilder();
        while ((progressInfo = (PaySettingUpdateProgressInfo)SWCAppCache.get((String)"hsas").get(key, PaySettingUpdateProgressInfo.class)) != null) {
            String desc;
            int status = progressInfo.getStatus();
            int progress = 0;
            int total = progressInfo.getTotal();
            int finish = progressInfo.getFinish();
            if (total != 0) {
                progress = new BigDecimal(String.valueOf(finish)).divide(new BigDecimal(String.valueOf(total)), 2, 4).multiply(new BigDecimal("100")).intValue();
            }
            if (progress >= 100) {
                desc = ResManager.loadKDString((String)"\u66f4\u65b0\u53d1\u653e\u8bbe\u7f6e\u5df2\u5b8c\u6210\u3002", (String)"PaySettingUpdateBallTask_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                this.feedbackProgress(progress, desc, null);
                logger.info(desc);
                break;
            }
            String message = ResManager.loadKDString((String)"\u66f4\u65b0\u53d1\u653e\u8bbe\u7f6e\u8fdb\u5ea6\u4e3a", (String)"PaySettingUpdateBallTask_4", (String)"swc-hsas-formplugin", (Object[])new Object[]{progress});
            messageSb.setLength(0);
            messageSb.append(message).append('\uff1a').append(progress).append('%');
            desc = messageSb.toString();
            logger.info(desc);
            this.feedbackProgress(progress, desc, null);
            if (status == 2) break;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.error("sleep failed:{}", (Object)e.getMessage());
            }
            Date now = new Date();
            if (progress != preProgress) {
                preProgress = progress;
                preChangeTime = now;
            }
            if (now.getTime() - preChangeTime.getTime() <= 10800000L) continue;
            break;
        }
    }
}

