/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.file.subpage.paysetting;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.bgtask.HRBackgroundTaskHelper;
import kd.swc.hsas.business.cal.export.SWCExportDataHelper;
import kd.swc.hsas.business.paysalarysetting.PaySalarySettingExportHelper;
import kd.swc.hsas.business.paysalarysetting.paysetting.entity.PaySettingUpdateProgressInfo;
import kd.swc.hsas.business.paysalarysetting.paysetting.entity.UpdateErrorResult;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class PaySettingUpdateProgressPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    protected static final Log logger = LogFactory.getLog(PaySettingUpdateProgressPlugin.class);
    private static final String EXPORTPROGRESSBAR = "exportprogressbar";
    private static final String KEY_BTNMIN = "btn_min";
    private static final String KEY_BTNOK = "btn_ok";
    private static final String KEY_CLOSE = "btn_close";
    private static final String KEY_BTNGIVEUP = "btn_giveup";
    private static final String KEY_FAILDETAILLAB = "labelfaildetail";
    private static final String TASK_RECORD = "task_record_%s";
    private static final String DONOTHING_GIVEUP = "donothing_giveup";

    public void initialize() {
        ProgressBar progressBar = (ProgressBar)this.getControl(EXPORTPROGRESSBAR);
        progressBar.addProgressListener((ProgresssListener)this);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Label failDetailLabel = (Label)this.getView().getControl(KEY_FAILDETAILLAB);
        failDetailLabel.addClickListener((ClickListener)this);
        this.addClickListeners(new String[]{KEY_BTNOK});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.init();
    }

    public void afterBindData(EventObject e) {
        ProgressBar progressBar = (ProgressBar)this.getControl(EXPORTPROGRESSBAR);
        progressBar.start();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control sControl = (Control)evt.getSource();
        switch (sControl.getKey()) {
            case "labelfaildetail": {
                this.downloadFailExcel();
                break;
            }
            case "btn_ok": {
                this.viewUpdateResult();
                break;
            }
        }
    }

    public void onProgress(ProgressEvent progressEvent) {
        Control control = (Control)progressEvent.getSource();
        String progressKey = control.getKey();
        if (SWCStringUtils.equals((String)progressKey, (String)EXPORTPROGRESSBAR)) {
            this.queryAndSetProgressDetails(progressEvent);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        Map map = (Map)this.getView().getFormShowParameter().getCustomParam("customMap");
        String recordId = (String)map.get("recordId");
        ISWCAppCache appCache = SWCAppCache.get((String)"hsas");
        String progressKey = String.format(Locale.ROOT, "paySettingUpdateProgress_%s", recordId);
        PaySettingUpdateProgressInfo progress = (PaySettingUpdateProgressInfo)appCache.get(progressKey, PaySettingUpdateProgressInfo.class);
        String floatingTaskId = (String)appCache.get(String.format(Locale.ROOT, "paySettingUpdateJob_%s", recordId), String.class);
        if (progress != null) {
            int status = progress.getStatus();
            if (StringUtils.isEmpty((CharSequence)floatingTaskId)) {
                return;
            }
            HRBackgroundTaskHelper.getInstance().removeProgressPageId(this.getView(), floatingTaskId);
            Boolean isBackground = (Boolean)this.getView().getFormShowParameter().getCustomParam("isBackground");
            if (status != 2) {
                if (isBackground == null) {
                    HRBackgroundTaskHelper.getInstance().showBaskgroundTask(floatingTaskId);
                }
            } else {
                HRBackgroundTaskHelper.getInstance().confirmEndTask(floatingTaskId, "COMPLETED");
            }
        } else {
            HRBackgroundTaskHelper.getInstance().confirmEndTask(floatingTaskId, "ABORTED");
        }
        this.returnDataToParent();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (DONOTHING_GIVEUP.equals(operateKey)) {
            this.updateGiveUp();
        }
    }

    private void updateGiveUp() {
        int status;
        PaySettingUpdateProgressInfo paySettingUpdateProgressInfo = this.getPaySettingUpdateProgressInfo();
        if (paySettingUpdateProgressInfo != null && (status = paySettingUpdateProgressInfo.getStatus()) != 2) {
            ISWCAppCache appCache = SWCAppCache.get((String)"hsas");
            appCache.put("isCancelUpdatePaySetting", (Object)Boolean.TRUE);
            appCache.put("updatepaysettinglock", (Object)"0");
        }
    }

    private void init() {
        Boolean isFromBall = (Boolean)this.getView().getFormShowParameter().getCustomParam("isFromBall");
        if (isFromBall != null && isFromBall.booleanValue()) {
            String progressKey;
            Map map = (Map)this.getView().getFormShowParameter().getCustomParam("customMap");
            String recordId = (String)map.get("recordId");
            ISWCAppCache appCache = SWCAppCache.get((String)"hsas");
            PaySettingUpdateProgressInfo progress = (PaySettingUpdateProgressInfo)appCache.get(progressKey = String.format(Locale.ROOT, "paySettingUpdateProgress_%s", recordId), PaySettingUpdateProgressInfo.class);
            if (progress != null) {
                int status = progress.getStatus();
                if (status == 2) {
                    this.setProgressBarFormBall(progress);
                } else {
                    this.setProgressBarFromUpdate(progress);
                }
            }
        } else {
            this.setProgressBarFromInit();
        }
    }

    private void setProgressBarFromInit() {
        Label stateLabel = (Label)this.getView().getControl("statelabel");
        stateLabel.setText(ResManager.loadKDString((String)"\u66f4\u65b0\u4e2d\u00b7\u00b7\u00b7", (String)"PaySettingUpdateProgressPlugin_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BTNOK, KEY_CLOSE});
        this.getView().setVisible(Boolean.FALSE, new String[]{"detailpanel", "stateimage"});
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map map = (Map)formShowParameter.getCustomParam("customMap");
        if (CollectionUtils.isEmpty((Map)map)) {
            return;
        }
        Label labelTotal = (Label)this.getView().getControl("totalnum");
        labelTotal.setText(String.valueOf(map.get("totalnum")));
        Label labelSuccess = (Label)this.getView().getControl("successnum");
        labelSuccess.setText("0");
        Label labelFail = (Label)this.getView().getControl("failnum");
        labelFail.setText("0");
    }

    private void setProgressBarFromUpdate(PaySettingUpdateProgressInfo progress) {
        int total = progress.getTotal();
        int success = progress.getSuccess();
        int fail = progress.getFail();
        int finish = progress.getFinish();
        if (total > 0) {
            int percentage = this.calculatePercentageByDivide(finish, total);
            ProgressBar progressBar = (ProgressBar)this.getControl(EXPORTPROGRESSBAR);
            progressBar.setPercent(percentage);
        }
        this.setTotalSuccessAndFail(total, success, fail);
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_BTNGIVEUP, KEY_BTNMIN});
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_CLOSE, KEY_BTNOK, "stateimage"});
    }

    private void setProgressBarFormBall(PaySettingUpdateProgressInfo progress) {
        this.paySettingUpdateResult(progress);
        int total = progress.getTotal();
        int success = progress.getSuccess();
        int fail = progress.getFail();
        this.setTotalSuccessAndFail(total, success, fail);
        ProgressBar progressBar = (ProgressBar)this.getControl(EXPORTPROGRESSBAR);
        progressBar.setPercent(100);
    }

    private void queryAndSetProgressDetails(ProgressEvent progressEvent) {
        PaySettingUpdateProgressInfo progress = this.getPaySettingUpdateProgressInfo();
        if (progress == null) {
            this.stopProgress(progressEvent);
            return;
        }
        int status = progress.getStatus();
        int total = progress.getTotal();
        int success = progress.getSuccess();
        int fail = progress.getFail();
        int finish = progress.getFinish();
        this.setTotalSuccessAndFail(total, success, fail);
        int percentage = 0;
        if (status == 0) {
            return;
        }
        if (status == 2 || total == finish) {
            percentage = 100;
            this.stopProgress(progressEvent);
            this.paySettingUpdateResult(progress);
        } else if (total > 0) {
            percentage = this.calculatePercentageByDivide(finish, total);
        }
        progressEvent.setProgress(percentage);
    }

    private void paySettingUpdateResult(PaySettingUpdateProgressInfo progress) {
        Image stateImage;
        Label stateLabel;
        ISWCAppCache appCache = SWCAppCache.get((String)"hsas");
        Boolean isCancel = (Boolean)appCache.get("isCancelUpdatePaySetting", Boolean.class);
        if (null == isCancel || !isCancel.booleanValue()) {
            stateLabel = (Label)this.getView().getControl("statelabel");
            stateLabel.setText(ResManager.loadKDString((String)"\u66f4\u65b0\u5b8c\u6210", (String)"PaySettingUpdateProgressPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            stateImage = (Image)this.getView().getControl("stateimage");
            stateImage.setUrl("/icons/pc/state/success_28_28.png");
        } else {
            stateLabel = (Label)this.getView().getControl("statelabel");
            stateLabel.setText(ResManager.loadKDString((String)"\u66f4\u65b0\u5df2\u7ec8\u6b62", (String)"PaySettingUpdateProgressPlugin_18", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            stateImage = (Image)this.getView().getControl("stateimage");
            stateImage.setUrl("/icons/pc/state/warning34_34.png");
            this.getView().setVisible(Boolean.TRUE, new String[]{"statelabel", "stateimage"});
            appCache.put("isCancelUpdatePaySetting", (Object)Boolean.FALSE);
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BTNMIN, KEY_BTNGIVEUP});
        this.getView().setVisible(Boolean.TRUE, new String[]{"stateimage", KEY_CLOSE});
        int fail = progress.getFail();
        List errorResultList = progress.getErrorResultList();
        this.showOrHideFailDetail(errorResultList, fail);
        int success = progress.getSuccess();
        List successIdList = progress.getSuccessIdList();
        this.showOrHideBtnOk(success, successIdList);
        logger.info("updateGiveUp,success num:{}", (Object)success);
        logger.info("updateGiveUp,successIdList size:{}", (Object)successIdList.size());
        logger.info("updateGiveUp,fail num:{}", (Object)fail);
        logger.info("updateGiveUp,errorResultList size:{}", (Object)errorResultList.size());
    }

    private void stopProgress(ProgressEvent progressEvent) {
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BTNMIN});
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BTNGIVEUP});
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_CLOSE});
        ProgressBar bar = (ProgressBar)progressEvent.getSource();
        bar.stop();
        ISWCAppCache appCache = SWCAppCache.get((String)"hsas");
        appCache.put("updatepaysettinglock", (Object)"0");
    }

    private void returnDataToParent() {
        Object returnData = this.getView().getReturnData();
        if (returnData != null) {
            this.getView().returnDataToParent(returnData);
        }
    }

    private void downloadFailExcel() {
        long userId = RequestContext.get().getCurrUserId();
        boolean hasPerm = SWCPermissionServiceHelper.hasPermByPermItemNum((long)userId, (String)"/UHMBBGZQ65X", (String)"hsas_salaryfile", (String)"HRQXX0165");
        if (!hasPerm) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u4eba\u5458\u85aa\u8d44\u6863\u6848\u201d\u7684\u201c\u66f4\u65b0\u53d1\u653e\u8bbe\u7f6e\u201d\u6743\u9650\u3002", (String)"PaySettingUpdateProgressPlugin_17", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        String uploadUrl = this.getUploadUrl();
        if (SWCStringUtils.isNotEmpty((String)uploadUrl)) {
            this.getView().download(uploadUrl);
        }
    }

    private void viewUpdateResult() {
        long userId = RequestContext.get().getCurrUserId();
        boolean hasPerm = SWCPermissionServiceHelper.hasPerm((long)userId, (String)"/UHMBBGZQ65X", (String)"hsas_paysetting", (String)"47150e89000000ac");
        if (!hasPerm) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u85aa\u8d44\u53d1\u653e\u8bbe\u7f6e\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\u3002", (String)"PaySettingUpdateProgressPlugin_19", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        PaySettingUpdateProgressInfo progress = this.getPaySettingUpdateProgressInfo();
        ArrayList successIdList = progress == null ? new ArrayList() : progress.getSuccessIdList();
        logger.info("SuccessIdListSize\uff1a{}", (Object)successIdList.size());
        HashMap returnData = new HashMap(16);
        returnData.put("successIdList", successIdList);
        this.getView().setReturnData(returnData);
        Boolean isFromBall = (Boolean)this.getView().getFormShowParameter().getCustomParam("isFromBall");
        if (isFromBall != null && isFromBall.booleanValue()) {
            Map map = (Map)this.getView().getFormShowParameter().getCustomParam("customMap");
            String recordId = (String)map.get("recordId");
            IFormView view = this.getView().getView(recordId);
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setBillFormId("hsas_paysetting");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
            QFilter qFilter = new QFilter("id", "in", successIdList);
            listFilterParameter.setFilter(qFilter);
            showParameter.setListFilterParameter(listFilterParameter);
            if (view == null) {
                view = this.getView().getParentView();
            }
            view.showForm((FormShowParameter)showParameter);
            this.getView().sendFormAction(view);
        }
        this.getView().close();
    }

    private PaySettingUpdateProgressInfo getPaySettingUpdateProgressInfo() {
        Map map = (Map)this.getView().getFormShowParameter().getCustomParam("customMap");
        String recordId = (String)map.get("recordId");
        ISWCAppCache appCache = SWCAppCache.get((String)"hsas");
        return (PaySettingUpdateProgressInfo)appCache.get(String.format(Locale.ROOT, "paySettingUpdateProgress_%s", recordId), PaySettingUpdateProgressInfo.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getUploadUrl() {
        PaySettingUpdateProgressInfo progress = this.getPaySettingUpdateProgressInfo();
        if (progress == null) {
            return "";
        }
        List<Map<String, Object>> errorList = this.convertResult(progress);
        try (SXSSFWorkbook wb = new SXSSFWorkbook(100);){
            String exportSheetName = ResManager.loadKDString((String)"\u66f4\u65b0\u53d1\u653e\u8bbe\u7f6e\u5931\u8d25\u8be6\u60c5", (String)"PaySettingUpdateProgressPlugin_8", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            LinkedHashMap<String, String> errorExportHeaders = this.getExportErrorHeader();
            logger.info("PaySettingUpdateProgressPlugin createExportSheet begin 6-1");
            SXSSFSheet exportSheet = this.createExportSheet(wb, errorExportHeaders, exportSheetName);
            logger.info("PaySettingUpdateProgressPlugin write2ExportContent begin 6-2");
            PaySalarySettingExportHelper.write2ExportContent((SXSSFSheet)exportSheet, (Integer)1, errorList, errorExportHeaders);
            String exportFileName = this.getExportErrorFileName();
            logger.info("PaySettingUpdateProgressPlugin writeFile begin 6-3");
            String string = SWCExportDataHelper.writeFile((SXSSFWorkbook)wb, (String)exportFileName);
            return string;
        }
        catch (Exception e) {
            logger.error("PaySettingUpdateProgressPlugin uploadErrorInfo error 6-4", (Throwable)e);
            String str = ResManager.loadKDString((String)"\u4e0a\u4f20\u9519\u8bef\u65e5\u5fd7\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PaySettingUpdateProgressPlugin_10", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(str + e);
            return "";
        }
    }

    private List<Map<String, Object>> convertResult(PaySettingUpdateProgressInfo progress) {
        List errorResultList = progress.getErrorResultList();
        if (errorResultList != null) {
            logger.info("ErrorResultListSize:{}", (Object)errorResultList.size());
        }
        ArrayList<Map<String, Object>> errorList = new ArrayList<Map<String, Object>>(10);
        if (SWCListUtils.isEmpty((List)errorResultList)) {
            return errorList;
        }
        for (UpdateErrorResult errorResult : errorResultList) {
            HashMap<String, Object> exportMap = new HashMap<String, Object>(16);
            String errorReason = errorResult.getErrorReason();
            String personName = errorResult.getPersonName();
            String personNumber = errorResult.getPersonNumber();
            String salaryFileNumber = errorResult.getSalaryFileNumber();
            exportMap.put("errorLevel", errorResult.getErrorLevel());
            exportMap.put("errorMessage", errorReason);
            exportMap.put("personName", personName);
            exportMap.put("personNumber", personNumber);
            exportMap.put("salaryFileNumber", salaryFileNumber);
            errorList.add(exportMap);
        }
        return errorList;
    }

    private LinkedHashMap<String, String> getExportErrorHeader() {
        LinkedHashMap<String, String> errorExportHeaders = new LinkedHashMap<String, String>(16);
        errorExportHeaders.put("errorMessage", ResManager.loadKDString((String)"\u5931\u8d25\u539f\u56e0/\u9884\u8b66\u63d0\u9192", (String)"PaySettingUpdateProgressPlugin_11", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        errorExportHeaders.put("personName", ResManager.loadKDString((String)"\u59d3\u540d", (String)"PaySettingUpdateProgressPlugin_12", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        errorExportHeaders.put("personNumber", ResManager.loadKDString((String)"\u5de5\u53f7", (String)"PaySettingUpdateProgressPlugin_13", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        errorExportHeaders.put("salaryFileNumber", ResManager.loadKDString((String)"\u6863\u6848\u7f16\u53f7", (String)"PaySettingUpdateProgressPlugin_14", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        return errorExportHeaders;
    }

    private String getExportErrorFileName() {
        String dateStr = SWCDateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd");
        return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u66f4\u65b0\u53d1\u653e\u8bbe\u7f6e\u5931\u8d25\u8be6\u60c5_%s", (String)"PaySettingUpdateProgressPlugin_9", (String)"swc-hsas-formplugin", (Object[])new Object[0]), dateStr);
    }

    private SXSSFSheet createExportSheet(SXSSFWorkbook wb, Map<String, String> errorExportHeaders, String sheetName) {
        SXSSFSheet sheet = wb.createSheet(sheetName);
        sheet.setRandomAccessWindowSize(-1);
        PaySalarySettingExportHelper.write2ExportHead((SXSSFSheet)sheet, errorExportHeaders);
        return sheet;
    }

    private void showOrHideFailDetail(List<UpdateErrorResult> errorResultList, int fail) {
        if (SWCListUtils.isEmpty(errorResultList)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"detailpanel", KEY_FAILDETAILLAB});
            if (fail != 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PaySettingUpdateProgressPlugin_16", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            }
            logger.info("hide labelfaildetail");
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"detailpanel", KEY_FAILDETAILLAB});
            Label labels = (Label)this.getView().getControl(KEY_FAILDETAILLAB);
            labels.setText(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\u8be6\u60c5", (String)"PaySettingUpdateProgressPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            logger.info("show labelfaildetail");
        }
    }

    private void showOrHideBtnOk(int success, List<Long> successIdList) {
        if (SWCListUtils.isEmpty(successIdList)) {
            if (success != 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PaySettingUpdateProgressPlugin_16", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BTNOK});
            logger.info("hide btn_ok");
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_BTNOK});
            logger.info("show btn_ok");
        }
    }

    private void setTotalSuccessAndFail(int total, int success, int fail) {
        Label labelTotal = (Label)this.getView().getControl("totalnum");
        labelTotal.setText(String.valueOf(total));
        Label labelSuccess = (Label)this.getView().getControl("successnum");
        labelSuccess.setText(String.valueOf(success));
        Label labelFail = (Label)this.getView().getControl("failnum");
        labelFail.setText(String.valueOf(fail));
    }

    private int calculatePercentageByDivide(int finish, int total) {
        return new BigDecimal(String.valueOf(finish)).divide(new BigDecimal(String.valueOf(total)), 2, 1).multiply(new BigDecimal("100")).intValue();
    }
}

