/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.formula;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.IFormView;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsas.business.formula.FormulaViewServiceHelper;
import kd.swc.hsas.business.formula.helper.FormulaDataServiceHelper;
import kd.swc.hsas.business.formula.helper.FormulaItemOrFuncTreeHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.lang3.StringUtils;

public class FormulaItemTreePlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
SearchEnterListener {
    private static final Log LOGGER = LogFactory.getLog(FormulaItemTreePlugin.class);
    private static final String ITEMTREEVIEW = "itemtreeview";
    private static final String SEARCHAP = "searchap";
    private static final String FORMULAEDITOR = "formulaeditor";
    private static final String FLOAT = "float";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getView().getControl(ITEMTREEVIEW);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getView().getControl(SEARCHAP);
        search.addEnterListener((SearchEnterListener)this);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = evt.getNodeId().toString();
        String parentId = (String)evt.getParentNodeId();
        if (SWCStringUtils.isEmpty((String)parentId) || !StringUtils.containsAny((CharSequence)parentId, (CharSequence)"FT_") && !StringUtils.containsAny((CharSequence)nodeId, (CharSequence)"FT_")) {
            return;
        }
        List<String> showItemList = this.showItem(nodeId, parentId);
        if (!ObjectUtils.isEmpty(showItemList)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{FLOAT});
            this.showFloat(showItemList);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLOAT});
        }
    }

    private List<Map<String, Object>> getItemValue(String nodeId, String parentId) {
        String pageId = this.getView().getPageId();
        if (pageId == null) {
            return new ArrayList<Map<String, Object>>();
        }
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        List resultList = (List)pageCache.get(nodeId, List.class);
        if (ObjectUtils.isEmpty((Object)resultList)) {
            DynamicObjectCollection dynamicObjects = FormulaDataServiceHelper.getFetchConfigEntryByUniqueCode((String)nodeId);
            pageCache.put(parentId, Collections.singletonList(dynamicObjects));
            resultList = (List)pageCache.get(parentId, List.class);
        }
        resultList = (List)resultList.get(0);
        return resultList;
    }

    private List<String> showItem(String nodeId, String parentId) {
        List<Map<String, Object>> itemList = this.getItemValue(nodeId, parentId);
        ArrayList<String> valueList = new ArrayList<String>();
        if (ObjectUtils.isEmpty(itemList)) {
            return valueList;
        }
        for (Map<String, Object> itemMap : itemList) {
            if (!nodeId.equals(itemMap.get("uniquecode")) && !nodeId.contains("FT_")) continue;
            String srcType = (String)itemMap.get("srctype");
            String srcField = ((String)itemMap.get("srcfield")).trim();
            if (SWCStringUtils.equals((String)srcType, (String)"0")) {
                return null;
            }
            if (SWCStringUtils.equals((String)srcType, (String)"1")) {
                Map srcentityMap = (Map)itemMap.get("srcentity");
                if (CollectionUtils.isEmpty((Map)srcentityMap)) {
                    return null;
                }
                String srcEntity = (String)srcentityMap.get("number");
                String field = (String)itemMap.get("field");
                if (SWCStringUtils.isEmpty((String)srcEntity)) {
                    return null;
                }
                if (SWCStringUtils.isEmpty((String)srcField)) {
                    return null;
                }
                this.getEntityItemList(srcEntity, valueList, srcField, field);
            } else if (SWCStringUtils.equals((String)srcType, (String)"2")) {
                this.getEnumItemList(itemMap, valueList, "enumname");
            }
            this.showFloat(valueList);
        }
        return valueList;
    }

    private void getEntityItemList(String srcEntity, List<String> valueList, String srcField, String field) {
        ArrayList fiels = new ArrayList(10);
        SWCDataServiceHelper basehelper = new SWCDataServiceHelper(srcEntity);
        StringBuilder baseQueryField = new StringBuilder();
        baseQueryField.append("id,number,name");
        baseQueryField.append(", ");
        baseQueryField.append(srcField);
        QFilter baseFilter = new QFilter("1", "=", (Object)1);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)srcEntity);
        Map allFieldsMap = mainEntityType.getAllFields();
        for (Map.Entry entry : allFieldsMap.entrySet()) {
            if (SWCStringUtils.equals((String)((String)entry.getKey()), (String)"status") && !((IDataEntityProperty)entry.getValue()).isDbIgnore()) {
                baseFilter.and(new QFilter("status", "=", (Object)"C"));
            }
            if (SWCStringUtils.equals((String)((String)entry.getKey()), (String)"enable") && !((IDataEntityProperty)entry.getValue()).isDbIgnore()) {
                baseFilter.and(new QFilter("enable", "=", (Object)"1"));
            }
            fiels.add(entry.getKey());
        }
        if (!fiels.contains(srcField)) {
            return;
        }
        DynamicObject[] baseResults = null;
        try {
            baseResults = basehelper.query(baseQueryField.toString(), new QFilter[]{baseFilter});
        }
        catch (Exception exception) {
            LOGGER.error("the meta is not exist.{}", (Object)srcEntity);
        }
        if (ObjectUtils.isEmpty(baseResults)) {
            valueList.add("");
            return;
        }
        for (DynamicObject obj : baseResults) {
            String srcFieldStr = "";
            try {
                srcFieldStr = obj.getString(srcField);
            }
            catch (Exception exception) {
                LOGGER.error("the meta {} is not exist {}", (Object)srcEntity, (Object)srcField);
                continue;
            }
            if (valueList.contains(srcFieldStr)) continue;
            valueList.add(obj.getString(srcField));
        }
    }

    private void getEnumItemList(Map<String, Object> itemMap, List<String> valueList, String srcfield) {
        Map srcenumMap = (Map)itemMap.get("srcenum");
        Long srcenum = (Long)srcenumMap.get("id");
        SWCDataServiceHelper basehelper = new SWCDataServiceHelper("hsbs_enumconfig");
        String baseQueryField = "id,number,name,entryentity ,entryentity.enumname,entryentity.enumvalue";
        QFilter baseFilter = new QFilter("id", "=", (Object)srcenum);
        DynamicObject object = basehelper.queryOne(baseQueryField, new QFilter[]{baseFilter});
        DynamicObjectCollection objects = object.getDynamicObjectCollection("entryentity");
        if (ObjectUtils.isEmpty((Object)objects)) {
            this.showFloat(new ArrayList<String>());
            return;
        }
        for (DynamicObject obj : objects) {
            if (valueList.contains(obj.get(srcfield).toString())) continue;
            valueList.add(obj.get(srcfield).toString());
        }
    }

    private void showFloat(List<String> valueList) {
        CustomControl floatControl = (CustomControl)this.getView().getControl(FLOAT);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("title", ResManager.loadKDString((String)"\u9879\u76ee", (String)"FormulaItemTreePlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        data.put("listItem", valueList);
        data.put("treeDom", "itemlistflex");
        data.put("date", String.valueOf(System.currentTimeMillis()));
        floatControl.setData(data);
    }

    public void treeNodeDoubleClick(TreeNodeEvent evt) {
        String nodeId = evt.getNodeId().toString();
        String parentId = (String)evt.getParentNodeId();
        if (SWCStringUtils.isEmpty((String)parentId) || nodeId.contains("_@_") || FormulaViewServiceHelper.isViewStatus((IDataModel)this.getModel(), (IFormView)this.getView())) {
            return;
        }
        CustomControl formulaEditor = (CustomControl)this.getView().getControl(FORMULAEDITOR);
        SWCPageCache cache = new SWCPageCache(this.getView());
        Map uniqueCodeRelMap = (Map)cache.get("uniqueCodeRelMap", Map.class);
        if (uniqueCodeRelMap == null) {
            return;
        }
        String name = (String)uniqueCodeRelMap.get(nodeId);
        String itemName = nodeId.startsWith("BSP_") && parentId.startsWith("BS") ? "BS[" + (String)uniqueCodeRelMap.get(parentId) + "].[" + name + ']' : this.getItemPrefix(parentId) + '[' + name + ']';
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("method", "insertValue");
        data.put("value", " " + itemName + " ");
        data.put("date", String.valueOf(System.currentTimeMillis()));
        formulaEditor.setData(data);
    }

    private String getItemPrefix(String parentId) {
        String[] array = parentId.split("_@_");
        return array[array.length - 1];
    }

    public void search(SearchEnterEvent arg) {
        String searchText = arg.getText();
        DynamicObject formulaObj = this.getModel().getDataEntity();
        Map dataMap = FormulaDataServiceHelper.getAllItemAndFuncData((IFormView)this.getView(), (DynamicObject)formulaObj);
        boolean isExpend = true;
        if (SWCStringUtils.isEmpty((String)searchText)) {
            isExpend = false;
            searchText = null;
        }
        boolean isProrationFormula = SWCStringUtils.equals((String)formulaObj.getString("usetype"), (String)"1");
        List nodeItemList = FormulaItemOrFuncTreeHelper.loadFTTreeNodeList((String)searchText, (boolean)isExpend, (Map)dataMap);
        if (isProrationFormula) {
            nodeItemList.addAll(FormulaItemOrFuncTreeHelper.loadBSTreeNodeList((String)searchText, (boolean)isExpend, (Map)dataMap));
        } else {
            nodeItemList.addAll(FormulaItemOrFuncTreeHelper.loadSLItemChildNode((String)searchText, (boolean)isExpend, (Map)dataMap));
            nodeItemList.addAll(FormulaItemOrFuncTreeHelper.loadBSTreeNodeList((String)searchText, (boolean)isExpend, (Map)dataMap));
            nodeItemList.addAll(FormulaItemOrFuncTreeHelper.loadSPTreeNodeList((String)searchText, (boolean)isExpend, (Map)dataMap));
            nodeItemList.addAll(FormulaItemOrFuncTreeHelper.loadACTreeNodeList((String)searchText, (boolean)isExpend, (Map)dataMap));
        }
        if (ObjectUtils.isEmpty((Object)nodeItemList)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u641c\u7d22\u5df2\u5b8c\u6210\uff0c\u672a\u627e\u5230\u641c\u7d22\u9879\u3002", (String)"FormulaItemTreePlugin_8", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        TreeView treeView = (TreeView)this.getView().getControl(ITEMTREEVIEW);
        treeView.deleteAllNodes();
        treeView.addNodes(nodeItemList);
    }

    public void customEvent(CustomEventArgs e) {
        String key = e.getKey();
        String name = e.getEventName();
        String args = e.getEventArgs();
        if (SWCStringUtils.equals((String)key, (String)FLOAT) && !FormulaViewServiceHelper.isViewStatus((IDataModel)this.getModel(), (IFormView)this.getView())) {
            CustomControl formulaeditor = (CustomControl)this.getView().getControl(FORMULAEDITOR);
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("method", name);
            data.put("value", "\"" + args + "\"");
            if (FormulaViewServiceHelper.isViewStatus((IDataModel)this.getModel(), (IFormView)this.getView())) {
                data.put("method", "readOnly");
                data.put("readOnly", "true");
            }
            data.put("date", String.valueOf(System.currentTimeMillis()));
            formulaeditor.setData(data);
        }
    }
}

