/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.formula;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Html;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.control.BarItemAp;
import kd.bos.orm.query.QFilter;
import kd.bos.service.IBaseDataService;
import kd.swc.hsas.business.formula.FormulaParseService;
import kd.swc.hsas.business.formula.FormulaViewServiceHelper;
import kd.swc.hsas.business.formula.helper.FormulaDataServiceHelper;
import kd.swc.hsas.business.formula.helper.FormulaFormatHelper;
import kd.swc.hsas.business.formula.helper.FormulaItemOrFuncTreeHelper;
import kd.swc.hsas.business.formula.helper.FormulaSplitHelper;
import kd.swc.hsas.business.formula.utils.FormulaOperatorUtils;
import kd.swc.hsas.common.formula.vo.FormulaInfo;
import kd.swc.hsbp.business.area.AreaHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class FormulaSettingEdit
extends SWCDataBaseEdit
implements BeforeF7SelectListener {
    private static final String SWC_HSAS_FORMPLUGIN = "swc-hsas-formplugin";
    private static Log logger = LogFactory.getLog(FormulaSettingEdit.class);
    private static final String[] BTNKEYARRAY = new String[]{"oper_plus", "oper_subtract", "oper_multiply", "oper_divide", "oper_gt", "oper_lt", "oper_ltorequal", "oper_gtorequal", "oper_equal", "oper_unequal", "oper_quot", "oper_parentheses", "oper_linecomment", "oper_blockcomment", "datatype_num", "datatype_date", "datatype_text", "condition_if", "condition_then", "condition_elseif", "condition_else", "condition_and", "condition_or", "condition_like", "condition_result", "condition_endif", "imageap", "oper_assignment", "condition_null", "condition_exit"};
    private static final String FORMULAEDITOR = "formulaeditor";
    private static final String ISDRAFT = "isdraft";
    private static final String FIELD_AREATYPE = "areatype";
    private static final String FIELD_SALARYITEM = "salaryitem";
    private static final String DATASTATUS_ABANDON = "-3";
    private static final String CHANGE_AREATYPE_CONFIRMCALLBACK = "change_areatype_confirmcallback";
    private static final String CHANGE_COUNTRY_CONFIRMCALLBACK = "change_country_confirmcallback";
    private static final String CHANGE_SALARYITEM_CONFIRMCALLBACK = "change_salaryitem_confirmcallback";
    private static final String CHANGE_USETYPE_CONFIRMCALLBACK = "change_usetype_confirmcallback";
    private static final String FIELD_COUNTRY = "country";
    private static final String FIRST = "first";
    private static final String PREVIOUS = "previous";
    private static final String NEXT = "next";
    private static final String LAST = "last";
    private static final String ORIGINALEXP = "originalexp";
    private static final String CLOSEFLAG = "closeFlag";
    private static final String NOT_INIT_EDITOR_FLAG = "notInitEditor";
    private static final String FORMULAPREVIEW = "formulapreview";
    private static final String SAVEASDRAFT = "saveasdraft";
    private static final String SAVEASDRAFTAFTERAUDIT = "saveasdraftafteraudit";
    private static final String CONFIRMCHANGE = "confirmchange";
    private static final String DESCHTML = "deschtml";
    private static final String ITEMTREEVIEW = "itemtreeview";
    private static final String FUNCTREE = "functree";
    private static final String CACHE_ALLDATA = "allItemAndFuncData";
    private static final String SHOWFORMULA = "showformula";

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addClickListeners(BTNKEYARRAY);
        BasedataEdit salaryItem = (BasedataEdit)this.getView().getControl(FIELD_SALARYITEM);
        salaryItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        DynamicObject formulaObj = this.getModel().getDataEntity();
        DynamicObject salaryItem = formulaObj.getDynamicObject(FIELD_SALARYITEM);
        String useType = formulaObj.getString("usetype");
        if (SWCStringUtils.equals((String)useType, (String)"0")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{FIELD_SALARYITEM});
            FieldEdit salaryItemEdit = (FieldEdit)this.getControl(FIELD_SALARYITEM);
            salaryItemEdit.setMustInput(true);
            if (null != salaryItem) {
                this.initFormulaConfigParams(formulaObj, true);
            } else {
                SWCPageCache pageCache = new SWCPageCache(this.getView());
                pageCache.put(CLOSEFLAG, (Object)Boolean.TRUE);
                pageCache.put(NOT_INIT_EDITOR_FLAG, (Object)Boolean.TRUE);
                this.getView().setEnable(Boolean.FALSE, new String[]{"searchap", "searchfunc"});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{FIELD_SALARYITEM});
            FieldEdit salaryItemEdit = (FieldEdit)this.getControl(FIELD_SALARYITEM);
            salaryItemEdit.setMustInput(false);
            this.initFormulaConfigParams(formulaObj, true);
        }
        AreaHelper.initAreaTypeAndcountryStatus((IDataModel)this.getModel(), (IFormView)this.getView());
        if (BaseDataHisHelper.isCurrPage((IFormView)this.getView()) && SWCStringUtils.equals((String)"A", (String)formulaObj.getString("status"))) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"usetype"});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"usetype"});
        }
    }

    private void initFormulaConfigParams(DynamicObject formulaObj, boolean isInit) {
        Map dataMap = FormulaDataServiceHelper.getAllItemAndFuncData((IFormView)this.getView(), (DynamicObject)formulaObj);
        this.initItemTree(dataMap);
        this.initCalculateToolsTree(dataMap);
        this.initFormulaEditor(dataMap, isInit);
    }

    public void afterBindData(EventObject evt) {
        this.createBizBtn();
        DynamicObject formula = this.getModel().getDataEntity();
        String status = formula.getString("status");
        Container baseInfo = (Container)this.getView().getControl("fs_baseinfo");
        if (!"A".equals(status)) {
            baseInfo.setCollapse(true);
        } else {
            baseInfo.setCollapse(false);
        }
        this.setFieldUnable();
    }

    private void createBizBtn() {
        if (BaseDataHisHelper.isHisPage((IFormView)this.getView())) {
            String dataStatus;
            this.getView().setEnable(Boolean.FALSE, new String[]{FIELD_SALARYITEM});
            Container toolBar = (Container)this.getView().getControl("tbmain");
            if (toolBar != null) {
                this.getView().setVisible(Boolean.FALSE, new String[]{CONFIRMCHANGE, "tblclosehis"});
                toolBar.deleteControls(new String[]{"bar_saveasdraftafteraudit", "bar_confirmchange_new", "bar_example", "baritemap_refresh", "tblclosehisnew", "bar_prevoew"});
                ArrayList items = Lists.newArrayListWithExpectedSize((int)16);
                String dataStatus2 = this.getModel().getDataEntity().getString("datastatus");
                if (dataStatus2 == null || DATASTATUS_ABANDON.equals(dataStatus2)) {
                    this.genSaveAsDraftBtn(items);
                    FormulaSettingEdit.genConfirmChangeBtn(items);
                }
                this.genShowFormulaBtn(items);
                this.genPreviewBtn(items);
                this.genRefreshBtn(items);
                this.genCloseBtn(items);
                toolBar.addControls((List)items);
            }
            if ((dataStatus = this.getModel().getDataEntity().getString("datastatus")) == null || DATASTATUS_ABANDON.equals(dataStatus)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"bsed", "bsled", "changedescription", "description", "name"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"bsed", "bsled", "changedescription", "description", "name"});
            }
        }
    }

    private void genSaveAsDraftBtn(List<Map<String, Object>> items) {
        BarItemAp insertDataBtn = new BarItemAp();
        insertDataBtn.setKey("bar_saveasdraftafteraudit");
        insertDataBtn.setName(new LocaleString(ResManager.loadKDString((String)"\u4fdd\u5b58\u4e3a\u8349\u7a3f", (String)"FormulaSettingEdit_30", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0])));
        insertDataBtn.setOperationKey(SAVEASDRAFTAFTERAUDIT);
        items.add(insertDataBtn.createControl());
    }

    private static void genConfirmChangeBtn(List<Map<String, Object>> items) {
        BarItemAp confirmChangeBtn = new BarItemAp();
        confirmChangeBtn.setKey("bar_confirmchange_new");
        confirmChangeBtn.setName(new LocaleString(ResManager.loadKDString((String)"\u786e\u8ba4\u53d8\u66f4", (String)"FormulaSettingEdit_31", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0])));
        confirmChangeBtn.setOperationKey(CONFIRMCHANGE);
        confirmChangeBtn.setCommitValidate(true);
        items.add(confirmChangeBtn.createControl());
    }

    private void genPreviewBtn(List<Map<String, Object>> items) {
        BarItemAp insertDataBtn = new BarItemAp();
        insertDataBtn.setKey("bar_prevoew");
        insertDataBtn.setName(new LocaleString(ResManager.loadKDString((String)"\u9605\u8bfb\u6a21\u5f0f", (String)"FormulaSettingEdit_2", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0])));
        insertDataBtn.setOperationKey(FORMULAPREVIEW);
        items.add(insertDataBtn.createControl());
    }

    private void genShowFormulaBtn(List<Map<String, Object>> items) {
        BarItemAp insertDataBtn = new BarItemAp();
        insertDataBtn.setKey("bar_example");
        insertDataBtn.setName(new LocaleString(ResManager.loadKDString((String)"\u67e5\u770b\u793a\u4f8b", (String)"FormulaSettingEdit_32", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0])));
        insertDataBtn.setOperationKey(SHOWFORMULA);
        items.add(insertDataBtn.createControl());
    }

    private void genRefreshBtn(List<Map<String, Object>> items) {
        BarItemAp insertDataBtn = new BarItemAp();
        insertDataBtn.setKey("baritemap_refresh");
        insertDataBtn.setName(new LocaleString(ResManager.loadKDString((String)"\u5237\u65b0", (String)"FormulaSettingEdit_33", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0])));
        insertDataBtn.setOperationKey("refresh");
        items.add(insertDataBtn.createControl());
    }

    private void genCloseBtn(List<Map<String, Object>> items) {
        BarItemAp closeBtn = new BarItemAp();
        closeBtn.setKey("tblclosehisnew");
        closeBtn.setName(new LocaleString(ResManager.loadKDString((String)"\u9000\u51fa", (String)"FormulaSettingEdit_34", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0])));
        closeBtn.setOperationKey("close");
        items.add(closeBtn.createControl());
    }

    public void afterLoadData(EventObject evt) {
        this.getModel().setDataChanged(false);
    }

    private void setFieldUnable() {
        Boolean comeFromCalRuleOrGroup = (Boolean)this.getView().getFormShowParameter().getCustomParam("comefromcalruleorgroup");
        if (comeFromCalRuleOrGroup != null && comeFromCalRuleOrGroup.booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"insertdatabtn", "hisversionbtn"});
        }
    }

    private void initFormulaEditor(Map<String, Map<String, Map<String, Object>>> dataMap, boolean isInit) {
        CustomControl formulaeditor = (CustomControl)this.getView().getControl(FORMULAEDITOR);
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        DynamicObject formulaObj = this.getModel().getDataEntity();
        data.put("key", FormulaDataServiceHelper.getEditorKey((IFormView)this.getView(), dataMap, (DynamicObject)formulaObj));
        data.put("method", "init");
        if (isInit) {
            data.put("value", this.getOriginalExp());
        } else {
            data.put("value", "");
        }
        if (FormulaViewServiceHelper.isViewStatus((IDataModel)this.getModel(), (IFormView)this.getView())) {
            data.put("readOnly", "true");
        } else {
            data.put("readOnly", Boolean.FALSE);
        }
        data.put("date", String.valueOf(System.currentTimeMillis()));
        formulaeditor.setData(data);
    }

    private void initItemTree(Map<String, Map<String, Map<String, Object>>> dataMap) {
        TreeView treeView = (TreeView)this.getView().getControl(ITEMTREEVIEW);
        DynamicObject formulaObj = this.getModel().getDataEntity();
        boolean isProrationFormula = false;
        if (SWCStringUtils.equals((String)formulaObj.getString("usetype"), (String)"1")) {
            isProrationFormula = true;
        }
        List list = FormulaItemOrFuncTreeHelper.loadFTTreeNodeList(null, (boolean)false, dataMap);
        if (isProrationFormula) {
            list.addAll(FormulaItemOrFuncTreeHelper.loadBSTreeNodeList(null, (boolean)false, dataMap));
        } else {
            list.addAll(FormulaItemOrFuncTreeHelper.loadSLItemChildNode(null, (boolean)false, dataMap));
            list.addAll(FormulaItemOrFuncTreeHelper.loadBSTreeNodeList(null, (boolean)false, dataMap));
            list.addAll(FormulaItemOrFuncTreeHelper.loadSPTreeNodeList(null, (boolean)false, dataMap));
            list.addAll(FormulaItemOrFuncTreeHelper.loadACTreeNodeList(null, (boolean)false, dataMap));
        }
        treeView.deleteAllNodes();
        treeView.addNodes(list);
    }

    private void initCalculateToolsTree(Map<String, Map<String, Map<String, Object>>> dataMap) {
        TreeView treeView = (TreeView)this.getView().getControl(FUNCTREE);
        List nodeList = FormulaItemOrFuncTreeHelper.queryFuncDefineList(null, (boolean)false, dataMap);
        nodeList.addAll(FormulaItemOrFuncTreeHelper.queryDataGradeDefineList(null, (boolean)false, dataMap));
        treeView.deleteAllNodes();
        treeView.addNodes(nodeList);
    }

    private String getOriginalExp() {
        this.getModel().updateCache();
        return (String)this.getModel().getValue(ORIGINALEXP);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (key.startsWith("datatype_") || key.startsWith("oper_") || key.startsWith("condition_")) {
            this.addOperationToEditor(key);
        }
    }

    private void addOperationToEditor(String key) {
        if (FormulaViewServiceHelper.isViewStatus((IDataModel)this.getModel(), (IFormView)this.getView())) {
            return;
        }
        CustomControl formulaeditor = (CustomControl)this.getView().getControl(FORMULAEDITOR);
        HashMap<String, String> data = new HashMap<String, String>(16);
        data.put("method", "insertValue");
        String value = FormulaOperatorUtils.getOperatorValue((String)key);
        value = " " + value;
        data.put("value", value);
        data.put("date", String.valueOf(System.currentTimeMillis()));
        formulaeditor.setData(data);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        switch (evt.getOperationKey()) {
            case "save": 
            case "submit": 
            case "confirmchange": {
                if (!this.checkAndParseExpBeforeSave()) break;
                evt.setCancel(true);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        switch (operate.getOperateKey()) {
            case "save": 
            case "submit": 
            case "confirmchange": {
                operate.getOption().setVariableValue("save", Boolean.TRUE.toString());
                break;
            }
            case "refresh": {
                this.clearCache(pageCache);
                operate.getOption().setVariableValue("cacheOriginalExp", this.getOriginalExp());
                break;
            }
            case "saveasdraftafteraudit": {
                long boId = this.getModel().getDataEntity().getLong("boid");
                this.getModel().setValue(ISDRAFT, (Object)Boolean.TRUE);
                if (boId == 0L) {
                    this.getModel().setValue("boid", this.getView().getFormShowParameter().getCustomParam("boid"));
                }
                operate.getOption().setVariableValue("opFromFormEdit", "true");
                operate.getOption().setVariableValue("save", Boolean.TRUE.toString());
                break;
            }
            case "saveasdraft": {
                this.getModel().setValue(ISDRAFT, (Object)Boolean.TRUE);
                operate.getOption().setVariableValue("save", Boolean.TRUE.toString());
                break;
            }
            case "formulapreview": {
                Boolean isNotInitEditor = (Boolean)pageCache.get(NOT_INIT_EDITOR_FLAG, Boolean.class);
                if (isNotInitEditor != null && isNotInitEditor.booleanValue()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u201c\u516c\u5f0f\u914d\u7f6e\u201d\u3002", (String)"FormulaSettingEdit_16", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]));
                } else {
                    FormulaItemOrFuncTreeHelper.openFormulaExamplePage((IFormView)this.getView(), (String)"hsas_formulapreview", (ShowType)ShowType.Modal, (String)this.getOriginalExp());
                }
                args.setCancel(true);
                break;
            }
            case "first": 
            case "previous": 
            case "next": 
            case "last": {
                this.clearCache(pageCache);
                break;
            }
        }
    }

    private void clearCache(SWCPageCache pageCache) {
        DynamicObject formulaObj = this.getModel().getDataEntity();
        pageCache.remove(CACHE_ALLDATA + formulaObj.getString("usetype"));
        pageCache.remove("uniqueCodeRelMap");
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operate.getOperateKey()) {
            case "showformula": {
                FormulaItemOrFuncTreeHelper.openFormulaExamplePage((IFormView)this.getView(), (String)"hsas_formulaexamplepage", (ShowType)ShowType.MainNewTabPage, (String)FormulaItemOrFuncTreeHelper.getFormulaExample());
                break;
            }
            case "unsubmit": {
                this.setFormulaEditorReadOnly(false);
                if (BaseDataHisHelper.isCurrPage((IFormView)this.getView()) && SWCStringUtils.equals((String)"A", (String)this.getModel().getDataEntity().getString("status"))) {
                    this.getView().setEnable(Boolean.TRUE, new String[]{"usetype"});
                    break;
                }
                this.getView().setEnable(Boolean.FALSE, new String[]{"usetype"});
                break;
            }
            case "delete": {
                SWCPageCache pageCache = new SWCPageCache(this.getView());
                pageCache.put(CLOSEFLAG, (Object)Boolean.TRUE);
                break;
            }
            case "save": {
                if (!args.getOperationResult().isSuccess()) {
                    return;
                }
                this.setFormulaEditorValue(this.getOriginalExp(), false);
                break;
            }
            case "submit": {
                if (!args.getOperationResult().isSuccess()) {
                    return;
                }
                this.setFormulaEditorValue(this.getOriginalExp(), true);
                break;
            }
            case "confirmchange": {
                if (!args.getOperationResult().isSuccess()) {
                    return;
                }
                this.setFormulaEditorValue(this.getOriginalExp(), true);
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_saveasdraftafteraudit", "bar_confirmchange_new", "tblclosehis"});
                break;
            }
            case "refresh": {
                Map variablesMap = operate.getOption().getVariables();
                String cacheOriginalExp = (String)variablesMap.get("cacheOriginalExp");
                Html html = (Html)this.getView().getControl(DESCHTML);
                html.setConent(null);
                if (FormulaViewServiceHelper.isViewStatus((IDataModel)this.getModel(), (IFormView)this.getView()) || SWCStringUtils.equals((String)cacheOriginalExp, (String)this.getOriginalExp())) {
                    return;
                }
                this.setFormulaEditorValue(cacheOriginalExp, false);
                break;
            }
        }
    }

    private void setFormulaEditorReadOnly(boolean readOnly) {
        CustomControl formulaEditor = (CustomControl)this.getView().getControl(FORMULAEDITOR);
        HashMap<String, Object> data = new HashMap<String, Object>(3);
        data.put("method", "setReadOnly");
        data.put("readOnly", readOnly);
        data.put("date", String.valueOf(System.currentTimeMillis()));
        formulaEditor.setData(data);
    }

    private void setFormulaEditorValue(String origialExp, boolean readOnly) {
        CustomControl formulaeditor = (CustomControl)this.getView().getControl(FORMULAEDITOR);
        HashMap<String, Object> data = new HashMap<String, Object>(3);
        data.put("method", "setValue");
        data.put("value", origialExp);
        data.put("readOnly", readOnly);
        data.put("date", String.valueOf(System.currentTimeMillis()));
        formulaeditor.setData(data);
    }

    public void customEvent(CustomEventArgs evt) {
        String key = evt.getKey();
        String args = evt.getEventArgs();
        if (!FORMULAEDITOR.equals(key)) {
            return;
        }
        if (!SWCStringUtils.equals((String)args, (String)this.getOriginalExp())) {
            this.getModel().setValue(ORIGINALEXP, (Object)args);
        }
    }

    private boolean checkAndParseExpBeforeSave() {
        boolean isNoPassCheck = false;
        FormulaParseService formulaParse = new FormulaParseService();
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        Map dataMap = (Map)pageCache.get(CACHE_ALLDATA + this.getModel().getValue("usetype"), Map.class);
        try {
            if (this.getModel().getValue("id") == null || (Long)this.getModel().getValue("id") == 0L) {
                this.getModel().setValue("id", (Object)DB.genLongId((String)"t_hsas_formula"));
            }
            FormulaInfo formulaInfo = formulaParse.parseFormula(this.getModel().getDataEntity(), dataMap);
            String originalExp = this.doFormatFormulaExp(formulaInfo.getOriginalCode());
            String uniqueKeyExp = this.doFormatFormulaExp(formulaInfo.getUniqueKeyCode());
            this.getModel().beginInit();
            this.getModel().setValue("executeexp", (Object)formulaInfo.getExecuteCode());
            this.getModel().setValue("uniquecodeexp", (Object)uniqueKeyExp);
            this.getModel().setValue(ORIGINALEXP, (Object)originalExp);
            this.getModel().setValue(ISDRAFT, (Object)Boolean.FALSE);
            this.getModel().setValue("dependonfunc", (Object)SWCListUtils.join((Set)formulaInfo.getFcUniqueCodeSet(), (String)","));
            this.getModel().setValue("dependonsitem", (Object)SWCListUtils.join((Set)formulaInfo.getSlUniqueCodeSet(), (String)","));
            this.getModel().setValue("dependonbsitem", (Object)SWCListUtils.join((Set)formulaInfo.getBsUniqueCodeSet(), (String)","));
            this.getModel().setValue("dependonspitem", (Object)SWCListUtils.join((Set)formulaInfo.getSpUniqueCodeSet(), (String)","));
            this.getModel().setValue("dependondatagrade", (Object)SWCListUtils.join((Set)formulaInfo.getDmUniqueCodeSet(), (String)","));
            this.getModel().setValue("dependonacc", (Object)SWCListUtils.join((Set)formulaInfo.getAcUniqueCodeSet(), (String)","));
            this.getModel().setValue("dependonftitem", (Object)SWCListUtils.join((Set)formulaInfo.getFtUniqueCodeSet(), (String)","));
            this.getModel().setValue("bsitemprop", (Object)SWCListUtils.join((Set)formulaInfo.getBspUniqueCodeSet(), (String)","));
            this.getModel().endInit();
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            String msg = e.getMessage();
            if (msg == null) {
                msg = ResManager.loadKDString((String)"\u516c\u5f0f\u914d\u7f6e\u4e0d\u6b63\u786e\u3002", (String)"FormulaSettingEdit_19", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]);
            }
            this.getView().showErrorNotification(msg);
            isNoPassCheck = true;
        }
        return isNoPassCheck;
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        String fieldKey = evt.getProperty().getName();
        ChangeData[] changeSets = evt.getChangeSet();
        switch (fieldKey) {
            case "areatype": {
                this.checkConfirmPage(changeSets, Boolean.TRUE);
                break;
            }
            case "country": {
                this.checkConfirmPage(changeSets, Boolean.FALSE);
                break;
            }
            case "salaryitem": {
                this.checkSalaryItemConfirmPage(changeSets);
                break;
            }
            case "usetype": {
                this.checkUseTypeConfirmPage(changeSets);
                break;
            }
        }
    }

    private void clearItemTreeAndFuncTree() {
        TreeView treeView = (TreeView)this.getView().getControl(ITEMTREEVIEW);
        treeView.deleteAllNodes();
        TreeView funcTree = (TreeView)this.getView().getControl(FUNCTREE);
        funcTree.deleteAllNodes();
    }

    private void checkSalaryItemConfirmPage(ChangeData[] changeSets) {
        if (null == changeSets || changeSets.length == 0) {
            return;
        }
        String customValue = "";
        ChangeData changeData = changeSets[0];
        DynamicObject oldValue = (DynamicObject)changeData.getOldValue();
        if (oldValue == null) {
            this.reloadFormulaConfig();
            return;
        }
        customValue = String.valueOf(oldValue.getLong("id"));
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u540e\uff0c\u5c06\u6e05\u7a7a\u516c\u5f0f\u4f53\u5185\u5bb9\u3002\u662f\u5426\u5207\u6362\uff1f", (String)"FormulaSettingEdit_3", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]), "", MessageBoxOptions.OKCancel, null, new ConfirmCallBackListener(CHANGE_SALARYITEM_CONFIRMCALLBACK), null, customValue);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId = event.getCallBackId();
        String[] keys = new String[]{FIELD_SALARYITEM};
        switch (callBackId) {
            case "change_areatype_confirmcallback": {
                AreaHelper.confirmAfterModifyAraeType((MessageBoxClosedEvent)event, (IDataModel)this.getModel(), (IFormView)this.getView(), (String[])keys, null);
                this.clearFormulaCongfig(event);
                this.clearItemTree(event);
                break;
            }
            case "change_country_confirmcallback": {
                AreaHelper.confirmAfterModifyCountry((MessageBoxClosedEvent)event, (IDataModel)this.getModel(), (IFormView)this.getView(), (String[])keys, null);
                this.clearFormulaCongfig(event);
                this.clearItemTree(event);
                break;
            }
            case "change_salaryitem_confirmcallback": {
                if (MessageBoxResult.Cancel.equals((Object)event.getResult())) {
                    String customVaule = event.getCustomVaule();
                    this.getModel().beginInit();
                    this.getModel().setValue(FIELD_SALARYITEM, (Object)Long.valueOf(customVaule));
                    this.getModel().endInit();
                    this.getView().updateView(FIELD_SALARYITEM);
                    break;
                }
                this.reloadFormulaConfig();
                Object salaryItem = this.getModel().getDataEntity().get(FIELD_SALARYITEM);
                if (salaryItem != null) break;
                this.clearItemTreeAndFuncTree();
                break;
            }
            case "change_usetype_confirmcallback": {
                if (MessageBoxResult.Cancel.equals((Object)event.getResult())) {
                    String customVaule = event.getCustomVaule();
                    this.getModel().beginInit();
                    this.getModel().setValue("usetype", (Object)customVaule);
                    this.getModel().endInit();
                    this.getView().updateView("usetype");
                    break;
                }
                this.clearValueByUseType();
                String useType = this.getModel().getDataEntity().getString("usetype");
                if (!SWCStringUtils.equals((String)"0", (String)useType)) break;
                this.clearItemTreeAndFuncTree();
                break;
            }
        }
    }

    private void checkUseTypeConfirmPage(ChangeData[] changeSets) {
        if (null == changeSets || changeSets.length == 0) {
            return;
        }
        String orignalExp = (String)this.getModel().getValue(ORIGINALEXP);
        Object salaryItem = this.getModel().getDataEntity().get(FIELD_SALARYITEM);
        String areaType = (String)this.getModel().getDataEntity().get(FIELD_AREATYPE);
        DynamicObject countryObj = this.getModel().getDataEntity().getDynamicObject(FIELD_COUNTRY);
        if (SWCStringUtils.equals((String)"2", (String)areaType) && countryObj == null) {
            this.clearValueByUseType();
            this.clearItemTreeAndFuncTree();
            return;
        }
        if (salaryItem == null && SWCStringUtils.isEmpty((String)orignalExp)) {
            this.clearValueByUseType();
            if (SWCStringUtils.equals((String)"0", (String)((String)changeSets[0].getNewValue()))) {
                this.clearItemTreeAndFuncTree();
            }
            return;
        }
        ChangeData changeData = changeSets[0];
        String oldValue = (String)changeData.getOldValue();
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u540e\uff0c\u5c06\u6e05\u7a7a\u8ba1\u7b97\u516c\u5f0f\u5185\u5bb9\u3002\u662f\u5426\u5207\u6362\uff1f", (String)"FormulaSettingEdit_35", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]), "", MessageBoxOptions.OKCancel, null, new ConfirmCallBackListener(CHANGE_USETYPE_CONFIRMCALLBACK), null, oldValue);
    }

    private void clearValueByUseType() {
        String useType = (String)this.getModel().getValue("usetype");
        if (SWCStringUtils.equals((String)useType, (String)"1")) {
            this.getModel().beginInit();
            this.getModel().setValue(FIELD_SALARYITEM, null);
            this.getModel().endInit();
            this.getView().updateView(FIELD_SALARYITEM);
            this.getView().setVisible(Boolean.FALSE, new String[]{FIELD_SALARYITEM});
            FieldEdit salaryItemEdit = (FieldEdit)this.getControl(FIELD_SALARYITEM);
            salaryItemEdit.setMustInput(false);
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{FIELD_SALARYITEM});
            FieldEdit salaryItemEdit = (FieldEdit)this.getControl(FIELD_SALARYITEM);
            salaryItemEdit.setMustInput(true);
        }
        this.reloadFormulaConfig();
    }

    private void reloadFormulaConfig() {
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        pageCache.remove("allItemAndFuncData1");
        pageCache.remove("allItemAndFuncData0");
        pageCache.remove(CACHE_ALLDATA);
        pageCache.remove(CLOSEFLAG);
        pageCache.remove(NOT_INIT_EDITOR_FLAG);
        this.getView().setEnable(Boolean.TRUE, new String[]{"searchap", "searchfunc"});
        this.initFormulaConfigParams(this.getModel().getDataEntity(), false);
        this.getModel().setValue(ORIGINALEXP, (Object)"");
    }

    private void clearItemTree(MessageBoxClosedEvent event) {
        if (MessageBoxResult.Cancel.equals((Object)event.getResult())) {
            return;
        }
        this.clearItemTreeAndFuncTree();
    }

    private void clearDataGradeTreeNode() {
        DynamicObject formulaObj = this.getModel().getDataEntity();
        Map dataMap = FormulaDataServiceHelper.getAllItemAndFuncData((IFormView)this.getView(), (DynamicObject)formulaObj);
        this.initCalculateToolsTree(dataMap);
    }

    private void clearFormulaCongfig(MessageBoxClosedEvent event) {
        if (MessageBoxResult.Cancel.equals((Object)event.getResult())) {
            return;
        }
        this.setFormulaEditorValue("", true);
    }

    private void checkConfirmPage(ChangeData[] changeSets, Boolean isAraeType) {
        Object salaryitem = this.getModel().getDataEntity().get(FIELD_SALARYITEM);
        if (null == salaryitem) {
            AreaHelper.setAreaTypeAndcountryStatus((IDataModel)this.getModel(), (IFormView)this.getView());
            String useType = this.getModel().getDataEntity().getString("usetype");
            DynamicObject countryObj = this.getModel().getDataEntity().getDynamicObject(FIELD_COUNTRY);
            if (isAraeType.booleanValue()) {
                if (SWCStringUtils.equals((String)"1", (String)String.valueOf(changeSets[0].getNewValue()))) {
                    if (SWCStringUtils.equals((String)"0", (String)useType)) {
                        this.clearItemTreeAndFuncTree();
                    } else {
                        this.reloadFormulaConfig();
                    }
                } else if (countryObj == null) {
                    this.clearItemTreeAndFuncTree();
                }
            } else if (countryObj == null) {
                this.clearItemTreeAndFuncTree();
            } else if (SWCStringUtils.equals((String)"0", (String)useType)) {
                this.clearItemTreeAndFuncTree();
            } else {
                this.reloadFormulaConfig();
            }
            return;
        }
        if (null == changeSets || changeSets.length == 0) {
            return;
        }
        String customValue = "";
        String callBack = "";
        if (isAraeType.booleanValue()) {
            ChangeData changeData = changeSets[0];
            Object oldValue = changeData.getOldValue();
            if (oldValue != null) {
                customValue = (String)changeData.getOldValue();
            }
            callBack = CHANGE_AREATYPE_CONFIRMCALLBACK;
        } else {
            ChangeData changeData = changeSets[0];
            Object oldValue = changeData.getOldValue();
            if (oldValue != null) {
                DynamicObject country = (DynamicObject)oldValue;
                Object countryId = country.get("id");
                customValue = String.valueOf(countryId);
            }
            callBack = CHANGE_COUNTRY_CONFIRMCALLBACK;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u540e\uff0c\u5c06\u6e05\u7a7a\u201c\u85aa\u916c\u9879\u76ee\u201d\u3002\u662f\u5426\u5207\u6362\uff1f", (String)"FormulaSettingEdit_1", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]), "", MessageBoxOptions.OKCancel, null, new ConfirmCallBackListener(callBack), null, customValue);
    }

    private String doFormatFormulaExp(String originalExp) throws Exception {
        FormulaSplitHelper formulaSplitHelper = new FormulaSplitHelper();
        List nodes = formulaSplitHelper.getOriginalNodesWithComment(originalExp);
        return FormulaFormatHelper.formatFormula((List)nodes);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey;
        switch (fieldKey = beforeF7SelectEvent.getProperty().getName()) {
            case "salaryitem": {
                DynamicObject mainOrgObj;
                DynamicObject formula = this.getModel().getDataEntity();
                boolean checkArea = AreaHelper.checkArea((DynamicObject)formula);
                if (!checkArea) {
                    beforeF7SelectEvent.setCancel(true);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u56fd\u5bb6/\u5730\u533a\u540e\u518d\u9009\u62e9\u201c\u85aa\u916c\u9879\u76ee\u201d\u3002", (String)"FormulaSettingEdit_0", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]));
                    return;
                }
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
                MainEntityType billEntityType = this.getModel().getDataEntityType();
                String mainOrgProp = billEntityType.getMainOrg();
                if (StringUtils.isNotBlank((CharSequence)mainOrgProp) && (mainOrgObj = (DynamicObject)this.getModel().getValue(mainOrgProp)) != null && mainOrgObj.getPkValue() != null) {
                    long orgID = (Long)mainOrgObj.getPkValue();
                    IBaseDataService baseDataService = (IBaseDataService)this.getModel().getService(IBaseDataService.class);
                    QFilter qFilter = baseDataService.getBaseDataFilter("hsbs_salaryitem", Long.valueOf(orgID));
                    qFilters.add(qFilter);
                    QFilter areaFilter = AreaHelper.addAreaFilter((long)formula.getLong("country.id"), (String)formula.getString(FIELD_AREATYPE));
                    if (null != areaFilter) {
                        qFilters.add(areaFilter);
                    }
                }
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                showParameter.getListFilterParameter().setQFilters(qFilters);
                break;
            }
        }
    }
}

