/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.formula;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.config.client.util.JSONUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsas.business.formula.helper.FormulaExampleHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;
import org.apache.commons.collections.CollectionUtils;

public class FormulaShowExamplePlugin
extends SWCDataBaseEdit
implements RowClickEventListener {
    private static final Log logger = LogFactory.getLog(FormulaShowExamplePlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initExampleList();
        this.initExampleEditor();
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        if (SWCStringUtils.equals((String)"entryentity", (String)entryGrid.getKey())) {
            DynamicObject matchFormula = entryGrid.getEntryData().getDataEntitys()[evt.getRow()];
            this.setExampleEditor(matchFormula.getString("formulacontent"));
        }
    }

    private void initExampleList() {
        this.addFormulaExampleEntry(FormulaExampleHelper.getAllFormulaExample());
    }

    private void addFormulaExampleEntry(List<Map<String, String>> formulaExampleList) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("name", new Object[0]);
        setter.addField("description", new Object[0]);
        setter.addField("formulacontent", new Object[0]);
        setter.addField("level", new Object[0]);
        for (Map<String, String> formulaExample : formulaExampleList) {
            setter.addRow(new Object[]{formulaExample.get("name"), formulaExample.get("description"), formulaExample.get("formulacontent"), formulaExample.get("level")});
        }
        model.batchCreateNewEntryRow("entryentity", setter);
        model.endInit();
    }

    private void initExampleEditor() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isNotEmpty((Collection)entryEntity)) {
            this.setExampleEditor(((DynamicObject)entryEntity.get(0)).getString("formulacontent"));
        }
    }

    private void setExampleEditor(String formulaExp) {
        String keyMapStr = this.getView().getPageCache().get("keyMapStr");
        Map keyMap = null;
        if (!SWCStringUtils.isEmpty((String)keyMapStr)) {
            try {
                keyMap = (Map)JSONUtils.cast((String)keyMapStr, Map.class);
            }
            catch (Exception exception) {
                logger.error("cast keyMap error :", (Throwable)exception);
            }
        }
        if (keyMap == null) {
            keyMap = FormulaExampleHelper.getEditorKey();
            try {
                this.getView().getPageCache().put("keyMapStr", JSONUtils.toString((Object)keyMap));
            }
            catch (Exception exception) {
                logger.error("cache keyMap error :", (Throwable)exception);
            }
        }
        CustomControl showEditor = (CustomControl)this.getView().getControl("formulaexample");
        HashMap<String, Object> data = new HashMap<String, Object>(5);
        data.put("key", keyMap);
        data.put("method", "setValue");
        data.put("value", formulaExp);
        data.put("date", String.valueOf(System.currentTimeMillis()));
        data.put("readOnly", "true");
        showEditor.setData(data);
    }
}

