/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.guide;

import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.OperationServiceImpl;
import kd.swc.hsas.business.cal.helper.CalPayRollTaskCalHelper;
import kd.swc.hsas.business.cal.helper.CalPersonListHelper;
import kd.swc.hsas.business.cal.service.calperson.DefaultProcessHandler;
import kd.swc.hsas.business.cal.service.calperson.ProcessHandler;
import kd.swc.hsas.business.cal.vo.CalPayRollTask;
import kd.swc.hsas.business.cal.vo.CalPayRollTaskContext;
import kd.swc.hsas.formplugin.web.guide.AbstractCalPersonOperation;
import kd.swc.hsbp.business.cal.helper.PayrollTaskHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCShowFormServiceHelper;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.CalPersonOperationEnum;
import kd.swc.hsbp.common.util.SWCStringUtils;

public abstract class AbstractCalPayRollTaskList
extends AbstractCalPersonOperation {
    private static final Log logger = LogFactory.getLog(AbstractCalPayRollTaskList.class);
    private static final Set<String> hisTaskBanOpKeySet = new HashSet<String>(16);
    protected ProcessHandler processHandler;

    protected void createProcessHandler() {
        this.processHandler = new DefaultProcessHandler();
    }

    protected void showConfirm(List<CalPayRollTask> confirmDatas) {
    }

    protected boolean hasPerm(CalPersonOperationEnum calPersonOperationEnum) {
        return true;
    }

    public void pageRelease(EventObject eventObject) {
        CalPayRollTaskContext calPayRollTaskContext = this.getCalPayRollTaskContext();
        if (calPayRollTaskContext != null && this.operationKey().contains(calPayRollTaskContext.getCalPersonOperationEnum()) && this.getPageCache().get("invokeOperation") == null) {
            this.releaseDistributedLock(calPayRollTaskContext);
        }
        ISWCAppCache iswcAppCache = SWCAppCache.get((String)"CalPayRollTaskOperationTest");
        iswcAppCache.clear();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        this.calPersonOperationEnum = CalPersonOperationEnum.getCalOperationEnum((String)operateKey);
        if (this.calPersonOperationEnum == null) {
            return;
        }
        if (this.operationKey().contains(this.calPersonOperationEnum)) {
            if (!this.hasPerm(this.calPersonOperationEnum)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u6838\u7b97\u540d\u5355\u201d\u7684\u201c{0}\u201d\u6743\u9650\u3002", (String)"AbstractCalPayRollTaskList_16", (String)"swc-hsas-formplugin", (Object[])new Object[]{this.calPersonOperationEnum.getOperationName()}));
                args.setCancel(true);
                return;
            }
            OperateOption operateOption = formOperate.getOption();
            if (this.calPayRollTaskContext == null) {
                if (operateOption.tryGetVariableValue("CallBackInvoke", new RefObject())) {
                    this.calPayRollTaskContext = (CalPayRollTaskContext)SerializationUtils.fromJsonString((String)this.getView().getPageCache().get("calPayRollTaskContext"), CalPayRollTaskContext.class);
                } else {
                    ListSelectedRowCollection listSelectedData = ((ListView)this.getView()).getSelectedRows();
                    if (this.singleCalPayRollTaskValidator(listSelectedData)) {
                        args.setCancel(true);
                        return;
                    }
                    if (this.isSelectData() && listSelectedData.size() <= 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"AbstractCalPayRollTaskList_8", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    Map selectCalPayRollTaskMap = CalPayRollTaskCalHelper.groupCalPayRollTask((ListSelectedRowCollection)listSelectedData);
                    this.initCalPayRollTaskContext(selectCalPayRollTaskMap);
                    if (!this.doValidateChooseData()) {
                        args.setCancel(true);
                        this.releaseDistributedLock(this.calPayRollTaskContext);
                        return;
                    }
                    if (this.isSelectData() && this.calPayRollTaskContext.getValidDatas().size() > 0) {
                        String permItemName = PayrollTaskHelper.getPermItemName((String)formOperate.getPermissionItemId());
                        String entityName = EntityMetadataCache.getDataEntityType((String)"hsas_calpayrolltask").getDisplayName().getLocaleValue();
                        Set fitDataRuleTasks = CalPersonListHelper.getFitDataRuleIds((long)RequestContext.get().getCurrUserId(), (String)"/UHMBBGZQ65X", (String)"hsas_calpayrolltask", (String)formOperate.getPermissionItemId(), (Object)listSelectedData.getPrimaryKeyValues());
                        Iterator iterator = this.calPayRollTaskContext.getValidDatas().iterator();
                        while (iterator.hasNext()) {
                            CalPayRollTask calPayRollTask = (CalPayRollTask)iterator.next();
                            Long taskId = calPayRollTask.getCalPayRollTaskId();
                            if (fitDataRuleTasks.contains(taskId)) continue;
                            calPayRollTask.setCalPayRollTaskValidatorErrorMsg(String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c%s\u201d\u201c\u85aa\u8d44\u6838\u7b97\u4efb\u52a1\u201d\u7684\u6570\u636e\u89c4\u5219\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AbstractCalPayRollTaskList_18", (String)"swc-hsas-formplugin", (Object[])new Object[0]), formOperate.getOperateName()));
                            iterator.remove();
                            this.calPayRollTaskContext.getInvalidDatas().add(calPayRollTask);
                            PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(taskId), (String)this.calPersonOperationEnum.getOperationKey());
                        }
                    }
                    if (this.isSelectData() && this.calPayRollTaskContext.getValidDatas().size() <= 0) {
                        this.cancelOperation(args);
                        this.getView().getPageCache().remove("calPayRollTaskContext");
                        return;
                    }
                }
            }
            ArrayList<CalPayRollTask> confirmDatas = new ArrayList<CalPayRollTask>(10);
            if (!formOperate.getOption().tryGetVariableValue("CallBackInvoke", new RefObject())) {
                this.doValidate(args, confirmDatas);
            }
            if (this.isSelectData() && this.calPayRollTaskContext.getValidDatas().size() <= 0) {
                this.cancelOperation(args);
                this.getView().getPageCache().remove("calPayRollTaskContext");
                return;
            }
            ISWCAppCache iswcAppCache = SWCAppCache.get((String)"CalPayRollTaskOperationTest");
            iswcAppCache.put("calPayRollTaskContext", (Object)SerializationUtils.toJsonString((Object)this.calPayRollTaskContext));
            iswcAppCache.put("pageId", (Object)this.getView().getPageId());
            this.calPayRollTaskContext.setStartTime(new Date());
            this.getView().getPageCache().put("calPayRollTaskContext", SerializationUtils.toJsonString((Object)this.calPayRollTaskContext));
            if (confirmDatas.size() > 0) {
                this.showConfirm(confirmDatas);
                return;
            }
            if (!(this.isSelectData() && this.calPayRollTaskContext.getValidDatas().size() <= 0 || args.cancel)) {
                this.execute();
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (this.operationKey().contains(this.calPersonOperationEnum)) {
            OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
            List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
            for (IOperateInfo iOperateInfo : allErrorOrValidateInfo) {
                OperateErrorInfo operateErrorInfo = (OperateErrorInfo)iOperateInfo;
                String errorCode = operateErrorInfo.getErrorCode();
                if (!SWCStringUtils.equals((String)"datamutex", (String)errorCode)) continue;
                operationResult.setShowMessage(false);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Object data = event.getReturnData();
        switch (actionId) {
            case "processCloseCallBack": {
                if (data == null) break;
                FormShowParameter calOperationResultForm = CalPayRollTaskCalHelper.getModalFormShowParameter((String)"hsas_caloperationresult");
                calOperationResultForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hsas_caloperationresult"));
                if (data instanceof Map) {
                    return;
                }
                calOperationResultForm.setCustomParam("calPayRollTaskContext", data);
                this.getView().showForm(calOperationResultForm);
                break;
            }
            case "hsas_caloperationresult": {
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    @Override
    protected void cancelOperation(BeforeDoOperationEventArgs args) {
        args.setCancel(true);
        this.showErrMsg();
    }

    protected void showErrMsg() {
        List invalidDatas = this.calPayRollTaskContext.getInvalidDatas();
        ArrayList<String> failMessages = new ArrayList<String>(10);
        for (CalPayRollTask invalidData : invalidDatas) {
            failMessages.add(invalidData.getCalPayRollTaskValidatorErrorMsg());
        }
        if (failMessages.size() == 1) {
            this.getView().showTipNotification((String)failMessages.get(0));
        } else {
            FormShowParameter parameters = SWCShowFormServiceHelper.getOperationResultParameter((String)this.calPersonOperationEnum.getOperationName(), (String)MessageFormat.format(ResManager.loadKDString((String)"\u5171{0}\u4e2a\u6838\u7b97\u4efb\u52a1\uff0c\u5747\u4e0d\u7b26\u5408\u5904\u7406\u6761\u4ef6\u3002", (String)"AbstractCalPayRollTaskList_12", (String)"swc-hsas-formplugin", (Object[])new Object[0]), invalidDatas.size(), invalidDatas.size()), failMessages);
            this.getView().showForm(parameters);
        }
    }

    protected boolean singleCalPayRollTaskValidator(ListSelectedRowCollection listSelectedData) {
        if (listSelectedData.size() > 1) {
            switch (this.calPersonOperationEnum) {
                case OP_UNAUDIT: 
                case OP_DISAPPROVE: {
                    this.getView().showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8bf7\u5355\u9009\u6838\u7b97\u4efb\u52a1%s\u3002", (String)"AbstractCalPayRollTaskList_11", (String)"swc-hsas-formplugin", (Object[])new Object[0]), this.calPersonOperationEnum.getOperationName()));
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public boolean doValidateChooseData() {
        return true;
    }

    private void doValidate(BeforeDoOperationEventArgs args, List<CalPayRollTask> confirmDatas) {
        List validDatas = this.calPayRollTaskContext.getValidDatas();
        Iterator<CalPayRollTask> iterator = validDatas.iterator();
        List invalidDatas = this.calPayRollTaskContext.getInvalidDatas();
        FormOperate formOperate = (FormOperate)args.getSource();
        String optKey = formOperate.getOperateKey();
        while (iterator.hasNext()) {
            CalPayRollTask calPayRollTask = (CalPayRollTask)iterator.next();
            if (!this.checkTaskType(optKey, calPayRollTask)) {
                iterator.remove();
                invalidDatas.add(calPayRollTask);
                continue;
            }
            try {
                this.beforeDoOperation(args, calPayRollTask);
            }
            catch (Exception exception) {
                logger.error("\u6838\u7b97\u4efb\u52a1\u6279\u91cf\u64cd\u4f5c\u4e1a\u52a1\u6821\u9a8c\u5f02\u5e38", (Throwable)exception);
                calPayRollTask.setCalPayRollTaskValidatorErrorMsg(exception.getMessage());
                iterator.remove();
                invalidDatas.add(calPayRollTask);
                this.calPayRollTaskContext.getValidateCauseOfFailure().add(exception.getMessage());
                PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(calPayRollTask.getCalPayRollTaskId()), (String)this.calPersonOperationEnum.getOperationKey());
                continue;
            }
            this.afterDoValidator(args, confirmDatas, iterator, invalidDatas, calPayRollTask);
        }
    }

    private boolean checkTaskType(String optKey, CalPayRollTask calPayRollTask) {
        if (!SWCStringUtils.equals((String)calPayRollTask.getTaskType(), (String)"2")) {
            return true;
        }
        String errorMsg = null;
        if (!hisTaskBanOpKeySet.contains(optKey)) {
            return true;
        }
        errorMsg = ResManager.loadKDString((String)"\u5386\u53f2\u6570\u636e\u5bfc\u5165\u7c7b\u578b\u7684\u6838\u7b97\u4efb\u52a1\u4ec5\u5141\u8bb8\u67e5\u8be2\u548c\u53d1\u5e03\u5de5\u8d44\u6761\u3002", (String)"AbstractCalPayRollTaskList_17", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        calPayRollTask.setCalPayRollTaskValidatorErrorMsg(errorMsg);
        this.calPayRollTaskContext.getValidateCauseOfFailure().add(errorMsg);
        PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(calPayRollTask.getCalPayRollTaskId()), (String)this.calPersonOperationEnum.getOperationKey());
        return false;
    }

    private void afterDoValidator(BeforeDoOperationEventArgs args, List<CalPayRollTask> confirmDatas, Iterator<CalPayRollTask> iterator, List<CalPayRollTask> invalidDatas, CalPayRollTask calPayRollTask) {
        if (calPayRollTask.getCancelEnum() == CalPayRollTask.CancelEnum.Cancel) {
            iterator.remove();
            invalidDatas.add(calPayRollTask);
            this.calPayRollTaskContext.getValidateCauseOfFailure().add(calPayRollTask.getCalPayRollTaskValidatorErrorMsg());
            PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(calPayRollTask.getCalPayRollTaskId()), (String)this.calPersonOperationEnum.getOperationKey());
        } else if (calPayRollTask.getCancelEnum() == CalPayRollTask.CancelEnum.Confirm) {
            calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.OK);
            confirmDatas.add(calPayRollTask);
        } else {
            OperateOption option = ((FormOperate)args.getSource()).getOption();
            option.getVariables().forEach((key, value) -> calPayRollTask.getOperationParam().put(key, value));
            option.getVariables().forEach((key, value) -> option.removeVariable(key));
        }
    }

    public void doOperation() {
        this.createProcessHandler();
        this.invokeOperation();
        List invalidDatas = this.calPayRollTaskContext.getInvalidDatas();
        for (CalPayRollTask invalidData : invalidDatas) {
            int calPersonCount = CalPayRollTaskCalHelper.getCalPersonCount((Long)invalidData.getCalPayRollTaskId());
            invalidData.setCountCalPersons(calPersonCount);
            this.processHandler.update(0, calPersonCount, this.calPayRollTaskContext.getTraceId(), invalidData.getCalPayRollTaskId());
        }
        this.openProcessHandler();
    }

    protected void invokeOperation() {
        this.doInvokeOperation();
    }

    protected void doInvokeOperation() {
        if (this.calPayRollTaskContext == null) {
            this.calPayRollTaskContext = this.getCalPayRollTaskContext();
        }
        if (this.calPayRollTaskContext == null) {
            return;
        }
        List validDatas = this.calPayRollTaskContext.getValidDatas();
        for (CalPayRollTask validData : validDatas) {
            List calPersons = validData.getCalPersons();
            this.doInvokeOperation(calPersons, validData);
        }
    }

    protected void openProcessHandler() {
        HashMap<String, Object> param = new HashMap<String, Object>(2);
        param.put("closeCallBack", new CloseCallBack((IFormPlugin)this, "processCloseCallBack"));
        param.put("calPayRollTaskContext", SerializationUtils.toJsonString((Object)this.calPayRollTaskContext));
        this.processHandler.open(this.getView(), String.format(Locale.ROOT, ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97%s\u770b\u677f", (String)"AbstractCalPayRollTaskList_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]), this.calPersonOperationEnum.getOperationName()), param);
    }

    protected void doInvokeOperation(List<Long> calPersons, CalPayRollTask calPayRollTask) {
        Long calPayRollTaskId = calPayRollTask.getCalPayRollTaskId();
        Map operationParams = calPayRollTask.getOperationParam();
        OperateOption operateOption = OperateOption.create();
        operationParams.forEach((arg_0, arg_1) -> ((OperateOption)operateOption).setVariableValue(arg_0, arg_1));
        String operationKey = this.calPersonOperationEnum.getOperationKey();
        SWCThreadPoolFactory.getPayrolltaskOpThreadpool().execute(() -> {
            long startTime = System.currentTimeMillis();
            OperationServiceImpl opImpl = new OperationServiceImpl();
            List<Long> calPersonIds = calPersons;
            if (calPersonIds == null) {
                calPersonIds = this.getCalPersonIds(calPayRollTask);
            }
            if (calPersonIds.size() == 0) {
                this.processHandler.update(0, 0, this.calPayRollTaskContext.getTraceId(), calPayRollTaskId);
                PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(calPayRollTask.getCalPayRollTaskId()), (String)operationKey);
                return;
            }
            List partitionIds = Lists.partition(calPersonIds, (int)5000);
            for (List partitionId : partitionIds) {
                long invokeTime = System.currentTimeMillis();
                Long[] partCalPersonIds = new Long[partitionId.size()];
                this.invokeOp(calPayRollTaskId, operateOption, operationKey, opImpl, partitionId.size(), partitionId.toArray(partCalPersonIds));
                logger.info("invoke {} op cost\uff1a{}", (Object)this.calPersonOperationEnum.getOperationName(), (Object)(System.currentTimeMillis() - invokeTime));
            }
            PayrollTaskHelper.updateCalPayRollTaskStatus((Long)calPayRollTask.getCalPayRollTaskId());
            PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(calPayRollTask.getCalPayRollTaskId()), (String)operationKey);
            logger.info("invoke {} \u8017\u65f6\uff1a{}", (Object)this.calPersonOperationEnum.getOperationName(), (Object)(System.currentTimeMillis() - startTime));
        });
    }

    protected void invokeOp(Long calPayRollTaskId, OperateOption operateOption, String operationKey, OperationServiceImpl opImpl, int total, Object[] ids) {
        int failCount;
        if (ids == null) {
            logger.error("invoke {} fail\uff1acause calPersons is empty", (Object)operationKey);
            this.processHandler.update(0, total, this.calPayRollTaskContext.getTraceId(), calPayRollTaskId);
            return;
        }
        int successCount = 0;
        try {
            OperationResult operationResult = opImpl.localInvokeOperation(operationKey, "hsas_calperson", ids, operateOption);
            this.handelOperationResult(operationResult, calPayRollTaskId);
            successCount = operationResult.getSuccessPkIds().size();
            failCount = ids.length - successCount;
        }
        catch (Exception exception) {
            ISWCAppCache appCache = SWCAppCache.get((String)"SWC_PAYROLL_TASK");
            HashSet<String> errorInfos = (HashSet<String>)appCache.get(this.calPayRollTaskContext.getTraceId() + '_' + calPayRollTaskId + "opfail", HashSet.class);
            if (errorInfos == null) {
                errorInfos = new HashSet<String>(16);
            }
            errorInfos.add(exception.getMessage());
            appCache.put(this.calPayRollTaskContext.getTraceId() + '_' + calPayRollTaskId + "opfail", errorInfos);
            failCount = ids.length;
            logger.error("calPayRollTask operation error {}", (Object)exception.getMessage());
        }
        this.processHandler.update(successCount, failCount, this.calPayRollTaskContext.getTraceId(), calPayRollTaskId);
    }

    public void handelOperationResult(OperationResult operationResult, Long calPayRollTaskId) {
        List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
        ISWCAppCache appCache = SWCAppCache.get((String)"SWC_PAYROLL_TASK");
        HashSet<String> errorInfos = (HashSet<String>)appCache.get(this.calPayRollTaskContext.getTraceId() + '_' + calPayRollTaskId + "opfail", HashSet.class);
        if (errorInfos == null) {
            errorInfos = new HashSet<String>(allErrorOrValidateInfo.size());
        }
        for (IOperateInfo iOperateInfo : allErrorOrValidateInfo) {
            String errorMessage = iOperateInfo.getMessage();
            if (errorMessage.contains("\uff1a")) {
                errorInfos.add(errorMessage.substring(errorMessage.indexOf(65306) + 1));
                continue;
            }
            if (errorMessage.contains(": ")) {
                errorInfos.add(errorMessage.substring(errorMessage.indexOf(": ") + 1));
                continue;
            }
            errorInfos.add(errorMessage);
        }
        appCache.put(this.calPayRollTaskContext.getTraceId() + '_' + calPayRollTaskId + "opfail", errorInfos);
    }

    protected DynamicObject[] queryCalPersons(String selectProperties, CalPayRollTask calPayRollTask) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        QFilter calPersonFilter = new QFilter("caltask", "=", (Object)calPayRollTask.getCalPayRollTaskId());
        try {
            List authorizedDataRuleQFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"/UHMBBGZQ65X", (String)"hsas_calperson", (String)"47150e89000000ac");
            if (authorizedDataRuleQFilter != null) {
                for (QFilter qFilter : authorizedDataRuleQFilter) {
                    calPersonFilter.and(qFilter);
                }
            } else {
                calPersonFilter.and(new QFilter("1", "!=", (Object)1));
            }
        }
        catch (Exception exception) {
            logger.error("invoke hrcs IHRCSDataPermissionService error", (Object)exception.getMessage());
        }
        if (SWCStringUtils.isEmpty((String)selectProperties)) {
            selectProperties = "id";
        }
        long startTime = System.currentTimeMillis();
        DynamicObject[] query = helper.query(selectProperties, new QFilter[]{calPersonFilter});
        logger.info("queryCalPersons cost\uff1a{}", (Object)(System.currentTimeMillis() - startTime));
        return query;
    }

    protected DynamicObject[] queryCalPersonsToCost(String selectProperties, CalPayRollTask calPayRollTask) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        QFilter calPersonFilter = new QFilter("caltask", "=", (Object)calPayRollTask.getCalPayRollTaskId());
        try {
            long currUserId = RequestContext.get().getCurrUserId();
            QFilter salaryFileFilter = SWCPermissionServiceHelper.getDataRuleForBdProp((long)currUserId, (String)"1ANC8T4UC434", (String)"pcs_allotdetail", (String)"salaryfile", (String)"47150e89000000ac");
            if (salaryFileFilter != null) {
                calPersonFilter.and(salaryFileFilter);
            }
        }
        catch (Exception exception) {
            logger.error("invoke hrcs IHRCSDataPermissionService error", (Object)exception.getMessage());
        }
        if (SWCStringUtils.isEmpty((String)selectProperties)) {
            selectProperties = "id";
        }
        long startTime = System.currentTimeMillis();
        DynamicObject[] query = helper.query(selectProperties, new QFilter[]{calPersonFilter});
        logger.info("queryCalPersons cost\uff1a{}", (Object)(System.currentTimeMillis() - startTime));
        return query;
    }

    protected DynamicObject[] queryCalPersonsAndSetCalPersonIds(String selectProperties, CalPayRollTask calPayRollTask) {
        DynamicObject[] calPersonArr = this.queryCalPersons(selectProperties, calPayRollTask);
        this.setCalPersonIds(calPersonArr, calPayRollTask);
        return calPersonArr;
    }

    protected DynamicObject[] queryCalPersonsAndSetCalPersonIdsToCost(String selectProperties, CalPayRollTask calPayRollTask) {
        DynamicObject[] calPersonArr = this.queryCalPersonsToCost(selectProperties, calPayRollTask);
        this.setCalPersonIds(calPersonArr, calPayRollTask);
        return calPersonArr;
    }

    private void setCalPersonIds(DynamicObject[] calPersonArr, CalPayRollTask calPayRollTask) {
        ArrayList<Long> calPersonIds = new ArrayList<Long>(10);
        for (DynamicObject calPersonDy : calPersonArr) {
            calPersonIds.add(calPersonDy.getLong("id"));
        }
        calPayRollTask.setCalPersons(calPersonIds);
        calPayRollTask.setCountCalPersons(calPersonIds.size());
    }

    protected List<Long> getCalTaskIds() {
        ArrayList<Long> calTaskIdList = new ArrayList<Long>(10);
        CalPayRollTaskContext calPayRollTaskContext = this.getCalPayRollTaskContext();
        for (CalPayRollTask validData : calPayRollTaskContext.getValidDatas()) {
            calTaskIdList.add(validData.getCalPayRollTaskId());
        }
        return calTaskIdList;
    }

    protected List<Long> getCalPersonIds(CalPayRollTask calPayRollTask) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        QFilter calPersonFilter = new QFilter("caltask", "=", (Object)calPayRollTask.getCalPayRollTaskId());
        try {
            List authorizedDataRuleQFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"/UHMBBGZQ65X", (String)"hsas_calperson", (String)"47150e89000000ac");
            if (authorizedDataRuleQFilter != null) {
                for (QFilter qFilter : authorizedDataRuleQFilter) {
                    calPersonFilter.and(qFilter);
                }
            } else {
                calPersonFilter.and(new QFilter("1", "!=", (Object)1));
            }
        }
        catch (Exception exception) {
            logger.error("invoke hrcs IHRCSDataPermissionService error", (Throwable)exception);
        }
        long startTime = System.currentTimeMillis();
        DynamicObject[] query = helper.queryOriginalArray("id", new QFilter[]{calPersonFilter});
        logger.info("queryCalPersonIds cost\uff1a{}", (Object)(System.currentTimeMillis() - startTime));
        ArrayList<Long> calPersonIds = new ArrayList<Long>(10);
        for (DynamicObject calPersonDy : query) {
            calPersonIds.add(calPersonDy.getLong("id"));
        }
        return calPersonIds;
    }

    static {
        hisTaskBanOpKeySet.add("donothing_cal");
        hisTaskBanOpKeySet.add("donothing_cancelcal");
        hisTaskBanOpKeySet.add("donothing_viewcalreporthis");
        hisTaskBanOpKeySet.add("donothing_audit");
        hisTaskBanOpKeySet.add("donothing_unaudit");
        hisTaskBanOpKeySet.add("approve");
        hisTaskBanOpKeySet.add("disapprove");
        hisTaskBanOpKeySet.add("createapprove");
        hisTaskBanOpKeySet.add("showapprovedetail");
        hisTaskBanOpKeySet.add("createpay");
        hisTaskBanOpKeySet.add("donothing_viewpaydetail");
        hisTaskBanOpKeySet.add("deletepaydetail");
        hisTaskBanOpKeySet.add("donothing_createcostallot");
        hisTaskBanOpKeySet.add("donothing_viewcostallotdetail");
        hisTaskBanOpKeySet.add("donothing_delcostallot");
        hisTaskBanOpKeySet.add("donothing_viewfeedback");
    }
}

