/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.guide;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.cal.vo.CalPayRollTask;
import kd.swc.hsas.business.cal.vo.CalPayRollTaskContext;
import kd.swc.hsas.business.calpayrolltask.CalPayrollTaskHelper;
import kd.swc.hsbp.business.cal.helper.PayrollTaskHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.enums.CalPayrollTaskStateEnum;
import kd.swc.hsbp.common.enums.CalPersonOperationEnum;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseList;

public abstract class AbstractCalPersonOperation
extends SWCDataBaseList {
    private static final Log logger = LogFactory.getLog(AbstractCalPersonOperation.class);
    protected static final String KEY_CALTASK = "caltask";
    public static final int DEFAULT_SIZE = 5000;
    public static final String CALLBACK_INVOKE = "CallBackInvoke";
    public static final String OPERATION = "invokeOperation";
    protected CalPayRollTaskContext calPayRollTaskContext;
    protected CalPersonOperationEnum calPersonOperationEnum;

    protected List<CalPersonOperationEnum> operationKey() {
        return new ArrayList<CalPersonOperationEnum>(10);
    }

    protected abstract void beforeDoOperation(BeforeDoOperationEventArgs var1, CalPayRollTask var2);

    protected boolean operationMutex() {
        return true;
    }

    protected void execute() {
    }

    protected boolean isSelectData() {
        return true;
    }

    protected boolean checkCalPayrollTaskState(CalPayrollTaskStateEnum calPayrollTaskStateEnum) {
        return false;
    }

    protected void cancelOperation(BeforeDoOperationEventArgs args) {
        args.setCancel(true);
    }

    protected void initCalPayRollTaskContext(Map<Long, CalPayRollTask> selectCalPayRollTaskMap) {
        long startTime = System.currentTimeMillis();
        this.calPayRollTaskContext = new CalPayRollTaskContext();
        this.calPayRollTaskContext.setStartTime(new Date());
        this.calPayRollTaskContext.setCalPersonOperationEnum(this.calPersonOperationEnum);
        this.calPayRollTaskContext.setTraceId(RequestContext.get().getTraceId());
        this.calPayRollTaskContext.setSelectDatas(Long.valueOf(selectCalPayRollTaskMap.size()));
        this.calPayRollTaskContext.setSourceTypeName(this.getPluginName());
        this.operationMutex(selectCalPayRollTaskMap);
        logger.info("\u6838\u7b97\u4efb\u52a1\u6279\u91cf\u64cd\u4f5c\u521d\u59cb\u5316\u52a0\u9501\u8017\u65f6{}", (Object)(System.currentTimeMillis() - startTime));
        this.initCalPayRollTaskContext();
        logger.info("\u6838\u7b97\u4efb\u52a1\u6279\u91cf\u64cd\u4f5c\u521d\u59cb\u5316\u8017\u65f6{}", (Object)(System.currentTimeMillis() - startTime));
    }

    private List<DynamicObject> queryCalPayRollTask(List<CalPayRollTask> validDatas) {
        Set calTables = validDatas.stream().map(CalPayRollTask::getCalPayRollTaskId).collect(Collectors.toSet());
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        QFilter ids = new QFilter("id", "in", calTables);
        DynamicObject[] calPayRollTasks = helper.queryOriginalArray("id,number,taskstatus,country.id,calrulev.opentaxcal", new QFilter[]{ids});
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(calPayRollTasks.length);
        Collections.addAll(result, calPayRollTasks);
        return result;
    }

    private void operationMutex(Map<Long, CalPayRollTask> selectCalPayRollTaskMap) {
        List invalidDatas = this.calPayRollTaskContext.getInvalidDatas();
        List validDatas = this.calPayRollTaskContext.getValidDatas();
        Iterator<Map.Entry<Long, CalPayRollTask>> iterator = selectCalPayRollTaskMap.entrySet().iterator();
        boolean operationMutex = this.operationMutex();
        while (iterator.hasNext()) {
            String msg;
            Map.Entry<Long, CalPayRollTask> calPayRollTaskEntry = iterator.next();
            CalPayRollTask calPayRollTask = calPayRollTaskEntry.getValue();
            if (operationMutex && SWCStringUtils.isNotEmpty((String)(msg = CalPayrollTaskHelper.checkCalPayRollTaskIsMutex((CalPayRollTask)calPayRollTask, (CalPersonOperationEnum)this.calPersonOperationEnum)))) {
                this.calPayRollTaskContext.getValidateCauseOfFailure().add(msg);
                invalidDatas.add(calPayRollTask);
                iterator.remove();
                continue;
            }
            validDatas.add(calPayRollTask);
        }
    }

    private void initCalPayRollTaskContext() {
        List<DynamicObject> DBCalPayRollTasks = this.queryCalPayRollTask(this.calPayRollTaskContext.getValidDatas());
        HashMap<Long, DynamicObject> DBCalPayRollTaskIdMap = new HashMap<Long, DynamicObject>(DBCalPayRollTasks.size());
        for (DynamicObject calPayRollTask : DBCalPayRollTasks) {
            DBCalPayRollTaskIdMap.put(calPayRollTask.getLong("id"), calPayRollTask);
        }
        String errorMessage = ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u6838\u7b97\u4efb\u52a1\uff1a\u6838\u7b97\u4efb\u52a1\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"AbstractCalPayRollTaskList_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        String validateCauseOfFailure = ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"AbstractCalPayRollTaskList_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        String createTaskValidatorErrorMessage = ResManager.loadKDString((String)"{0}\uff1a\u6838\u7b97\u4efb\u52a1\u672a\u6dfb\u52a0\u85aa\u8d44\u6863\u6848\uff0c\u4e0d\u80fd\u8fdb\u884c{1}\u64cd\u4f5c\u3002", (String)"AbstractCalPayRollTaskList_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        String disusedTaskValidatorErrorMessage = ResManager.loadKDString((String)"\u7f16\u7801\u4e3a{0}\u7684\u6838\u7b97\u4efb\u52a1\uff1a\u6838\u7b97\u4efb\u52a1\u5df2\u5e9f\u5f03\uff0c\u65e0\u6cd5{1}\u3002", (String)"AbstractCalPayRollTaskList_13", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        String createTaskStatusCauseOfFailure = ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u4efb\u52a1\u672a\u6dfb\u52a0\u85aa\u8d44\u6863\u6848\uff0c\u65e0\u6cd5\u8fdb\u884c%s\u64cd\u4f5c\u3002", (String)"AbstractCalPayRollTaskList_14", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        String disusedTaskStatusCauseOfFailure = ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u4efb\u52a1\u5df2\u5e9f\u5f03\uff0c\u65e0\u6cd5\u8fdb\u884c%s\u64cd\u4f5c\u3002", (String)"AbstractCalPayRollTaskList_15", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        List invalidDatas = this.calPayRollTaskContext.getInvalidDatas();
        List validDatas = this.calPayRollTaskContext.getValidDatas();
        Iterator iterator = validDatas.iterator();
        while (iterator.hasNext()) {
            CalPayRollTask calPayRollTaskTemp = (CalPayRollTask)iterator.next();
            DynamicObject calPayRollTask = (DynamicObject)DBCalPayRollTaskIdMap.get(calPayRollTaskTemp.getCalPayRollTaskId());
            if (calPayRollTask == null) {
                calPayRollTaskTemp.setCalPayRollTaskValidatorErrorMsg(String.format(Locale.ROOT, errorMessage, calPayRollTaskTemp.getNumber()));
                invalidDatas.add(calPayRollTaskTemp);
                this.calPayRollTaskContext.getValidateCauseOfFailure().add(validateCauseOfFailure);
                PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(calPayRollTaskTemp.getCalPayRollTaskId()), (String)this.calPersonOperationEnum.getOperationKey());
                iterator.remove();
                continue;
            }
            CalPayrollTaskStateEnum calPayrollTaskStateEnum = CalPayrollTaskStateEnum.getCalTaskState((String)calPayRollTask.getString("taskstatus"));
            if ((CalPayrollTaskStateEnum.CREATE.equals((Object)calPayrollTaskStateEnum) || CalPayrollTaskStateEnum.DISUSED.equals((Object)calPayrollTaskStateEnum)) && !this.checkCalPayrollTaskState(calPayrollTaskStateEnum)) {
                if (CalPayrollTaskStateEnum.CREATE.equals((Object)calPayrollTaskStateEnum)) {
                    calPayRollTaskTemp.setCalPayRollTaskValidatorErrorMsg(MessageFormat.format(createTaskValidatorErrorMessage, calPayRollTaskTemp.getNumber(), this.calPersonOperationEnum.getOperationName()));
                    this.calPayRollTaskContext.getValidateCauseOfFailure().add(String.format(Locale.ROOT, createTaskStatusCauseOfFailure, this.calPersonOperationEnum.getOperationName()));
                } else {
                    calPayRollTaskTemp.setCalPayRollTaskValidatorErrorMsg(MessageFormat.format(disusedTaskValidatorErrorMessage, calPayRollTaskTemp.getNumber(), this.calPersonOperationEnum.getOperationName()));
                    this.calPayRollTaskContext.getValidateCauseOfFailure().add(String.format(Locale.ROOT, disusedTaskStatusCauseOfFailure, this.calPersonOperationEnum.getOperationName()));
                }
                PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(calPayRollTaskTemp.getCalPayRollTaskId()), (String)this.calPersonOperationEnum.getOperationKey());
                invalidDatas.add(calPayRollTaskTemp);
                iterator.remove();
                continue;
            }
            List calPersons = calPayRollTaskTemp.getCalPersons();
            calPayRollTaskTemp.setCountCalPersons(calPersons == null ? this.count(calPayRollTaskTemp.getCalPayRollTaskId()) : calPersons.size());
            calPayRollTaskTemp.setPayRollTaskStatus(calPayRollTask.getString("taskstatus"));
            HashMap<String, String> operationParam = new HashMap<String, String>(16);
            operationParam.put("langCode", Lang.get().getLangTag());
            calPayRollTaskTemp.setOperationParam(operationParam);
            String openTaxCal = calPayRollTask.getString("calrulev.opentaxcal");
            if (SWCStringUtils.isEmpty((String)openTaxCal) || SWCStringUtils.equals((String)"0", (String)openTaxCal)) {
                calPayRollTaskTemp.setOpenTaxCal("0");
            } else {
                calPayRollTaskTemp.setOpenTaxCal("1");
            }
            calPayRollTaskTemp.setCountryId(Long.valueOf(calPayRollTask.getLong("country.id")));
        }
    }

    public void releaseDistributedLock() {
        CalPayRollTaskContext calPayRollTaskContext = (CalPayRollTaskContext)SerializationUtils.fromJsonString((String)this.getView().getPageCache().get("calPayRollTaskContext"), CalPayRollTaskContext.class);
        this.releaseDistributedLock(calPayRollTaskContext);
    }

    public void releaseDistributedLock(CalPayRollTaskContext calPayRollTaskContext) {
        for (CalPayRollTask validData : calPayRollTaskContext.getValidDatas()) {
            PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(validData.getCalPayRollTaskId()), (String)calPayRollTaskContext.getCalPersonOperationEnum().getOperationKey());
        }
    }

    protected DynamicObject getCalTaskInfo(long taskId, String selectProperties) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        return helper.queryOne(selectProperties, (Object)taskId);
    }

    protected int count(Long calTaskId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        QFilter qFilter = new QFilter("caltask.id", "=", (Object)calTaskId);
        qFilter.and(new QFilter("calmainid", "=", (Object)0));
        try {
            List authorizedDataRuleQFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"/UHMBBGZQ65X", (String)"hsas_calperson", (String)"47150e89000000ac");
            if (authorizedDataRuleQFilter != null) {
                for (QFilter authFilter : authorizedDataRuleQFilter) {
                    qFilter.and(authFilter);
                }
            } else {
                qFilter.and(new QFilter("1", "!=", (Object)1));
            }
        }
        catch (Exception exception) {
            logger.error("invoke hrcs IHRCSDataPermissionService error", (Throwable)exception);
        }
        return helper.count(new QFilter[]{qFilter});
    }

    protected CalPayRollTaskContext getCalPayRollTaskContext() {
        if (this.calPayRollTaskContext != null) {
            return this.calPayRollTaskContext;
        }
        String calPayRollTaskContextJson = this.getView().getPageCache().get("calPayRollTaskContext");
        if (calPayRollTaskContextJson != null) {
            return (CalPayRollTaskContext)SerializationUtils.fromJsonString((String)calPayRollTaskContextJson, CalPayRollTaskContext.class);
        }
        return null;
    }

    protected String getTraceId() {
        CalPayRollTaskContext calPayRollTaskContext = this.getCalPayRollTaskContext();
        if (calPayRollTaskContext != null) {
            return calPayRollTaskContext.getTraceId();
        }
        return "";
    }
}

