/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.guide;

import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FieldTip;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.cal.helper.CalPersonListHelper;
import kd.swc.hsas.business.payrollscene.service.SWCPayRollSceneService;
import kd.swc.hsas.business.payrolltask.helper.PayRollTaskHelper;
import kd.swc.hsas.business.payrolltask.service.PayRollTaskService;
import kd.swc.hsas.business.payrolltask.service.TaskConfirmEnum;
import kd.swc.hsas.common.enums.AfterCalEnum;
import kd.swc.hsbp.business.calperson.CalPersonHelper;
import kd.swc.hsbp.business.coderule.CodeRuleHelper;
import kd.swc.hsbp.business.datachanged.BizChangedHelper;
import kd.swc.hsbp.business.log.SWCOpLogServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.enums.CalPersonLockEnum;
import kd.swc.hsbp.common.util.SWCArrayUtils;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CalAutoCreatePayrollTaskPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final String OP_SAVE = "donothing_ok";
    private static final String BTN_CLOSE = "donothing_close";
    private static final String BTN_OK = "btnok";
    private static final String HRQXX0182 = "2B+P=Q5GPS2Z";
    private static Log log = LogFactory.getLog(CalAutoCreatePayrollTaskPlugin.class);

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter formShowParameter = e.getFormShowParameter();
        if (formShowParameter == null || formShowParameter.getParentPageId() == null) {
            e.setCancel(true);
        }
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{BTN_OK});
        SWCPayRollSceneService.createInstance().multiSetBeforeF7SelectListener((Object)this, new String[]{"payrollgroup", "payrollscene", "period"});
    }

    public void createNewData(BizDataEventArgs args) {
        this.getView().setEnable(Boolean.FALSE, new String[]{"payrollscene", "period"});
    }

    public void afterCreateNewData(EventObject eventObject) {
        IFormView parentView;
        this.setDefaultTracker();
        this.setTrackerFilter();
        this.getModel().setDataChanged(false);
        String calPlatform = (String)this.getView().getFormShowParameter().getCustomParam("calplatformflag");
        if (!StringUtils.isEmpty((CharSequence)calPlatform) && (parentView = this.getView().getParentView().getParentView()) != null) {
            DynamicObject params = parentView.getModel().getDataEntity();
            this.getModel().setValue("payrollgroup", (Object)params.getLong("payrollgroup.id"));
            this.getView().setEnable(Boolean.TRUE, new String[]{"payrollscene"});
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name;
        Object[] changeSets = args.getChangeSet();
        if (SWCArrayUtils.isEmpty((Object[])changeSets)) {
            return;
        }
        switch (name = args.getProperty().getName()) {
            case "payrollgroup": {
                PayRollTaskService payRollTaskService = PayRollTaskService.createInstance();
                Long newPayRollGroupId = payRollTaskService.getFieldPkId((DynamicObject)changeSets[0].getNewValue());
                if (newPayRollGroupId == null) {
                    this.clearFields("payrollscene", "payrollscenev", "payrollgroupv", "period", "calrulev");
                    this.getView().setEnable(Boolean.FALSE, new String[]{"payrollscene"});
                    this.getView().setEnable(Boolean.FALSE, new String[]{"period"});
                    break;
                }
                if (!newPayRollGroupId.equals(payRollTaskService.getFieldPkId((DynamicObject)changeSets[0].getOldValue()))) {
                    this.clearFields("payrollscene", "payrollscenev", "payrollgroupv", "period", "calrulev");
                    this.getView().setEnable(Boolean.TRUE, new String[]{"payrollscene"});
                    break;
                }
                this.getView().setEnable(Boolean.TRUE, new String[]{"payrollscene"});
                break;
            }
            case "tasktype": {
                this.adjustAutoAddPersonSwitch((String)changeSets[0].getNewValue());
                break;
            }
            case "payrollscenev": {
                this.adjustCalRuleAndPeriod((DynamicObject)changeSets[0].getNewValue());
                break;
            }
            case "period": {
                this.adjustCalRuleVersion((DynamicObject)changeSets[0].getNewValue());
                break;
            }
        }
    }

    private void adjustCalRuleAndPeriod(DynamicObject paySceneVDyObj) {
        if (!SWCObjectUtils.isEmpty((Object)paySceneVDyObj)) {
            this.clearFields("period", "calrulev");
            this.getView().setEnable(Boolean.TRUE, new String[]{"period"});
        } else {
            this.clearFields("payrollgroupv", "payrollscene", "period", "calrulev", "callistviewv");
            this.getView().setEnable(Boolean.FALSE, new String[]{"period"});
        }
    }

    private void adjustCalRuleVersion(DynamicObject periodDyObj) {
        String afterCal;
        Long calRuleVId;
        DynamicObject[] calRuleVersionArr;
        String errMsg;
        DynamicObject payRollSceneVDyObj;
        if (periodDyObj == null || periodDyObj.getLong("id") == 0L || (payRollSceneVDyObj = this.getModel().getDataEntity().getDynamicObject("payrollscenev")) == null) {
            this.clearFields("calrulev", "period");
            return;
        }
        PayRollTaskService payRollTaskService = PayRollTaskService.createInstance();
        Date endDate = periodDyObj.getDate("enddate");
        Long calListRuleID = payRollSceneVDyObj.getLong("callistrule.id");
        if (calListRuleID != 0L && (errMsg = payRollTaskService.checkCalListRuleV(calListRuleID, endDate)) != null) {
            this.getView().showErrorNotification(errMsg);
            this.clearFields("calrulev", "period");
            return;
        }
        Long calRuleId = payRollSceneVDyObj.getLong("calrule.id");
        if (calRuleId == 0L || (calRuleVersionArr = PayRollTaskHelper.queryCalRuleVersionArr((long)calRuleId, (Date)endDate)) == null || calRuleVersionArr.length == 0 || (calRuleVId = Long.valueOf(calRuleVersionArr[0].getLong("id"))) == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba1\u7b97\u89c4\u5219\u5728\u85aa\u8d44\u7ed3\u675f\u65e5\u671f\u524d\u4e0d\u5b58\u5728\u5df2\u751f\u6548\u7684\u6570\u636e\u7248\u672c\uff0c\u8bf7\u65b0\u589e\u8ba1\u7b97\u89c4\u5219\u7248\u672c\u4fe1\u606f\u6216\u66f4\u6539\u671f\u95f4\u3002", (String)"CalAutoCreatePayrollTaskPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            this.clearFields("calrulev", "period");
            return;
        }
        IDataModel model = this.getModel();
        DynamicObject payrollSceneVInfo = (DynamicObject)model.getValue("payrollscenev");
        if (payrollSceneVInfo != null && (afterCal = payrollSceneVInfo.getString("aftercal")) != null && afterCal.contains(AfterCalEnum.PERSONALPAY.getCode()) && !payRollTaskService.verifyHasPayoutItem(calRuleVersionArr[0])) {
            this.clearFields("calrulev", "period");
            String msg = ResManager.loadKDString((String)"\u6839\u636e\u671f\u95f4\u9ed8\u8ba4\u4f7f\u7528\u7684\u8ba1\u7b97\u89c4\u5219\u7248\u672c\u672a\u5305\u542b\u5b9e\u53d1\u9879\u76ee\uff0c\u8bf7\u901a\u8fc7\u9ad8\u9636\u521b\u5efa\u5207\u6362\u8ba1\u7b97\u89c4\u5219\u7248\u672c\u521b\u5efa\u6838\u7b97\u4efb\u52a1\uff0c\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"CalAutoCreatePayrollTaskPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            return;
        }
        model.setValue("calrulev", (Object)calRuleVId);
        String defaultPayRollTaskName = payRollTaskService.getCalPayRollTaskDefaultName(this.getModel().getDataEntity());
        if (defaultPayRollTaskName.length() > 0) {
            this.getModel().setValue("name", (Object)defaultPayRollTaskName);
        } else {
            this.getModel().setValue("name", null);
        }
        payRollTaskService.verifyPayrollGrpV(this.getView(), endDate);
    }

    private void adjustAutoAddPersonSwitch(String newValue) {
        boolean preAutoAddPerson;
        Boolean isCommonSwitch = "0".equals(newValue);
        if (!isCommonSwitch.equals(preAutoAddPerson = this.getModel().getDataEntity(true).getBoolean("isautoaddperson"))) {
            this.getModel().setValue("isautoaddperson", (Object)isCommonSwitch);
        }
        this.getView().updateView("isautoaddperson");
    }

    private void setDefaultTracker() {
        DynamicObjectCollection collection = new DynamicObjectCollection();
        collection.add((Object)PayRollTaskHelper.queryDefaultTracker());
        this.getModel().setValue("tracker", (Object)collection);
    }

    private void setTrackerFilter() {
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        BasedataEdit trackerF7 = (BasedataEdit)this.getControl("tracker");
        trackerF7.setQFilter(qFilter);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String fieldKey = event.getProperty().getName();
        ListShowParameter param = (ListShowParameter)event.getFormShowParameter();
        switch (fieldKey) {
            case "payrollgroup": {
                List qFilters = param.getListFilterParameter().getQFilters();
                QFilter dataRuleForBdPropFilter = SWCPermissionServiceHelper.getDataRuleForBdProp((long)RequestContext.get().getCurrUserId(), (String)"/UHMBBGZQ65X", (String)"hsas_calpayrolltask", (String)"payrollgroup", (String)HRQXX0182);
                if (dataRuleForBdPropFilter != null) {
                    qFilters.add(dataRuleForBdPropFilter);
                }
                PayRollTaskService.setOrgAuthorFilter((List)qFilters);
                break;
            }
            case "payrollscene": {
                long payRollGrpId;
                event.setCancel(true);
                DynamicObject payRollGrpDyObj = (DynamicObject)this.getModel().getValue("payrollgroup");
                if (payRollGrpDyObj == null || (payRollGrpId = payRollGrpDyObj.getLong("id")) == 0L) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"payrollscene"});
                    this.getModel().setValue("payrollscene", null);
                    break;
                }
                ListShowParameter showParameter = PayRollTaskService.createInstance().getPayRollGroupEntityInfoShowParameter(payRollGrpId, SWCDateTimeUtils.getDateWithoutMinTs((Date)new Date()));
                showParameter.setCustomParam("permissionId", (Object)HRQXX0182);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hsas_payrollgrpschis"));
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnDataObj = closedCallBackEvent.getReturnData();
        if (SWCObjectUtils.isEmpty((Object)returnDataObj)) {
            return;
        }
        switch (closedCallBackEvent.getActionId()) {
            case "hsas_payrollgrpschis": {
                ListSelectedRowCollection returnDataList = (ListSelectedRowCollection)returnDataObj;
                PayRollTaskService payRollTaskService = PayRollTaskService.createInstance();
                Object result = PayRollTaskService.checkAndGetPayRollGroupInfo((Long)((Long)returnDataList.get(0).getPrimaryKeyValue()));
                if (result instanceof List) {
                    for (String errMsg : (List)result) {
                        this.getView().showErrorNotification(errMsg);
                    }
                    break;
                }
                if (!(result instanceof Map)) break;
                Map resultMap = (Map)result;
                boolean isInValid = payRollTaskService.checkPeriodTypeInfoAndSetFilterForPeriod((AbstractFormPlugin)this, (Long)resultMap.get("periodtype"));
                if (isInValid) {
                    return;
                }
                List<String> needStoreFieldArr = Arrays.asList("payrollscene", "payrollscenev", "payrollgroupv", "callistviewv");
                for (Map.Entry entry : resultMap.entrySet()) {
                    if (!needStoreFieldArr.contains(entry.getKey())) continue;
                    this.getModel().setValue((String)entry.getKey(), entry.getValue());
                }
                this.getView().updateView();
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "donothing_ok": {
                PayRollTaskService payRollTaskService;
                DynamicObject calPeriodObj;
                String taskName = this.getModel().getDataEntity().getString("name");
                if (taskName != null && PayRollTaskHelper.queryCount((String)taskName) > 0) {
                    args.setCancel(true);
                    Map resultMap = PayRollTaskService.checkFieldsMustInput((Object)taskName);
                    if (!resultMap.isEmpty()) {
                        this.getView().showFieldTip((FieldTip)resultMap.get("FieldTip"));
                        this.getView().showTipNotification((String)resultMap.get("errMsg"));
                        break;
                    }
                }
                if (SWCPermissionServiceHelper.checkCancelDataAndFunctionRight((IFormView)this.getView().getParentView(), (boolean)true)) {
                    args.setCancel(true);
                    return;
                }
                boolean hasViewPermssion = SWCPermissionServiceHelper.hasPerm((String)"/UHMBBGZQ65X", (String)"hsas_calpayrolltask", (String)HRQXX0182);
                if (!hasViewPermssion) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u85aa\u8d44\u6838\u7b97\u4efb\u52a1\u7684\u5feb\u901f\u521b\u5efa\u6743\u9650\u3002", (String)"CalAutoCreatePayrollTaskPlugin_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                TaskConfirmEnum taskConfirmEnum = TaskConfirmEnum.getInstance((String)this.getView().getEntityId(), (Boolean)"0".equals(this.getModel().getValue("tasktype")));
                if (taskConfirmEnum != null && taskConfirmEnum.confirmBeforeSave((Object)this)) {
                    args.setCancel(true);
                    break;
                }
                DynamicObject srcTaskInfoDyObj = this.getModel().getDataEntity();
                DynamicObject payrollSceneVInfo = srcTaskInfoDyObj.getDynamicObject("payrollscenev");
                if (!payrollSceneVInfo.getBoolean("isenableatt") || !SWCObjectUtils.isEmpty((Object)(calPeriodObj = (payRollTaskService = PayRollTaskService.createInstance()).getAttDateRange(payrollSceneVInfo, srcTaskInfoDyObj.getDynamicObject("period"), payrollSceneVInfo.getDynamicObject("periodtype"))))) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u85aa\u8d44\u671f\u95f4\u65e0\u53ef\u7528\u7684\u201c\u4e0a\u4e2a\u671f\u95f4\u201d\u6216\u201c\u4e0a\u4e0a\u4e2a\u671f\u95f4\u201d\uff0c\u8003\u52e4\u8d77\u6b62\u65e5\u671f\u751f\u6210\u5931\u8d25\u3002", (String)"CalAutoCreatePayrollTaskPlugin_8", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
            case "donothing_close": {
                ConfirmCallBackListener listener = new ConfirmCallBackListener("continue_close", (IFormPlugin)this);
                IDataModel dataModel = this.getModel();
                String changeDesc = null;
                List<String> allNeedShowFieldBorderList = Arrays.asList("name", "tasktype", "payrollgroup", "payrollscene", "period", "isautoaddperson", "tracker", "description");
                BizChangedHelper.operateBizChangedSet((DynamicObject)dataModel.getDataEntity(true), allNeedShowFieldBorderList, (BizChangedHelper.OperateEnum)BizChangedHelper.OperateEnum.RETAIN);
                if (dataModel.getDataChanged()) {
                    changeDesc = dataModel.getChangeDesc();
                }
                if (SWCStringUtils.isNotEmpty(changeDesc)) {
                    String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"CalAutoCreatePayrollTaskPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]) + "\r\n" + ResManager.loadKDString((String)"\u8bf7\u4fdd\u5b58\uff0c\u5426\u5219\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"CalAutoCreatePayrollTaskPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                    msg = msg.replaceAll("\\\\r\\\\n", "\r\n");
                    this.getView().showConfirm(msg, changeDesc, MessageBoxOptions.OKCancel, ConfirmTypes.Save, listener);
                    break;
                }
                this.getView().close();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (formOperate.getOperateKey()) {
            case "donothing_ok": {
                this.updatePayrollTask(args);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            if ("continue_close".equals(messageBoxClosedEvent.getCallBackId())) {
                this.getView().close();
                this.getView().getParentView().close();
            } else {
                TaskConfirmEnum.confirmCallBack((Object)((Object)this), (String)messageBoxClosedEvent.getCallBackId());
            }
        }
    }

    private void updatePayrollTask(AfterDoOperationEventArgs args) {
        String opName = ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"CalAutoCreatePayrollTaskPlugin_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        if (!args.getOperationResult().isSuccess()) {
            MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u4fdd\u5b58\u5931\u8d25\u3002", "CalAutoCreatePayrollTaskPlugin_6", "swc-hsas-formplugin");
            MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u4fdd\u5b58", "CalAutoCreatePayrollTaskPlugin_4", "swc-hsas-formplugin");
            SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)OP_SAVE, (MultiLangEnumBridge)opNameBridge, null, (MultiLangEnumBridge)opDescBridge, null);
            return;
        }
        DynamicObject srcTaskInfoDyObj = this.getModel().getDataEntity();
        PayRollTaskService payRollTaskService = PayRollTaskService.createInstance();
        Map resultMap = null;
        try {
            resultMap = payRollTaskService.addPayrollTask(this.getModel().getDataEntity());
        }
        catch (Exception exception) {
            log.error("CalAutoCreatePayrollTaskPlugin.updatePayrollTask: ", (Throwable)exception);
            String codeRuleInfo = CodeRuleHelper.getCodeRuleExceptionInfo((Exception)exception);
            if (codeRuleInfo != null) {
                this.getView().showErrorNotification(codeRuleInfo);
                return;
            }
            throw exception;
        }
        if (resultMap.get("isSaveErrorMark") != null) {
            this.updateViewByOpMark(resultMap);
            return;
        }
        IFormView parentView = this.getView().getParentView();
        String calPlatform = (String)this.getView().getFormShowParameter().getCustomParam("calplatformflag");
        if (parentView != null) {
            if (!StringUtils.isEmpty((CharSequence)calPlatform)) {
                if (!srcTaskInfoDyObj.getBoolean("isautoaddperson")) {
                    this.getView().returnDataToParent((Object)"calplatformflag");
                }
            } else {
                parentView.invokeOperation("refresh");
                this.getView().sendFormAction(parentView);
            }
        }
        this.getView().close();
        Long taskId = Long.valueOf((String)resultMap.get("id"));
        if (srcTaskInfoDyObj.getBoolean("isautoaddperson") && CalPersonListHelper.validateRuleVersion((Long)taskId, (IFormView)this.getView().getParentView(), (boolean)true)) {
            String taskName = (String)resultMap.get("name");
            String errorCode = payRollTaskService.autoAddCalPerson(taskId);
            if (SWCStringUtils.isNotEmpty((String)errorCode)) {
                this.getView().getParentView().showErrorNotification(CalPersonLockEnum.getDesc((String)errorCode));
            } else {
                CalPersonHelper.showAddPersonProgress((Long)taskId, (String)taskName, (IFormView)this.getView().getParentView(), (boolean)true, (boolean)false);
            }
        }
        this.getView().sendFormAction(this.getView().getParentView());
        MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u4fdd\u5b58\u6210\u529f\u3002", "CalAutoCreatePayrollTaskPlugin_5", "swc-hsas-formplugin");
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u4fdd\u5b58", "CalAutoCreatePayrollTaskPlugin_4", "swc-hsas-formplugin");
        SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)OP_SAVE, (MultiLangEnumBridge)opNameBridge, null, (MultiLangEnumBridge)opDescBridge, null);
    }

    private void updateViewByOpMark(Map<String, String> resultMap) {
        String errMark = resultMap.get("isSaveErrorMark");
        String errField = resultMap.get("SaveErrorField");
        if (SWCStringUtils.isEmpty((String)errMark) || SWCStringUtils.isEmpty((String)errField)) {
            return;
        }
        switch (errMark) {
            case "payrollgroup": {
                this.clearFields("payrollgroup", "payrollgroupv", "payrollscene", "payrollscenev", "period", "calrulev", "callistviewv");
                this.getView().setEnable(Boolean.FALSE, new String[]{"payrollscene"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"period"});
                break;
            }
            case "payrollscene": {
                this.clearFields("payrollgroupv", "payrollscene", "payrollscenev", "period", "calrulev", "callistviewv");
                this.getView().setEnable(Boolean.FALSE, new String[]{"period"});
                break;
            }
            case "period": 
            case "calrulev": {
                this.clearFields("calrulev", "period");
                break;
            }
        }
        Map fieldErrMsgWhenSaveMap = PayRollTaskService.getFieldErrMsgWhenSaveMap((boolean)true);
        String errMsg = (String)fieldErrMsgWhenSaveMap.get(errField);
        if (!SWCStringUtils.isEmpty((String)errMsg)) {
            this.getView().showErrorNotification(errMsg);
        }
        this.getView().updateView();
    }

    private void clearFields(String ... fieldNames) {
        for (String fieldName : fieldNames) {
            this.getModel().setValue(fieldName, null);
        }
    }
}

