/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.guide;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.swc.hsas.business.cal.helper.CalHelper;
import kd.swc.hsas.business.cal.helper.CalPayRollTaskCalHelper;
import kd.swc.hsas.business.cal.helper.CalTableCalHelper;
import kd.swc.hsas.business.cal.service.CalTableCalService;
import kd.swc.hsas.business.cal.vo.CalPayRollTask;
import kd.swc.hsas.business.cal.vo.CalPayRollTaskContext;
import kd.swc.hsbp.business.cal.helper.PayrollTaskHelper;
import kd.swc.hsbp.business.calrequest.CalRequestHelper;
import kd.swc.hsbp.business.log.SWCOpLogServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.constants.CalConstants;
import kd.swc.hsbp.common.enums.CalPersonOperationEnum;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.CollectionUtils;

public class CalCalPersonFormPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(CalCalPersonFormPlugin.class);
    public static final String START_CAL = "startcal";
    public static final String CONFIRM_CAL = "confirm";
    public static final String CONFIRM_NEWVERSOIN = "confirm_newversion";
    public static final String OPENTAX_CONFIRM_NEWVERSOIN = "opeantax_confirm_newversion";
    public static final String CAL_PAY_ROLL_TASK_NAME = "calpayrolltaskname";
    public static final String CAL_PERSON_COUNT = "calpersoncount";
    public static final String CAN_OPERATION_COUNT = "canoperationcount";
    public static final String NOT_OPERATION_COUNT = "notoperationcount";
    private static final String CAL_PERMID = "4730fc9f000025ae";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (SWCStringUtils.equals((String)operate.getOperateKey(), (String)START_CAL)) {
            this.beforeCalOperation(args, operate, START_CAL, CONFIRM_NEWVERSOIN);
        } else if (SWCStringUtils.equals((String)CONFIRM_CAL, (String)operate.getOperateKey())) {
            this.beforeCalOperation(args, operate, CONFIRM_CAL, OPENTAX_CONFIRM_NEWVERSOIN);
        }
    }

    private boolean checkCalPerms() {
        logger.info("checkCalPerms begin");
        if (!SWCPermissionServiceHelper.hasPerm((String)"/UHMBBGZQ65X", (String)"hsas_calperson", (String)CAL_PERMID)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u6838\u7b97\u540d\u5355\u201d\u7684\u201c\u8ba1\u7b97\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CalCalPersonFormPlugin_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return false;
        }
        logger.info("checkCalPerms end");
        return true;
    }

    private void beforeCalOperation(BeforeDoOperationEventArgs args, FormOperate operate, String operationCode, String callBackCode) {
        logger.info("beforeCalOperation begin,key:{}", (Object)operate.getOperateKey());
        operate.getOption().setVariableValue("skipCheckDataPermission", String.valueOf(true));
        if (!operate.getOption().tryGetVariableValue(operationCode, new RefObject())) {
            CalPayRollTaskContext calPayRollTaskContext = this.getCalPayRollTaskContext();
            List validDatas = calPayRollTaskContext.getValidDatas();
            if (!this.checkCalPerms()) {
                args.setCancel(true);
                return;
            }
            if (this.checkChoose(operationCode)) {
                args.setCancel(true);
                return;
            }
            int canCalTotalCount = 0;
            for (CalPayRollTask validData : validDatas) {
                canCalTotalCount += validData.getCalPersons().size();
            }
            if (canCalTotalCount == 0) {
                args.setCancel(true);
                return;
            }
            boolean flag = false;
            for (CalPayRollTask validData : validDatas) {
                SWCPageCache swcPageCache = new SWCPageCache(this.getView());
                HashMap versionData = new HashMap(16);
                String confirmMessage = CalHelper.initCalFormulaGradeInfo((CalPayRollTask)validData, versionData);
                swcPageCache.put(String.valueOf(validData.getCalPayRollTaskId()), versionData);
                if (!SWCStringUtils.isNotEmpty((String)confirmMessage)) continue;
                flag = true;
            }
            if (flag) {
                args.setCancel(true);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6709\u8ba1\u7b97\u5143\u7d20\u4ea7\u751f\u65b0\u7248\u672c\uff0c\u662f\u5426\u5168\u90e8\u5e94\u7528\u65b0\u7248\u672c\u53c2\u4e0e\u8ba1\u7b97\u3002", (String)"CalCalPersonFormPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(callBackCode, (IFormPlugin)this));
            } else if (canCalTotalCount <= CalConstants.SYN_CHECK_CERT_MAX_KEY && !this.checkCert(validDatas)) {
                args.setCancel(true);
            }
        }
    }

    private boolean checkChoose(String operationCode) {
        if (!SWCStringUtils.equals((String)operationCode, (String)CONFIRM_CAL)) {
            return false;
        }
        String unCalState = (String)this.getModel().getValue("uncalstate");
        String partialCaledState = (String)this.getModel().getValue("partialcaledstate");
        String errorState = (String)this.getModel().getValue("errorstate");
        String caledState = (String)this.getModel().getValue("caledstate");
        if (SWCStringUtils.isEmpty((String)unCalState) || SWCStringUtils.isEmpty((String)partialCaledState) || SWCStringUtils.isEmpty((String)errorState) || SWCStringUtils.isEmpty((String)caledState)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u79cd\u6838\u7b97\u72b6\u6001\u7684\u6838\u7b97\u8bb0\u5f55\u6267\u884c\u8ba1\u7b97\u64cd\u4f5c\u3002", (String)"CalCalPersonFormPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (SWCStringUtils.equals((String)unCalState, (String)"0") && SWCStringUtils.equals((String)partialCaledState, (String)"0") && SWCStringUtils.equals((String)errorState, (String)"0") && SWCStringUtils.equals((String)caledState, (String)"0")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u79cd\u6838\u7b97\u72b6\u6001\u7684\u6838\u7b97\u8bb0\u5f55\u6267\u884c\u8ba1\u7b97\u64cd\u4f5c\u3002", (String)"CalCalPersonFormPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public void afterDoOperation(AfterDoOperationEventArgs arg) {
        super.afterDoOperation(arg);
        FormOperate operate = (FormOperate)arg.getSource();
        if (SWCStringUtils.equals((String)operate.getOperateKey(), (String)START_CAL) || SWCStringUtils.equals((String)operate.getOperateKey(), (String)CONFIRM_CAL)) {
            this.afterCalOperation(operate.getOperateKey());
        }
    }

    private Map<String, String> getCalModeMap(String operateKey) {
        HashMap<String, String> calModeMap = new HashMap<String, String>(4);
        if (START_CAL.equals(operateKey)) {
            calModeMap.put("uncalstate", "4");
            calModeMap.put("partialcaledstate", "3");
            calModeMap.put("errorstate", "3");
            calModeMap.put("caledstate", "3");
            return calModeMap;
        }
        String unCalState = (String)this.getModel().getValue("uncalstate");
        String partialCaledState = (String)this.getModel().getValue("partialcaledstate");
        String errorState = (String)this.getModel().getValue("errorstate");
        String caledState = (String)this.getModel().getValue("caledstate");
        calModeMap.put("uncalstate", unCalState);
        calModeMap.put("partialcaledstate", partialCaledState);
        calModeMap.put("errorstate", errorState);
        calModeMap.put("caledstate", caledState);
        return calModeMap;
    }

    private void afterCalOperation(String operateKey) {
        CalPayRollTaskContext calPayRollTaskContext = this.getCalPayRollTaskContext();
        CalPersonOperationEnum calPersonOperationEnum = calPayRollTaskContext.getCalPersonOperationEnum();
        List validDatas = calPayRollTaskContext.getValidDatas();
        SWCPageCache swcPageCache = new SWCPageCache(this.getView());
        Map<String, String> calModeMap = this.getCalModeMap(operateKey);
        boolean resultCheck = this.getModel().getDataEntity().getBoolean("resultcheck");
        String cacheUUID = UUID.randomUUID().toString();
        RequestContext ctx = RequestContext.get();
        ThreadPools.executeOnce((String)"GET_DO_CAL_POOL", () -> {
            RequestContext.copyAndSet((RequestContext)ctx);
            logger.info("asynDoCal,traceId={}", (Object)ctx.getTraceId());
            this.asynDoCal(cacheUUID, calPersonOperationEnum, validDatas, swcPageCache, calModeMap, resultCheck, calPayRollTaskContext);
        });
        this.setCalPayRollTaskContext(calPayRollTaskContext);
        HashMap<String, Object> backData = new HashMap<String, Object>(2);
        HashMap<Long, Integer> taskPersonCountMap = new HashMap<Long, Integer>(16);
        for (CalPayRollTask validData : validDatas) {
            taskPersonCountMap.put(validData.getCalPayRollTaskId(), validData.getCalPersons().size());
        }
        backData.put("taskInfo", taskPersonCountMap);
        backData.put("cacheUUID", cacheUUID);
        if (CONFIRM_CAL.equals(operateKey)) {
            backData.put("isOneCalTaskForTax", Boolean.TRUE);
        }
        this.getView().getParentView().getPageCache().put("invokeOperation", "true");
        this.getView().returnDataToParent(backData);
        this.getView().close();
    }

    private void asynDoCal(String cacheUUID, CalPersonOperationEnum calPersonOperationEnum, List<CalPayRollTask> validDatas, SWCPageCache swcPageCache, Map<String, String> calModeMap, boolean resultCheck, CalPayRollTaskContext calPayRollTaskContext) {
        int calPersonCount = validDatas.stream().mapToInt(validData -> validData.getCalPersons().size()).sum();
        if (calPersonCount > CalConstants.SYN_CHECK_CERT_MAX_KEY && !this.asynCheckCert(validDatas, cacheUUID)) {
            for (CalPayRollTask validData2 : validDatas) {
                PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(validData2.getCalPayRollTaskId()), (String)calPersonOperationEnum.getOperationKey());
            }
            return;
        }
        String batchNum = CalRequestHelper.getBatchNum();
        ISWCAppCache calRequestCache = SWCAppCache.get((String)String.format(Locale.ROOT, "cal_request_param_%s", batchNum));
        StringBuilder errorMsg = new StringBuilder();
        HashMap<String, String> calRequestParams = new HashMap<String, String>(16);
        calRequestParams.put("cacheUUID", cacheUUID);
        calRequestParams.put("traceId", calPayRollTaskContext.getTraceId());
        calRequestCache.put("cal_param", calRequestParams);
        String resultMsg = ResManager.loadKDString((String)"\u8ba1\u7b97\u6210\u529f", (String)"CalCalPersonFormPlugin_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        ArrayList<Map> calParamList = new ArrayList<Map>(10);
        for (CalPayRollTask validData3 : validDatas) {
            try {
                logger.info("asynDoCal begin,taskId={},time={}", (Object)validData3.getCalPayRollTaskId(), (Object)System.currentTimeMillis());
                Map versionData = (Map)swcPageCache.get(String.valueOf(validData3.getCalPayRollTaskId()), Map.class);
                Map map = CalHelper.startCal((CalPayRollTask)validData3, (Map)((Map)versionData.get("formula_grade_verion")), calModeMap, (boolean)resultCheck, (String)batchNum, (String)cacheUUID);
                calParamList.add(map);
                logger.info("asynDoCal end,taskId={},time={}", (Object)validData3.getCalPayRollTaskId(), (Object)System.currentTimeMillis());
            }
            catch (Exception e) {
                PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(validData3.getCalPayRollTaskId()), (String)calPersonOperationEnum.getOperationKey());
                logger.error("startCal error", (Throwable)e);
                errorMsg.append(e.getMessage());
                resultMsg = e.getMessage();
            }
            this.addLog(this.getView().getParentView(), resultMsg);
        }
        ISWCAppCache calParamCache = SWCAppCache.get((String)String.format(Locale.ROOT, "swc_cal_param_%s", cacheUUID));
        calParamCache.put("cal_param", calParamList);
        if (errorMsg.length() > 0) {
            ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CALCHECK_ERRMSG_%s", cacheUUID));
            appCache.put("cal_param", (Object)errorMsg.toString());
        }
    }

    private void addLog(IFormView view, String msg) {
        if (view == null) {
            return;
        }
        if (!"hsas_calpersonlist".equals(view.getEntityId())) {
            return;
        }
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u8ba1\u7b97", "CalCalPersonFormPlugin_3", "swc-hsas-formplugin");
        MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u8ba1\u7b97\u6210\u529f", "CalCalPersonFormPlugin_4", "swc-hsas-formplugin");
        SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)START_CAL, (MultiLangEnumBridge)opNameBridge, null, (MultiLangEnumBridge)opDescBridge, null);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (SWCStringUtils.equals((String)event.getCallBackId(), (String)CONFIRM_NEWVERSOIN) || SWCStringUtils.equals((String)event.getCallBackId(), (String)OPENTAX_CONFIRM_NEWVERSOIN)) {
            CalPayRollTaskContext calPayRollTaskContext = this.getCalPayRollTaskContext();
            List validDatas = calPayRollTaskContext.getValidDatas();
            CalTableCalService calService = new CalTableCalService();
            SWCPageCache page = new SWCPageCache(this.getView());
            if (event.getResult().equals((Object)MessageBoxResult.Yes)) {
                for (CalPayRollTask validData : validDatas) {
                    Map versionData = (Map)page.get(String.valueOf(validData.getCalPayRollTaskId()), Map.class);
                    Map formulaAndGradeMap = (Map)versionData.get("formula_grade_cachekey");
                    if (formulaAndGradeMap == null) continue;
                    String calVersionNo = CalTableCalHelper.createCalVersion((Map)formulaAndGradeMap);
                    formulaAndGradeMap.put("calVersionNo", calVersionNo);
                    calService.cacheVersionData(versionData, formulaAndGradeMap, true);
                    page.put(String.valueOf(validData.getCalPayRollTaskId()), (Object)versionData);
                }
            } else {
                for (CalPayRollTask validData : validDatas) {
                    Map versionData = (Map)page.get(String.valueOf(validData.getCalPayRollTaskId()), Map.class);
                    Map collection = (Map)versionData.get("formula_grade_verionold");
                    if (collection == null) continue;
                    boolean exist = this.checkDataExist(collection);
                    if (exist) {
                        versionData.put("formula_grade_verion", collection);
                    } else {
                        Map formulaAndGradeMap = (Map)versionData.get("formula_grade_cachekey");
                        String calVersionNo = CalTableCalHelper.createCalVersion((Map)formulaAndGradeMap);
                        formulaAndGradeMap.put("calVersionNo", calVersionNo);
                        calService.cacheVersionData(versionData, formulaAndGradeMap, true);
                    }
                    page.put(String.valueOf(validData.getCalPayRollTaskId()), (Object)versionData);
                }
            }
        }
        OperateOption operateOption = OperateOption.create();
        if (SWCStringUtils.equals((String)event.getCallBackId(), (String)OPENTAX_CONFIRM_NEWVERSOIN)) {
            operateOption.setVariableValue(CONFIRM_CAL, "true");
            this.getView().invokeOperation(CONFIRM_CAL, operateOption);
        } else {
            operateOption.setVariableValue(START_CAL, "true");
            this.getView().invokeOperation(START_CAL, operateOption);
        }
    }

    public int initEntry(CalPayRollTaskContext calPayRollTaskContext) {
        long startTime = System.currentTimeMillis();
        CalPersonOperationEnum calPersonOperationEnum = calPayRollTaskContext.getCalPersonOperationEnum();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
        tableValueSetter.addField(CAL_PAY_ROLL_TASK_NAME, new Object[0]);
        tableValueSetter.addField(CAL_PERSON_COUNT, new Object[0]);
        tableValueSetter.addField(CAN_OPERATION_COUNT, new Object[0]);
        tableValueSetter.addField(NOT_OPERATION_COUNT, new Object[0]);
        Iterator iterator = calPayRollTaskContext.getValidDatas().iterator();
        int sumValidatorCalPersons = 0;
        while (iterator.hasNext()) {
            CalPayRollTask validData = (CalPayRollTask)iterator.next();
            Long calPayRollTaskId = validData.getCalPayRollTaskId();
            int calPersonCount = validData.getCountCalPersons();
            List calPersonIds = CalPayRollTaskCalHelper.filterCalData((Long)calPayRollTaskId, (CalPersonOperationEnum)calPersonOperationEnum, (String)validData.getOpenTaxCal());
            validData.setCalPersons(calPersonIds);
            int validatorCalPersonCount = calPersonIds.size();
            tableValueSetter.addRow(new Object[]{validData.getName(), calPersonCount, validatorCalPersonCount, calPersonCount - validatorCalPersonCount});
            if (validatorCalPersonCount == 0) {
                PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(validData.getCalPayRollTaskId()), (String)calPersonOperationEnum.getOperationKey());
                iterator.remove();
            }
            sumValidatorCalPersons += validatorCalPersonCount;
        }
        model.batchCreateNewEntryRow("entryentity", tableValueSetter);
        logger.info("\u591a\u6838\u7b97\u4efb\u52a1\u67e5\u8be2\u5e76\u521b\u5efa\u5206\u5f55\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        this.setCalPayRollTaskContext(calPayRollTaskContext);
        logger.info("\u591a\u6838\u7b97\u4efb\u52a1\u7f13\u5b58\u4e0a\u4e0b\u6587\u5bf9\u8c61\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - startTime));
        return sumValidatorCalPersons;
    }

    private boolean checkDataExist(Map<String, List<Long>> collection) {
        if (collection.size() == 0) {
            return false;
        }
        List<Long> baseIdsList = collection.get("formulaBaseIdList");
        return !CollectionUtils.isEmpty(baseIdsList);
    }

    public CalPayRollTaskContext getCalPayRollTaskContext() {
        return (CalPayRollTaskContext)SerializationUtils.fromJsonString((String)this.getView().getParentView().getPageCache().get("calPayRollTaskContext"), CalPayRollTaskContext.class);
    }

    public void setCalPayRollTaskContext(CalPayRollTaskContext calPayRollTaskContext) {
        this.getView().getParentView().getPageCache().put("calPayRollTaskContext", SerializationUtils.toJsonString((Object)calPayRollTaskContext));
    }

    protected boolean checkCert(List<CalPayRollTask> validDatas) {
        if (CollectionUtils.isEmpty(validDatas)) {
            return true;
        }
        HashSet calPersonIdSet = new HashSet(16);
        for (CalPayRollTask calTask : validDatas) {
            if (!CollectionUtils.isNotEmpty((Collection)calTask.getCalPersons())) continue;
            calPersonIdSet.addAll(calTask.getCalPersons());
        }
        if (CollectionUtils.isEmpty(calPersonIdSet)) {
            return true;
        }
        Map result = CalHelper.checkCert(new ArrayList(calPersonIdSet), validDatas);
        CalHelper.handlePrompts((Map)result, (IFormView)this.getView());
        return (Boolean)result.get("success");
    }

    private boolean asynCheckCert(List<CalPayRollTask> validDatas, String cacheUUID) {
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CALCHECK_%s", RequestContext.get().getCurrUserId()));
        Map currentResult = null;
        Integer finishCheckCertCount = 0;
        for (CalPayRollTask calPayRollTask : validDatas) {
            Map result = CalHelper.checkCert(new ArrayList(calPayRollTask.getCalPersons()), (List)Lists.newArrayList((Object[])new CalPayRollTask[]{calPayRollTask}));
            boolean success = (Boolean)result.get("success");
            String msg = (String)result.get("msg");
            String infoType = (String)result.get("infoType");
            finishCheckCertCount = finishCheckCertCount + calPayRollTask.getCalPersons().size();
            appCache.put(String.format(Locale.ROOT, "finish_check_cert_%s", cacheUUID), (Object)finishCheckCertCount);
            if (!success) {
                appCache.put(String.format(Locale.ROOT, "check_cert_fail_%s", cacheUUID), (Object)"1");
                appCache.put(String.format(Locale.ROOT, "check_cert_result_%s", cacheUUID), (Object)result);
                return false;
            }
            if (SWCStringUtils.isEmpty((String)msg)) {
                currentResult = result;
                continue;
            }
            if (currentResult == null) {
                currentResult = result;
                continue;
            }
            int compareResult = CalHelper.compareInfoLevel((String)((String)currentResult.get("infoType")), (String)infoType);
            if (compareResult < 0) {
                currentResult = result;
                continue;
            }
            if (compareResult != 0) continue;
            List currentMessageList = currentResult.getOrDefault("messageList", new ArrayList(10));
            List messageList = result.getOrDefault("messageList", new ArrayList(10));
            for (String message : messageList) {
                if (currentMessageList.contains(message)) continue;
                currentMessageList.add(message);
            }
            currentResult.put("messageList", currentMessageList);
        }
        if (currentResult == null) {
            return false;
        }
        List messageList = currentResult.getOrDefault("messageList", new ArrayList(10));
        StringBuilder sb = new StringBuilder();
        for (String message : messageList) {
            if (sb.length() > 0) {
                sb.append('\n');
            }
            sb.append(message);
        }
        currentResult.put("msg", sb.toString());
        appCache.put(String.format(Locale.ROOT, "check_cert_result_%s", cacheUUID), (Object)currentResult);
        return true;
    }
}

