/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.guide;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Html;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.swc.hsas.business.cal.vo.CalPayRollTask;
import kd.swc.hsas.business.cal.vo.CalPayRollTaskContext;
import kd.swc.hsbp.business.log.SWCOpLogServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.CalPersonOperationEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CalOperationResultPlugin
extends AbstractFormPlugin {
    private static final String CAL_PAY_ROLL_TASK_NAME = "calpayrolltaskname";
    private static final String CAL_TABLE_COUNT = "caltablecount";
    private static final String RESULT_HTML0 = "resulthtml0";
    private static final String RESULT_HTML1 = "resulthtml1";
    private static final String SUCCESS_COUNT = "successcount";
    private static final String FAIL_COUNT = "failcount";
    private static final String FAIL_HTML = "failhtml";
    private static final String CLOSE = "close";
    private static final String SHOW_APPROVAL = "showapproval";
    private static final String DONOTHING_SHOW_APPROVAL = "donothing_showapproval";
    private static final String BUTTON_AP = "buttonap";
    private static final String DONOTHING_CREAT_EAGENCY = "donothing_createagency";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        CalPayRollTaskContext calPayRollTaskContext = (CalPayRollTaskContext)SerializationUtils.fromJsonString((String)((String)this.getView().getFormShowParameter().getCustomParam("calPayRollTaskContext")), CalPayRollTaskContext.class);
        this.createEntry(calPayRollTaskContext);
        String traceId = calPayRollTaskContext.getTraceId();
        this.buildFailMessage(calPayRollTaskContext, traceId);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (SWCStringUtils.equals((String)DONOTHING_SHOW_APPROVAL, (String)operateKey)) {
            this.jumpApproveBillDetail();
        }
    }

    private void jumpApproveBillDetail() {
        IFormView parentView = this.getView().getParentView();
        IPageCache pageCache = parentView.getPageCache();
        String createApproveBillParams = pageCache.get("createApproveBillParams");
        Map operationParams = (Map)JSON.parseObject((String)createApproveBillParams, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
        if (operationParams == null) {
            return;
        }
        ISWCAppCache appCache = SWCAppCache.get((String)((String)operationParams.get("pageId")));
        CalPayRollTaskContext calPayRollTaskContext = (CalPayRollTaskContext)SerializationUtils.fromJsonString((String)((String)this.getView().getFormShowParameter().getCustomParam("calPayRollTaskContext")), CalPayRollTaskContext.class);
        List validDatas = calPayRollTaskContext.getValidDatas();
        ArrayList<Object> approveBillNos = new ArrayList<Object>(validDatas.size());
        approveBillNos.add(appCache.get((String)operationParams.get("taskId") + "approveBillNo", String.class));
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId("hsas_approvebill");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        parameter.setListFilterParameter(listFilterParameter);
        parameter.setCustomParam("defaultApproveBillNo", approveBillNos);
        parentView.showForm((FormShowParameter)parameter);
        this.getView().sendFormAction(parentView);
        this.getView().close();
        appCache.clear();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        CalPayRollTaskContext calPayRollTaskContext = (CalPayRollTaskContext)SerializationUtils.fromJsonString((String)((String)this.getView().getFormShowParameter().getCustomParam("calPayRollTaskContext")), CalPayRollTaskContext.class);
        this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)calPayRollTaskContext));
    }

    private void createEntry(CalPayRollTaskContext calPayRollTaskContext) {
        ISWCAppCache appCache = SWCAppCache.get((String)"SWC_PAYROLL_TASK");
        String traceId = calPayRollTaskContext.getTraceId();
        TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
        tableValueSetter.addField(CAL_PAY_ROLL_TASK_NAME, new Object[0]);
        tableValueSetter.addField(CAL_TABLE_COUNT, new Object[0]);
        tableValueSetter.addField(SUCCESS_COUNT, new Object[0]);
        tableValueSetter.addField(FAIL_COUNT, new Object[0]);
        List validDatas = calPayRollTaskContext.getValidDatas();
        validDatas = validDatas.stream().sorted((v1, v2) -> v2.getNumber().compareTo(v1.getNumber())).collect(Collectors.toList());
        int sumCount = 0;
        int sumSuccessCount = 0;
        int sumFailCount = 0;
        for (CalPayRollTask calPayRollTask : validDatas) {
            HashMap map = (HashMap)appCache.get("process" + traceId + calPayRollTask.getCalPayRollTaskId(), HashMap.class);
            if (map == null) continue;
            sumCount += calPayRollTask.getCountCalPersons();
            sumSuccessCount += ((Integer)map.get("successCount")).intValue();
            sumFailCount += ((Integer)map.get("failCount")).intValue();
            tableValueSetter.addRow(new Object[]{calPayRollTask.getName(), calPayRollTask.getCountCalPersons(), map.get("successCount"), map.get("failCount")});
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.batchCreateNewEntryRow("entryentity", tableValueSetter);
        CalPersonOperationEnum calPersonOperationEnum = calPayRollTaskContext.getCalPersonOperationEnum();
        this.buildResultMessage(calPayRollTaskContext, sumCount, sumSuccessCount, sumFailCount, calPersonOperationEnum);
        this.setVisible(calPersonOperationEnum, sumSuccessCount);
    }

    private void buildResultMessage(CalPayRollTaskContext calPayRollTaskContext, int sumCount, int sumSuccessCount, int sumFailCount, CalPersonOperationEnum calPersonOperationEnum) {
        String calHtml1ResultStr;
        List validDatas = calPayRollTaskContext.getValidDatas();
        int countValidDatas = validDatas.size();
        List invalidDatas = calPayRollTaskContext.getInvalidDatas();
        int countInvalidDatas = invalidDatas.size();
        Html calHtml0 = (Html)this.getControl(RESULT_HTML0);
        Html calHtml1 = (Html)this.getControl(RESULT_HTML1);
        String operationName = calPersonOperationEnum.getOperationName();
        String calHtml0Str = "";
        if (!CalPersonOperationEnum.OP_CREATEAPPROVE.equals((Object)calPersonOperationEnum)) {
            calHtml0Str = MessageFormat.format(ResManager.loadKDString((String)"{0}\u672c\u6b21{1}\u4efb\u52a1\u603b\u6570 {2} \u4e2a\uff0c\u4e0d\u7b26\u5408{3}\u6761\u4ef6\u7684 {4} \u4e2a\uff0c\u5df2\u8df3\u8fc7{5}\u3002\u5904\u7406\u8017\u65f6{6}\u3002{7}", (String)"CalOperationResultPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]), "<span style='font-size:14px;color:#666666'>", operationName, countValidDatas + countInvalidDatas, operationName, countInvalidDatas, operationName, SWCDateTimeUtils.getConsumeTime((Date)calPayRollTaskContext.getStartTime()), "</span>");
        }
        calHtml0.setConent(calHtml0Str);
        if (CalPersonOperationEnum.OP_CREATEAPPROVE == calPersonOperationEnum) {
            calHtml1ResultStr = MessageFormat.format(ResManager.loadKDString((String)"{0}\u5df2\u5904\u7406 {1} \u4e2a\u4efb\u52a1\uff0c\u5171 {2} \u6761\u6838\u7b97\u8bb0\u5f55\u3002{3} \u6761\u6838\u7b97\u8bb0\u5f55\u5df2\u6210\u529f\u751f\u6210\u5ba1\u6279\u5355\uff0c{4} \u6761\u6838\u7b97\u8bb0\u5f55\u751f\u6210\u5ba1\u6279\u5355\u5931\u8d25\u3002{5}", (String)"CalOperationResultPlugin_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]), "<span style='font-size:14px;color:#212121'>", countValidDatas, sumCount, "<span style='font-size:14px;color:#276FF5'>" + sumSuccessCount + ' ' + "</span>", "<span style='font-size:14px;color:#FB2230'>" + sumFailCount + ' ' + "</span>", "</span>");
            MultiLangEnumBridge multiLangEnumBridge = new MultiLangEnumBridge("\u5df2\u5904\u7406 {0} \u4e2a\u4efb\u52a1\uff0c\u5171 {1} \u6761\u6838\u7b97\u8bb0\u5f55\u3002{2} \u6761\u6838\u7b97\u8bb0\u5f55\u5df2\u6210\u529f\u751f\u6210\u5ba1\u6279\u5355\uff0c{3} \u6761\u6838\u7b97\u8bb0\u5f55\u751f\u6210\u5ba1\u6279\u5355\u5931\u8d25\u3002", "CalOperationResultPlugin_8", "swc-hsas-formplugin");
            SWCOpLogServiceHelper.addOpLog((IFormView)this.getView().getParentView(), (String)calPersonOperationEnum.getOperationKey(), (String)"", (MultiLangEnumBridge)multiLangEnumBridge, (String[])new String[]{String.valueOf(countValidDatas), String.valueOf(sumCount), String.valueOf(sumSuccessCount), String.valueOf(sumFailCount)});
        } else {
            calHtml1ResultStr = MessageFormat.format(ResManager.loadKDString((String)"{0}\u5df2\u5904\u7406 {1} \u4e2a\u4efb\u52a1\uff0c\u5171 {2} \u6761\u6838\u7b97\u8bb0\u5f55\u3002{3}\u6210\u529f {4} \u6761\uff0c{5}\u5931\u8d25 {6} \u6761\u3002{7}", (String)"CalOperationResultPlugin_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]), "<span style='font-size:14px;color:#212121'>", countValidDatas, sumCount, operationName, "<span style='font-size:14px;color:#276FF5'>" + sumSuccessCount + ' ' + "</span>", operationName, "<span style='font-size:14px;color:#FB2230'>" + sumFailCount + ' ' + "</span>", "</span>");
            MultiLangEnumBridge multiLangEnumBridge = new MultiLangEnumBridge("\u5df2\u5904\u7406 {0} \u4e2a\u4efb\u52a1\uff0c\u5171 {1} \u6761\u6838\u7b97\u8bb0\u5f55\u3002{3}\u6210\u529f {4} \u6761\uff0c{5}\u5931\u8d25 {6} \u6761\u3002", "CalOperationResultPlugin_7", "swc-hsas-formplugin");
            SWCOpLogServiceHelper.addOpLog((IFormView)this.getView().getParentView(), (String)calPersonOperationEnum.getOperationKey(), (String)"", (MultiLangEnumBridge)multiLangEnumBridge, (String[])new String[]{String.valueOf(countValidDatas), String.valueOf(sumCount), operationName, String.valueOf(sumSuccessCount), operationName, String.valueOf(sumFailCount)});
        }
        calHtml1.setConent(calHtml1ResultStr);
    }

    private void setVisible(CalPersonOperationEnum calPersonOperationEnum, int sumSuccessCount) {
        if (CalPersonOperationEnum.OP_CREATEPAY.equals((Object)calPersonOperationEnum)) {
            if (sumSuccessCount <= 0) {
                this.getView().setVisible(Boolean.TRUE, new String[]{BUTTON_AP});
                this.getView().setVisible(Boolean.FALSE, new String[]{CLOSE, SHOW_APPROVAL});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{CLOSE});
                this.getView().setVisible(Boolean.FALSE, new String[]{SHOW_APPROVAL, BUTTON_AP});
            }
        } else if (CalPersonOperationEnum.OP_CREATEAPPROVE.equals((Object)calPersonOperationEnum)) {
            if (sumSuccessCount <= 0) {
                this.getView().setVisible(Boolean.TRUE, new String[]{BUTTON_AP});
                this.getView().setVisible(Boolean.FALSE, new String[]{CLOSE, SHOW_APPROVAL});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{CLOSE, SHOW_APPROVAL});
                this.getView().setVisible(Boolean.FALSE, new String[]{BUTTON_AP});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{CLOSE, SHOW_APPROVAL});
        }
    }

    private void buildFailMessage(CalPayRollTaskContext calPayRollTaskContext, String traceId) {
        Set validateCauseOfFailure;
        ISWCAppCache appCache = SWCAppCache.get((String)"SWC_PAYROLL_TASK");
        HashSet errorInfoSum = new HashSet(16);
        for (CalPayRollTask validData : calPayRollTaskContext.getValidDatas()) {
            HashSet errorInfos = (HashSet)appCache.get(traceId + '_' + validData.getCalPayRollTaskId() + "opfail", HashSet.class);
            if (errorInfos == null) continue;
            errorInfoSum.addAll(errorInfos);
        }
        Html validateFailHtml = (Html)this.getControl(FAIL_HTML);
        StringBuilder desc = new StringBuilder();
        if (errorInfoSum.size() > 0) {
            String startDiv = "<div style='margin-left:15px;margin-bottom:10px;'><span style='font-size:14px'>";
            String endDiv = "</span></div>";
            desc.append(startDiv).append(ResManager.loadKDString((String)"\u5931\u8d25\u539f\u56e0\uff1a", (String)"CalOperationResultPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0])).append(endDiv);
            startDiv = "<div style='margin-left:15px;margin-bottom:10px;'><span style='font-size:14px;color:#666666'>";
            int i = 1;
            for (String errorInfo : errorInfoSum) {
                desc.append(startDiv).append(String.format(Locale.ROOT, "\uff08%s\uff09", i++)).append(errorInfo).append(endDiv);
            }
        }
        if ((validateCauseOfFailure = calPayRollTaskContext.getValidateCauseOfFailure()).size() > 0) {
            String startDiv = "<div style='margin-left:15px;margin-bottom:10px;'><span style='font-size:14px'>";
            String endDiv = "</span></div>";
            desc.append(startDiv).append(ResManager.loadKDString((String)"\u8df3\u8fc7\u539f\u56e0\uff1a", (String)"CalOperationResultPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0])).append(endDiv);
            startDiv = "<div style='margin-left:15px;margin-bottom:10px;'><span style='font-size:14px;color:#666666'>";
            int i = 1;
            for (String validateMessage : validateCauseOfFailure) {
                desc.append(startDiv).append(String.format(Locale.ROOT, "\uff08%s\uff09", i++)).append(validateMessage).append(endDiv);
            }
        }
        if (SWCStringUtils.isNotEmpty((String)desc.toString())) {
            validateFailHtml.setConent(desc.toString());
        }
    }
}

