/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.guide;

import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.form.JobFormInfo;
import kd.hr.hbp.business.bgtask.HRBackgroundTaskHelper;
import kd.swc.hsas.business.cal.helper.CalProcessHandler;
import kd.swc.hsas.business.cal.service.CalTableCalService;
import kd.swc.hsas.common.vo.CalPayRollTaskProcessVO;
import kd.swc.hsas.common.vo.CalProcessVO;
import kd.swc.hsbp.business.record.TaskRecordHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCShowFormServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CalPayRollTaskCalProcessPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final Log logger = LogFactory.getLog(CalPayRollTaskCalProcessPlugin.class);
    private static final String CANCEL_CAL = "cancelcal";
    private static final String BTN_CANCELCAL = "btn_cancelcal";
    private static final String SAVE_SUCC_COUNT = "savesucccount";
    private static final String SAVE_FAIL_COUNT = "savefailcount";
    private static final String SAVE_TODO_COUNT = "savetodocount";
    private static final String VIEW_CAL_RECORD = "donothing_viewcalrecord";
    private static final String VIEW_CAL_REQUEST = "donothing_viewcalrequestlist";
    private static final String MINIMIZE = "minimize";
    private static final String BTN_OK = "btn_ok";
    private static final String PERMITEMID = "0SWBXI04K+PJ";
    public static final String TASK_RECORD = "task_record_%s";
    public static final String CAL_INFO = "calInfo_%s";
    public static final String SAVE_PROCESS = "saveprocess";
    private static final String KEY_ONCALAP = "oncalap";
    private static final String KEY_AFTERCALAP = "aftercalap";
    private static final String KEY_SOTPREMINDAP = "sotpremindap";
    public static final String KEY_PROGRESSAP = "progressap";

    public void initialize() {
        super.initialize();
        ProgressBar saveProgressBar = (ProgressBar)this.getControl("saveprogressbarap");
        saveProgressBar.addProgressListener((ProgresssListener)this);
        logger.info("\u8ba1\u7b97\u8fdb\u5ea6\u6761\u9875\u9762\u521d\u59cb\u5316");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_OK, KEY_AFTERCALAP, KEY_SOTPREMINDAP});
        ProgressBar saveProgressBar = (ProgressBar)this.getControl("saveprogressbarap");
        saveProgressBar.start();
        CalPayRollTaskProcessVO calPayRollTaskProcessVO = this.getCalPayRollTaskProcessVO(true);
        if (calPayRollTaskProcessVO == null) {
            return;
        }
        this.setCalInfo(calPayRollTaskProcessVO);
    }

    public void onProgress(ProgressEvent evt) {
        Control control = (Control)evt.getSource();
        String progressKey = control.getKey();
        this.terminationCal();
        if (StringUtils.equals((CharSequence)progressKey, (CharSequence)"saveprogressbarap")) {
            this.queryAndSetSaveProgressDetails(evt);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (SWCStringUtils.equals((String)operate.getOperateKey(), (String)CANCEL_CAL)) {
            this.showCancelCalConfirmCallBack();
        } else if (SWCStringUtils.equals((String)operate.getOperateKey(), (String)VIEW_CAL_RECORD)) {
            Button btnRefresh;
            if (!SWCPermissionServiceHelper.hasPerm((String)"/UHMBBGZQ65X", (String)"hsas_calperson", (String)PERMITEMID)) {
                this.getView().showErrorNotification(SWCPermissionServiceHelper.getNoPermTips((String)operate.getOperateName().getLocaleValue()));
                args.setCancel(true);
                return;
            }
            this.getView().close();
            if (this.getView().getParentView() != null && (btnRefresh = (Button)this.getView().getParentView().getControl("refresh")) != null) {
                btnRefresh.click();
                this.getView().sendFormAction(this.getView().getParentView());
            }
            this.openReportList();
        } else if (SWCStringUtils.equals((String)operate.getOperateKey(), (String)VIEW_CAL_REQUEST)) {
            CalProcessHandler.openRequestList((IFormView)this.getView());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        MessageBoxResult result = event.getResult();
        String callBackId = event.getCallBackId();
        if (SWCStringUtils.equals((String)CANCEL_CAL, (String)callBackId) && MessageBoxResult.Yes.equals((Object)result)) {
            CalPayRollTaskProcessVO calPayRollTaskProcessVO = this.getCalPayRollTaskProcessVO(true);
            if (calPayRollTaskProcessVO == null) {
                return;
            }
            boolean cancelFlag = this.cancelCal(calPayRollTaskProcessVO);
            if (!cancelFlag) {
                return;
            }
            this.delTask(calPayRollTaskProcessVO);
            this.getPageCache().put("cachekey_startpropgress", "false");
            ProgressBar saveProgressBar = (ProgressBar)this.getControl("saveprogressbarap");
            saveProgressBar.stop();
            this.getView().setVisible(Boolean.FALSE, new String[]{MINIMIZE, CANCEL_CAL, KEY_ONCALAP, "viewcalrequest", "remindap", KEY_PROGRESSAP, BTN_CANCELCAL});
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_OK, KEY_SOTPREMINDAP});
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        CalPayRollTaskProcessVO calPayRollTaskProcessVO = this.getCalPayRollTaskProcessVO(true);
        if (calPayRollTaskProcessVO == null) {
            return;
        }
        this.toBackground(calPayRollTaskProcessVO);
        String rootPageId = calPayRollTaskProcessVO.getRootPageId();
        IFormView rootPageView = this.getView().getView(rootPageId);
        if (rootPageView != null) {
            rootPageView.invokeOperation("refresh");
            this.getView().sendFormAction(rootPageView);
        }
    }

    private void queryAndSetSaveProgressDetails(ProgressEvent evt) {
        IFormView view = this.getView();
        CalPayRollTaskProcessVO calPayRollTaskProcessVO = this.getCalPayRollTaskProcessVO(true);
        if (calPayRollTaskProcessVO == null) {
            return;
        }
        this.setCalInfo(calPayRollTaskProcessVO);
        CalProcessHandler calProcessHandler = CalProcessHandler.buildCalProcessHandler((String)"saveprogressbarap", (CalPayRollTaskProcessVO)calPayRollTaskProcessVO);
        int saveProgressPercent = calProcessHandler.getCalProcess();
        Label process = (Label)this.getControl(SAVE_PROCESS);
        process.setText(String.valueOf(saveProgressPercent) + '%');
        Label saveSuccessCount = (Label)this.getControl(SAVE_SUCC_COUNT);
        saveSuccessCount.setText(String.valueOf(calProcessHandler.getSuccessCount()));
        Label saveFailCount = (Label)this.getControl(SAVE_FAIL_COUNT);
        saveFailCount.setText(String.valueOf(calProcessHandler.getFailCount()));
        Label saveTodoCount = (Label)this.getControl(SAVE_TODO_COUNT);
        saveTodoCount.setText(String.valueOf(calProcessHandler.getPendingCount()));
        evt.setProgress(saveProgressPercent);
        if (saveProgressPercent > 0 && saveProgressPercent >= 100) {
            view.setVisible(Boolean.FALSE, new String[]{BTN_CANCELCAL, KEY_ONCALAP});
            this.getView().setVisible(Boolean.FALSE, new String[]{MINIMIZE, CANCEL_CAL, "viewcalrequest", "remindap"});
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_OK, KEY_AFTERCALAP});
            ProgressBar saveProgress = (ProgressBar)this.getControl("saveprogressbarap");
            saveProgress.stop();
            CalProcessHandler.changeGreenProgressColor((IFormView)this.getView(), (String)"saveprogressbarap");
            logger.info("\u4fdd\u5b58\u5b8c\u6210");
        }
        String consumerTime = SWCDateTimeUtils.getConsumeTime((Date)calProcessHandler.getStartTime());
        this.setText("consumetimelabe", ResManager.loadKDString((String)"\uff08\u8017\u65f6\uff1a{0}\uff09", (String)"CalProgressPlugin_11", (String)"swc-hsas-formplugin", (Object[])new Object[]{consumerTime}));
    }

    private void terminationCal() {
        String startProgress = this.getPageCache().get("cachekey_startpropgress");
        if (StringUtils.equals((CharSequence)"false", (CharSequence)startProgress)) {
            ProgressBar save = (ProgressBar)this.getControl("saveprogressbarap");
            save.stop();
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_CANCELCAL});
        }
    }

    private void setCalInfo(CalPayRollTaskProcessVO calPayRollTaskProcessVO) {
        int calCount = 0;
        for (CalProcessVO calProcessVO : calPayRollTaskProcessVO.getCalProcessVOs()) {
            calCount += calProcessVO.getCalCount();
        }
        this.setText("taskcount", String.format(Locale.ROOT, ResManager.loadKDString((String)"\u672c\u6b21\u6838\u7b97\u4efb\u52a1\u603b\u6570\uff1a%s\u4e2a", (String)"CalPayRollTaskCalProcessPlugin_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]), calPayRollTaskProcessVO.getCalProcessVOs().size()));
        this.setText("personcount", String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6838\u7b97\u8bb0\u5f55\u603b\u6570\uff1a%s\u6761", (String)"CalPayRollTaskCalProcessPlugin_8", (String)"swc-hsas-formplugin", (Object[])new Object[0]), calCount));
    }

    private void setText(String key, String text) {
        Label control = (Label)this.getControl(key);
        if (control != null) {
            control.setText(text);
        }
    }

    private CalPayRollTaskProcessVO getCalPayRollTaskProcessVO(boolean isFilterStop) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String customParam = (String)parameter.getCustomParam("params");
        CalPayRollTaskProcessVO calPayRollTaskProcessVO = null;
        if (SWCStringUtils.isEmpty((String)customParam)) {
            calPayRollTaskProcessVO = this.getCalPayRollTaskProcessVOFormCache(parameter);
            if (calPayRollTaskProcessVO == null) {
                return null;
            }
        } else {
            calPayRollTaskProcessVO = (CalPayRollTaskProcessVO)SerializationUtils.fromJsonString((String)customParam, CalPayRollTaskProcessVO.class);
        }
        if (calPayRollTaskProcessVO != null && isFilterStop) {
            CalProcessHandler.filterStopTask((CalPayRollTaskProcessVO)calPayRollTaskProcessVO);
        }
        return calPayRollTaskProcessVO;
    }

    private CalPayRollTaskProcessVO getCalPayRollTaskProcessVOFormCache(FormShowParameter parameter) {
        String cacheUUID = (String)parameter.getCustomParam("cacheUUID");
        String traceId = (String)parameter.getCustomParam("traceId");
        String rootPageId = (String)parameter.getCustomParam("rootPageId");
        ISWCAppCache calParamCache = SWCAppCache.get((String)String.format(Locale.ROOT, "swc_cal_param_%s", cacheUUID));
        List calParamList = (List)calParamCache.get("cal_param", List.class);
        CalPayRollTaskProcessVO calPayRollTaskProcessVO = new CalPayRollTaskProcessVO();
        calPayRollTaskProcessVO.setTraceId(traceId);
        if (calParamList == null) {
            return null;
        }
        ArrayList<CalProcessVO> calProcessVOS = new ArrayList<CalProcessVO>(calParamList.size());
        for (Map datum : calParamList) {
            CalProcessVO calProcessVO = new CalProcessVO();
            calProcessVO.setCalType((String)datum.get("calType"));
            calProcessVO.setCalCount(((Integer)datum.get("calCount")).intValue());
            calProcessVO.setCalRecordId((Long)datum.get("calRecordId"));
            calProcessVO.setCalTaskId((Long)datum.get("calTaskId"));
            calProcessVO.setCalPayRollTaskName((String)datum.get("calTaskName"));
            calProcessVOS.add(calProcessVO);
        }
        calPayRollTaskProcessVO.setCalProcessVOs(calProcessVOS);
        try {
            calPayRollTaskProcessVO.setStartTime(SWCDateTimeUtils.parseDate((String)(((Map)calParamList.get(0)).get("starttime") + "")));
        }
        catch (ParseException exception) {
            logger.error("date parse error", (Throwable)exception);
        }
        calPayRollTaskProcessVO.setRootPageId(rootPageId);
        return calPayRollTaskProcessVO;
    }

    private void showCancelCalConfirmCallBack() {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CANCEL_CAL, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMap = new HashMap<Integer, String>();
        btnNameMap.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"CalPayRollTaskCalProcessPlugin_9", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        btnNameMap.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u7ec8\u6b62", (String)"CalPayRollTaskCalProcessPlugin_10", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u672a\u8ba1\u7b97\u6210\u529f\u7684\u6838\u7b97\u8bb0\u5f55\u5c06\u7ec8\u6b62\u8ba1\u7b97\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"CalPayRollTaskCalProcessPlugin_11", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Default, confirmCallBacks, btnNameMap);
    }

    private void openReportList() {
        CalPayRollTaskProcessVO calPayRollTaskProcessVO = this.getCalPayRollTaskProcessVO(false);
        if (calPayRollTaskProcessVO == null) {
            return;
        }
        ArrayList calRecordIds = new ArrayList();
        calPayRollTaskProcessVO.getCalProcessVOs().forEach(calProcessVO -> calRecordIds.add(calProcessVO.getCalRecordId()));
        ArrayList calTaskIds = new ArrayList();
        calPayRollTaskProcessVO.getCalProcessVOs().forEach(calProcessVO -> calTaskIds.add(calProcessVO.getCalTaskId()));
        ListShowParameter show = new ListShowParameter();
        show.setBillFormId("hsas_calrecord");
        show.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        show.setCustomParam("calRecordIds", calRecordIds);
        QFilter filter = new QFilter("caltask.id", "in", calTaskIds);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(filter);
        show.setListFilterParameter(new ListFilterParameter(filters, ""));
        if (CalProcessHandler.isParentRequestList((IFormView)this.getView())) {
            CalProcessHandler.grandfatherShow((IFormView)this.getView(), (FormShowParameter)show);
            return;
        }
        if (this.getView().getView(calPayRollTaskProcessVO.getRootPageId()) != null) {
            this.getView().getParentView().showForm((FormShowParameter)show);
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    private void delTask(CalPayRollTaskProcessVO calPayRollTaskProcessVO) {
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CAL_PROCESS_%s", calPayRollTaskProcessVO.getTraceId()));
        JobFormInfo jobFormInfo = (JobFormInfo)appCache.get("platformTaskInfo_%s", JobFormInfo.class);
        if (jobFormInfo != null) {
            appCache.remove("platformTaskInfo_%s");
            TaskRecordHelper.delTask((String)jobFormInfo.getJobInfo().getTaskId(), (JobFormInfo)jobFormInfo, null);
        }
    }

    private boolean cancelCal(CalPayRollTaskProcessVO calPayRollTaskProcessVO) {
        CalTableCalService calService = new CalTableCalService();
        Map cancelResult = null;
        ArrayList<String> failList = new ArrayList<String>(10);
        StringBuilder msgKey = new StringBuilder();
        int successCount = 0;
        ArrayList<CalProcessVO> successRecordList = new ArrayList<CalProcessVO>(10);
        for (CalProcessVO calProcessVO : calPayRollTaskProcessVO.getCalProcessVOs()) {
            msgKey.setLength(0);
            Long calRecordId = calProcessVO.getCalRecordId();
            Long calTaskId = calProcessVO.getCalTaskId();
            try {
                cancelResult = calService.cancelCal(calRecordId, calTaskId);
                if (cancelResult != null && cancelResult.size() > 0) {
                    failList.add(msgKey.append(calProcessVO.getCalPayRollTaskName()).append('\uff1a').append((String)cancelResult.get("msg")).toString());
                    continue;
                }
                ++successCount;
                successRecordList.add(calProcessVO);
            }
            catch (Exception e) {
                logger.error("cancelCal error {0},\u6838\u7b97\u4efb\u52a1\u540d\u79f0\uff1a{1}", (Object)e, (Object)calProcessVO.getCalPayRollTaskName());
                failList.add(msgKey.append(calProcessVO.getCalPayRollTaskName()).append('\uff1a').append(e.getMessage()).toString());
            }
        }
        if (failList.size() == 0) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7ec8\u6b62\u8ba1\u7b97\u6210\u529f", (String)"CalPayRollTaskCalProcessPlugin_13", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return true;
        }
        this.setSuccessCancelCalProgress(successRecordList);
        if (calPayRollTaskProcessVO.getCalProcessVOs().size() == 1) {
            this.getView().showErrorNotification((String)failList.get(0));
            return false;
        }
        String operateName = ResManager.loadKDString((String)"\u64cd\u4f5c\u7ed3\u679c", (String)"CalPayRollTaskCalProcessPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        String title = MessageFormat.format(ResManager.loadKDString((String)"\u672c\u6b21\u7ec8\u6b62\u8ba1\u7b97\u64cd\u4f5c\u6210\u529f{0}\u6761\uff0c\u5931\u8d25{1}\u6761\u3002", (String)"CalPayRollTaskCalProcessPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]), successCount, failList.size());
        FormShowParameter parameters = SWCShowFormServiceHelper.getOperationResultParameter((String)operateName, (String)title, failList);
        this.getView().showForm(parameters);
        return false;
    }

    private void setSuccessCancelCalProgress(List<CalProcessVO> successRecordList) {
        ISWCAppCache calProgressAppCache = null;
        HashMap<String, Integer> calProgressMap = null;
        for (CalProcessVO process : successRecordList) {
            calProgressAppCache = SWCAppCache.get((String)String.format(Locale.ROOT, "CACHE_SWC_CAL_PROGRESS_KEY_%s", process.getCalRecordId()));
            calProgressMap = (HashMap<String, Integer>)calProgressAppCache.get(String.format(Locale.ROOT, "calrecord_progress_%s", process.getCalRecordId()), Map.class);
            if (calProgressMap == null || calProgressMap.size() == 0) {
                calProgressMap = new HashMap<String, Integer>(3);
            }
            calProgressMap.put("sucesscount", process.getCalCount());
            calProgressMap.put("failcount", 0);
            calProgressMap.put("onlyPreCalCount", 0);
            calProgressAppCache.put(String.format(Locale.ROOT, "calrecord_progress_%s", process.getCalRecordId()), calProgressMap);
        }
    }

    private void toBackground(CalPayRollTaskProcessVO calPayRollTaskProcessVO) {
        String traceId = calPayRollTaskProcessVO.getTraceId();
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CAL_PROCESS_%s", traceId));
        JobFormInfo jobFormInfo = (JobFormInfo)appCache.get("platformTaskInfo_%s", JobFormInfo.class);
        CalProcessHandler calProcessHandler = CalProcessHandler.buildCalProcessHandler((String)"saveprogressbarap", (CalPayRollTaskProcessVO)this.getCalPayRollTaskProcessVO(true));
        if (calProcessHandler.getCalProcess() < 100) {
            if (jobFormInfo == null) {
                jobFormInfo = this.dispatchTask();
            }
        } else if (jobFormInfo != null) {
            appCache.remove("platformTaskInfo_%s");
            TaskRecordHelper.delTask((String)jobFormInfo.getJobInfo().getTaskId(), (JobFormInfo)jobFormInfo, null);
        }
    }

    private JobFormInfo dispatchTask() {
        CalPayRollTaskProcessVO calPayRollTaskProcessVO = this.getCalPayRollTaskProcessVO(true);
        if (calPayRollTaskProcessVO == null) {
            return null;
        }
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CAL_PROCESS_%s", calPayRollTaskProcessVO.getTraceId()));
        Map data = this.getView().getFormShowParameter().getCustomParams();
        HashMap<String, String> params = new HashMap<String, String>(data.size());
        params.putAll(data);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        params.put("parentpageid", formShowParameter.getParentPageId());
        HRBackgroundTaskHelper instance = HRBackgroundTaskHelper.getInstance();
        if (this.getView().getMainView() == null) {
            return null;
        }
        String bgTaskId = instance.createBaskgroundTask("swc_hsas_batchcal", ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97(\u8ba1\u7b97)", (String)"CalPayRollTaskCalProcessPlugin_12", (String)"swc-hsas-formplugin", (Object[])new Object[0]), true, this.getView().getMainView().getPageId(), this.getView().getParentView().getPageId(), params);
        instance.showBaskgroundTask(bgTaskId);
        JobFormInfo jobFormInfo = instance.getJobFormInfoByTaskId(bgTaskId);
        appCache.put(String.format(Locale.ROOT, CAL_INFO, bgTaskId), params);
        appCache.put("platformTaskInfo_%s", (Object)jobFormInfo);
        return jobFormInfo;
    }
}

