/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.guide;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.swc.hsas.business.cal.helper.CalPayRollTaskCalHelper;
import kd.swc.hsas.business.cal.service.HSASAllotExrateService;
import kd.swc.hsas.business.cal.vo.CalPayRollTask;
import kd.swc.hsas.business.cal.vo.CalPayRollTaskContext;
import kd.swc.hsas.business.cost.helper.CostAllotHelper;
import kd.swc.hsas.business.payrollscene.service.SWCPayRollSceneService;
import kd.swc.hsas.formplugin.web.guide.AbstractCalPayRollTaskList;
import kd.swc.hsbp.business.cal.helper.PayrollTaskHelper;
import kd.swc.hsbp.business.exchangerate.ExchangeRateInfo;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.CalPayrollTaskStateEnum;
import kd.swc.hsbp.common.enums.CalPersonOperationEnum;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CalPayRollTaskCostAllotList
extends AbstractCalPayRollTaskList {
    private static final Log logger = LogFactory.getLog(CalPayRollTaskCostAllotList.class);
    private static final String SWC_HSAS_FORMPLUGIN = "swc-hsas-formplugin";

    @Override
    protected List<CalPersonOperationEnum> operationKey() {
        ArrayList<CalPersonOperationEnum> calPersonOperationEnums = new ArrayList<CalPersonOperationEnum>();
        calPersonOperationEnums.add(CalPersonOperationEnum.OP_CREATCOSTEALLOT);
        calPersonOperationEnums.add(CalPersonOperationEnum.OP_VIEWCOSTALLOTDETAIL);
        calPersonOperationEnums.add(CalPersonOperationEnum.OP_VIEWFEEDBACK);
        calPersonOperationEnums.add(CalPersonOperationEnum.OP_DELCOSTALLOT);
        return calPersonOperationEnums;
    }

    @Override
    protected boolean operationMutex() {
        return false;
    }

    @Override
    protected void execute() {
        switch (this.calPersonOperationEnum) {
            case OP_CREATCOSTEALLOT: {
                this.doOperation();
                break;
            }
            case OP_VIEWCOSTALLOTDETAIL: {
                this.openAllotDetailList();
                break;
            }
            case OP_VIEWFEEDBACK: {
                this.openFeedbackList();
                break;
            }
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        this.calPersonOperationEnum = CalPersonOperationEnum.getCalOperationEnum((String)operateKey);
        if (this.calPersonOperationEnum == null) {
            return;
        }
        if (this.operationKey().contains(this.calPersonOperationEnum)) {
            boolean isDel;
            if (!this.hasPerm(this.calPersonOperationEnum)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u6838\u7b97\u540d\u5355\u201d\u7684\u201c{0}\u201d\u6743\u9650\u3002", (String)"AbstractCalPayRollTaskList_16", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[]{this.calPersonOperationEnum.getOperationName()}));
                args.setCancel(true);
                return;
            }
            OperateOption operateOption = formOperate.getOption();
            if (this.calPayRollTaskContext == null) {
                if (operateOption.tryGetVariableValue("CallBackInvoke", new RefObject())) {
                    this.calPayRollTaskContext = (CalPayRollTaskContext)SerializationUtils.fromJsonString((String)this.getView().getPageCache().get("calPayRollTaskContext"), CalPayRollTaskContext.class);
                } else {
                    ListSelectedRowCollection listSelectedData = ((ListView)this.getView()).getSelectedRows();
                    if (this.singleCalPayRollTaskValidator(listSelectedData)) {
                        args.setCancel(true);
                        return;
                    }
                    if (this.isSelectData() && listSelectedData.size() <= 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"AbstractCalPayRollTaskList_8", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    Map selectCalPayRollTaskMap = CalPayRollTaskCalHelper.groupCalPayRollTask((ListSelectedRowCollection)listSelectedData);
                    this.initCalPayRollTaskContext(selectCalPayRollTaskMap);
                    if (this.isSelectData() && this.calPayRollTaskContext.getValidDatas().size() <= 0) {
                        this.cancelOperation(args);
                        this.getView().getPageCache().remove("calPayRollTaskContext");
                        return;
                    }
                }
            }
            ArrayList<CalPayRollTask> confirmDatas = new ArrayList<CalPayRollTask>(10);
            if (!formOperate.getOption().tryGetVariableValue("CallBackInvoke", new RefObject())) {
                this.doValidate(args, confirmDatas);
            }
            if (this.isSelectData() && this.calPayRollTaskContext.getValidDatas().size() <= 0) {
                this.cancelOperation(args);
                this.getView().getPageCache().remove("calPayRollTaskContext");
                return;
            }
            ISWCAppCache iswcAppCache = SWCAppCache.get((String)"CalPayRollTaskOperationTest");
            iswcAppCache.put("calPayRollTaskContext", (Object)SerializationUtils.toJsonString((Object)this.calPayRollTaskContext));
            iswcAppCache.put("pageId", (Object)this.getView().getPageId());
            this.calPayRollTaskContext.setStartTime(new Date());
            this.getView().getPageCache().put("calPayRollTaskContext", SerializationUtils.toJsonString((Object)this.calPayRollTaskContext));
            if (confirmDatas.size() > 0) {
                if (SWCStringUtils.equals((String)"donothing_createcostallot", (String)operateKey)) {
                    this.showSetupIsChangedTipDialog(confirmDatas);
                }
                return;
            }
            boolean bl = isDel = CalPersonOperationEnum.OP_DELCOSTALLOT == this.calPersonOperationEnum;
            if (!(isDel || this.isSelectData() && this.calPayRollTaskContext.getValidDatas().size() <= 0 || args.cancel)) {
                this.execute();
                args.setCancel(true);
            }
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args, CalPayRollTask calPayRollTask) {
        FormOperate formOperate = (FormOperate)args.getSource();
        Long taskId = calPayRollTask.getCalPayRollTaskId();
        if (taskId != null && taskId > 0L) {
            switch (this.calPersonOperationEnum) {
                case OP_CREATCOSTEALLOT: 
                case OP_VIEWCOSTALLOTDETAIL: 
                case OP_VIEWFEEDBACK: 
                case OP_DELCOSTALLOT: {
                    boolean costallot;
                    SWCPayRollSceneService sceneService = SWCPayRollSceneService.createInstance();
                    DynamicObject schemeAfterCalObj = sceneService.getAfterCalObjByTask(taskId);
                    if (schemeAfterCalObj == null || (costallot = schemeAfterCalObj.getBoolean("costallot"))) break;
                    calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
                    calPayRollTask.setCalPayRollTaskValidatorErrorMsg(ResManager.loadKDString((String)"\u8be5\u6838\u7b97\u4efb\u52a1\u7684\u6838\u7b97\u540e\u5904\u7406\u65b9\u6848{0}\u4e2d\u672a\u542f\u7528\u6210\u672c\u5206\u644a\u4e1a\u52a1\u3002", (String)"CalPayRollTaskCostAllotList_17", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[]{schemeAfterCalObj.getString("number")}));
                    return;
                }
            }
        }
        switch (this.calPersonOperationEnum) {
            case OP_CREATCOSTEALLOT: {
                this.validateAndSetData2Cache(formOperate, calPayRollTask);
                break;
            }
            case OP_VIEWCOSTALLOTDETAIL: {
                this.validateProduceAllot(calPayRollTask);
                break;
            }
        }
    }

    private void validateProduceAllot(CalPayRollTask calPayRollTask) {
        DynamicObject[] calPersonArr = this.queryCalPersonsAndSetCalPersonIdsToCost("id,salaryfile,allotstatus", calPayRollTask);
        boolean flag = true;
        for (DynamicObject calTable : calPersonArr) {
            String allotStatus = calTable.getString("allotstatus");
            if (!SWCStringUtils.equals((String)"B", (String)allotStatus)) continue;
            flag = false;
            break;
        }
        if (flag) {
            calPayRollTask.setCalPayRollTaskValidatorErrorMsg(ResManager.loadKDString((String)"{0}\uff1a\u6838\u7b97\u4efb\u52a1\u672a\u751f\u6210\u5206\u644a\u660e\u7ec6\uff0c\u65e0\u5bf9\u5e94\u53ef\u67e5\u8be2\u6570\u636e\u3002", (String)"CalPayRollTaskCostAllotList_6", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[]{calPayRollTask.getNumber()}));
            calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
        }
    }

    @Override
    protected void invokeOperation() {
        switch (this.calPersonOperationEnum) {
            case OP_CREATCOSTEALLOT: {
                SWCThreadPoolFactory.getPayrolltaskOpThreadpool().execute(() -> {
                    String batchId = this.calPayRollTaskContext.getTraceId();
                    for (CalPayRollTask validData : this.calPayRollTaskContext.getValidDatas()) {
                        Long calPayRollTaskId = validData.getCalPayRollTaskId();
                        SWCMServiceUtils.invokeSWCService((String)"hscs", (String)"IHSCSCostAllotDetailService", (String)"generateAllotDetail", (Object[])new Object[]{calPayRollTaskId, null, null, "1", Collections.EMPTY_LIST, batchId});
                    }
                });
                break;
            }
            default: {
                this.doInvokeOperation();
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        Object returnData = event.getReturnData();
        String actionId = event.getActionId();
        if (returnData == null) {
            return;
        }
        switch (actionId) {
            case "pcs_allotoperationresult": {
                if (!(returnData instanceof Map)) break;
                Map map = (Map)returnData;
                String radiogroupfield = (String)map.get("radiogroupfield");
                if (SWCStringUtils.equals((String)"1", (String)radiogroupfield)) {
                    ListShowParameter showParameter = new ListShowParameter();
                    showParameter.setBillFormId("pcs_costallocation");
                    showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    this.getView().showForm((FormShowParameter)showParameter);
                    return;
                }
                this.calPersonOperationEnum = CalPersonOperationEnum.OP_CREATCOSTEALLOT;
                this.calPayRollTaskContext = (CalPayRollTaskContext)SerializationUtils.fromJsonString((String)this.getView().getPageCache().get("calPayRollTaskContext"), CalPayRollTaskContext.class);
                List validDatas = this.calPayRollTaskContext.getValidDatas();
                for (CalPayRollTask calPayRollTask : validDatas) {
                    OperateOption option = OperateOption.create();
                    this.setOptionVariables(option);
                    calPayRollTask.setOperationParam(option.getVariables());
                }
                this.doOperation();
                return;
            }
        }
        this.releaseDistributedLock();
    }

    private boolean validateAndSetData2Cache(FormOperate formOperate, CalPayRollTask calPayRollTask) {
        if (formOperate.getOption().tryGetVariableValue("CallBackInvoke", new RefObject())) {
            return true;
        }
        Long calTaskId = calPayRollTask.getCalPayRollTaskId();
        DynamicObject costAdapterObj = CostAllotHelper.queryCostAdapterIdByCalTaskId((Long)calTaskId);
        if (costAdapterObj != null) {
            String costAdapterId = costAdapterObj.getString("id");
            String amtPrecision = costAdapterObj.getString("currency.amtprecision");
            String costAdapterCurrencyId = costAdapterObj.getString("currency.id");
            String costAdapterCurrencyName = costAdapterObj.getString("currency.name");
            String costStruId = costAdapterObj.getString("coststru.id");
            this.getView().getPageCache().put("calTaskId", calTaskId.toString());
            this.getView().getPageCache().put("amtPrecision", amtPrecision);
            this.getView().getPageCache().put("costAdapterId", costAdapterId);
            this.getView().getPageCache().put("costAdapterCurrencyId", costAdapterCurrencyId);
            this.getView().getPageCache().put("costAdapterCurrencyName", costAdapterCurrencyName);
            this.getView().getPageCache().put("costStruId", costStruId);
        }
        if (!this.validate(calPayRollTask)) {
            return false;
        }
        String pageId = this.getView().getPageId();
        ISWCAppCache iswcAppCache = SWCAppCache.get((String)pageId);
        HashSet<String> cacheTaskList = (HashSet<String>)iswcAppCache.get("createallottask", Set.class);
        if (cacheTaskList == null) {
            cacheTaskList = new HashSet<String>(16);
        }
        cacheTaskList.add(String.valueOf(calPayRollTask.getCalPayRollTaskId()));
        iswcAppCache.put("createallottask", cacheTaskList);
        this.setOptionVariables(formOperate.getOption());
        return true;
    }

    private OperateOption setOptionVariables(OperateOption option) {
        String costAdapterId = this.getView().getPageCache().get("costAdapterId");
        String calTaskId = this.getView().getPageCache().get("calTaskId");
        String amtPrecision = this.getView().getPageCache().get("amtPrecision");
        String costAdapterCurrencyId = this.getView().getPageCache().get("costAdapterCurrencyId");
        String costStruId = this.getView().getPageCache().get("costStruId");
        option.setVariableValue("pageId", this.getView().getPageId());
        option.setVariableValue("taskId", calTaskId);
        option.setVariableValue("costAdapterCurrencyId", costAdapterCurrencyId);
        option.setVariableValue("amtPrecision", amtPrecision);
        option.setVariableValue("costStruId", costStruId);
        option.setVariableValue("costAdapterId", costAdapterId);
        option.setVariableValue("isConfirm", Boolean.TRUE.toString());
        return option;
    }

    private boolean validate(CalPayRollTask calPayRollTask) {
        return this.validateGenerateAllotPerm(calPayRollTask.getCalPayRollTaskId()) && CostAllotHelper.validateCert((CalPayRollTask)calPayRollTask) && this.validateCalTaskStatus(calPayRollTask) && this.validateAdapter(calPayRollTask) && this.validateSalaryItemIsAllot(calPayRollTask) && this.validateIsExistRate(calPayRollTask) && this.validateCalPersonStatus(calPayRollTask) && this.validateCalTaskCostSetup(calPayRollTask) && this.validateCostTaskStatus(calPayRollTask) && this.validateIsLatest(calPayRollTask);
    }

    private boolean validateGenerateAllotPerm(long calTaskId) {
        long userId = RequestContext.get().getCurrUserId();
        boolean hasPerm = SWCPermissionServiceHelper.hasPerm((long)userId, (String)"1ANC8T4UC434", (String)"pcs_allottask", (String)"0=KX5+RE6N4W");
        if (!hasPerm) {
            logger.info("generatecostdetail no perm");
            return false;
        }
        DynamicObject calTaskDy = CostAllotHelper.queryCalPalRollTaskObj((Long)calTaskId);
        long orgId = calTaskDy.getLong("org.id");
        long payrollGroupId = calTaskDy.getLong("payrollgroup.id");
        Set payRollCalSet = SWCPermissionServiceHelper.getPayrollCalSetByPermItem((String)"1ANC8T4UC434", (String)"pcs_allotdetail", (String)"47150e89000000ac");
        Set payrollGroupIdSet = SWCPermissionServiceHelper.getPayrollGrpSetByPermItem((String)"1ANC8T4UC434", (String)"pcs_allotdetail", (String)"47150e89000000ac");
        if (payRollCalSet != null && !payRollCalSet.contains(orgId) || payrollGroupIdSet != null && !payrollGroupIdSet.contains(payrollGroupId)) {
            logger.info("dimvalueresult no perm");
            return false;
        }
        return true;
    }

    private boolean validateIsExistRate(CalPayRollTask calPayRollTask) {
        long calTaskId = calPayRollTask.getCalPayRollTaskId();
        String costAdapterCurrencyId = this.getView().getPageCache().get("costAdapterCurrencyId");
        String costAdapterCurrencyName = this.getView().getPageCache().get("costAdapterCurrencyName");
        DynamicObject calTaskInfo = this.getCalTaskInfo(calTaskId, "payrollgroupv,exratedate");
        long exrateTableId = calTaskInfo.getLong("payrollgroupv.exratetable.id");
        String exrateTableName = calTaskInfo.getString("payrollgroupv.exratetable.name");
        long calCurrencyId = calTaskInfo.getLong("payrollgroupv.currency.id");
        String calCurrencyName = calTaskInfo.getString("payrollgroupv.currency.name");
        Date exrateDate = calTaskInfo.getDate("exratedate");
        String exrateDateStr = HRInteDateTimeUtil.formatDate((String)"hsas_calpayrolltask", (String)"exratedate", (Date)exrateDate);
        HSASAllotExrateService allotExrateService = new HSASAllotExrateService();
        ExchangeRateInfo calCurrency2CostCurrencyRate = allotExrateService.getExrate(Long.valueOf(calCurrencyId), Long.valueOf(costAdapterCurrencyId), exrateDate, Long.valueOf(exrateTableId));
        if (calCurrency2CostCurrencyRate == null) {
            String errorTip = ResManager.loadKDString((String)"\u201c{0}\u201d\u6c47\u7387\u8868\u4e2d\uff0c\u672a\u627e\u5230{1}\u65e5\u671f\u7684\u201c{2}\u201d\u5151\u201c{3}\u201d\u7684\u6c47\u7387\u3002", (String)"CalPersonCostAllotList_3", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[]{exrateTableName, exrateDateStr, calCurrencyName, costAdapterCurrencyName});
            calPayRollTask.setCalPayRollTaskValidatorErrorMsg(errorTip);
            calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
            return false;
        }
        ExchangeRateInfo costCurrency2CalCurrencyRate = allotExrateService.getExrate(Long.valueOf(costAdapterCurrencyId), Long.valueOf(calCurrencyId), exrateDate, Long.valueOf(exrateTableId));
        if (costCurrency2CalCurrencyRate == null) {
            String errorTip = ResManager.loadKDString((String)"\u201c{0}\u201d\u6c47\u7387\u8868\u4e2d\uff0c\u672a\u627e\u5230{1}\u65e5\u671f\u7684\u201c{2}\u201d\u5151\u201c{3}\u201d\u7684\u6c47\u7387\u3002", (String)"CalPersonCostAllotList_3", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[]{exrateTableName, exrateDateStr, costAdapterCurrencyName, calCurrencyName});
            calPayRollTask.setCalPayRollTaskValidatorErrorMsg(errorTip);
            calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
            return false;
        }
        return true;
    }

    private boolean validateCalTaskStatus(CalPayRollTask calPayRollTask) {
        if (!this.checkCalTaskStatus(calPayRollTask.getPayRollTaskStatus())) {
            calPayRollTask.setCalPayRollTaskValidatorErrorMsg(ResManager.loadKDString((String)"{0}\uff1a\u6838\u7b97\u4efb\u52a1\u672a\u5ba1\u6838\uff0c\u65e0\u6cd5\u751f\u6210\u5206\u644a\u660e\u7ec6\u3002", (String)"CalPayRollTaskCostAllotList_4", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[]{calPayRollTask.getNumber()}));
            calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
            return false;
        }
        return true;
    }

    private boolean validateAdapter(CalPayRollTask calPayRollTask) {
        Long calTaskId = calPayRollTask.getCalPayRollTaskId();
        DynamicObject costAdapterObj = CostAllotHelper.queryCostAdapterIdByCalTaskId((Long)calTaskId);
        if (costAdapterObj == null) {
            calPayRollTask.setCalPayRollTaskValidatorErrorMsg(ResManager.loadKDString((String)"{0}\uff1a\u6838\u7b97\u4efb\u52a1\u6240\u5c5e\u85aa\u8d44\u6838\u7b97\u7ec4\u6ca1\u6709\u5bf9\u5e94\u7684\u4eba\u529b\u6210\u672c\u7ef4\u5ea6\u65b9\u6848\u3002", (String)"CalPayRollTaskCostAllotList_3", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[]{calPayRollTask.getNumber()}));
            calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
            return false;
        }
        return true;
    }

    private boolean validateCalPersonStatus(CalPayRollTask calPayRollTask) {
        int permCount;
        Long calPayRollTaskId = calPayRollTask.getCalPayRollTaskId();
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        QFilter calPersonFilter = new QFilter("caltask", "=", (Object)calPayRollTaskId);
        long currUserId = RequestContext.get().getCurrUserId();
        QFilter salaryFileFilter = SWCPermissionServiceHelper.getDataRuleForBdProp((long)currUserId, (String)"1ANC8T4UC434", (String)"pcs_allotdetail", (String)"salaryfile", (String)"47150e89000000ac");
        if (salaryFileFilter != null) {
            calPersonFilter.and(salaryFileFilter);
        }
        if ((permCount = helper.count(new QFilter[]{calPersonFilter})) == 0) {
            calPayRollTask.setCalPayRollTaskValidatorErrorMsg(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u4efb\u52a1\u4e0b\u6ca1\u6709\u7b26\u5408\u751f\u6210\u5206\u644a\u660e\u7ec6\u7684\u85aa\u8d44\u6863\u6848\u3002", (String)"CalPayRollTaskCostAllotList_15", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[]{calPayRollTask.getNumber()}));
            calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
            return false;
        }
        DynamicObject[] calPersonArr = this.queryCalPersonsAndSetCalPersonIdsToCost("id,salaryfile,allotstatus", calPayRollTask);
        ArrayList<Long> salaryfileIdList = new ArrayList<Long>(calPersonArr.length);
        for (DynamicObject calTable : calPersonArr) {
            long salaryfileId = calTable.getLong("salaryfile.id");
            String allotStatus = calTable.getString("allotstatus");
            if (SWCStringUtils.equals((String)"B", (String)allotStatus)) continue;
            salaryfileIdList.add(salaryfileId);
        }
        if (salaryfileIdList.size() == 0) {
            calPayRollTask.setCalPayRollTaskValidatorErrorMsg(ResManager.loadKDString((String)"{0}\uff1a\u53ea\u6709\u5df2\u5ba1\u6838\u4e14\u5206\u644a\u72b6\u6001\u4e0d\u4e3a\u5df2\u751f\u6210\u7684\u6838\u7b97\u8bb0\u5f55\uff0c\u624d\u80fd\u751f\u6210\u5206\u644a\u660e\u7ec6\u3002", (String)"CalPayRollTaskCostAllotList_5", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[]{calPayRollTask.getNumber()}));
            calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
            return false;
        }
        return true;
    }

    private boolean validateAllotBillStatus(CalPayRollTask calPayRollTask) {
        Set allotBillStatusSet;
        DynamicObject[] dynamicObjects = CalPayRollTaskCostAllotList.queryCostAllotByCalTask("allotbillstatus", calPayRollTask.getCalPayRollTaskId());
        if (dynamicObjects != null && dynamicObjects.length > 0 && (allotBillStatusSet = Arrays.stream(dynamicObjects).map(param -> param.getString("allotbillstatus")).collect(Collectors.toSet())).contains("B")) {
            calPayRollTask.setCalPayRollTaskValidatorErrorMsg(ResManager.loadKDString((String)"\u5206\u644a\u660e\u7ec6\u5df2\u751f\u6210\u5206\u914d\u5355\uff0c\u65e0\u6cd5\u91cd\u590d\u751f\u6210\u3002", (String)"CalPayRollTaskCostAllotList_14", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[]{calPayRollTask.getNumber()}));
            calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
            return false;
        }
        return true;
    }

    private boolean validateCalTaskCostSetup(CalPayRollTask calPayRollTask) {
        Long calTaskId = calPayRollTask.getCalPayRollTaskId();
        boolean isOwnCostSetUp = CostAllotHelper.isOwnCostSetUp((Long)calTaskId);
        if (!isOwnCostSetUp) {
            calPayRollTask.setCalPayRollTaskValidatorErrorMsg(ResManager.loadKDString((String)"{0}\uff1a\u5f53\u524d\u6838\u7b97\u4efb\u52a1\u65e0\u5bf9\u5e94\u7684\u6210\u672c\u5206\u644a\u7ed3\u6784\uff0c\u8bf7\u751f\u6210\u6210\u672c\u5206\u644a\u7ed3\u6784\u540e\u91cd\u8bd5\u3002", (String)"CalPayRollTaskCostAllotList_7", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[]{calPayRollTask.getNumber()}));
            calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
            return false;
        }
        boolean flag = CostAllotHelper.isOwnErrorCostSetUp((Long)calTaskId);
        if (flag) {
            calPayRollTask.setCalPayRollTaskValidatorErrorMsg(ResManager.loadKDString((String)"{0}\uff1a\u5f53\u524d\u6838\u7b97\u4efb\u52a1\u5bf9\u5e94\u7684\u5206\u644a\u7ed3\u6784\u8ba1\u7b97\u4efb\u52a1\u5b58\u5728\u65e0\u6548\u6210\u672c\u5206\u644a\u7ed3\u6784\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"CalPayRollTaskCostAllotList_8", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[]{calPayRollTask.getNumber()}));
            calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
            return false;
        }
        return true;
    }

    private boolean validateCostTaskStatus(CalPayRollTask calPayRollTask) {
        Long calTaskId = calPayRollTask.getCalPayRollTaskId();
        DynamicObject costAllotObj = CostAllotHelper.queryCostAllotByCalTaskId((Long)calTaskId);
        if (costAllotObj != null && "2".equals(costAllotObj.getString("costtaskstatus"))) {
            calPayRollTask.setCalPayRollTaskValidatorErrorMsg(ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1{0}\u6b63\u5728\u8ba1\u7b97\u4e2d\u3002", (String)"CalPayRollTaskCostAllotList_16", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[]{calPayRollTask.getName()}));
            calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
            return false;
        }
        return true;
    }

    public static DynamicObject[] queryCostAllotByCalTask(String selectProperties, Long calTaskId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("pcs_allotdetail");
        return helper.query(selectProperties, new QFilter[]{new QFilter("caltask", "=", (Object)calTaskId)});
    }

    private boolean checkCalTaskStatus(String payRollTaskStatus) {
        return SWCStringUtils.equals((String)CalPayrollTaskStateEnum.AUDIT.getCode(), (String)payRollTaskStatus) || SWCStringUtils.equals((String)CalPayrollTaskStateEnum.APPROVALEDING.getCode(), (String)payRollTaskStatus) || SWCStringUtils.equals((String)CalPayrollTaskStateEnum.APPROVALED.getCode(), (String)payRollTaskStatus) || SWCStringUtils.equals((String)CalPayrollTaskStateEnum.APPROVALED_NOT_PASS.getCode(), (String)payRollTaskStatus);
    }

    private boolean validateSalaryItemIsAllot(CalPayRollTask calPayRollTask) {
        Long calTaskId = calPayRollTask.getCalPayRollTaskId();
        Map salaryItemIdListByCalTaskId = CostAllotHelper.getSalaryItemIdListByCalTaskId((Long)calTaskId);
        boolean isEmpty = salaryItemIdListByCalTaskId.isEmpty();
        if (isEmpty) {
            calPayRollTask.setCalPayRollTaskValidatorErrorMsg(ResManager.loadKDString((String)"{0}\uff1a\u8ba1\u7b97\u89c4\u5219\u4e2d\u65e0\u53c2\u4e0e\u6210\u672c\u5206\u644a\u7684\u85aa\u916c\u9879\u76ee\uff0c\u65e0\u6cd5\u751f\u6210\u5206\u644a\u660e\u7ec6\u3002", (String)"CalPayRollTaskCostAllotList_9", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[]{calPayRollTask.getNumber()}));
            calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
            return false;
        }
        return true;
    }

    private boolean validateIsLatest(CalPayRollTask calPayRollTask) {
        Long calTaskId = calPayRollTask.getCalPayRollTaskId();
        Date costAllocationModifyDate = CostAllotHelper.queryCostAllocationModifyDate((Long)calTaskId);
        String costAdapterId = this.getView().getPageCache().get("costAdapterId");
        boolean isLaterThanCostAllocationModifyDate = CostAllotHelper.costCfgModifyTimeIsLaterThanCostAllocationModifyDate((Long)Long.valueOf(costAdapterId), (Date)costAllocationModifyDate);
        boolean flag = CostAllotHelper.existCreatedAllotDetailByTaskId((Long)calPayRollTask.getCalPayRollTaskId());
        if (!flag & isLaterThanCostAllocationModifyDate) {
            calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Confirm);
        }
        return true;
    }

    private void openAllotDetailList() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setPageId(this.getView().getPageId() + "pcs_allotdetail");
        showParameter.setBillFormId("pcs_allotdetail");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        if (!CollectionUtils.isEmpty((Collection)selectedRows)) {
            ArrayList<String> taskNameList = new ArrayList<String>(10);
            List validDatas = this.calPayRollTaskContext.getValidDatas();
            block0: for (CalPayRollTask calPayRollTask : validDatas) {
                DynamicObject[] calPersonArr;
                for (DynamicObject calTable : calPersonArr = this.queryCalPersonsAndSetCalPersonIdsToCost("id,salaryfile,allotstatus", calPayRollTask)) {
                    String allotStatus = calTable.getString("allotstatus");
                    if (!SWCStringUtils.equals((String)"B", (String)allotStatus)) continue;
                    taskNameList.add(calPayRollTask.getName());
                    continue block0;
                }
            }
            showParameter.setCustomParam("caltaskName", taskNameList);
        }
        showParameter.setCustomParam("allotbillStatus", (Object)"allotbill");
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void openFeedbackList() {
        ListShowParameter show = new ListShowParameter();
        show.setPageId(this.getView().getPageId() + "pcs_allotfeedback");
        show.setBillFormId("pcs_allotfeedback");
        show.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)show);
    }

    private void showSetupIsChangedTipDialog(List<CalPayRollTask> confirmDatas) {
        Set changeCalTaskList = confirmDatas.stream().map(CalPayRollTask::getName).collect(Collectors.toSet());
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setShowTitle(false);
        parameter.setCustomParam("costcaltask", changeCalTaskList);
        parameter.setFormId("pcs_allotoperationresult");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pcs_allotoperationresult"));
        this.getView().showForm(parameter);
    }

    private void doValidate(BeforeDoOperationEventArgs args, List<CalPayRollTask> confirmDatas) {
        List validDatas = this.calPayRollTaskContext.getValidDatas();
        Iterator<CalPayRollTask> iterator = validDatas.iterator();
        List invalidDatas = this.calPayRollTaskContext.getInvalidDatas();
        while (iterator.hasNext()) {
            CalPayRollTask calPayRollTask = (CalPayRollTask)iterator.next();
            try {
                this.beforeDoOperation(args, calPayRollTask);
            }
            catch (Exception exception) {
                logger.error("\u6838\u7b97\u4efb\u52a1\u6279\u91cf\u64cd\u4f5c\u4e1a\u52a1\u6821\u9a8c\u5f02\u5e38", (Throwable)exception);
                calPayRollTask.setCalPayRollTaskValidatorErrorMsg(exception.getMessage());
                iterator.remove();
                invalidDatas.add(calPayRollTask);
                this.calPayRollTaskContext.getValidateCauseOfFailure().add(exception.getMessage());
                PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(calPayRollTask.getCalPayRollTaskId()), (String)this.calPersonOperationEnum.getOperationKey());
                continue;
            }
            this.afterDoValidator(args, confirmDatas, iterator, invalidDatas, calPayRollTask);
        }
    }

    private void afterDoValidator(BeforeDoOperationEventArgs args, List<CalPayRollTask> confirmDatas, Iterator<CalPayRollTask> iterator, List<CalPayRollTask> invalidDatas, CalPayRollTask calPayRollTask) {
        if (calPayRollTask.getCancelEnum() == CalPayRollTask.CancelEnum.Cancel) {
            iterator.remove();
            invalidDatas.add(calPayRollTask);
            this.calPayRollTaskContext.getValidateCauseOfFailure().add(calPayRollTask.getCalPayRollTaskValidatorErrorMsg());
            PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(calPayRollTask.getCalPayRollTaskId()), (String)this.calPersonOperationEnum.getOperationKey());
        } else if (calPayRollTask.getCancelEnum() == CalPayRollTask.CancelEnum.Confirm) {
            calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.OK);
            confirmDatas.add(calPayRollTask);
        } else {
            OperateOption option = ((FormOperate)args.getSource()).getOption();
            option.getVariables().forEach((key, value) -> calPayRollTask.getOperationParam().put(key, value));
            option.getVariables().forEach((key, value) -> option.removeVariable(key));
        }
    }
}

