/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.guide;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.hr.hbp.business.bgtask.HRBackgroundTaskHelper;
import kd.swc.hsas.business.cal.service.calperson.DefaultProcessHandler;
import kd.swc.hsas.business.cal.vo.CalPayRollTask;
import kd.swc.hsas.business.cal.vo.CalPayRollTaskContext;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CalPayRollTaskProcessPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final String PROGRESSBAR_AP = "progressbarap";
    private static final String PAY_ROLL_TASK_COUNT = "payrolltaskcount";
    private static final String CAL_PERSON_COUNT = "calpersoncount";
    private static final String SUCCESS_COUNT = "successcount";
    private static final String FAIL_COUNT = "failcount";
    private static final String TODO_COUNT = "todocount";
    private static final String FINISH = "finish";
    private static final String CONSUME_TIME = "consumetime";
    private static final String PROCESS = "process";

    public void initialize() {
        super.initialize();
        ProgressBar progressBar = (ProgressBar)this.getControl(PROGRESSBAR_AP);
        progressBar.addProgressListener((ProgresssListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{FINISH});
        ProgressBar progressBar = (ProgressBar)this.getControl(PROGRESSBAR_AP);
        progressBar.start();
        Label calTableCountLabel = (Label)this.getControl(CAL_PERSON_COUNT);
        Label payRollTaskCountLabel = (Label)this.getControl(PAY_ROLL_TASK_COUNT);
        int calTableCount = 0;
        int payRollTaskCount = 0;
        CalPayRollTaskContext calPayRollTaskContext = this.getCalPayRollTaskContext();
        for (CalPayRollTask calPayRollTask : calPayRollTaskContext.getValidDatas()) {
            ++payRollTaskCount;
            calTableCount += calPayRollTask.getCountCalPersons();
        }
        for (CalPayRollTask calPayRollTask : calPayRollTaskContext.getInvalidDatas()) {
            ++payRollTaskCount;
            calTableCount += calPayRollTask.getCountCalPersons();
        }
        calTableCountLabel.setText(String.valueOf(calTableCount));
        payRollTaskCountLabel.setText(String.valueOf(payRollTaskCount));
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        CalPayRollTaskContext calPayRollTaskContext = this.getCalPayRollTaskContext();
        Map result = DefaultProcessHandler.get((CalPayRollTaskContext)calPayRollTaskContext);
        int processIntValue = ((BigDecimal)result.get("progress")).intValue();
        if (processIntValue >= 100) {
            this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)calPayRollTaskContext));
        } else if (SWCStringUtils.isEmpty((String)((String)this.getView().getFormShowParameter().getCustomParam("sch_taskid")))) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("calPayRollTaskContext", SerializationUtils.toJsonString((Object)calPayRollTaskContext));
            IFormView mainView = this.getView().getMainView();
            if (mainView != null) {
                HRBackgroundTaskHelper instance = HRBackgroundTaskHelper.getInstance();
                String bgTaskId = instance.createBaskgroundTask("swc_hsas_payrolltask", calPayRollTaskContext.getCalPersonOperationEnum().getOperationName(), true, mainView.getPageId(), this.getView().getParentView().getPageId(), params);
                instance.showBaskgroundTask(bgTaskId);
            }
        }
    }

    public void onProgress(ProgressEvent progressEvent) {
        IFormView view = this.getView();
        CalPayRollTaskContext calPayRollTaskContext = this.getCalPayRollTaskContext();
        Map result = DefaultProcessHandler.get((CalPayRollTaskContext)calPayRollTaskContext);
        int sumSuccessCount = (Integer)result.get("sumSuccessCount");
        int sumFailCount = (Integer)result.get("sumFailCount");
        int sumCount = (Integer)result.get("sumCount");
        int processIntValue = ((BigDecimal)result.get("progress")).intValue();
        progressEvent.setProgress(processIntValue);
        Label process = (Label)this.getControl(PROCESS);
        process.setText(String.valueOf(processIntValue) + '%');
        if (processIntValue >= 100) {
            ProgressBar progressBar = (ProgressBar)this.getControl(PROGRESSBAR_AP);
            progressBar.stop();
            view.setVisible(Boolean.TRUE, new String[]{FINISH});
            view.close();
        }
        Label consumeTimeLabel = (Label)view.getControl(CONSUME_TIME);
        consumeTimeLabel.setText(SWCDateTimeUtils.getConsumeTime((Date)calPayRollTaskContext.getStartTime()));
        Label successCount = (Label)view.getControl(SUCCESS_COUNT);
        successCount.setText(String.valueOf(sumSuccessCount));
        Label failCount = (Label)view.getControl(FAIL_COUNT);
        failCount.setText(String.valueOf(sumFailCount));
        Label todoCount = (Label)view.getControl(TODO_COUNT);
        todoCount.setText(String.valueOf(sumCount - sumSuccessCount - sumFailCount));
    }

    public CalPayRollTaskContext getCalPayRollTaskContext() {
        return (CalPayRollTaskContext)SerializationUtils.fromJsonString((String)((String)this.getView().getFormShowParameter().getCustomParam("calPayRollTaskContext")), CalPayRollTaskContext.class);
    }
}

