/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.guide;

import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsas.business.cal.helper.CalDetailHelper;
import kd.swc.hsas.business.cal.vo.CalPayRollTask;
import kd.swc.hsas.business.payrollscene.service.SWCPayRollSceneService;
import kd.swc.hsas.formplugin.web.guide.AbstractCalPayRollTaskList;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.enums.CalPersonOperationEnum;

public class CalPayrollTaskApproveList
extends AbstractCalPayRollTaskList {
    private static final Log logger = LogFactory.getLog(CalPayrollTaskApproveList.class);

    @Override
    protected List<CalPersonOperationEnum> operationKey() {
        ArrayList<CalPersonOperationEnum> calPersonOperationEnums = new ArrayList<CalPersonOperationEnum>();
        calPersonOperationEnums.add(CalPersonOperationEnum.OP_APPROVE);
        calPersonOperationEnums.add(CalPersonOperationEnum.OP_DISAPPROVE);
        return calPersonOperationEnums;
    }

    @Override
    protected boolean hasPerm(CalPersonOperationEnum calPersonOperationEnum) {
        switch (calPersonOperationEnum) {
            case OP_APPROVE: 
            case OP_DISAPPROVE: {
                return SWCPermissionServiceHelper.hasPerm((long)RequestContext.get().getCurrUserId(), (String)"/UHMBBGZQ65X", (String)"hsas_calperson", (String)calPersonOperationEnum.getPermission());
            }
        }
        return true;
    }

    @Override
    protected void execute() {
        switch (this.calPersonOperationEnum) {
            case OP_APPROVE: 
            case OP_DISAPPROVE: {
                this.getPageCache().put("invokeOperation", "true");
                this.doOperation();
                break;
            }
        }
    }

    @Override
    protected void beforeDoOperation(BeforeDoOperationEventArgs args, CalPayRollTask calPayRollTask) {
        FormOperate formOperate = (FormOperate)args.getSource();
        Long taskId = calPayRollTask.getCalPayRollTaskId();
        if (taskId != null && taskId > 0L) {
            switch (this.calPersonOperationEnum) {
                case OP_APPROVE: 
                case OP_DISAPPROVE: {
                    boolean calapprove;
                    SWCPayRollSceneService sceneService = SWCPayRollSceneService.createInstance();
                    DynamicObject schemeAfterCalObj = sceneService.getAfterCalObjByTask(taskId);
                    if (schemeAfterCalObj == null || (calapprove = schemeAfterCalObj.getBoolean("calapprove"))) break;
                    calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
                    calPayRollTask.setCalPayRollTaskValidatorErrorMsg(ResManager.loadKDString((String)"\u8be5\u6838\u7b97\u4efb\u52a1\u7684\u6838\u7b97\u540e\u5904\u7406\u65b9\u6848{0}\u4e2d\u672a\u542f\u7528\u85aa\u8d44\u5ba1\u6279\u4e1a\u52a1\u3002", (String)"CalPayRollTaskApproveBillList_4", (String)"swc-hsas-formplugin", (Object[])new Object[]{schemeAfterCalObj.getString("number")}));
                    break;
                }
            }
        }
        switch (this.calPersonOperationEnum) {
            case OP_DISAPPROVE: {
                if (formOperate.getOption().tryGetVariableValue("CallBackInvoke", new RefObject())) break;
                this.disapproveValidator(calPayRollTask);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        CalPersonOperationEnum calPersonOperationEnum = CalPersonOperationEnum.getCalOperationEnum((String)callBackId);
        if (calPersonOperationEnum == null) {
            return;
        }
        MessageBoxResult messageBoxResult = messageBoxClosedEvent.getResult();
        switch (calPersonOperationEnum) {
            case OP_DISAPPROVE: {
                if (MessageBoxResult.OK.equals((Object)messageBoxResult) || MessageBoxResult.Yes.equals((Object)messageBoxResult)) {
                    OperateOption operateOption = OperateOption.create();
                    operateOption.setVariableValue("CallBackInvoke", "true");
                    this.getView().invokeOperation(CalPersonOperationEnum.OP_DISAPPROVE.getOperationKey(), operateOption);
                    break;
                }
                this.releaseDistributedLock();
                break;
            }
        }
    }

    private void disapproveValidator(CalPayRollTask calPayRollTask) {
        long startTime = System.currentTimeMillis();
        this.queryCalPersonsAndSetCalPersonIds("id", calPayRollTask);
        boolean flag = CalDetailHelper.hasOnHoldReleaseAgencyBill((List)calPayRollTask.getCalPersons());
        logger.info("\u53cd\u5ba1\u6279\u67e5\u8be2\u6570\u636e\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - startTime));
        if (flag) {
            String msg = ResManager.loadKDString((String)"\u53cd\u5ba1\u6279\u65f6\uff0c\u4f1a\u5c06\u5df2\u89e3\u85aa\u7684\u4ee3\u53d1\u5355\u5bf9\u5e94\u6570\u636e\u5e9f\u5f03\uff0c\u786e\u5b9a\u7ee7\u7eed\uff1f", (String)"HSASCalTableListPayPlugin_27", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CalPersonOperationEnum.OP_DISAPPROVE.getOperationKey()));
            calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Confirm);
        }
    }
}

