/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.guide;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.cal.check.SalaryCalCheckService;
import kd.swc.hsas.business.cal.helper.CalHelper;
import kd.swc.hsas.business.cal.helper.CalPayRollTaskCalHelper;
import kd.swc.hsas.business.cal.helper.CalTableCalHelper;
import kd.swc.hsas.business.cal.vo.CalPayRollTask;
import kd.swc.hsas.business.calpayrolltask.CalPayrollTaskHelper;
import kd.swc.hsas.business.payrollscene.service.SWCPayRollSceneService;
import kd.swc.hsas.business.salarydeatilresult.helper.SalaryDetailResultListHelper;
import kd.swc.hsas.formplugin.web.guide.AbstractCalPayRollTaskList;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.constants.CalConstants;
import kd.swc.hsbp.common.enums.CalPersonOperationEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CalPayrollTaskCalList
extends AbstractCalPayRollTaskList {
    private static final Log logger = LogFactory.getLog(CalPayrollTaskCalList.class);

    @Override
    protected List<CalPersonOperationEnum> operationKey() {
        ArrayList<CalPersonOperationEnum> calPersonOperationEnums = new ArrayList<CalPersonOperationEnum>();
        calPersonOperationEnums.add(CalPersonOperationEnum.OP_CAL);
        calPersonOperationEnums.add(CalPersonOperationEnum.CANCEL_CAL);
        calPersonOperationEnums.add(CalPersonOperationEnum.OP_VIEWCALREPORTHIS);
        return calPersonOperationEnums;
    }

    @Override
    protected boolean hasPerm(CalPersonOperationEnum calPersonOperationEnum) {
        switch (calPersonOperationEnum) {
            case OP_CAL: 
            case CANCEL_CAL: 
            case OP_VIEWCALREPORTHIS: {
                return SWCPermissionServiceHelper.hasPerm((long)RequestContext.get().getCurrUserId(), (String)"/UHMBBGZQ65X", (String)"hsas_calperson", (String)calPersonOperationEnum.getPermission());
            }
        }
        return true;
    }

    @Override
    protected boolean operationMutex() {
        switch (this.calPersonOperationEnum) {
            case OP_VIEWCALREPORTHIS: {
                return false;
            }
        }
        return true;
    }

    @Override
    protected void execute() {
        switch (this.calPersonOperationEnum) {
            case OP_CAL: {
                FormShowParameter formShowParameter = CalPayRollTaskCalHelper.getCalTaskConfirmFormShowParamter((long)this.calPayRollTaskContext.getSelectDatas());
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, formShowParameter.getFormId()));
                this.getView().showForm(formShowParameter);
                break;
            }
            case CANCEL_CAL: {
                FormShowParameter cancelCalTaskConfirmForm = CalPayRollTaskCalHelper.getModalFormShowParameter((String)"hsas_cancelcaltaskconfirm");
                cancelCalTaskConfirmForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, cancelCalTaskConfirmForm.getFormId()));
                this.getView().showForm(cancelCalTaskConfirmForm);
                break;
            }
            case OP_VIEWCALREPORTHIS: {
                this.openCalreport();
                break;
            }
        }
    }

    @Override
    protected void beforeDoOperation(BeforeDoOperationEventArgs args, CalPayRollTask calPayRollTask) {
        switch (this.calPersonOperationEnum) {
            case OP_CAL: {
                long startTime = System.currentTimeMillis();
                this.beforeDoCalValidator(calPayRollTask);
                logger.info("\u6838\u7b97\u4efb\u52a1\u7f16\u7801\uff1a{} \u8ba1\u7b97\u6821\u9a8c\u8017\u65f6\uff1a{}", (Object)calPayRollTask.getNumber(), (Object)(System.currentTimeMillis() - startTime));
                break;
            }
            case CANCEL_CAL: {
                this.beforeDoCancelCalValidator(calPayRollTask);
                break;
            }
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        SWCPayRollSceneService sceneService = SWCPayRollSceneService.createInstance();
        for (FilterColumn filterColumn : commonFilterColumnList) {
            String fieldName = filterColumn.getFieldName();
            if (!SWCStringUtils.equals((String)"payrollscenev.schemeaftercal.name", (String)fieldName)) continue;
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            commonFilterColumn.setDefaultValue(sceneService.getDefaultSchemeAfterCal() + "");
        }
    }

    private void beforeDoCancelCalValidator(CalPayRollTask calPayRollTask) {
        if (CalTableCalHelper.checkIsHasCalingRecord((Long)calPayRollTask.getCalPayRollTaskId(), (String)"2")) {
            String errMsg = ResManager.loadKDString((String)"%s\u6b63\u5728\u56de\u6eda\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"CalPersonCalOperateList_12", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            calPayRollTask.setCalPayRollTaskValidatorErrorMsg(String.format(Locale.ROOT, errMsg, calPayRollTask.getNumber()));
            calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
            return;
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Object data = event.getReturnData();
        switch (actionId) {
            case "hsas_calmodeconfirm": 
            case "hsas_singlecaltaskconfirm": 
            case "hsas_caltaskconfirm": {
                if (data != null) {
                    Map backData = (Map)data;
                    Map taskPersonMap = (Map)backData.get("taskInfo");
                    String cacheUUID = backData.get("cacheUUID").toString();
                    Boolean isOneCalTaskForTax = (Boolean)backData.get("isOneCalTaskForTax");
                    int personCount = 0;
                    for (Map.Entry entry : taskPersonMap.entrySet()) {
                        personCount += ((Integer)entry.getValue()).intValue();
                    }
                    if (personCount > CalConstants.SYN_CHECK_CERT_MAX_KEY) {
                        this.openCalCheckWaitPage(cacheUUID, isOneCalTaskForTax, personCount);
                        break;
                    }
                    this.openCalProcessPage(cacheUUID, isOneCalTaskForTax);
                    break;
                }
                this.releaseDistributedLock();
                break;
            }
            case "hsas_cancelcaltaskconfirm": {
                if (data != null) {
                    List rollbackData = (List)data;
                    if (rollbackData.size() > 1) {
                        this.getView().showForm(CalPayRollTaskCalHelper.getCalProcessPage((String)"hsas_cancelcalprocess", (List)rollbackData, (String)this.getTraceId(), (String)this.getView().getPageId()));
                        break;
                    }
                    Map calPersonCancelCalResponse = (Map)rollbackData.get(0);
                    if (calPersonCancelCalResponse == null) break;
                    this.showSingleCanelTask(calPersonCancelCalResponse);
                    break;
                }
                this.releaseDistributedLock();
                break;
            }
            case "hsas_calcheckwait": {
                Map backData = (Map)data;
                if (backData == null || backData.get("cacheUUID") == null) break;
                String cacheUUID = backData.get("cacheUUID").toString();
                ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CALCHECK_%s", RequestContext.get().getCurrUserId()));
                String checkCertResultKey = String.format(Locale.ROOT, "check_cert_result_%s", cacheUUID);
                Map result = (Map)appCache.get(checkCertResultKey, Map.class);
                appCache.remove(checkCertResultKey);
                result.put("isCurrentView", Boolean.TRUE);
                CalHelper.handlePrompts((Map)result, (IFormView)this.getView());
                if (!Boolean.TRUE.equals(result.get("success"))) break;
                Boolean isOneCalTaskForTax = (Boolean)backData.get("isOneCalTaskForTax");
                this.openCalProcessPage(cacheUUID, isOneCalTaskForTax);
                break;
            }
            case "hsas_calprogress": {
                this.getView().invokeOperation("refresh");
                break;
            }
            case "closecaldetailpage": {
                this.openSalaryResultPage(event);
                break;
            }
        }
    }

    private void showSingleCanelTask(Map<String, Object> calPersonCancelCalResponse) {
        Long calTaskId = (Long)calPersonCancelCalResponse.get("calTaskId");
        Long recordId = (Long)calPersonCancelCalResponse.get("calRecordId");
        Integer calCount = (Integer)calPersonCancelCalResponse.get("calCount");
        String calTaskName = (String)calPersonCancelCalResponse.get("calTaskName");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsas_cancelcalprogress");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, Object> parameterMap = new HashMap<String, Object>(8);
        parameterMap.put("calTaskId", calTaskId);
        parameterMap.put("calRecordId", recordId);
        parameterMap.put("cancelCount", calCount);
        parameterMap.put("startTime", SWCDateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        parameterMap.put("calTaskName", calTaskName);
        showParameter.setCustomParams(parameterMap);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "cancelCal"));
        this.getView().showForm(showParameter);
    }

    private void openSalaryResultPage(ClosedCallBackEvent event) {
        ListSelectedRowCollection returnData = (ListSelectedRowCollection)event.getReturnData();
        if (!SWCObjectUtils.isEmpty((Object)returnData)) {
            ListSelectedRow selectRow = returnData.get(0);
            Long calResultTplId = (Long)selectRow.getPrimaryKeyValue();
            Long calTaskId = this.getCalTaskId();
            if (calTaskId == null) {
                return;
            }
            FormShowParameter formShowParameter = SalaryDetailResultListHelper.openCalResultDetailPage((Long)calResultTplId, (Long)calTaskId, (String)this.getView().getPageId());
            if (formShowParameter == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u4efb\u52a1\u53ef\u80fd\u88ab\u5220\u9664,\u8bf7\u68c0\u67e5\u3002", (String)"CalPersonF7List_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().showForm(formShowParameter);
        }
    }

    private Long getCalTaskId() {
        SWCPageCache pageChche = new SWCPageCache(this.getView());
        Long calTaskId = (Long)pageChche.get(this.getView().getPageId() + "_cacheCalTaskId", Long.class);
        return calTaskId;
    }

    private void openCalProcessPage(String cacheUUID, Boolean isOneCalTaskForTax) {
        ISWCAppCache errMsgCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CALCHECK_ERRMSG_%s", cacheUUID));
        ISWCAppCache calParamCache = SWCAppCache.get((String)String.format(Locale.ROOT, "swc_cal_param_%s", cacheUUID));
        List calParamList = new ArrayList(10);
        int tryCnt = 60;
        while (tryCnt > 0) {
            String errMsg = (String)errMsgCache.get("cal_param", String.class);
            if (SWCStringUtils.isNotEmpty((String)errMsg)) {
                this.getView().showErrorNotification(errMsg);
                return;
            }
            calParamList = (List)calParamCache.get("cal_param", List.class);
            if (!SWCListUtils.isEmpty(calParamList)) break;
            try {
                Thread.sleep(1000L);
                --tryCnt;
            }
            catch (InterruptedException exception) {
                logger.error("openCalProcessPage_getCalParam_error", (Throwable)exception);
            }
        }
        if (isOneCalTaskForTax != null && isOneCalTaskForTax.booleanValue()) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("hsas_calprogress");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hsas_calprogress"));
            for (Map.Entry entry : ((Map)calParamList.get(0)).entrySet()) {
                showParameter.setCustomParam((String)entry.getKey(), entry.getValue());
            }
            this.getView().showForm(showParameter);
            return;
        }
        this.getView().showForm(CalPayRollTaskCalHelper.getCalProcessPage((String)"hsas_caltaskcalprocess", calParamList, (String)this.getTraceId(), (String)this.getView().getPageId()));
    }

    private void openCalCheckWaitPage(String cacheUUID, Boolean isOneCalTaskForTax, int personCount) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsas_calcheckwait");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hsas_calcheckwait"));
        showParameter.setCustomParam("cacheUUID", (Object)cacheUUID);
        showParameter.setCustomParam("isOneCalTaskForTax", (Object)(isOneCalTaskForTax == null ? Boolean.FALSE : isOneCalTaskForTax));
        showParameter.setCustomParam("personCount", (Object)personCount);
        this.getView().showForm(showParameter);
    }

    private void beforeDoCalValidator(CalPayRollTask calPayRollTask) {
        SalaryCalCheckService salaryCalCheckService = new SalaryCalCheckService();
        Long calTaskId = calPayRollTask.getCalPayRollTaskId();
        DynamicObject calTaskData = CalPayrollTaskHelper.queryTaskInfoById((Long)calTaskId);
        String errorMsg = salaryCalCheckService.beforeCalCheck(calPayRollTask, calTaskData, new HashMap(16));
        if (SWCStringUtils.isNotEmpty((String)errorMsg)) {
            calPayRollTask.setCalPayRollTaskValidatorErrorMsg(errorMsg);
            calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
            return;
        }
        String calType = "cal";
        if (SWCStringUtils.equals((String)"1", (String)calPayRollTask.getOpenTaxCal())) {
            calType = "preTaxCal";
        }
        Map operationParam = calPayRollTask.getOperationParam();
        operationParam.put("calType", calType);
        operationParam.put("enddate", SWCDateTimeUtils.format((Date)calTaskData.getDate("enddate"), (String)"yyyy-MM-dd"));
        operationParam.put("startdate", SWCDateTimeUtils.format((Date)calTaskData.getDate("startdate"), (String)"yyyy-MM-dd"));
        if (this.calPayRollTaskContext.getValidDatas().size() == 1) {
            QFilter filter = new QFilter("caltask", "=", (Object)calTaskId);
            try {
                List authorizedDataRuleQFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"/UHMBBGZQ65X", (String)"hsas_calperson", (String)CalPersonOperationEnum.OP_CAL.getPermission());
                if (authorizedDataRuleQFilter != null) {
                    for (QFilter tempFilter : authorizedDataRuleQFilter) {
                        filter.and(tempFilter);
                    }
                } else {
                    filter.and("1", "!=", (Object)1);
                }
            }
            catch (Exception exception) {
                logger.error("invoke hrcs IHRCSDataPermissionService error", (Throwable)exception);
            }
            DynamicObjectCollection calPersonDataList = CalHelper.getCalPersonData(null, (Long)calTaskId, (QFilter)filter);
            if (calPersonDataList.isEmpty()) {
                String msg = ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u65e0\u53ef\u8ba1\u7b97\u6570\u636e\u3002", (String)"CalPayrollTaskCalList_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                calPayRollTask.setCalPayRollTaskValidatorErrorMsg(msg);
                calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
                return;
            }
            List calPersonIdList = calPersonDataList.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
            calPayRollTask.setCalPersons(calPersonIdList);
            CalHelper.groupByCalStatusForCalPerson((DynamicObjectCollection)calPersonDataList, (Map)operationParam);
        }
    }

    private void openCalreport() {
        ListShowParameter show = new ListShowParameter();
        show.setBillFormId("hsas_calrecord");
        show.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        QFilter filter = new QFilter("caltask.id", "in", this.getCalTaskIds());
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(filter);
        show.setListFilterParameter(new ListFilterParameter(filters, "starttime desc"));
        show.setPageId(this.getView().getPageId() + "_" + "hsas_calrecord");
        this.getView().showForm((FormShowParameter)show);
    }
}

