/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.guide;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsas.business.cal.service.CalRollBackService;
import kd.swc.hsas.business.cal.vo.CalPayRollTask;
import kd.swc.hsas.business.cal.vo.CalPayRollTaskContext;
import kd.swc.hsas.formplugin.web.guide.CalCalPersonFormPlugin;
import kd.swc.hsbp.business.calrequest.CalRequestHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.CalPersonOperationEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CancelCalTaskConfirmPlugin
extends CalCalPersonFormPlugin {
    private static final Log logger = LogFactory.getLog(CancelCalTaskConfirmPlugin.class);
    public static final String BUTTON_AP = "buttonap";
    public static final String CANCEL = "cancel";
    public static final String CANCEL_CAL = "cancelcal";
    public static final String CAN_CANCEL_CAL = "cancancelcal";
    public static final String NOT_CANCEL_CAL_LABEL = "flexpanelap1";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        CalPayRollTaskContext calPayRollTaskContext = this.getCalPayRollTaskContext();
        int sumCancelCalCount = this.initEntry(calPayRollTaskContext);
        this.getView().setVisible(Boolean.valueOf(sumCancelCalCount == 0), new String[]{BUTTON_AP, NOT_CANCEL_CAL_LABEL});
        this.getView().setVisible(Boolean.valueOf(sumCancelCalCount != 0), new String[]{CANCEL, CANCEL_CAL, CAN_CANCEL_CAL});
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs arg) {
        super.afterDoOperation(arg);
        FormOperate operate = (FormOperate)arg.getSource();
        if (SWCStringUtils.equals((String)operate.getOperateKey(), (String)CalPersonOperationEnum.CANCEL_CAL.getOperationKey())) {
            List<Map<String, Object>> calPersonCancelCalResponses = this.invokeCancelCal();
            if (calPersonCancelCalResponses.size() == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8c03\u7528\u5fae\u670d\u52a1\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u76f8\u5173\u4eba\u5458\u5904\u7406\u3002", (String)"CalCalPersonFormPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().getParentView().getPageCache().put("invokeOperation", "true");
            this.getView().returnDataToParent(calPersonCancelCalResponses);
            this.getView().close();
        }
    }

    private List<Map<String, Object>> invokeCancelCal() {
        CalPayRollTaskContext calPayRollTaskContext = this.getCalPayRollTaskContext();
        List validDatas = calPayRollTaskContext.getValidDatas();
        ArrayList<Map<String, Object>> calPersonCancelCalResponses = new ArrayList<Map<String, Object>>();
        String batchNum = CalRequestHelper.getBatchNum();
        CalRollBackService calRollBackService = null;
        for (CalPayRollTask validData : validDatas) {
            Long calPayRollTaskId = validData.getCalPayRollTaskId();
            List calPersons = validData.getCalPersons();
            try {
                calRollBackService = new CalRollBackService(calPayRollTaskId.longValue(), calPersons);
                Long recordId = calRollBackService.calRollBack(CANCEL_CAL, batchNum);
                HashMap<String, Object> calPersonCancelCalResponse = new HashMap<String, Object>(5);
                calPersonCancelCalResponse.put("calTaskId", validData.getCalPayRollTaskId());
                calPersonCancelCalResponse.put("calTaskName", validData.getName());
                calPersonCancelCalResponse.put("calRecordId", recordId);
                calPersonCancelCalResponse.put("calCount", validData.getCalPersons().size());
                calPersonCancelCalResponse.put("starttime", SWCDateTimeUtils.format((Date)new Date()));
                calPersonCancelCalResponses.add(calPersonCancelCalResponse);
            }
            catch (Exception e) {
                logger.error("CalRollBackService.calRollBack is fail,calTaskId = {}", (Object)calPayRollTaskId);
                logger.error("cancelCal error", (Throwable)e);
            }
        }
        ISWCAppCache calRequestCache = SWCAppCache.get((String)String.format(Locale.ROOT, "cal_request_param_%s", batchNum));
        HashMap<String, Object> calRequestParams = new HashMap<String, Object>(16);
        calRequestParams.put("data", calPersonCancelCalResponses);
        calRequestParams.put("traceId", calPayRollTaskContext.getTraceId());
        calRequestCache.put("cal_param", calRequestParams);
        return calPersonCancelCalResponses;
    }
}

