/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.guide;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.payrolltask.helper.PayRollTaskHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCArrayUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class SceneInfoListPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(SceneInfoListPlugin.class);
    private static final String PAYROLL_GROUPV = "payrollgroupv";
    private static final String BTN_EFFECT_DATE = "effectdate";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_EFFECT_DATE});
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        String clkKey = ((Control)evt.getSource()).getKey();
        if (BTN_EFFECT_DATE.equals(clkKey)) {
            this.getView().updateView();
        }
    }

    public void setFilter(SetFilterEvent e) {
        QFilter dataRuleForBdPropFilter;
        super.setFilter(e);
        Object payRollGrpIdObj = null;
        List qFilterList = e.getQFilters();
        Date effectDate = (Date)this.getModel().getValue(BTN_EFFECT_DATE);
        if (effectDate == null || (payRollGrpIdObj = this.getView().getFormShowParameter().getCustomParam("payRollGrpId")) == null || SWCListUtils.isEmpty((List)qFilterList)) {
            logger.info("SceneInfoListPlugin.setFilter: effectDate = {}, payRollGrpId = {}", (Object)effectDate, payRollGrpIdObj);
            return;
        }
        long payRollGrpId = payRollGrpIdObj instanceof Integer ? ((Integer)payRollGrpIdObj).longValue() : ((Long)payRollGrpIdObj).longValue();
        Long payRollGrpVid = PayRollTaskHelper.queryCurrentTimePayRollGrpVId((long)payRollGrpId, (Date)effectDate);
        boolean payrollgroupvFilterNotExists = true;
        for (QFilter filter : qFilterList) {
            if (!filter.getProperty().contains(PAYROLL_GROUPV)) continue;
            filter.__setValue((Object)payRollGrpVid);
            payrollgroupvFilterNotExists = false;
            break;
        }
        List qFilters = e.getQFilters();
        if (payrollgroupvFilterNotExists) {
            QFilter payRollGrpVidFilter = new QFilter(PAYROLL_GROUPV, "=", (Object)payRollGrpVid);
            qFilters.add(payRollGrpVidFilter);
        }
        qFilters.add(new QFilter("payrollscene.enable", "=", (Object)"1"));
        String permissionId = (String)this.getView().getFormShowParameter().getCustomParam("permissionId");
        if (SWCStringUtils.isNotEmpty((String)permissionId) && (dataRuleForBdPropFilter = SWCPermissionServiceHelper.getDataRuleForBdProp((long)RequestContext.get().getCurrUserId(), (String)"/UHMBBGZQ65X", (String)"hsas_calpayrolltask", (String)"payrollscene", (String)permissionId)) != null) {
            List pkIds = PayRollTaskHelper.queryPkIdsByAuthorizedFilter((String)"hsas_payrollscene", (QFilter)dataRuleForBdPropFilter);
            logger.info("SceneInfoListPlugin.setFilter: dataRuleForBdPropFilter = {}, pkIds = {}", (Object)dataRuleForBdPropFilter.toString(), (Object)pkIds.toString());
            qFilters.add(new QFilter("payrollscene", "in", (Object)pkIds));
        }
        logger.info("SceneInfoListPlugin.setFilter: qFilters = {}, payRollGrpId = {}, permissionId = {}", new Object[]{qFilters != null ? qFilters.toString() : null, payRollGrpIdObj, permissionId});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (BTN_EFFECT_DATE.equals(e.getProperty().getName()) && !SWCArrayUtils.isEmpty((Object[])e.getChangeSet()) && e.getChangeSet()[0].getNewValue() != null) {
            this.getView().updateView();
        }
    }
}

