/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.onhold;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Image;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.IBaseDataService;
import kd.swc.hsas.business.calpayrolltask.CalPayrollTaskHelper;
import kd.swc.hsas.business.onhold.helper.OnHoldBillHelper;
import kd.swc.hsas.business.onhold.helper.OnHoldDetailHelper;
import kd.swc.hsas.business.salaryfile.SWCSalaryFileServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCShowFormServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.enums.OnHoldStatusEnum;
import kd.swc.hsbp.common.enums.PayStateEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class OnHoldBillEdit
extends SWCDataBaseEdit
implements RowClickEventListener,
HyperLinkClickListener,
BeforeF7SelectListener {
    private static final String SWC_HSAS_FORMPLUGIN = "swc-hsas-formplugin";
    private static final String FLEX_CONTENTPANELFLEX = "contentpanelflex";
    private static final String FLEX_CONTENTPANEL = "contentpanel";
    private static final Log LOGGER = LogFactory.getLog(OnHoldBillEdit.class);

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setMainContent();
    }

    private void setMainContent() {
        if (this.getEntrySize("personentry") < 1) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_CONTENTPANEL});
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_CONTENTPANELFLEX});
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.deleteEntryData("caltableentry");
            model.deleteEntryData("salaryentry");
            Image statusImg = (Image)this.getControl("nodata");
            statusImg.setUrl("/images/pc/emotion/emotional_empty_220_220.png");
            this.getModel().setDataChanged(false);
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_CONTENTPANEL});
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_CONTENTPANELFLEX});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "donothing_delperson": {
                if (!this.validateIsExistPersonData()) {
                    String tipNotification = ResManager.loadKDString((String)"\u6682\u672a\u6dfb\u52a0\u505c\u7f13\u53d1\u4eba\u5458\uff0c\u65e0\u6cd5\u8fdb\u884c\u201c\u5220\u9664\u201d\u64cd\u4f5c\u3002", (String)"OnHoldBillEdit_0", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]);
                    this.getView().showTipNotification(tipNotification);
                    args.setCancel(true);
                    return;
                }
                this.confirmDelPerson();
                break;
            }
            case "donothing_save": {
                if (this.validateIsExistPersonData()) break;
                String tipNotification = ResManager.loadKDString((String)"\u6682\u672a\u6dfb\u52a0\u505c\u7f13\u53d1\u4eba\u5458\uff0c\u65e0\u6cd5\u8fdb\u884c\u201c\u4fdd\u5b58\u201d\u64cd\u4f5c\u3002", (String)"OnHoldBillEdit_1", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]);
                this.getView().showTipNotification(tipNotification);
                args.setCancel(true);
                return;
            }
            case "donothing_formsubmit": {
                if (this.validateIsExistPersonData()) break;
                String tipNotification = ResManager.loadKDString((String)"\u6682\u672a\u6dfb\u52a0\u505c\u7f13\u53d1\u4eba\u5458\uff0c\u65e0\u6cd5\u8fdb\u884c\u201c\u63d0\u4ea4\u5e76\u751f\u6548\u201d\u64cd\u4f5c\u3002", (String)"OnHoldBillEdit_2", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]);
                this.getView().showTipNotification(tipNotification);
                args.setCancel(true);
                return;
            }
        }
    }

    private void delEntryUpdateCacheData(String module, int[] delEntryIndexArr) {
        JSONArray toDeleOnHoldIdAppcheArr;
        JSONArray personInfoAppcheArr;
        String listName = "";
        String idListName = "";
        String onHoldIdName = "";
        if (module.startsWith("caltable")) {
            listName = "caltableList";
            idListName = "caltableIdList";
            onHoldIdName = "caltableOnHoldId";
        } else {
            listName = "salaryfileList";
            idListName = "salaryfileIdList";
            onHoldIdName = "salaryfileOnHoldId";
        }
        ISWCAppCache appCache = SWCAppCache.get((String)"personinfo_appcache");
        String pageId = this.getView().getPageId();
        JSONObject onholdInfoAppcheJSONObject = (JSONObject)appCache.get(pageId, JSONObject.class);
        Long personId = this.getCurrentPersonId();
        String personIdStr = String.valueOf(personId);
        JSONObject personJsonInfo = onholdInfoAppcheJSONObject.getJSONObject(personIdStr);
        if (personJsonInfo == null) {
            personJsonInfo = new JSONObject();
        }
        if ((personInfoAppcheArr = personJsonInfo.getJSONArray(listName)) == null) {
            personInfoAppcheArr = new JSONArray();
        }
        if ((toDeleOnHoldIdAppcheArr = personJsonInfo.getJSONArray("delOnholdIdList")) == null) {
            toDeleOnHoldIdAppcheArr = new JSONArray();
        }
        JSONArray idListAppcheArr = personJsonInfo.getJSONArray(idListName);
        int entityLen = delEntryIndexArr.length;
        int index = entityLen - 1;
        for (int i = 0; i < entityLen; ++i) {
            JSONObject onHoldJson = null;
            try {
                onHoldJson = personInfoAppcheArr.getJSONObject(delEntryIndexArr[index]);
            }
            catch (Exception e) {
                continue;
            }
            String onHoldId = onHoldJson.getString(onHoldIdName);
            if (onHoldId != null) {
                toDeleOnHoldIdAppcheArr.add((Object)onHoldId);
            }
            personInfoAppcheArr.remove(delEntryIndexArr[index]);
            idListAppcheArr.remove(delEntryIndexArr[index]);
            --index;
        }
        personJsonInfo.put(listName, (Object)personInfoAppcheArr);
        personJsonInfo.put(idListName, (Object)idListAppcheArr);
        onholdInfoAppcheJSONObject.put("delOnholdIdList", (Object)toDeleOnHoldIdAppcheArr);
        onholdInfoAppcheJSONObject.put(personIdStr, (Object)personJsonInfo);
        appCache.put(pageId, (Object)onholdInfoAppcheJSONObject);
    }

    private void confirmDelPerson() {
        int[] selectedRows = this.getEntryIndexArrByEntryName("personentry");
        int selectedSize = selectedRows.length;
        if (selectedSize < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u5220\u9664\u7684\u8ba1\u85aa\u4eba\u5458\u3002", (String)"OnHoldBillEdit_3", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684%s\u6761\u8bb0\u5f55\u540e\uff0c\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u8981\u5220\u9664\u8bb0\u5f55\uff1f", (String)"OnHoldBillEdit_4", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]), selectedSize), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("donothing_delperson", (IFormPlugin)this));
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "donothing_addperson": {
                this.openPersonListF7();
                break;
            }
            case "donothing_save": {
                OnHoldBillHelper.confirmOperate((IFormView)this.getView(), (boolean)true, this.getSelectedPersonIdList());
                this.getModel().setDataChanged(false);
                break;
            }
            case "donothing_calnewentry": {
                this.openCalPersonListF7(this.getCurrentPersonId());
                break;
            }
            case "donothing_salaryfilenewentry": {
                OnHoldBillHelper.openSalaryfileListF7((IFormView)this.getView(), (String)this.getPluginName(), (Long)this.getCurrentPersonId());
                break;
            }
            case "donothing_formsubmit": {
                OnHoldBillHelper.confirmOperate((IFormView)this.getView(), (boolean)false, this.getSelectedPersonIdList());
                OnHoldBillHelper.updateEditStatus((IDataModel)this.getModel(), (IFormView)this.getView(), (Long)this.getCurrentPersonId());
                this.getModel().setDataChanged(false);
                break;
            }
            case "caltable_deleteentry": {
                this.delCaltableEntryRow();
                OnHoldBillHelper.updateEditStatus((IDataModel)this.getModel(), (IFormView)this.getView(), (Long)this.getCurrentPersonId());
                break;
            }
            case "salaryfile_deleteentry": {
                this.delSalaryEntryRow();
                break;
            }
        }
    }

    private List<String> getSelectedPersonIdList() {
        int[] selectedRows = this.getEntryIndexArrByEntryName("personentry");
        int selectedRowsSize = selectedRows == null ? 0 : selectedRows.length;
        ArrayList<String> personIdList = new ArrayList<String>(selectedRowsSize);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("personentry");
        if (selectedRows == null || selectedRowsSize == 0) {
            for (DynamicObject personObj : entryEntity) {
                personIdList.add(personObj.getString("personinfo"));
            }
        } else {
            for (int i = 0; i < selectedRowsSize; ++i) {
                DynamicObject personObj = (DynamicObject)entryEntity.get(selectedRows[i]);
                personIdList.add(personObj.getString("personinfo"));
            }
        }
        return personIdList;
    }

    private void delCaltableEntryRow() {
        int[] selectedRows = this.getEntryIndexArrByEntryName("caltableentry");
        int selectedRowSize = selectedRows.length;
        if (selectedRowSize == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u884c\u3002", (String)"OnHoldDetailEdit_0", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        ArrayList<String> errorMsgList = new ArrayList<String>(selectedRowSize);
        int[] delIndexArr = this.getDelCalPersonIndexArr(selectedRows, errorMsgList);
        this.delEntryUpdateCacheData("caltable", delIndexArr);
        this.getModel().deleteEntryRows("caltableentry", delIndexArr);
        OnHoldDetailHelper.showDetailResultMsg((int)selectedRowSize, errorMsgList, (String)"caltable_deleteentry", (IFormView)this.getView());
    }

    private void delSalaryEntryRow() {
        int[] selectedRows = this.getEntryIndexArrByEntryName("salaryentry");
        int selectedRowSize = selectedRows.length;
        if (selectedRowSize == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u884c\u3002", (String)"OnHoldDetailEdit_0", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        ArrayList<String> errorMsgList = new ArrayList<String>(selectedRowSize);
        int[] delIndexArr = this.getDelSalaryIndexArr(selectedRows, errorMsgList);
        this.delEntryUpdateCacheData("salary", delIndexArr);
        this.getModel().deleteEntryRows("salaryentry", delIndexArr);
        OnHoldDetailHelper.showDetailResultMsg((int)selectedRowSize, errorMsgList, (String)"salaryfile_deleteentry", (IFormView)this.getView());
    }

    private int[] getDelCalPersonIndexArr(int[] selectedRows, List<String> errorMsgList) {
        ISWCAppCache appCache = SWCAppCache.get((String)"personinfo_appcache");
        String pageId = this.getView().getPageId();
        JSONObject onHoldInfoAppCacheJSONObject = (JSONObject)appCache.get(pageId, JSONObject.class);
        JSONObject personInfo = onHoldInfoAppCacheJSONObject.getJSONObject(String.valueOf(this.getCurrentPersonId()));
        JSONArray calTableList = personInfo.getJSONArray("caltableList");
        int cacheCalTableSize = calTableList.size();
        int selectedOnHoldListSize = selectedRows.length;
        ArrayList<Integer> delIndexList = new ArrayList<Integer>(selectedOnHoldListSize);
        ArrayList<LinkedHashMap> selectedOnHoldList = new ArrayList<LinkedHashMap>(selectedOnHoldListSize);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("caltableentry");
        ArrayList<Long> caltableIdList = new ArrayList<Long>(selectedOnHoldListSize);
        for (int selectedRow : selectedRows) {
            if (selectedRow >= cacheCalTableSize) {
                delIndexList.add(selectedRow);
                continue;
            }
            selectedOnHoldList.add((LinkedHashMap)calTableList.get(selectedRow));
            caltableIdList.add(Long.valueOf((String)((LinkedHashMap)calTableList.get(selectedRow)).get("caltable")));
        }
        Map onHoldCaltableMap = OnHoldBillHelper.queryOnHoldedCalPersonMap(caltableIdList);
        int index = 0;
        List<Long> calPersonDeledIdList = this.getCalPersonDeledIdListFromCache();
        for (LinkedHashMap onHold : selectedOnHoldList) {
            Integer caltableStatusInt;
            String calTableStatus = (String)onHold.get("caltableStatus");
            DynamicObject caltableOnHoldDb = (DynamicObject)onHoldCaltableMap.get(onHold.get("caltable"));
            if (!SWCObjectUtils.isEmpty((Object)caltableOnHoldDb)) {
                calTableStatus = caltableOnHoldDb.getString("status");
            }
            if ((caltableStatusInt = Integer.valueOf(calTableStatus)) >= OnHoldStatusEnum.STATUS_RELEASE.getCode()) {
                String salaryFileNumber = (String)onHold.get("caltableSalaryfileNumber");
                String calTaskNumber = (String)onHold.get("caltableCaltaskNumber");
                String onHoldStatusDec = OnHoldStatusEnum.getDesc((Integer)caltableStatusInt);
                errorMsgList.add(ResManager.loadKDString((String)"\u6863\u6848\u7f16\u53f7\uff1a{0}\uff0c\u6838\u7b97\u4efb\u52a1\u7f16\u7801\uff1a{1}\u4e3a{2}\uff0c\u65e0\u6cd5\u5220\u9664\u505c\u7f13\u53d1\u3002", (String)"OnHoldDetailEdit_1", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[]{salaryFileNumber, calTaskNumber, onHoldStatusDec}));
            } else {
                DynamicObject caltableObj = (DynamicObject)entryEntity.get(selectedRows[index]);
                Long caltableId = caltableObj.getLong("caltableinfo.id");
                calPersonDeledIdList.add(caltableId);
                delIndexList.add(caltableObj.getInt("seq") - 1);
            }
            ++index;
        }
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        pageCache.put("caltableDeledIdList", calPersonDeledIdList);
        int[] delIndexArr = OnHoldDetailHelper.integerListToArray(delIndexList);
        return delIndexArr;
    }

    private int[] getDelSalaryIndexArr(int[] selectedRows, List<String> errorMsgList) {
        ISWCAppCache appCache = SWCAppCache.get((String)"personinfo_appcache");
        String pageId = this.getView().getPageId();
        JSONObject onholdInfoAppcheJSONObject = (JSONObject)appCache.get(pageId, JSONObject.class);
        JSONObject personInfo = onholdInfoAppcheJSONObject.getJSONObject(String.valueOf(this.getCurrentPersonId()));
        JSONArray caltableList = personInfo.getJSONArray("salaryfileList");
        int selectedOnHoldListSize = selectedRows.length;
        ArrayList<LinkedHashMap> selectedOnHoldList = new ArrayList<LinkedHashMap>(selectedOnHoldListSize);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("salaryentry");
        for (int selectedRow : selectedRows) {
            selectedOnHoldList.add((LinkedHashMap)caltableList.get(selectedRow));
        }
        ArrayList<Integer> delIndexList = new ArrayList<Integer>(selectedOnHoldListSize);
        int index = 0;
        for (LinkedHashMap onHold : selectedOnHoldList) {
            String salaryStatus = (String)onHold.get("salaryfileStatus");
            if (SWCStringUtils.isEmpty((String)salaryStatus)) {
                Integer delIndex = (Integer)onHold.get("salaryIndex") - 1;
                delIndexList.add(delIndex);
                continue;
            }
            Integer salaryStatusInt = Integer.valueOf(salaryStatus);
            if (salaryStatusInt > OnHoldStatusEnum.STATUS_RELEASE.getCode()) {
                String salaryNumber = (String)onHold.get("salaryNumber");
                String onHoldStatusDec = OnHoldStatusEnum.getDesc((Integer)salaryStatusInt);
                errorMsgList.add(ResManager.loadKDString((String)"\u6863\u6848\u7f16\u53f7({0})\uff1a\u4e3a{1}\uff0c\u65e0\u6cd5\u5220\u9664\u505c\u7f13\u53d1\u3002", (String)"OnHoldDetailEdit_2", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[]{salaryNumber, onHoldStatusDec}));
            } else {
                delIndexList.add(((DynamicObject)entryEntity.get(selectedRows[index])).getInt("seq") - 1);
            }
            ++index;
        }
        int[] delIndexArr = OnHoldDetailHelper.integerListToArray(delIndexList);
        return delIndexArr;
    }

    private boolean validateIsExistPersonData() {
        return this.getEntrySize("personentry") >= 1;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        this.setEditStatus(fieldKey);
        if (SWCStringUtils.equals((String)fieldKey, (String)"attachment")) {
            this.updateAttachmentCache(e);
        } else {
            this.updateCacheData(fieldKey, this.getModel().getValue(fieldKey));
        }
    }

    private void updateAttachmentCache(PropertyChangedArgs e) {
        DynamicObject deleteAttachment;
        String attachNeedCancel = this.getView().getPageCache().get("attachNeedCancel");
        if (SWCStringUtils.equals((String)attachNeedCancel, (String)"true")) {
            this.getView().getPageCache().remove("attachNeedCancel");
            return;
        }
        ChangeData[] changeSet = e.getChangeSet();
        DynamicObjectCollection newColl = (DynamicObjectCollection)changeSet[0].getNewValue();
        Long personId = this.getCurrentPersonId();
        ISWCAppCache appCache = SWCAppCache.get((String)"personinfo_appcache");
        String pageId = this.getView().getPageId();
        JSONObject onholdInfoAppcheJSONObject = (JSONObject)appCache.get(pageId, JSONObject.class);
        String personIdStr = String.valueOf(personId);
        JSONObject personJsonInfo = onholdInfoAppcheJSONObject.getJSONObject(personIdStr);
        Object cacheAttachmentColl = personJsonInfo.get((Object)"attachmentCollection");
        DynamicObjectCollection cacheColl = new DynamicObjectCollection();
        if (cacheAttachmentColl instanceof String) {
            String attachmentByteStr = (String)cacheAttachmentColl;
            byte[] decoded = Base64.getDecoder().decode(attachmentByteStr);
            cacheColl = (DynamicObjectCollection)OnHoldBillHelper.deserialize((byte[])decoded);
        }
        if ((deleteAttachment = this.getDeleteAttachment(cacheColl, newColl)) == null) {
            this.updatePublicFieldCacheData("attachment", newColl);
        } else {
            this.deleteAttachmentCacheData(cacheColl, newColl, personIdStr, deleteAttachment);
        }
    }

    private void deleteAttachmentCacheData(DynamicObjectCollection cacheColl, DynamicObjectCollection newColl, String personIdStr, DynamicObject deleteAttachment) {
        if (cacheColl == null || cacheColl.size() == 0) {
            return;
        }
        ISWCAppCache appCache = SWCAppCache.get((String)"personinfo_appcache");
        String pageId = this.getView().getPageId();
        JSONObject onholdInfoAppcheJSONObject = (JSONObject)appCache.get(pageId, JSONObject.class);
        JSONObject personJsonInfo = onholdInfoAppcheJSONObject.getJSONObject(personIdStr);
        cacheColl.remove((Object)deleteAttachment);
        personJsonInfo.put("attachmentCollection", OnHoldBillHelper.serialize((Serializable)cacheColl));
        Long[] attachmentIdArr = new Long[cacheColl.size()];
        int index = 0;
        for (DynamicObject obj : cacheColl) {
            Long attachmentId = obj.getLong("fbasedataid_id");
            attachmentIdArr[index++] = attachmentId;
        }
        personJsonInfo.put("attachment", (Object)attachmentIdArr);
        this.getModel().setValue("attachment", (Object)attachmentIdArr);
        onholdInfoAppcheJSONObject.put(personIdStr, (Object)personJsonInfo);
        appCache.put(pageId, (Object)onholdInfoAppcheJSONObject);
    }

    private DynamicObject getDeleteAttachment(DynamicObjectCollection cacheColl, DynamicObjectCollection newColl) {
        HashSet<Long> attachmentIdSet = new HashSet<Long>(newColl.size());
        for (DynamicObject newObj : newColl) {
            Long attachmentId = newObj.getLong("fbasedataid_id");
            attachmentIdSet.add(attachmentId);
        }
        for (DynamicObject obj : cacheColl) {
            Long cacheAttachmentId = obj.getLong("fbasedataid_id");
            if (attachmentIdSet.contains(cacheAttachmentId)) continue;
            return obj;
        }
        return null;
    }

    private void setEditStatus(String fieldKey) {
        int entryIndex = this.getEntryIndexByField(fieldKey);
        switch (fieldKey) {
            case "caltableonholdstatus": {
                Boolean caltableonholdstatus = (Boolean)this.getModel().getValue(fieldKey);
                this.getModel().setValue("caltableonholdreason", null);
                this.getView().setEnable(caltableonholdstatus, entryIndex, new String[]{"caltableonholdreason"});
                break;
            }
        }
    }

    private void updateCacheData(String fieldKey, Object value) {
        if (fieldKey.startsWith("salary")) {
            this.updateCacheData(fieldKey, value, "salaryentry", "salaryfileList");
        } else if (fieldKey.startsWith("caltable")) {
            this.updateCacheData(fieldKey, value, "caltableentry", "caltableList");
        } else {
            this.updatePublicFieldCacheData(fieldKey, value);
        }
    }

    private void updateCacheData(String fieldKey, Object value, String entryName, String listName) {
        JSONArray personInfoAppCacheArr;
        Long personId;
        String personIdStr;
        String pageId;
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(entryName);
        int[] entryGridSelectRows = entryGrid.getSelectRows();
        int entryIndex = entryGridSelectRows.length > 0 ? entryGridSelectRows[0] : 0;
        ISWCAppCache appCache = SWCAppCache.get((String)"personinfo_appcache");
        JSONObject onHoldInfoAppCacheJSONObject = (JSONObject)appCache.get(pageId = this.getView().getPageId(), JSONObject.class);
        JSONObject personJsonInfo = onHoldInfoAppCacheJSONObject.getJSONObject(personIdStr = String.valueOf(personId = this.getCurrentPersonId()));
        if (personJsonInfo != null && (personInfoAppCacheArr = personJsonInfo.getJSONArray(listName)) != null && !personInfoAppCacheArr.isEmpty()) {
            LinkedHashMap personInfoAppCacheJSONObject = (LinkedHashMap)personInfoAppCacheArr.get(entryIndex);
            if (value == null) {
                personInfoAppCacheJSONObject.put(fieldKey, null);
            } else if (value instanceof DynamicObject) {
                DynamicObject valueObj = (DynamicObject)value;
                personInfoAppCacheJSONObject.put(fieldKey, valueObj.getString("id"));
            } else if (value instanceof BigDecimal) {
                personInfoAppCacheJSONObject.put(fieldKey, ((BigDecimal)value).toPlainString());
            } else if (fieldKey.equals("salaryonholdrange_enddate")) {
                Date startDate = (Date)this.getModel().getValue("salaryonholdrange_startdate");
                personInfoAppCacheJSONObject.put("salaryonholdrange_startdate", startDate == null ? "" : SWCDateTimeUtils.format((Date)startDate, (String)"yyyy-MM-dd"));
                personInfoAppCacheJSONObject.put("salaryonholdrange_enddate", SWCDateTimeUtils.format((Date)((Date)value)));
            } else if (value instanceof Date) {
                personInfoAppCacheJSONObject.put(fieldKey, SWCDateTimeUtils.format((Date)((Date)value), (String)"yyyy-MM-dd"));
            } else {
                personInfoAppCacheJSONObject.put(fieldKey, value);
            }
            personInfoAppCacheArr.set(entryIndex, (Object)personInfoAppCacheJSONObject);
            personJsonInfo.put(listName, (Object)personInfoAppCacheArr);
            onHoldInfoAppCacheJSONObject.put(personIdStr, (Object)personJsonInfo);
            appCache.put(pageId, (Object)onHoldInfoAppCacheJSONObject);
        }
    }

    private void updatePublicFieldCacheData(String fieldKey, Object value) {
        ISWCAppCache appCache = SWCAppCache.get((String)"personinfo_appcache");
        String pageId = this.getView().getPageId();
        JSONObject onholdInfoAppcheJSONObject = (JSONObject)appCache.get(pageId, JSONObject.class);
        Long personId = this.getCurrentPersonId();
        String personIdStr = String.valueOf(personId);
        JSONObject personJsonInfo = onholdInfoAppcheJSONObject.getJSONObject(personIdStr);
        if (value instanceof DynamicObjectCollection) {
            DynamicObjectCollection attachmentCollection = (DynamicObjectCollection)value;
            Object cacheAttachmentColl = personJsonInfo.get((Object)"attachmentCollection");
            DynamicObjectCollection cacheColl = new DynamicObjectCollection();
            if (cacheAttachmentColl instanceof String) {
                String attachmentByteStr = (String)cacheAttachmentColl;
                byte[] decoded = Base64.getDecoder().decode(attachmentByteStr);
                cacheColl = (DynamicObjectCollection)OnHoldBillHelper.deserialize((byte[])decoded);
            }
            if (attachmentCollection != null && attachmentCollection.size() > 0) {
                cacheColl.add((Object)this.getLastAttachment(attachmentCollection));
            }
            personJsonInfo.put("attachmentCollection", OnHoldBillHelper.serialize((Serializable)cacheColl));
            Long[] attachmentIdArr = new Long[cacheColl.size()];
            int index = 0;
            for (DynamicObject obj : cacheColl) {
                Long attachmentId = obj.getLong("fbasedataid_id");
                attachmentIdArr[index++] = attachmentId;
            }
            personJsonInfo.put(fieldKey, (Object)attachmentIdArr);
            this.getView().getPageCache().put("attachNeedCancel", "true");
            this.getModel().setValue("attachment", (Object)attachmentIdArr);
        } else {
            personJsonInfo.put(fieldKey, value);
        }
        onholdInfoAppcheJSONObject.put(personIdStr, (Object)personJsonInfo);
        appCache.put(pageId, (Object)onholdInfoAppcheJSONObject);
    }

    private DynamicObject getLastAttachment(DynamicObjectCollection attachmentCollection) {
        Long maxAttachId = 0L;
        DynamicObject lastObj = null;
        for (DynamicObject obj : attachmentCollection) {
            Long attachmentId = obj.getLong("fbasedataid_id");
            if (attachmentId < maxAttachId) continue;
            maxAttachId = attachmentId;
            lastObj = obj;
        }
        return lastObj;
    }

    private void openCalPersonListF7(Long personId) {
        ListShowParameter showParam = ShowFormHelper.createShowListForm((String)"hsas_onholdcalpersonf7", (boolean)true);
        QFilter qFilter = new QFilter("employee.id", "=", (Object)personId);
        List calPersonOnHoldedIdList = OnHoldBillHelper.queryOnHoldCalPersonIdListByPersonId((Long)personId);
        DynamicObjectCollection calTaskColl = this.getModel().getEntryEntity("caltableentry");
        if (calTaskColl != null && calTaskColl.size() > 0) {
            for (DynamicObject calTaskObj : calTaskColl) {
                calPersonOnHoldedIdList.add(calTaskObj.getLong("caltableinfo.id"));
            }
        }
        qFilter.and("id", "not in", (Object)calPersonOnHoldedIdList);
        qFilter.and("paystatus", "not in", (Object)new String[]{PayStateEnum.PAYING.getCode(), PayStateEnum.PAID.getCode()});
        qFilter.and("caltask.tasktype", "in", (Object)new String[]{"0", "1"});
        qFilter.and("onholdstatus", "not in", (Object)new String[]{"2", "4"});
        showParam.getListFilterParameter().setFilter(qFilter);
        showParam.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hsas_onholdcaltablef7"));
        this.getView().showForm((FormShowParameter)showParam);
    }

    private List<Long> getCalPersonDeledIdListFromCache() {
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        ArrayList calPersonDeledIdList = (ArrayList)pageCache.get("caltableDeledIdList", List.class);
        if (calPersonDeledIdList == null) {
            calPersonDeledIdList = new ArrayList(10);
        }
        return calPersonDeledIdList;
    }

    private void openPersonListF7() {
        ListShowParameter showParam = ShowFormHelper.createShowListForm((String)"hsas_employee", (boolean)true);
        showParam.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hsas_person"));
        this.getView().showForm((FormShowParameter)showParam);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "hsas_person": {
                this.addPerson(closedCallBackEvent);
                this.setMainContent();
                break;
            }
            case "hsas_onholdcaltablef7": {
                this.updateCaltableCacheAndEntry(closedCallBackEvent);
                OnHoldBillHelper.updateEditStatus((IDataModel)this.getModel(), (IFormView)this.getView(), (Long)this.getCurrentPersonId());
                break;
            }
            case "hsas_onholdsalaryfilef7": {
                this.updateSalaryCacheAndEntry(closedCallBackEvent);
                OnHoldBillHelper.updateEditStatus((IDataModel)this.getModel(), (IFormView)this.getView(), (Long)this.getCurrentPersonId());
                break;
            }
        }
    }

    private void addCalPersonUpdateEntry(DynamicObject[] calPersonArr) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        if (calPersonArr == null || calPersonArr.length < 1) {
            return;
        }
        model.beginInit();
        TableValueSetter setter = OnHoldBillHelper.getSetter((DynamicObject[])calPersonArr);
        model.batchCreateNewEntryRow("caltableentry", setter);
        this.getView().updateView("caltableentry");
        model.endInit();
    }

    private void addSalaryUpdateEntry(DynamicObject[] salaryfileArr) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        if (salaryfileArr == null || salaryfileArr.length < 1) {
            return;
        }
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("salaryfileinfo", new Object[0]);
        setter.addField("salaryonholdreason", new Object[0]);
        setter.addField("firstbsed", new Object[0]);
        setter.addField("bsed", new Object[0]);
        setter.addField("bsled", new Object[0]);
        for (DynamicObject salaryfile : salaryfileArr) {
            Long salaryfileId = salaryfile.getLong("id");
            Date firstBsed = salaryfile.getDate("firstbsed");
            Date bsed = salaryfile.getDate("bsed");
            Date bsled = salaryfile.getDate("bsled");
            setter.addRow(new Object[]{salaryfileId, BigDecimal.ZERO, firstBsed, bsed, bsled});
        }
        model.batchCreateNewEntryRow("salaryentry", setter);
        this.getView().updateView("salaryentry");
        model.endInit();
    }

    private void updateCaltableCacheAndEntry(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection selectedCollection = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (selectedCollection != null && !selectedCollection.isEmpty()) {
            Object[] primaryKeyValues = selectedCollection.getPrimaryKeyValues();
            List pkIds = OnHoldDetailHelper.changeToList((Object[])primaryKeyValues);
            SWCPageCache pageCache = new SWCPageCache(this.getView());
            List<Long> calPersonDeledIdList = this.getCalPersonDeledIdListFromCache();
            calPersonDeledIdList.removeAll(pkIds);
            pageCache.put("caltableDeledIdList", calPersonDeledIdList);
            DynamicObject[] calPersonArr = OnHoldBillHelper.queryCalPersonArrByIds((Object[])primaryKeyValues);
            Long personId = this.getCurrentPersonId();
            ISWCAppCache appCache = SWCAppCache.get((String)"personinfo_appcache");
            String pageId = this.getView().getPageId();
            JSONObject onholdInfoAppcheJSONObject = (JSONObject)appCache.get(pageId, JSONObject.class);
            if (onholdInfoAppcheJSONObject == null) {
                onholdInfoAppcheJSONObject = new JSONObject();
            }
            OnHoldBillHelper.saveCalPersonData((String)String.valueOf(personId), (JSONObject)onholdInfoAppcheJSONObject, Arrays.asList(calPersonArr));
            appCache.put(pageId, (Object)onholdInfoAppcheJSONObject);
            this.addCalPersonUpdateEntry(calPersonArr);
        }
    }

    private void updateSalaryCacheAndEntry(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection selectedCollection = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (selectedCollection != null && !selectedCollection.isEmpty()) {
            String pageId;
            Object[] primaryKeyValues = selectedCollection.getPrimaryKeyValues();
            DynamicObject[] salaryFileArr = OnHoldBillHelper.querySalaryFileArrByIds((Object[])primaryKeyValues);
            ISWCAppCache appCache = SWCAppCache.get((String)"personinfo_appcache");
            JSONObject onholdInfoAppcheJSONObject = (JSONObject)appCache.get(pageId = this.getView().getPageId(), JSONObject.class);
            if (onholdInfoAppcheJSONObject == null) {
                onholdInfoAppcheJSONObject = new JSONObject();
            }
            String personId = String.valueOf(this.getCurrentPersonId());
            OnHoldBillHelper.saveSalaryDataToCache((JSONObject)onholdInfoAppcheJSONObject, (String)personId, Arrays.asList(salaryFileArr));
            appCache.put(pageId, (Object)onholdInfoAppcheJSONObject);
            this.addSalaryUpdateEntry(salaryFileArr);
        }
    }

    private void addPerson(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection selectedCollection = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (selectedCollection != null && !selectedCollection.isEmpty()) {
            String pageId;
            Object[] primaryKeyValues = selectedCollection.getPrimaryKeyValues();
            Map personObjMap = OnHoldBillHelper.queryPersonListByIds((Object[])primaryKeyValues);
            if (personObjMap == null) {
                return;
            }
            Set keySetStr = personObjMap.keySet();
            Set keySetLong = keySetStr.stream().map(key -> Long.valueOf(key)).collect(Collectors.toSet());
            Map personRefSalaryListMap = OnHoldBillHelper.queryPersonRefSalaryListAssembleData(keySetLong);
            if (personRefSalaryListMap.isEmpty()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u8ba1\u85aa\u4eba\u5458\u65e0\u4eba\u5458\u85aa\u8d44\u6863\u6848\u6216\u6743\u9650\uff0c\u8bf7\u6838\u5b9e\u5904\u7406\u540e\u518d\u8fdb\u884c\u505c\u7f13\u53d1\u3002", (String)"OnHoldBillEdit_6", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            ISWCAppCache appCache = SWCAppCache.get((String)"personinfo_appcache");
            JSONObject onholdInfoAppcheJSONObject = (JSONObject)appCache.get(pageId = this.getView().getPageId(), JSONObject.class);
            if (onholdInfoAppcheJSONObject == null) {
                onholdInfoAppcheJSONObject = new JSONObject();
            }
            Map<String, Object> resultMap = this.validateAndSetPersonEntry(personObjMap, personRefSalaryListMap);
            if (!personObjMap.isEmpty()) {
                OnHoldBillHelper.saveSalaryCache((JSONObject)onholdInfoAppcheJSONObject, (Map)personRefSalaryListMap);
            }
            appCache.put(pageId, (Object)onholdInfoAppcheJSONObject);
            this.setDefaultSelectedRow(onholdInfoAppcheJSONObject);
            Integer successCount = (Integer)resultMap.get("successCount");
            LinkedHashMap errorMsgMap = (LinkedHashMap)resultMap.get("errorMsgMap");
            if (errorMsgMap.isEmpty()) {
                return;
            }
            Map sortedMap = OnHoldBillHelper.getKeySortedMap((LinkedHashMap)errorMsgMap);
            List errorMsgList = OnHoldBillHelper.mergeMapValues((Map)sortedMap);
            int total = primaryKeyValues.length;
            if (total == 1) {
                this.getView().showErrorNotification((String)errorMsgList.get(0));
            } else {
                int fail = total - successCount;
                String message = MessageFormat.format(ResManager.loadKDString((String)"\u5171\u9009\u62e9{0}\u6761\u8bb0\u5f55\uff0c{1}\u6761\u6210\u529f\uff0c{2}\u6761\u5931\u8d25\u3002", (String)"OnHoldBillEdit_8", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]), total, successCount, fail);
                FormShowParameter parameters = SWCShowFormServiceHelper.getOperationResultParameter((String)ResManager.loadKDString((String)"\u6dfb\u52a0\u4eba\u5458", (String)"OnHoldBillEdit_9", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]), (String)message, (List)errorMsgList);
                this.getView().showForm(parameters);
            }
        }
    }

    private Map<String, Object> validateAndSetPersonEntry(Map<String, DynamicObject> personObjMap, Map<String, List<DynamicObject>> personRefSalaryListMap) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        List<String> personIdList = this.getPersonIdList();
        Iterator<Map.Entry<String, DynamicObject>> iterator = personObjMap.entrySet().iterator();
        LinkedHashMap<String, List<String>> errorMsgMap = new LinkedHashMap<String, List<String>>(16);
        LinkedHashMap<String, String> personInfo = new LinkedHashMap<String, String>(personObjMap.size());
        while (iterator.hasNext()) {
            List<String> errorMsgList;
            Map.Entry<String, DynamicObject> entry = iterator.next();
            String personId = entry.getKey();
            DynamicObject person = entry.getValue();
            String personName = person.getString("person.name");
            String empNumber = person.getString("empnumber");
            if (personIdList.contains(personId)) {
                iterator.remove();
                errorMsgList = this.getErrorListByType(errorMsgMap, "2");
                errorMsgList.add(MessageFormat.format(ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\u3002", (String)"OnHoldBillEdit_5", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]), personName, empNumber));
                continue;
            }
            if (personRefSalaryListMap.get(personId) == null) {
                iterator.remove();
                errorMsgList = this.getErrorListByType(errorMsgMap, "1");
                errorMsgList.add(MessageFormat.format(ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u65e0\u4eba\u5458\u85aa\u8d44\u6863\u6848\u3002", (String)"OnHoldBillEdit_10", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]), personName, empNumber));
                continue;
            }
            StringBuilder valStr = new StringBuilder();
            personInfo.put(personId, valStr.append(personName).append(' ').append(empNumber).toString());
        }
        if (!personInfo.isEmpty()) {
            this.setPersonInfoEntryValue(personInfo);
        }
        resultMap.put("errorMsgMap", errorMsgMap);
        resultMap.put("successCount", personInfo.size());
        return resultMap;
    }

    private List<String> getErrorListByType(Map<String, List<String>> errorMsgMap, String type) {
        List<String> errorMsgList = errorMsgMap.get(type);
        if (errorMsgList == null) {
            errorMsgList = new ArrayList<String>(10);
            errorMsgMap.put(type, errorMsgList);
        }
        return errorMsgList;
    }

    private void setDefaultSelectedRow(JSONObject onholdInfoAppcheJSONObject) {
        EntryGrid personGrid = (EntryGrid)this.getControl("personentry");
        if (this.getEntrySize("personentry") > 0) {
            Long personId = this.getCurrentPersonId();
            if (personId == null) {
                this.entryRowClick(0);
                personGrid.selectRows(0);
            } else {
                Integer currentRow = onholdInfoAppcheJSONObject.getInteger("currentRowIndex");
                personGrid.selectRows(currentRow.intValue());
            }
        }
    }

    private List<Long> getBaseDataIdList(String listName) {
        Long personId;
        String personIdStr;
        String pageId;
        ISWCAppCache appCache = SWCAppCache.get((String)"personinfo_appcache");
        JSONObject onholdInfoAppcheJSONObject = (JSONObject)appCache.get(pageId = this.getView().getPageId(), JSONObject.class);
        JSONObject personJsonInfo = onholdInfoAppcheJSONObject.getJSONObject(personIdStr = String.valueOf(personId = this.getCurrentPersonId()));
        JSONArray baseDataIdList = personJsonInfo.getJSONArray(listName);
        if (baseDataIdList == null) {
            return new ArrayList<Long>(1);
        }
        ArrayList<Long> idList = new ArrayList<Long>(baseDataIdList.size());
        baseDataIdList.forEach(baseDataId -> idList.add(Long.valueOf(String.valueOf(baseDataId))));
        return idList;
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        switch (e.getCallBackId()) {
            case "donothing_delperson": {
                if (!MessageBoxResult.Yes.equals((Object)e.getResult())) break;
                this.delePersonEntry();
                this.setMainContent();
                break;
            }
            case "save_confirm_callback": {
                if (!MessageBoxResult.Yes.equals((Object)e.getResult())) break;
                OnHoldBillHelper.saveOrSubmitOnHoldInfo((IFormView)this.getView(), this.getSelectedPersonIdList(), (boolean)true);
                break;
            }
            case "submit_confirm_callback": {
                if (!MessageBoxResult.Yes.equals((Object)e.getResult())) break;
                OnHoldBillHelper.saveOrSubmitOnHoldInfo((IFormView)this.getView(), this.getSelectedPersonIdList(), (boolean)false);
                OnHoldBillHelper.updateEditStatus((IDataModel)this.getModel(), (IFormView)this.getView(), (Long)this.getCurrentPersonId());
                break;
            }
        }
    }

    private void delePersonEntry() {
        String pageId;
        ISWCAppCache appCache = SWCAppCache.get((String)"personinfo_appcache");
        JSONObject onholdInfoAppcheJSONObject = (JSONObject)appCache.get(pageId = this.getView().getPageId(), JSONObject.class);
        if (onholdInfoAppcheJSONObject != null) {
            List<String> personIdList = this.getSelectedPersonList();
            for (String personId : personIdList) {
                onholdInfoAppcheJSONObject.remove((Object)personId);
            }
            onholdInfoAppcheJSONObject.remove((Object)"currentPersonId");
            appCache.put(pageId, (Object)onholdInfoAppcheJSONObject);
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryRows("personentry", this.getEntryIndexArrByEntryName("personentry"));
        this.getView().updateView("personentry");
        EntryGrid personGrid = (EntryGrid)this.getControl("personentry");
        if (this.getEntrySize("personentry") > 0) {
            this.entryRowClick(0);
            personGrid.selectRows(0);
        }
    }

    private void setPersonInfoEntryValue(Map<String, String> personInfo) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("personname", new Object[0]);
        setter.addField("personinfo", new Object[0]);
        for (Map.Entry<String, String> entry : personInfo.entrySet()) {
            setter.addRow(new Object[]{entry.getValue(), entry.getKey()});
        }
        model.batchCreateNewEntryRow("personentry", setter);
        this.getView().updateView("personentry");
        model.endInit();
    }

    public void entryRowClick(RowClickEvent evt) {
        int[] selectRows = this.getEntryIndexArrByEntryName("personentry");
        if (selectRows.length != 1) {
            return;
        }
        int rowIndex = evt.getRow();
        this.entryRowClick(rowIndex);
    }

    private void entryRowClick(int rowIndex) {
        DynamicObject entity = this.getModel().getEntryRowEntity("personentry", rowIndex);
        if (entity == null) {
            return;
        }
        Long personId = entity.getLong("personinfo");
        ISWCAppCache appCache = SWCAppCache.get((String)"personinfo_appcache");
        String pageId = this.getView().getPageId();
        JSONObject onHoldInfoCacheJSONObject = (JSONObject)appCache.get(pageId, JSONObject.class);
        onHoldInfoCacheJSONObject.put("currentPersonId", (Object)personId);
        onHoldInfoCacheJSONObject.put("currentRowIndex", (Object)rowIndex);
        appCache.put(pageId, (Object)onHoldInfoCacheJSONObject);
        JSONObject personInfoCache = onHoldInfoCacheJSONObject.getJSONObject(String.valueOf(personId));
        OnHoldBillHelper.showOnholdPreviewPage((Long)personId, (IFormView)this.getView());
        this.setCalTableInfoEntryValue(personInfoCache);
        this.setSalaryInfoEntryValue(personId, personInfoCache);
        this.setPublicFieldVal(onHoldInfoCacheJSONObject);
        OnHoldBillHelper.updateEditStatus((IDataModel)this.getModel(), (IFormView)this.getView(), (Long)this.getCurrentPersonId());
    }

    private Long getCurrentPersonId() {
        Long personId;
        String pageId;
        ISWCAppCache appCache = SWCAppCache.get((String)"personinfo_appcache");
        JSONObject onholdInfoAppcheJSONObject = (JSONObject)appCache.get(pageId = this.getView().getPageId(), JSONObject.class);
        if (onholdInfoAppcheJSONObject != null && (personId = onholdInfoAppcheJSONObject.getLong("currentPersonId")) != null) {
            return personId;
        }
        int[] entryGridSelectRows = this.getEntryIndexArrByEntryName("personentry");
        if (entryGridSelectRows.length > 0) {
            DynamicObject entity = this.getModel().getEntryRowEntity("personentry", entryGridSelectRows[0]);
            Long personId2 = entity.getLong("personinfo");
            return personId2;
        }
        return null;
    }

    private void setCalTableInfoEntryValue(JSONObject personInfoAppche) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("caltableentry");
        if (personInfoAppche == null) {
            return;
        }
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("caltableinfo", new Object[0]);
        setter.addField("caltableonholdstatus", new Object[0]);
        setter.addField("orgname", new Object[0]);
        setter.addField("calpayoutitem", new Object[0]);
        setter.addField("caltableamount", new Object[0]);
        setter.addField("caltablecalamount", new Object[0]);
        setter.addField("caltablecalcurrency", new Object[0]);
        setter.addField("caltableonholdreason", new Object[0]);
        setter.addField("payrolldate", new Object[0]);
        setter.addField("caltablestartdate", new Object[0]);
        setter.addField("caltableenddate", new Object[0]);
        setter.addField("calcount", new Object[0]);
        setter.addField("caltaskent", new Object[0]);
        setter.addField("salaryfileent", new Object[0]);
        JSONArray caltableListAppche = personInfoAppche.getJSONArray("caltableList");
        if (caltableListAppche == null || caltableListAppche.isEmpty()) {
            return;
        }
        Map salaryItemDataPrecisionInfoMap = null;
        if (caltableListAppche instanceof JSONArray) {
            int calTableSize = caltableListAppche.size();
            HashSet<Long> salaryItemIdList = new HashSet<Long>(calTableSize);
            JSONArray calTableInfo = caltableListAppche;
            for (Object obj : calTableInfo) {
                LinkedHashMap calPersonInfo;
                String payoutItem;
                if (!(obj instanceof LinkedHashMap) || SWCStringUtils.isEmpty((String)(payoutItem = (String)(calPersonInfo = (LinkedHashMap)obj).get("payoutitem")))) continue;
                salaryItemIdList.add(Long.valueOf(payoutItem));
            }
            salaryItemDataPrecisionInfoMap = OnHoldDetailHelper.getSalaryItemDataPrecisionInfoMap(salaryItemIdList);
        }
        if (caltableListAppche instanceof JSONArray) {
            JSONArray calTableInfo = caltableListAppche;
            for (Object obj : calTableInfo) {
                if (!(obj instanceof LinkedHashMap)) continue;
                LinkedHashMap calPersonInfo = (LinkedHashMap)obj;
                String calPersonId = (String)calPersonInfo.get("caltable");
                Boolean onHoldStatus = (Boolean)calPersonInfo.get("caltableonholdstatus");
                String payOutItem = (String)calPersonInfo.get("payoutitem");
                String payrollDate = (String)calPersonInfo.get("caltablePayrollDate");
                String orgName = (String)calPersonInfo.get("caltableorgname");
                String calPersonStartDate = (String)calPersonInfo.get("caltableStartdate");
                String calPersonEndDate = (String)calPersonInfo.get("caltableEnddate");
                Integer calCount = (Integer)calPersonInfo.get("caltableCalCount");
                String onHoldReason = (String)calPersonInfo.get("caltableonholdreason");
                String calTaskId = (String)calPersonInfo.get("caltask");
                String salaryFileId = (String)calPersonInfo.get("salaryfile");
                Date payRollDate = null;
                Date startDate = null;
                Date endDate = null;
                try {
                    payRollDate = SWCDateTimeUtils.parseDate((String)payrollDate);
                    startDate = SWCDateTimeUtils.parseDate((String)calPersonStartDate);
                    endDate = SWCDateTimeUtils.parseDate((String)calPersonEndDate);
                }
                catch (Exception e) {
                    LOGGER.error("\u65e5\u671f\u8f6c\u6362\u51fa\u9519\uff1a{}", (Object)e.getMessage());
                }
                long calCurrencyId = 0L;
                String calCurrency = (String)calPersonInfo.get("caltablecalcurrency");
                if (!SWCStringUtils.isEmpty((String)calCurrency)) {
                    calCurrencyId = Long.parseLong(calCurrency);
                }
                BigDecimal calAmount = BigDecimal.ZERO;
                String calAmountStr = (String)calPersonInfo.get("caltablecalamount");
                if (!SWCStringUtils.isEmpty((String)calAmountStr)) {
                    calAmount = new BigDecimal(calAmountStr);
                }
                String calAmountForDisplay = OnHoldDetailHelper.getCalTableAmount((Map)salaryItemDataPrecisionInfoMap, (LinkedHashMap)calPersonInfo);
                setter.addRow(new Object[]{Long.valueOf(calPersonId), onHoldStatus, orgName, payOutItem, calAmountForDisplay, calAmount, calCurrencyId, onHoldReason, payRollDate, startDate, endDate, calCount, calTaskId, salaryFileId});
            }
        }
        model.batchCreateNewEntryRow("caltableentry", setter);
        this.getView().updateView("caltableentry");
        model.endInit();
    }

    private void setSalaryInfoEntryValue(Long personId, JSONObject personInfoAppche) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("salaryentry");
        if (personInfoAppche == null) {
            return;
        }
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("salaryfileinfo", new Object[0]);
        setter.addField("firstbsed", new Object[0]);
        setter.addField("bsed", new Object[0]);
        setter.addField("bsled", new Object[0]);
        setter.addField("salaryonholdstartdate", new Object[0]);
        setter.addField("salaryreleasedate", new Object[0]);
        setter.addField("salaryisallowcal", new Object[0]);
        setter.addField("salaryonholdreason", new Object[0]);
        JSONArray salaryfileListAppche = personInfoAppche.getJSONArray("salaryfileList");
        if (salaryfileListAppche == null || salaryfileListAppche.isEmpty()) {
            this.getView().updateView("salaryentry");
            return;
        }
        if (salaryfileListAppche instanceof JSONArray) {
            JSONArray salaryfileInfo = salaryfileListAppche;
            for (Object obj : salaryfileInfo) {
                if (!(obj instanceof LinkedHashMap)) continue;
                LinkedHashMap salaryfileInfoJson = (LinkedHashMap)obj;
                String salaryfileId = (String)salaryfileInfoJson.get("salaryfile");
                Date startDate = null;
                Date releaseDate = null;
                Date salaryBred = null;
                Date salaryBrled = null;
                Date salaryFirstBred = null;
                try {
                    salaryFirstBred = SWCDateTimeUtils.parseDate((String)((String)salaryfileInfoJson.get("salaryFirstBred")), (String)"yyyy-MM-dd");
                    salaryBred = SWCDateTimeUtils.parseDate((String)((String)salaryfileInfoJson.get("salaryBred")), (String)"yyyy-MM-dd");
                    salaryBrled = SWCDateTimeUtils.parseDate((String)((String)salaryfileInfoJson.get("salaryBrled")), (String)"yyyy-MM-dd");
                    startDate = SWCDateTimeUtils.parseDate((String)((String)salaryfileInfoJson.get("salaryonholdstartdate")), (String)"yyyy-MM-dd");
                    releaseDate = SWCDateTimeUtils.parseDate((String)((String)salaryfileInfoJson.get("salaryreleasedate")), (String)"yyyy-MM-dd");
                }
                catch (Exception e) {
                    LOGGER.error("\u65e5\u671f\u8f6c\u6362\u5931\u8d25\uff1a{}", (Object)e.getMessage());
                }
                String salaryOnHoldReason = (String)salaryfileInfoJson.get("salaryonholdreason");
                String isAllowCal = (String)salaryfileInfoJson.get("salaryisallowcal");
                setter.addRow(new Object[]{salaryfileId, salaryFirstBred, salaryBred, salaryBrled, startDate, releaseDate, isAllowCal, salaryOnHoldReason});
            }
        }
        model.batchCreateNewEntryRow("salaryentry", setter);
        this.getView().updateView("salaryentry");
        model.endInit();
    }

    private void setPublicFieldVal(JSONObject onholdInfoAppcheJSONObject) {
        Long personId = this.getCurrentPersonId();
        String personIdStr = String.valueOf(personId);
        JSONObject personJsonInfo = onholdInfoAppcheJSONObject.getJSONObject(personIdStr);
        if (personJsonInfo != null) {
            this.getModel().setValue("releasedate", personJsonInfo.get((Object)"releasedate"));
            this.getModel().setValue("remark", personJsonInfo.get((Object)"remark"));
            List attchmentArr = (List)personJsonInfo.get((Object)"attachment");
            this.getModel().setValue("attachment", (Object)(attchmentArr == null ? null : attchmentArr.toArray()));
            this.getView().updateView("releasedate");
            this.getView().updateView("remark");
            this.getView().updateView("attachment");
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid personEntry = (EntryGrid)this.getControl("personentry");
        personEntry.addRowClickListener((RowClickEventListener)this);
        EntryGrid caltableEntry = (EntryGrid)this.getControl("caltableentry");
        caltableEntry.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid salaryfileEntry = (EntryGrid)this.getControl("salaryentry");
        salaryfileEntry.addHyperClickListener((HyperLinkClickListener)this);
        this.addClickListeners(new String[]{"addpersonlable"});
        BasedataEdit salaryfileControl = (BasedataEdit)this.getView().getControl("salaryonholdreason");
        BasedataEdit caltableControl = (BasedataEdit)this.getView().getControl("caltableonholdreason");
        salaryfileControl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        caltableControl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String controlKey = control.getKey();
        if ("addpersonlable".equals(controlKey)) {
            this.openPersonListF7();
        }
    }

    public void pageRelease(EventObject e) {
        super.pageRelease(e);
        ISWCAppCache appCache = SWCAppCache.get((String)"personinfo_appcache");
        String pageId = this.getView().getPageId();
        appCache.remove(pageId);
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        pageCache.remove("caltableDeledIdList");
    }

    private int[] getEntryIndexArrByEntryName(String entryName) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(entryName);
        int[] entryGridSelectRows = entryGrid.getSelectRows();
        return entryGridSelectRows;
    }

    private int getEntryIndexByField(String field) {
        int[] salaryGridSelectRows;
        String entryName = "caltableentry";
        if (field.startsWith("salary")) {
            entryName = "salaryentry";
        }
        int entryIndex = (salaryGridSelectRows = this.getEntryIndexArrByEntryName(entryName)).length > 0 ? salaryGridSelectRows[0] : 0;
        return entryIndex;
    }

    private List<String> getPersonIdList() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("personentry");
        ArrayList<String> personIdList = new ArrayList<String>(entryEntity.size());
        for (DynamicObject dynamicObject : entryEntity) {
            personIdList.add(dynamicObject.getString("personinfo"));
        }
        return personIdList;
    }

    private int getEntrySize(String entryName) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entryName);
        return entryEntity == null ? 0 : entryEntity.size();
    }

    private List<String> getSelectedPersonList() {
        int[] selectedRows = this.getEntryIndexArrByEntryName("personentry");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("personentry");
        int selectRowsLen = selectedRows.length;
        ArrayList<String> personIdList = new ArrayList<String>(selectRowsLen);
        for (int i = 0; i < selectRowsLen; ++i) {
            DynamicObject personObj = (DynamicObject)entryEntity.get(selectedRows[i]);
            personIdList.add(personObj.getString("personinfo"));
        }
        return personIdList;
    }

    private DynamicObject getCurrentSelectedRowObject(String entryName) {
        int[] entryGridSelectRows = this.getEntryIndexArrByEntryName(entryName);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entryName);
        return (DynamicObject)entryEntity.get(entryGridSelectRows[0]);
    }

    public void hyperLinkClick(HyperLinkClickEvent args) {
        String fieldName = args.getFieldName();
        EntryGrid entry = (EntryGrid)args.getSource();
        String entryName = entry.getEntryKey();
        DynamicObject currentRowObject = this.getCurrentSelectedRowObject(entryName);
        switch (fieldName) {
            case "caltablesalaryfileno": {
                Long caltableSalaryFileId = currentRowObject.getLong("caltableinfo.salaryfile.id");
                SWCSalaryFileServiceHelper.assembleSalaryFileDataAndOpenFormView((Long)caltableSalaryFileId, (IFormView)this.getView());
                break;
            }
            case "caltaskno": {
                Long calTaskId = currentRowObject.getLong("caltableinfo.caltask.id");
                ListShowParameter calTaskShowParameter = CalPayrollTaskHelper.getCalTableListForm((String)this.getView().getPageId(), (long)calTaskId);
                this.getView().showForm((FormShowParameter)calTaskShowParameter);
                break;
            }
            case "salaryfileno": {
                Long salaryFileId = currentRowObject.getLong("salaryfileinfo.id");
                SWCSalaryFileServiceHelper.assembleSalaryFileDataAndOpenFormView((Long)salaryFileId, (IFormView)this.getView());
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String propertyName = e.getProperty().getName();
        int entryIndex = this.getEntryIndexByField(propertyName);
        switch (propertyName) {
            case "caltableonholdreason": {
                DynamicObjectCollection caltableCol = this.getModel().getEntryEntity("caltableentry");
                Long caltableOrgId = ((DynamicObject)caltableCol.get(entryIndex)).getLong("caltableinfo.org.id");
                this.setOnHoldFilter(e, caltableOrgId);
                break;
            }
            case "salaryonholdreason": {
                DynamicObjectCollection salaryfileCol = this.getModel().getEntryEntity("salaryentry");
                Long salaryfileOrgId = ((DynamicObject)salaryfileCol.get(entryIndex)).getLong("salaryfileinfo.org.id");
                this.setOnHoldFilter(e, salaryfileOrgId);
                break;
            }
        }
    }

    private void setOnHoldFilter(BeforeF7SelectEvent e, Long orgId) {
        IBaseDataService baseDataService = (IBaseDataService)this.getModel().getService(IBaseDataService.class);
        ListShowParameter param = (ListShowParameter)e.getFormShowParameter();
        QFilter qFilter = baseDataService.getBaseDataFilter("hsbs_onholdcause", orgId);
        param.getListFilterParameter().setFilter(qFilter);
    }
}

