/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.onhold;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.BeforeUploadEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.url.UrlService;
import kd.swc.hsas.business.calpayrolltask.CalPayrollTaskHelper;
import kd.swc.hsas.business.onhold.helper.OnHoldBillHelper;
import kd.swc.hsas.business.onhold.helper.OnHoldDetailHelper;
import kd.swc.hsas.business.salaryfile.SWCSalaryFileServiceHelper;
import kd.swc.hsas.common.vo.CalPersonStatusDefault;
import kd.swc.hsbp.business.log.SWCOpLogServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCShowFormServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.enums.OnHoldStatusEnum;
import kd.swc.hsbp.formplugin.web.SWCDataBaseList;

public class OnHoldBillList
extends SWCDataBaseList
implements UploadListener {
    private static final String SALARYFILE_NUMBER = "salaryfile_number";
    private static final String CALTASK_NUMBER = "caltask_number";
    private static final String PERSON_EMPNUMBER = "person_person_number";
    public static final String BTN_DONOTHING_UPLOAD_FID = "0ZCQQZQINKF8";
    private static final String SWC_HSAS_FORMPLUGIN = "swc-hsas-formplugin";
    private static final String SIMPLE_NAME = OnHoldBillList.class.getSimpleName();
    private static final String BTN_DONOTHING_SUBMIT = "donothing_submit";
    private static final String BTN_DONOTHING_SKIPTOMSGCFG = "donothing_skiptomsgcfg";
    private static final String BTN_DONOTHING_RELEASE = "donothing_release";
    private static final String BTN_DONOTHING_RESENDMSG = "donothing_resendmsg";
    private static final String BTN_DONOTHING_STOPPAY = "donothing_stoppay";
    private static final String BTN_DONOTHING_UPLOAD = "donothing_upload";
    private static final String BTN_DONOTHING_DOWNLOAD = "donothing_download";
    private static final String BTN_DONOTHING_UNDO = "donothing_undo";
    private static final String KEY_TOOLBAR = "toolbar";
    private static final String RELEASE_AFTERCONFIRM = "notfirstrelease";
    private static final String STOPPAY_AFTERCONFIRM = "notfirststoppay";
    private static final String KEY_CALAMOUNT = "calamount";
    private static final String KEY_RELEASECALAMOUNT = "releasecalamount";
    private Map<String, Map<String, Object>> onHoldInfoMap = new HashMap<String, Map<String, Object>>(16);
    private Map<String, Integer> dataPrecisionMap = new HashMap<String, Integer>(16);
    private Log log = LogFactory.getLog(OnHoldBillList.class);
    private static final HashMap<String, String> BTNTOFIDMAP = new HashMap(9);
    private static final HashSet<String> FIXEDFIELDSET = new HashSet(16);

    public void initialize() {
        this.getView().getFormShowParameter().setAppId("hsas");
    }

    public void beforePackageData(BeforePackageDataEvent event) {
        long startTime = System.currentTimeMillis();
        DynamicObjectCollection pageDatas = event.getPageData();
        long endTime = System.currentTimeMillis();
        this.log.info("================onholdBillList beforePackageData query event.getPageData:{}", (Object)(endTime - startTime));
        ArrayList<Long> pkIdList = new ArrayList<Long>(pageDatas.size());
        HashSet<DynamicObject[]> salaryItemIdSet = new HashSet<DynamicObject[]>(pageDatas.size());
        for (DynamicObject pageData : pageDatas) {
            if (!pageData.getDynamicObjectType().getProperties().tryGetValue("payoutitem", new RefObject())) {
                return;
            }
            pkIdList.add(pageData.getLong("id"));
            DynamicObject[] payOutItemId = Long.valueOf(pageData.getLong("payoutitem.id"));
            if (payOutItemId.intValue() <= 0) continue;
            salaryItemIdSet.add(payOutItemId);
        }
        startTime = System.currentTimeMillis();
        SWCDataServiceHelper onHoldHelper = new SWCDataServiceHelper("hsas_onholdbill");
        DynamicObject[] onHoldArr = onHoldHelper.query("id,calcurrency.sign,payoutitem.id", new QFilter("id", "in", pkIdList).toArray());
        endTime = System.currentTimeMillis();
        this.log.info("================onholdBillList beforePackageData query onholdbill:{}", (Object)(endTime - startTime));
        for (DynamicObject onHold : onHoldArr) {
            HashMap<String, String> onHoldMap = new HashMap<String, String>(16);
            onHoldMap.put("calcurrency.sign", onHold.getString("calcurrency.sign"));
            onHoldMap.put("payoutitem.id", onHold.getString("payoutitem.id"));
            this.onHoldInfoMap.put(onHold.getString("id"), onHoldMap);
        }
        startTime = System.currentTimeMillis();
        Map salaryItemDataPrecisionInfoMap = OnHoldDetailHelper.getSalaryItemDataPrecisionInfoMap(salaryItemIdSet);
        endTime = System.currentTimeMillis();
        this.log.info("================onholdBillList beforePackageData query getSalaryItemDataPrecisionInfoMap:{}", (Object)(endTime - startTime));
        for (Map.Entry entry : salaryItemDataPrecisionInfoMap.entrySet()) {
            DynamicObject value = (DynamicObject)entry.getValue();
            int dataPrecision = 2;
            if (value != null) {
                dataPrecision = value.getInt("scale");
            }
            this.dataPrecisionMap.put((String)entry.getKey(), dataPrecision);
        }
    }

    public void packageData(PackageDataEvent event) {
        long startTime = System.currentTimeMillis();
        super.packageData(event);
        long endTime = System.currentTimeMillis();
        this.log.info("================onholdBillList packageData query packageData:{}", (Object)(endTime - startTime));
        startTime = System.currentTimeMillis();
        String fieldKey = ((ColumnDesc)event.getSource()).getFieldKey();
        if (KEY_CALAMOUNT.equals(fieldKey) || KEY_RELEASECALAMOUNT.equals(fieldKey)) {
            this.setGridScaleField(event, fieldKey);
        }
        endTime = System.currentTimeMillis();
        this.log.info("================onholdBillList packageData setGridScaleField:{}", (Object)(endTime - startTime));
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        List columns = args.getListColumns();
        for (IListColumn iListColumn : columns) {
            String listFieldKey = iListColumn.getListFieldKey();
            if (!FIXEDFIELDSET.contains(listFieldKey)) continue;
            iListColumn.setFixed(true);
        }
    }

    public void setFilter(SetFilterEvent e) {
        long startTime = System.currentTimeMillis();
        this.addOrgPermFilter(e.getQFilters(), "org.id");
        long endTime = System.currentTimeMillis();
        this.log.info("================onholdBillList setFilter addOrgPermFilter:{}", (Object)(endTime - startTime));
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName;
        args.setCancel(true);
        BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
        Long pkId = (Long)billList.getFocusRowPkId();
        DynamicObject onHold = OnHoldBillHelper.queryOnHoldByPkId((Long)pkId);
        if (onHold == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u88ab\u5176\u4ed6\u4eba\u5220\u9664\u4e86\u3002", (String)(SIMPLE_NAME + "_3"), (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
            return;
        }
        switch (fieldName = args.getFieldName()) {
            case "person_person_number": {
                this.openOnHoldDetail(onHold);
                break;
            }
            case "caltask_number": {
                CalPayrollTaskHelper.openCalPersonListView((AbstractFormPlugin)this, (Long)onHold.getLong("caltask.id"));
                break;
            }
            case "salaryfile_number": {
                Long salaryFileId = onHold.getLong("salaryfile.id");
                SWCSalaryFileServiceHelper.assembleSalaryFileDataAndOpenFormView((Long)salaryFileId, (IFormView)this.getView());
                break;
            }
        }
    }

    public void beforeBindData(EventObject e) {
        long startTime = System.currentTimeMillis();
        super.beforeBindData(e);
        long endTime = System.currentTimeMillis();
        this.log.info("================onholdBillList beforeBindData beforeBindData:{}", (Object)(endTime - startTime));
        List calStatusDefault = CalPersonStatusDefault.getCalStatusValueMapItems();
        if (calStatusDefault == null || calStatusDefault.isEmpty()) {
            return;
        }
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"hsas_calperson");
        BillStatusProp comboProp = (BillStatusProp)mainType.getProperty("calstatus");
        comboProp.getComboItems().clear();
        comboProp.getComboItems().addAll(calStatusDefault);
    }

    private void openOnHoldDetail(DynamicObject onHold) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsas_onholddetail");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("personid", (Object)onHold.getLong("person.id"));
        showParameter.setCustomParam("onHoldId", (Object)onHold.getLong("id"));
        StringBuilder builder = new StringBuilder();
        builder.append(ResManager.loadKDString((String)"\u505c\u7f13\u53d1", (String)(SIMPLE_NAME + "_5"), (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0])).append(" - ").append(onHold.getString("person.person.name"));
        showParameter.setCaption(builder.toString());
        this.getView().showForm(showParameter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String opKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (opKey = formOperate.getOperateKey()) {
            case "delete": {
                formOperate.getOption().setVariableValue("pageId", this.getView().getPageId());
                break;
            }
            case "donothing_release": {
                RefObject ReleaseAfterConfirm = new RefObject();
                if (formOperate.getOption().tryGetVariableValue(RELEASE_AFTERCONFIRM, ReleaseAfterConfirm)) break;
                List<Long> selectedRowsId = this.getSelectedRowsId();
                OnHoldBillHelper.confirmRelPerson((IFormView)this.getView(), selectedRowsId);
                args.setCancel(true);
                break;
            }
            case "donothing_stoppay": {
                RefObject StopPayAfterConfirm = new RefObject();
                if (formOperate.getOption().tryGetVariableValue(STOPPAY_AFTERCONFIRM, StopPayAfterConfirm)) break;
                List<Long> selectedRowsId = this.getSelectedRowsId();
                OnHoldBillHelper.confirmStopPerson((IFormView)this.getView(), selectedRowsId);
                args.setCancel(true);
                break;
            }
            case "donothing_download": {
                List<Long> selectedRowsId = this.getSelectedRowsId();
                if (selectedRowsId.size() <= 1) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u8fdb\u884c\u4e0b\u8f7d\u3002", (String)(SIMPLE_NAME + "_22"), (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        switch (e.getCallBackId()) {
            case "donothing_release": {
                if (!MessageBoxResult.Yes.equals((Object)e.getResult())) break;
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue(RELEASE_AFTERCONFIRM, "true");
                this.getView().invokeOperation(BTN_DONOTHING_RELEASE, operateOption);
                break;
            }
            case "donothing_stoppay": {
                if (!MessageBoxResult.Yes.equals((Object)e.getResult())) break;
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue(STOPPAY_AFTERCONFIRM, "true");
                this.getView().invokeOperation(BTN_DONOTHING_STOPPAY, operateOption);
                break;
            }
        }
    }

    private List<Long> getSelectedRowsId() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        ArrayList<Long> pKIds = new ArrayList<Long>(selectedRows.size());
        for (ListSelectedRow row : selectedRows) {
            Long primaryKeyValue = Long.valueOf(String.valueOf(row.getPrimaryKeyValue()));
            pKIds.add(primaryKeyValue);
        }
        return pKIds;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{KEY_TOOLBAR});
        Toolbar toolbar = (Toolbar)this.getView().getControl("toolbarap");
        toolbar.addUploadListener((UploadListener)this);
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        String fieldName = args.getFieldName();
        List filters = args.getQFilters();
        switch (fieldName) {
            case "company.name": {
                QFilter companyFilter = new QFilter("orgtype.adminorgtypestd.number", "=", (Object)"1020_S");
                filters.add(companyFilter);
                break;
            }
            case "org.name": {
                this.addOrgPermFilter(filters, "id");
                break;
            }
            case "payrollgroup.name": 
            case "payrollgroup.id": 
            case "caltask.payrollscenev.name": 
            case "caltask.payrollscenev.id": {
                this.setOrgAuthorFilter(filters);
                break;
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        List filters = args.getQfilters();
        switch (fieldName) {
            case "company.id": 
            case "company.name": {
                QFilter companyFilter = new QFilter("orgtype.adminorgtypestd.number", "=", (Object)"1020_S");
                filters.add(companyFilter);
                break;
            }
            case "salaryfile.empgroup.id": 
            case "salaryfile.empgroup.name": {
                QFilter empGroupFilter = new QFilter("id", "in", (Object)SWCPermissionServiceHelper.getEmpgroupByAppNumber((String)"hsas"));
                filters.add(empGroupFilter);
                break;
            }
            case "org.id": 
            case "org.name": {
                this.addOrgPermFilter(filters, "id");
                break;
            }
            case "department.name": 
            case "department.id": {
                QFilter departmentFilter = new QFilter("orgtype.adminorgtypestd.number", "=", (Object)"1040_S");
                filters.add(departmentFilter);
                break;
            }
            case "payrollgroup.name": 
            case "payrollgroup.id": 
            case "caltask.payrollscenev.name": 
            case "caltask.payrollscenev.id": {
                this.setOrgAuthorFilter(filters);
                break;
            }
        }
    }

    public void setOrgAuthorFilter(List<QFilter> qFilters) {
        HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)"hsas_onholdbill", (String)"47150e89000000ac");
        if (permOrgs != null && !permOrgs.hasAllOrgPerm()) {
            List hasPermOrgs = permOrgs.getHasPermOrgs();
            this.log.info("OnHoldBillList.setOrgAuthorFilter: hasPermOrgs is {}", (Object)JSON.toJSONString((Object)hasPermOrgs));
            QFilter permFilter = new QFilter("org", "in", (Object)hasPermOrgs);
            qFilters.add(permFilter);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String opKey;
        switch (opKey = args.getOperateKey()) {
            case "donothing_submit": 
            case "donothing_release": 
            case "donothing_stoppay": 
            case "donothing_undo": {
                this.showOpResult(args, opKey);
                break;
            }
            case "donothing_skiptomsgcfg": {
                this.openMsgCfgPage();
                break;
            }
            case "donothing_resendmsg": {
                this.showResendResult(args);
                break;
            }
            case "donothing_download": {
                this.downloadFile();
                break;
            }
        }
    }

    private void downloadFile() {
        List<Long> selectedRowsId = this.getSelectedRowsId();
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_onholdbill");
        if (!selectedRowsId.isEmpty() && !helper.isExists((Object)selectedRowsId.get(0))) {
            return;
        }
        List urlList = OnHoldDetailHelper.getFileUrls(selectedRowsId);
        if (urlList.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u9644\u4ef6\u4fe1\u606f\u3002", (String)(SIMPLE_NAME + "_30"), (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        for (String url : urlList) {
            if (url.startsWith("http")) {
                this.getView().download(url);
                continue;
            }
            url = OnHoldDetailHelper.getEncodedUrl((String)url);
            this.getView().download(UrlService.getAttachmentFullUrl((String)url));
        }
        MultiLangEnumBridge enumBridge = new MultiLangEnumBridge("\u4e0b\u8f7d\u9644\u4ef6\u6210\u529f", "OnHoldBillList_39", SWC_HSAS_FORMPLUGIN);
        SWCOpLogServiceHelper.addOpLog((String)"hsas", (String)"hsas_onholdbill", (String)BTN_DONOTHING_DOWNLOAD, (String)"", (MultiLangEnumBridge)enumBridge, (String[])new String[0]);
    }

    public void beforeUpload(BeforeUploadEvent evt) {
        List<Long> selectedRowsId = this.getSelectedRowsId();
        if (selectedRowsId.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)(SIMPLE_NAME + "_25"), (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        if (selectedRowsId.size() > 1) {
            return;
        }
        List attachInfoList = evt.getAttachInfos();
        HashMap<String, Map> attacheInfoMap = new HashMap<String, Map>(attachInfoList.size());
        for (Map attachInfo : attachInfoList) {
            String fileName = (String)attachInfo.get("name");
            attacheInfoMap.put(fileName, attachInfo);
        }
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        pageCache.put("attacheInfoMap", attacheInfoMap);
    }

    public void afterUpload(UploadEvent evt) {
        List<Long> selectedRowsId = this.getSelectedRowsId();
        long userId = RequestContext.get().getCurrUserId();
        boolean permFlag = SWCPermissionServiceHelper.hasPerm((long)userId, (String)"/UHMBBGZQ65X", (String)"hsas_onholdlistnew", (String)"1BBRZ331JVCW");
        if (!permFlag) {
            String msg = ResManager.loadKDString((String)"\u65e0\u201c\u505c\u7f13\u53d1\u7ba1\u7406\u5217\u8868\u201d\u7684\u201c\u4e0a\u4f20\u9644\u4ef6\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OnHoldBillList_9", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]);
            MultiLangEnumBridge enumBridge = new MultiLangEnumBridge("\u4e0a\u4f20\u9644\u4ef6", "OnHoldBillList_29", SWC_HSAS_FORMPLUGIN);
            SWCOpLogServiceHelper.addOpLog((String)"hsas", (String)"hsas_onholdbill", (String)BTN_DONOTHING_UPLOAD, (String)"", (MultiLangEnumBridge)enumBridge, (String[])new String[0]);
            this.getView().showErrorNotification(msg);
            return;
        }
        if (selectedRowsId.isEmpty()) {
            MultiLangEnumBridge enumBridge = new MultiLangEnumBridge("\u4e0a\u4f20\u9644\u4ef6\u5931\u8d25", "OnHoldBillList_40", SWC_HSAS_FORMPLUGIN);
            SWCOpLogServiceHelper.addOpLog((String)"hsas", (String)"hsas_onholdbill", (String)BTN_DONOTHING_UPLOAD, (String)"", (MultiLangEnumBridge)enumBridge, (String[])new String[0]);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)(SIMPLE_NAME + "_25"), (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        if (selectedRowsId.size() > 1) {
            MultiLangEnumBridge enumBridge = new MultiLangEnumBridge("\u4e0a\u4f20\u9644\u4ef6\u5931\u8d25", "OnHoldBillList_40", SWC_HSAS_FORMPLUGIN);
            SWCOpLogServiceHelper.addOpLog((String)"hsas", (String)"hsas_onholdbill", (String)BTN_DONOTHING_UPLOAD, (String)"", (MultiLangEnumBridge)enumBridge, (String[])new String[0]);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u8fdb\u884c\u4e0a\u4f20\u3002", (String)(SIMPLE_NAME + "_23"), (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        OnHoldDetailHelper.uploadFiles((UploadEvent)evt, (IListView)((IListView)this.getView()));
        MultiLangEnumBridge enumBridge = new MultiLangEnumBridge("\u4e0a\u4f20\u9644\u4ef6\u6210\u529f", "OnHoldBillList_41", SWC_HSAS_FORMPLUGIN);
        SWCOpLogServiceHelper.addOpLog((String)"hsas", (String)"hsas_onholdbill", (String)BTN_DONOTHING_UPLOAD, (String)"", (MultiLangEnumBridge)enumBridge, (String[])new String[0]);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4e0a\u4f20\u6210\u529f", (String)(SIMPLE_NAME + "_24"), (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]));
    }

    private void openMsgCfgPage() {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setFormId("bos_list");
        listShowParameter.setBillFormId("hsbs_onholdmsgcfg");
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void showOpResult(AfterDoOperationEventArgs args, String opKey) {
        OperationResult operationResult = args.getOperationResult();
        if (operationResult == null) {
            return;
        }
        operationResult.setShowMessage(false);
        int total = operationResult.getBillCount();
        int success = operationResult.getSuccessPkIds().size();
        if (total == success) {
            switch (opKey) {
                case "donothing_submit": {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f", (String)(SIMPLE_NAME + "_0"), (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]));
                    break;
                }
                case "donothing_release": {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u89e3\u85aa\u6210\u529f", (String)(SIMPLE_NAME + "_15"), (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]));
                    break;
                }
                case "donothing_stoppay": {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7ec8\u6b62\u53d1\u653e\u6210\u529f", (String)(SIMPLE_NAME + "_19"), (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]));
                    break;
                }
                case "donothing_undo": {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64a4\u9500\u6210\u529f", (String)(SIMPLE_NAME + "_20"), (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]));
                    break;
                }
            }
            this.getView().invokeOperation("refresh");
            return;
        }
        List operateInfoList = operationResult.getAllErrorOrValidateInfo();
        ArrayList<String> errorMsgList = new ArrayList<String>(operateInfoList.size());
        for (IOperateInfo iOperateInfo : operateInfoList) {
            errorMsgList.add(iOperateInfo.getMessage());
        }
        if (total == 1 && errorMsgList.size() == 1) {
            this.getView().showErrorNotification((String)errorMsgList.get(0));
            return;
        }
        int fail = total - success;
        this.showOpMessage(total, success, fail, errorMsgList, opKey);
        if (success > 0) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.itemClick((ItemClickEvent)evt);
        String opKey = evt.getOperationKey();
        MultiLangEnumBridge enumBridge = null;
        switch (opKey) {
            case "new": {
                String msg = ResManager.loadKDString((String)"\u65e0\u201c\u505c\u7f13\u53d1\u7ba1\u7406\u5217\u8868\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OnHoldBillList_6", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]);
                enumBridge = new MultiLangEnumBridge("\u65b0\u589e", "OnHoldBillList_31", SWC_HSAS_FORMPLUGIN);
                this.checkPerm(evt, opKey, enumBridge, msg);
                break;
            }
            case "donothing_submit": {
                String msg = ResManager.loadKDString((String)"\u65e0\u201c\u505c\u7f13\u53d1\u7ba1\u7406\u5217\u8868\u201d\u7684\u201c\u63d0\u4ea4\u5e76\u751f\u6548\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OnHoldBillList_7", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]);
                enumBridge = new MultiLangEnumBridge("\u63d0\u4ea4\u5e76\u751f\u6548", "OnHoldBillList_2", SWC_HSAS_FORMPLUGIN);
                this.checkPerm(evt, opKey, enumBridge, msg);
                break;
            }
            case "donothing_release": {
                String msg = ResManager.loadKDString((String)"\u65e0\u201c\u505c\u7f13\u53d1\u7ba1\u7406\u5217\u8868\u201d\u7684\u201c\u89e3\u85aa\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OnHoldBillList_8", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]);
                enumBridge = new MultiLangEnumBridge("\u89e3\u85aa", "OnHoldBillList_16", SWC_HSAS_FORMPLUGIN);
                this.checkPerm(evt, opKey, enumBridge, msg);
                break;
            }
            case "donothing_upload": {
                String msg = ResManager.loadKDString((String)"\u65e0\u201c\u505c\u7f13\u53d1\u7ba1\u7406\u5217\u8868\u201d\u7684\u201c\u4e0a\u4f20\u9644\u4ef6\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OnHoldBillList_9", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]);
                enumBridge = new MultiLangEnumBridge("\u4e0a\u4f20\u9644\u4ef6", "OnHoldBillList_29", SWC_HSAS_FORMPLUGIN);
                this.checkPerm(evt, opKey, enumBridge, msg);
                break;
            }
            case "donothing_download": {
                String msg = ResManager.loadKDString((String)"\u65e0\u201c\u505c\u7f13\u53d1\u7ba1\u7406\u5217\u8868\u201d\u7684\u201c\u4e0b\u8f7d\u9644\u4ef6\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OnHoldBillList_10", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]);
                enumBridge = new MultiLangEnumBridge("\u4e0b\u8f7d\u9644\u4ef6", "OnHoldBillList_32", SWC_HSAS_FORMPLUGIN);
                this.checkPerm(evt, opKey, enumBridge, msg);
                break;
            }
            case "delete": {
                String msg = ResManager.loadKDString((String)"\u65e0\u201c\u505c\u7f13\u53d1\u7ba1\u7406\u5217\u8868\u201d\u7684\u201c\u5220\u9664\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OnHoldBillList_11", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]);
                enumBridge = new MultiLangEnumBridge("\u5220\u9664", "OnHoldBillList_33", SWC_HSAS_FORMPLUGIN);
                this.checkPerm(evt, opKey, enumBridge, msg);
                break;
            }
            case "exportlistbyselectfields": {
                String msg = ResManager.loadKDString((String)"\u65e0\u201c\u505c\u7f13\u53d1\u7ba1\u7406\u5217\u8868\u201d\u7684\u201c\u5bfc\u51fa\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OnHoldBillList_12", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]);
                enumBridge = new MultiLangEnumBridge("\u5bfc\u51fa", "OnHoldBillList_34", SWC_HSAS_FORMPLUGIN);
                this.checkPerm(evt, opKey, enumBridge, msg);
                break;
            }
            case "donothing_stoppay": {
                String msg = ResManager.loadKDString((String)"\u65e0\u201c\u505c\u7f13\u53d1\u7ba1\u7406\u5217\u8868\u201d\u7684\u201c\u7ec8\u6b62\u53d1\u653e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OnHoldBillList_17", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]);
                enumBridge = new MultiLangEnumBridge("\u7ec8\u6b62\u53d1\u653e", "OnHoldBillList_35", SWC_HSAS_FORMPLUGIN);
                this.checkPerm(evt, opKey, enumBridge, msg);
                break;
            }
            case "donothing_undo": {
                String msg = ResManager.loadKDString((String)"\u65e0\u201c\u505c\u7f13\u53d1\u7ba1\u7406\u5217\u8868\u201d\u7684\u201c\u64a4\u9500\u201d\u6743\u9650,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OnHoldBillList_18", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]);
                enumBridge = new MultiLangEnumBridge("\u64a4\u9500", "OnHoldBillList_36", SWC_HSAS_FORMPLUGIN);
                this.checkPerm(evt, opKey, enumBridge, msg);
                break;
            }
            case "donothing_skiptomsgcfg": {
                String msg = ResManager.loadKDString((String)"\u65e0\u201c\u505c\u7f13\u53d1\u7ba1\u7406\u5217\u8868\u201d\u7684\u201c\u6d88\u606f\u914d\u7f6e\u201d\u6743\u9650,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OnHoldBillList_27", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]);
                enumBridge = new MultiLangEnumBridge("\u6d88\u606f\u914d\u7f6e", "OnHoldBillList_37", SWC_HSAS_FORMPLUGIN);
                this.checkPerm(evt, opKey, enumBridge, msg);
                break;
            }
            case "donothing_resendmsg": {
                String msg = ResManager.loadKDString((String)"\u65e0\u201c\u505c\u7f13\u53d1\u7ba1\u7406\u5217\u8868\u201d\u7684\u201c\u91cd\u53d1\u6d88\u606f\u201d\u6743\u9650,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OnHoldBillList_28", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]);
                enumBridge = new MultiLangEnumBridge("\u91cd\u53d1\u6d88\u606f", "OnHoldBillList_38", SWC_HSAS_FORMPLUGIN);
                this.checkPerm(evt, opKey, enumBridge, msg);
                break;
            }
        }
    }

    private void checkPerm(BeforeItemClickEvent evt, String opKey, MultiLangEnumBridge enumBridge, String msg) {
        String permItemId = BTNTOFIDMAP.get(opKey);
        long userId = RequestContext.get().getCurrUserId();
        boolean permFlag = SWCPermissionServiceHelper.hasPerm((long)userId, (String)"/UHMBBGZQ65X", (String)"hsas_onholdlistnew", (String)permItemId);
        if (!permFlag) {
            this.getView().showErrorNotification(msg);
            evt.setCancel(true);
            SWCOpLogServiceHelper.addOpLog((String)"hsas", (String)"hsas_onholdbill", (String)opKey, (String)"", (MultiLangEnumBridge)enumBridge, (String[])new String[0]);
        }
    }

    private void showResendResult(AfterDoOperationEventArgs args) {
        int success;
        OperationResult operationResult = args.getOperationResult();
        if (operationResult == null) {
            return;
        }
        int total = operationResult.getBillCount();
        if (total == (success = operationResult.getSuccessPkIds().size())) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u53d1\u6d88\u606f\u6210\u529f", (String)(SIMPLE_NAME + "_13"), (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
            return;
        }
        if (total == 1 && success == 0) {
            return;
        }
        operationResult.setShowMessage(false);
        List operateInfoList = operationResult.getAllErrorOrValidateInfo();
        ArrayList<String> errorMsgList = new ArrayList<String>(operateInfoList.size());
        for (IOperateInfo iOperateInfo : operateInfoList) {
            errorMsgList.add(iOperateInfo.getMessage());
        }
        int fail = total - success;
        this.showResendMessage(total, success, fail, errorMsgList);
        if (success > 0) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void showOpMessage(int total, int success, int fail, List<String> errorMsgList, String opKey) {
        String message = MessageFormat.format(ResManager.loadKDString((String)"\u5171\u9009\u62e9{0}\u6761\u8bb0\u5f55\uff0c{1}\u6761\u6210\u529f\uff0c{2}\u6761\u5931\u8d25\u3002", (String)(SIMPLE_NAME + "_1"), (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]), total, success, fail);
        FormShowParameter parameters = null;
        switch (opKey) {
            case "donothing_submit": {
                parameters = SWCShowFormServiceHelper.getOperationResultParameter((String)ResManager.loadKDString((String)"\u63d0\u4ea4\u5e76\u751f\u6548", (String)(SIMPLE_NAME + "_4"), (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]), (String)message, errorMsgList);
                break;
            }
            case "donothing_release": {
                parameters = SWCShowFormServiceHelper.getOperationResultParameter((String)ResManager.loadKDString((String)"\u89e3\u85aa", (String)(SIMPLE_NAME + "_16"), (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]), (String)message, errorMsgList);
                break;
            }
            case "donothing_stoppay": {
                parameters = SWCShowFormServiceHelper.getOperationResultParameter((String)ResManager.loadKDString((String)"\u7ec8\u6b62\u53d1\u653e", (String)(SIMPLE_NAME + "_21"), (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]), (String)message, errorMsgList);
                break;
            }
            case "donothing_undo": {
                parameters = SWCShowFormServiceHelper.getOperationResultParameter((String)ResManager.loadKDString((String)"\u64a4\u9500", (String)(SIMPLE_NAME + "_26"), (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]), (String)message, errorMsgList);
                break;
            }
        }
        this.getView().showForm(parameters);
    }

    private void showResendMessage(int total, int success, int fail, List<String> errorMsgList) {
        String message = ResManager.loadKDString((String)"\u5171\u9009\u62e9{0}\u6761\u8bb0\u5f55\uff0c{1}\u6761\u6210\u529f\uff0c{2}\u6761\u5931\u8d25\u3002", (String)(SIMPLE_NAME + "_1"), (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[]{total, success, fail});
        FormShowParameter parameters = SWCShowFormServiceHelper.getOperationResultParameter((String)ResManager.loadKDString((String)"\u91cd\u53d1\u6d88\u606f", (String)(SIMPLE_NAME + "_14"), (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]), (String)message, errorMsgList);
        this.getView().showForm(parameters);
    }

    private void addOrgPermFilter(List<QFilter> filters, String propKey) {
        HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)"hsas_onholdbill", (String)"47150e89000000ac");
        if (permOrgs != null) {
            if (permOrgs.hasAllOrgPerm()) {
                return;
            }
            List hasPermOrgs = permOrgs.getHasPermOrgs();
            QFilter permFilter = new QFilter(propKey, "in", (Object)hasPermOrgs);
            filters.add(permFilter);
        }
    }

    private void setGridScaleField(PackageDataEvent event, String fieldKey) {
        DynamicObject rowData = event.getRowData();
        BigDecimal amount = rowData.getBigDecimal(fieldKey);
        String onHoldId = rowData.getString("id");
        if (amount == null || onHoldId == null) {
            return;
        }
        Map<String, Object> onHoldMap = this.onHoldInfoMap.get(onHoldId);
        if (onHoldMap != null) {
            String calCurrencySign = (String)onHoldMap.get("calcurrency.sign");
            int dataPrecision = 2;
            String payOutItemId = (String)onHoldMap.get("payoutitem.id");
            if (payOutItemId != null && this.dataPrecisionMap.get(payOutItemId) != null) {
                dataPrecision = this.dataPrecisionMap.get(payOutItemId);
            }
            String formatValue = "";
            event.setFormatValue((Object)formatValue);
            amount = OnHoldDetailHelper.getScaleFormatValue((BigDecimal)amount, (int)dataPrecision);
            if (KEY_CALAMOUNT.equals(fieldKey) && (amount.intValue() != 0 || calCurrencySign != null)) {
                formatValue = String.join((CharSequence)"", calCurrencySign == null ? "" : calCurrencySign, amount.toPlainString());
                event.setFormatValue((Object)formatValue);
            }
            if (rowData.getDynamicObjectType().getProperties().tryGetValue("status", new RefObject())) {
                int onHoldStatus = rowData.getInt("status");
                if (calCurrencySign != null && KEY_RELEASECALAMOUNT.equals(fieldKey) && OnHoldStatusEnum.STATUS_RELEASE.getCode() == onHoldStatus) {
                    formatValue = String.join((CharSequence)"", calCurrencySign, amount.toPlainString());
                    event.setFormatValue((Object)formatValue);
                }
            }
        }
    }

    static {
        BTNTOFIDMAP.put("new", "47156aff000000ac");
        BTNTOFIDMAP.put(BTN_DONOTHING_SUBMIT, "0A3CBG6XWQC5");
        BTNTOFIDMAP.put(BTN_DONOTHING_RELEASE, "0ZCQINOEA/CJ");
        BTNTOFIDMAP.put(BTN_DONOTHING_UPLOAD, "1BBRZ331JVCW");
        BTNTOFIDMAP.put(BTN_DONOTHING_DOWNLOAD, "1Z3XAIKM8D4X");
        BTNTOFIDMAP.put("delete", "4715e1f1000000ac");
        BTNTOFIDMAP.put("exportlistbyselectfields", "0YH1MN9OTQ4J");
        BTNTOFIDMAP.put(BTN_DONOTHING_STOPPAY, "0ZCQNHVFZW0E");
        BTNTOFIDMAP.put(BTN_DONOTHING_UNDO, "80513207000000ac");
        BTNTOFIDMAP.put(BTN_DONOTHING_SKIPTOMSGCFG, "13ZV0EY+DM43");
        BTNTOFIDMAP.put(BTN_DONOTHING_RESENDMSG, "13ZV+U8YYC=L");
        FIXEDFIELDSET.add("fseq");
        FIXEDFIELDSET.add("person.person.name");
        FIXEDFIELDSET.add("person.person.number");
        FIXEDFIELDSET.add("status");
        FIXEDFIELDSET.add("salaryfile.number");
    }
}

