/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.onhold;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.person.PersonHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCImageUrlUtil;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class OnHoldPersonPreviewPlugin
extends AbstractFormPlugin {
    private static final String SELECT_PERSON_PROPS = "person.headsculpture, empnumber, person.name, person.id";
    private static final String SELECT_SALARY_FILE_PROPS = "status, payrollgroup, paystatus, empgroup, empposinfo,org,payrollregion,payrollgroup,salarycalcstyle";
    private static final String SELECT_EMP_PROPS = "adminorg, position, job, company, startdate,postype,posstatus";
    private static final String SELECT_EMPENTREL_PROPS = "laborreltype,laborrelstatus";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Long employeeId = PersonHelper.getPersonId((IFormView)this.getView());
        this.getView().setVisible(Boolean.FALSE, new String[]{"laborreltype", "laborrelstatus", "postype", "posstatus", "salarycalcstyle"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"vectorap1", "company", "vectorap2", "adminorg", "vectorap3", "positionlabelap", "vectorap4", "workplacelabelap"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"labeltxt1", "labeltxt2", "labeltxt3"});
        if (null != employeeId) {
            DynamicObject employee = this.getEmployee(employeeId);
            this.setFieldValue(employee);
        }
    }

    private DynamicObject getEmployee(Object employeeId) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_employee");
        return serviceHelper.queryOne(SELECT_PERSON_PROPS, employeeId);
    }

    private void setFieldValue(DynamicObject employeeDyobj) {
        if (null != employeeDyobj) {
            IFormView formView = this.getView();
            QFilter personFilter = new QFilter("person", "=", (Object)employeeDyobj.getLong("person.id"));
            SWCDataServiceHelper empentrelHelper = new SWCDataServiceHelper("hsas_empentrel");
            DynamicObject empentrelObj = empentrelHelper.queryOne(SELECT_EMPENTREL_PROPS, new QFilter[]{personFilter});
            if (null != empentrelObj) {
                this.setLabelValue("laborreltype", empentrelObj.getString("laborreltype.name"), formView);
                this.setLabelValue("laborrelstatus", empentrelObj.getString("laborrelstatus.name"), formView);
            }
            SWCDataServiceHelper empHelper = new SWCDataServiceHelper("hsas_empposorgrelhr");
            QFilter empIdFilter = new QFilter("employee.id", "=", (Object)employeeDyobj.getLong("id"));
            DynamicObject empObj = empHelper.queryOne(SELECT_EMP_PROPS, new QFilter[]{empIdFilter}, "sysenddate desc");
            if (null != empObj) {
                this.setLabelValue("postype", empObj.getString("postype.name"), formView);
                this.setLabelValue("posstatus", empObj.getString("posstatus.name"), formView);
                this.setLabelValueGroup("vectorap1", "company", empObj.getString("company.name"), formView);
                this.setLabelValueGroup("vectorap2", "adminorg", empObj.getString("adminorg.name"), formView);
                String positionInfo = empObj.getString("position.name");
                String jobInfo = empObj.getString("job.name");
                String jobLabel = SWCStringUtils.isEmpty((String)positionInfo) ? (SWCStringUtils.isEmpty((String)jobInfo) ? "" : jobInfo) : positionInfo;
                this.setLabelValueGroup("vectorap3", "positionlabelap", jobLabel, formView);
            }
            SWCDataServiceHelper managingScopeHelper = new SWCDataServiceHelper("hsas_managingscope");
            DynamicObject managingScopeObj = managingScopeHelper.queryOne("workplace", new QFilter[]{personFilter});
            if (null != managingScopeObj) {
                this.setLabelValueGroup("vectorap4", "workplacelabelap", managingScopeObj.getString("workplace.name"), formView);
            }
            this.setPortrait(employeeDyobj.getString("person.headsculpture"));
            this.setLabelValue("name", employeeDyobj.getString("person.name"), formView);
            this.setLabelValue("empnumber", employeeDyobj.getString("empnumber"), formView);
        }
    }

    private void setPortrait(String portraitUrl) {
        Image portrait = (Image)this.getControl("headsculpture");
        if (null != portraitUrl) {
            portrait.setUrl(SWCImageUrlUtil.getImageFullUrl((String)portraitUrl));
        } else {
            portrait.setUrl("/images/pc/emotion/default_person_82_82.png");
        }
    }

    private void setLabelValue(String fieldKey, String value, IFormView formView) {
        Label label = (Label)this.getControl(fieldKey);
        if (!SWCStringUtils.isEmpty((String)value)) {
            label.setText(value);
            formView.setVisible(Boolean.TRUE, new String[]{fieldKey});
        }
    }

    private void setLabelValueGroup(String icon, String fieldKey, String value, IFormView formView) {
        Label label = (Label)this.getControl(fieldKey);
        if (!SWCStringUtils.isEmpty((String)value)) {
            label.setText(value);
            formView.setVisible(Boolean.TRUE, new String[]{icon, fieldKey});
        }
    }
}

