/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.payschedule;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.payschedule.PayBizProcHelper;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class PayBizProcEdit
extends SWCDataBaseEdit
implements BeforeF7SelectListener {
    private static final String DELETE_ENTRY_ROW_ID = "delete_entry_row_id";
    private static final String STEP_TYPE = "steptype";
    public static final String SWC_HSAS_FORMPLUGIN = "swc-hsas-formplugin";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        BasedataEdit edit = (BasedataEdit)this.getView().getControl("prepaybizaction");
        edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.initEntryNode();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setEntryFirstLineLock();
        this.getView().getPageCache().put("BOS.setRowDataByNumberDisable", "true");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String opKey = formOperate.getOperateKey();
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        int[] selIndexs = proxy.getEntryState("entryentity").getSelectedRows();
        block7 : switch (opKey) {
            case "deleteentry": {
                for (int selIndex : selIndexs) {
                    if (selIndex == 0) {
                        args.setCancel(true);
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u884c\u5305\u542b\u201c\u5f00\u59cb\u201d\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"PayBizProcEdit_0", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]));
                        break block7;
                    }
                    if (selIndex + 1 == this.getModel().getEntryRowCount("entryentity")) {
                        args.setCancel(true);
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u884c\u5305\u542b\u201c\u7ed3\u675f\u201d\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"PayBizProcEdit_1", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]));
                        break block7;
                    }
                    DynamicObject payBizActDy = (DynamicObject)this.getModel().getValue("paybizaction", selIndex);
                    if (payBizActDy != null) {
                        formOperate.getOption().setVariableValue(DELETE_ENTRY_ROW_ID, payBizActDy.getString("id"));
                        continue;
                    }
                    formOperate.getOption().setVariableValue(DELETE_ENTRY_ROW_ID, "0");
                }
                break;
            }
            case "moveentryup": {
                for (int selIndex : selIndexs) {
                    if (selIndex == 1) {
                        args.setCancel(true);
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u4e0a\u79fb\u6240\u9009\u884c\u3002", (String)"PayBizProcEdit_2", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]));
                        break block7;
                    }
                    if (selIndex + 1 != this.getModel().getEntryRowCount("entryentity")) continue;
                    args.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u884c\u5305\u542b\u201c\u7ed3\u675f\u201d\uff0c\u65e0\u6cd5\u79fb\u52a8\u3002", (String)"PayBizProcEdit_3", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]));
                    break block7;
                }
                break;
            }
            case "moveentrydown": {
                for (int selIndex : selIndexs) {
                    if (selIndex == 0) {
                        args.setCancel(true);
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u884c\u5305\u542b\u201c\u5f00\u59cb\u201d\uff0c\u65e0\u6cd5\u79fb\u52a8\u3002", (String)"PayBizProcEdit_4", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]));
                        break block7;
                    }
                    if (selIndex + 2 != this.getModel().getEntryRowCount("entryentity")) continue;
                    args.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u4e0b\u79fb\u6240\u9009\u884c\u3002", (String)"PayBizProcEdit_5", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]));
                    break block7;
                }
                break;
            }
            case "save": 
            case "submit": {
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                if (!this.isEntryCorrectFilled(entryEntity)) {
                    args.setCancel(true);
                    args.setCancelMessage("fail");
                    return;
                }
                this.getView().invokeOperation("sortbyauto");
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        super.afterDoOperation(eventArgs);
        String operateKey = eventArgs.getOperateKey();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        switch (operateKey) {
            case "sortbyauto": {
                if (!this.isEntryCorrectFilled(entryEntity)) {
                    eventArgs.getOperationResult().setMessage("0");
                    return;
                }
                this.sortPayTasks(entryEntity);
                break;
            }
            case "viewflowchart": {
                if (!this.isEntryCorrectFilled(entryEntity)) {
                    eventArgs.getOperationResult().setMessage("0");
                    return;
                }
                this.sortPayTasks(entryEntity);
                PayBizProcHelper.viewFlowChart((IFormView)this.getView(), (DynamicObjectCollection)entryEntity, (String)this.getModel().getDataEntity().getString("name"));
                break;
            }
            case "deleteentry": {
                FormOperate formOperate = (FormOperate)eventArgs.getSource();
                String payBizActId = formOperate.getOption().getVariableValue(DELETE_ENTRY_ROW_ID);
                if (SWCObjectUtils.isEmpty((Object)payBizActId)) break;
                this.deleteEntryAdjustPreActs(payBizActId);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String fieldKey;
        switch (fieldKey = event.getProperty().getName()) {
            case "prepaybizaction": {
                DynamicObject dataEntity = this.getModel().getDataEntity(true);
                DynamicObjectCollection dyColl = dataEntity.getDynamicObjectCollection("entryentity");
                ArrayList<Long> payTaskIds = new ArrayList<Long>(dyColl.size());
                int index = 0;
                int row = event.getRow();
                for (DynamicObject entryDyObj : dyColl) {
                    if (index != row && index + 1 != dyColl.size()) {
                        payTaskIds.add(entryDyObj.getLong("paybizaction.id"));
                    }
                    ++index;
                }
                ListShowParameter param = (ListShowParameter)event.getFormShowParameter();
                param.getListFilterParameter().getQFilters().add(new QFilter("id", "in", payTaskIds));
            }
        }
    }

    private void initEntryNode() {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        TableValueSetter addVS = vs.addRow(new Object[0]);
        addVS.set("paybizaction", (Object)1139088596750377984L, 0);
        addVS.set("paybizaction", (Object)1139088905400819712L, 1);
        model.batchCreateNewEntryRow("entryentity", vs);
    }

    private boolean isEntryCorrectFilled(DynamicObjectCollection dyColl) {
        if (!this.isFillPrePayTask(dyColl)) {
            return false;
        }
        return !this.isExistCycle(dyColl);
    }

    private void sortPayTasks(DynamicObjectCollection dyColl) {
        int entryRowCount = this.getModel().getEntryRowCount("entryentity");
        Map entryNextMap = PayBizProcHelper.getEntryNextMap((DynamicObjectCollection)dyColl);
        LinkedHashSet<Long> needSortPayTasks = new LinkedHashSet<Long>((Collection)entryNextMap.get(String.valueOf(1139088596750377984L)));
        ArrayList<Long> nextPayTasks = new ArrayList<Long>(needSortPayTasks);
        LinkedHashSet<Long> payTaskQueue = new LinkedHashSet<Long>(entryRowCount);
        payTaskQueue.add(1139088596750377984L);
        LinkedHashMap<Long, Integer> nodeLengthMap = new LinkedHashMap<Long, Integer>(entryRowCount);
        PayBizProcHelper.setNodeLengthDoLoop((Long)1139088596750377984L, nextPayTasks, (Map)entryNextMap, nodeLengthMap, (Integer)0);
        this.setOrderQueue(nodeLengthMap, payTaskQueue);
        this.setOrderDoLoop(needSortPayTasks, nextPayTasks, entryNextMap, payTaskQueue);
        this.sortEntryAsc(payTaskQueue);
    }

    private void setOrderQueue(Map<Long, Integer> nodeLengthMap, Set<Long> payTaskQueue) {
        ArrayList<Map.Entry<Long, Integer>> entryList = new ArrayList<Map.Entry<Long, Integer>>(nodeLengthMap.entrySet());
        entryList.sort(new Comparator<Map.Entry<Long, Integer>>(){

            @Override
            public int compare(Map.Entry<Long, Integer> entryA, Map.Entry<Long, Integer> entryB) {
                return entryA.getValue() - entryB.getValue();
            }
        });
        for (Map.Entry entry : entryList) {
            payTaskQueue.add((Long)entry.getKey());
        }
    }

    private void sortEntryAsc(Set<Long> payTasksOrder) {
        int index = 0;
        for (Long payTaskId : payTasksOrder) {
            int payTaskIndexInEntry = this.getPayTaskIndexInEntry(payTaskId);
            int length = payTaskIndexInEntry - index;
            for (int i = 0; i < Math.abs(length); ++i) {
                if (length > 0) {
                    this.getView().getModel().moveEntryRowUp("entryentity", payTaskIndexInEntry - i);
                    continue;
                }
                this.getView().getModel().moveEntryRowDown("entryentity", payTaskIndexInEntry + i);
            }
            ++index;
        }
        this.setEntryFirstLineLock();
    }

    private void setOrderDoLoop(Set<Long> needSortPayTasks, List<Long> nextPayTasks, Map<String, List<Long>> entryNextMap, Set<Long> payTaskQueue) {
        for (Long nextPayTask : nextPayTasks) {
            payTaskQueue.add(nextPayTask);
            needSortPayTasks.remove(nextPayTask);
            List<Long> nextNextPayTasks = entryNextMap.get(String.valueOf(nextPayTask));
            if (nextNextPayTasks.isEmpty()) continue;
            needSortPayTasks.addAll(nextNextPayTasks);
        }
        if (needSortPayTasks.isEmpty()) {
            return;
        }
        this.setOrderDoLoop(needSortPayTasks, new ArrayList<Long>(needSortPayTasks), entryNextMap, payTaskQueue);
    }

    private boolean isFillPrePayTask(DynamicObjectCollection dyColl) {
        long payTaskId;
        int index = 0;
        for (DynamicObject dyObj : dyColl) {
            DynamicObjectCollection prePayTaskDyColl = dyObj.getDynamicObjectCollection("prepaybizaction");
            payTaskId = dyObj.getLong("paybizaction.id");
            if ((prePayTaskDyColl == null || prePayTaskDyColl.isEmpty()) && 1139088596750377984L != payTaskId) {
                this.getView().showErrorNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7b2c%d\u884c\uff1a\u201c\u524d\u5e8f\u65e5\u7a0b\u201d\u672a\u6309\u8981\u6c42\u586b\u5199\u3002", (String)"PayBizProcEdit_6", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]), index + 1));
                return false;
            }
            ++index;
        }
        Set<Long> prePayTasks = this.getPrePayTasks();
        index = 0;
        for (DynamicObject dyObj : dyColl) {
            payTaskId = dyObj.getLong("paybizaction.id");
            if (payTaskId == 0L) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7b97\u53d1\u85aa\u6b65\u9aa4\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"PayBizProcEdit_11", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]));
                return false;
            }
            if (!prePayTasks.contains(payTaskId) && 1139088905400819712L != payTaskId) {
                DynamicObject payTaskDyObjInEntry = this.getPayTaskDyObjInEntry(payTaskId);
                this.getView().showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff1a\u201c{1}\u201d\u201c{2}\u201d\uff0c\u672a\u7f16\u6392\u8fdb\u6d41\u7a0b\uff0c\u8bf7\u68c0\u67e5\u540e\u586b\u5199\u3002", (String)"PayBizProcEdit_7", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]), index + 1, payTaskDyObjInEntry.getString("number"), payTaskDyObjInEntry.getString("name")));
                return false;
            }
            ++index;
        }
        return true;
    }

    private Set<Long> getPrePayTasks() {
        HashSet<Long> prePayTasks = new HashSet<Long>(10);
        DynamicObjectCollection dyColl = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject dyObj : dyColl) {
            DynamicObjectCollection mulBaseData = dyObj.getDynamicObjectCollection("prepaybizaction");
            for (DynamicObject prepaybizaction : mulBaseData) {
                prePayTasks.add(prepaybizaction.getLong("fbasedataid_id"));
            }
        }
        return prePayTasks;
    }

    private boolean isExistCycle(DynamicObjectCollection dyColl) {
        Map entryPreMap = PayBizProcHelper.getEntryPreMap((DynamicObjectCollection)dyColl);
        Stack<Long> postPayTasks = new Stack<Long>();
        HashSet<Long> payTaskInLine = new HashSet<Long>(entryPreMap.size());
        HashMap<Long, Set<Long>> existCyclePayTasks = new HashMap<Long, Set<Long>>(10);
        int isExistStartNode = this.findCycleDoLoop(1139088905400819712L, postPayTasks, entryPreMap, existCyclePayTasks, payTaskInLine);
        payTaskInLine.add(1139088596750377984L);
        if (isExistStartNode == 0 && existCyclePayTasks.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7b2c1\u884c\uff1a\u201cProcStart\u201d\u201c\u5f00\u59cb\u201d\uff0c\u672a\u7f16\u6392\u8fdb\u6d41\u7a0b\uff0c\u8bf7\u68c0\u67e5\u540e\u586b\u5199\u3002", (String)"PayBizProcEdit_8", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]));
            return true;
        }
        for (Map.Entry entry : existCyclePayTasks.entrySet()) {
            Long payTaskId = (Long)entry.getKey();
            Set cycleIds = (Set)entry.getValue();
            int payTaskIndexInEntry = this.getPayTaskIndexInEntry(payTaskId);
            DynamicObject payTaskDy = this.getPayTaskDyObjInEntry(payTaskId);
            String payTaskName = payTaskDy.getString("name");
            for (Long cyclrId : cycleIds) {
                DynamicObject cyclrPayTaskDy = this.getPayTaskDyObjInEntry(cyclrId);
                String cyclrPayTaskName = cyclrPayTaskDy.getString("name");
                if (cyclrPayTaskName == null) continue;
                this.getView().showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\uff1a{1}\u4e0e{2}\u5b58\u5728\u5faa\u73af\u5f15\u7528\uff0c\u8bf7\u91cd\u65b0\u7ef4\u62a4\u6d41\u7a0b\u3002", (String)"PayBizProcEdit_9", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]), payTaskIndexInEntry + 1, payTaskName, cyclrPayTaskName));
                return true;
            }
        }
        if (payTaskInLine.size() != entryPreMap.size()) {
            Set payTaskIds = entryPreMap.keySet();
            for (Long payTaskId : payTaskIds) {
                if (payTaskInLine.contains(payTaskId)) continue;
                DynamicObject payTaskDy = this.getPayTaskDyObjInEntry(payTaskId);
                String payTaskName = payTaskDy.getString("name");
                String payTaskNumber = payTaskDy.getString("number");
                this.getView().showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"\u201c{0}\u201d\u201c{1}\u201d\u672a\u7f16\u6392\u8fdb\u4e3b\u6d41\u7a0b\uff0c\u8bf7\u68c0\u67e5\u540e\u586b\u5199\u3002", (String)"PayBizProcEdit_10", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]), payTaskNumber, payTaskName));
                return true;
            }
        }
        return false;
    }

    private int findCycleDoLoop(Long payTask, Stack<Long> postPayTasks, Map<Long, List<Long>> entryPreMap, Map<Long, Set<Long>> existCyclePayTasks, Set<Long> payTaskInLine) {
        payTaskInLine.add(payTask);
        postPayTasks.push(payTask);
        List<Long> prePayTasks = entryPreMap.get(payTask);
        int result = 0;
        for (Long prePayTask : prePayTasks) {
            if (postPayTasks.contains(prePayTask)) {
                Set<Long> cycleIds = existCyclePayTasks.get(payTask);
                if (cycleIds == null) {
                    cycleIds = new HashSet<Long>(10);
                }
                cycleIds.add(prePayTask);
                existCyclePayTasks.put(payTask, cycleIds);
                break;
            }
            List<Long> prePrePayTasks = entryPreMap.get(prePayTask);
            if (prePrePayTasks == null || prePrePayTasks.isEmpty()) {
                ++result;
                continue;
            }
            result += this.findCycleDoLoop(prePayTask, postPayTasks, entryPreMap, existCyclePayTasks, payTaskInLine);
        }
        postPayTasks.pop();
        return result;
    }

    private int getPayTaskIndexInEntry(Long payTaskId) {
        DynamicObjectCollection dyColl = this.getView().getModel().getEntryEntity("entryentity");
        int index = 0;
        for (DynamicObject dyObj : dyColl) {
            if (payTaskId.longValue() == dyObj.getLong("paybizaction.id")) {
                return index;
            }
            ++index;
        }
        return index;
    }

    private DynamicObject getPayTaskDyObjInEntry(Long payTaskId) {
        DynamicObjectCollection dyColl = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject dyObj : dyColl) {
            if (payTaskId.longValue() != dyObj.getLong("paybizaction.id")) continue;
            return dyObj.getDynamicObject("paybizaction");
        }
        return new DynamicObject();
    }

    private void setEntryFirstLineLock() {
        this.getView().updateView("entryentity");
        this.getView().setEnable(Boolean.FALSE, 0, new String[]{"prepaybizaction"});
    }

    private void deleteEntryAdjustPreActs(String payBizActId) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        block0: for (int m = 1; m < entryEntity.size(); ++m) {
            DynamicObject entryDy = (DynamicObject)entryEntity.get(m);
            DynamicObjectCollection prePayBizActDyColl = entryDy.getDynamicObjectCollection("prepaybizaction");
            if (prePayBizActDyColl.isEmpty()) continue;
            for (DynamicObject prePayBizActDy : prePayBizActDyColl) {
                if (prePayBizActDy.get("fbasedataid") != null && !SWCObjectUtils.equals((Object)prePayBizActDy.getString("fbasedataid_id"), (Object)payBizActId)) continue;
                this.copyMulBaseDataField(entryDy, "prepaybizaction", payBizActId);
                continue block0;
            }
        }
        this.setEntryFirstLineLock();
    }

    private void copyMulBaseDataField(DynamicObject newDyObj, String mulBaseDataField, String payBizActId) {
        DynamicObjectCollection newMulBasedataColl = new DynamicObjectCollection();
        DynamicObjectCollection mulBasedataColl = newDyObj.getDynamicObjectCollection(mulBaseDataField);
        for (DynamicObject mulBasedataDy : mulBasedataColl) {
            DynamicObject copyDynObj = (DynamicObject)OrmUtils.clone((IDataEntityBase)mulBasedataDy, (boolean)false, (boolean)true);
            copyDynObj.getDataEntityState().setDirty(true);
            if (SWCObjectUtils.equals((Object)mulBasedataDy.getString("fbasedataid_id"), (Object)payBizActId)) continue;
            newMulBasedataColl.add((Object)copyDynObj);
        }
        newDyObj.set(mulBaseDataField, (Object)newMulBasedataColl);
    }
}

