/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.payschedule;

import java.util.EventObject;
import java.util.HashSet;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.swc.hsas.business.payschedule.PayScheduleHelper;
import kd.swc.hsas.formplugin.web.payschedule.PayScheduleEdit;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class PaySchCusEdit
extends PayScheduleEdit
implements BeforeF7SelectListener {
    public static final String PAYROLLGRPV = "payrollgrpv";
    public static final String CALPERIOD = "calperiod";
    public static final String PAYROLLGRP = "payrollgrp";
    public static final String PAYROLLSCENE = "payrollscene";
    private static final String CALPERIODTYPE = "calperiodtype";
    private static final Log logger = LogFactory.getLog(PaySchCusEdit.class);

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit payrollgrp = (BasedataEdit)this.getView().getControl(PAYROLLGRP);
        payrollgrp.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit payrollgrpv = (BasedataEdit)this.getView().getControl(PAYROLLGRPV);
        payrollgrpv.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit calperiod = (BasedataEdit)this.getView().getControl(CALPERIOD);
        calperiod.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit calperiodType = (BasedataEdit)this.getView().getControl(CALPERIODTYPE);
        calperiodType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit payrollscene = (BasedataEdit)this.getView().getControl(PAYROLLSCENE);
        payrollscene.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String data = (String)this.getView().getFormShowParameter().getCustomParam("data");
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (Objects.nonNull(data)) {
            DynamicObject paySchDy = (DynamicObject)SerializationUtils.deSerializeFromBase64((String)data);
            SWCHisBaseDataHelper.transferDynamicObject((DynamicObject)paySchDy, (DynamicObject)dataEntity, null, null);
        } else {
            this.getModel().setValue("status", (Object)"A");
        }
        this.initView(dataEntity);
    }

    public void initView(DynamicObject dataEntity) {
        this.refreshLabelConfig();
        this.getView().setEnable(Boolean.valueOf(Objects.nonNull(dataEntity.get(PAYROLLGRP))), new String[]{PAYROLLGRPV});
        this.getView().setEnable(Boolean.valueOf(Objects.nonNull(dataEntity.get(PAYROLLGRPV))), new String[]{PAYROLLSCENE});
        this.getView().setEnable(Boolean.valueOf(Objects.nonNull(dataEntity.get(PAYROLLSCENE))), new String[]{CALPERIOD});
        if (!"A".equals(this.getModel().getValue("status"))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"number", "name", PAYROLLGRP, PAYROLLSCENE, "startdate", "enddate", "tracker", "description", PAYROLLGRPV, CALPERIOD});
            this.getView().setVisible(Boolean.FALSE, new String[]{"btncancel", "btnok"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"btnclose"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"btncancel", "btnok"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"btnclose"});
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        Boolean isNotEmpty = Objects.nonNull(e.getChangeSet()[0].getNewValue());
        switch (name) {
            case "tracker": {
                PayScheduleHelper.setEntryByTrackersChanged((IFormView)this.getView(), (boolean)false, (String)"entryentity");
                break;
            }
            case "payrollscene": {
                this.getModel().setValue(CALPERIOD, null);
                this.getModel().setValue(CALPERIODTYPE, null);
                this.getView().setEnable(isNotEmpty, new String[]{CALPERIOD});
                if (!Boolean.TRUE.equals(isNotEmpty)) break;
                this.getModel().setValue(CALPERIODTYPE, this.getModel().getDataEntity().get("payrollscene.periodtype.id"));
                break;
            }
            case "payrollgrp": {
                PayScheduleHelper.changePayRollGrp((ChangeData[])e.getChangeSet(), (IFormView)this.getView(), (IDataModel)this.getModel());
                this.getView().setEnable(isNotEmpty, new String[]{PAYROLLGRPV});
                break;
            }
            case "payrollgrpv": {
                this.getModel().setValue(PAYROLLSCENE, null);
                this.getView().setEnable(isNotEmpty, new String[]{PAYROLLSCENE});
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String fieldKey = event.getProperty().getName();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        switch (fieldKey) {
            case "payrollgrp": {
                HasPermOrgResult permOrgs;
                QFilter qFilter = new QFilter("status", "=", (Object)"C");
                qFilter.and("enable", "=", (Object)"1");
                QFilter payrollGrpForBdProp = SWCPermissionServiceHelper.getDataRuleForBdProp((String)"/UHMBBGZQ65X", (String)"hsas_payschedule", (String)PAYROLLGRP);
                if (payrollGrpForBdProp != null) {
                    logger.info("\u85aa\u8d44\u6838\u7b97\u7ec4 \u6570\u636e\u6743\u9650\u53ca\u6570\u636e\u89c4\u5219\u6743\u9650 payrollGrpForBdProp {}", (Object)payrollGrpForBdProp);
                    qFilter.and(payrollGrpForBdProp);
                }
                if (!(permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)"hsas_payschedule", (String)"47156aff000000ac")).hasAllOrgPerm()) {
                    qFilter.and("org", "in", (Object)permOrgs.getHasPermOrgs());
                }
                ((ListShowParameter)event.getFormShowParameter()).getListFilterParameter().setFilter(qFilter);
                break;
            }
            case "payrollgrpv": {
                DynamicObject payrollGrp = dataEntity.getDynamicObject(PAYROLLGRP);
                QFilter boFilter = Objects.isNull(payrollGrp) ? new QFilter("boid", "=", (Object)0L) : new QFilter("boid", "=", payrollGrp.getPkValue());
                QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)new String[]{"0", "1"});
                ((ListShowParameter)event.getFormShowParameter()).getListFilterParameter().setFilter(boFilter.and(dataStatusFilter));
                break;
            }
            case "payrollscene": {
                this.clickPayrollSceneF7(event, this.getModel());
                break;
            }
            case "calperiod": {
                Object periodTypeId = dataEntity.get("payrollscene.periodtype.id");
                QFilter qFilter1 = new QFilter("periodtypeid", "=", periodTypeId);
                QFilter periodForBdProp = SWCPermissionServiceHelper.getDataRuleForBdProp((String)"/UHMBBGZQ65X", (String)"hsas_payschedule", (String)CALPERIOD);
                if (periodForBdProp != null) {
                    logger.info("\u671f\u95f4 \u6570\u636e\u6743\u9650\u53ca\u6570\u636e\u89c4\u5219\u6743\u9650 periodForBdProp {}", (Object)periodForBdProp);
                    qFilter1.and(periodForBdProp);
                }
                ((ListShowParameter)event.getFormShowParameter()).getListFilterParameter().setFilter(qFilter1);
                break;
            }
            case "calperiodtype": {
                QFilter periodTypeForBdProp = SWCPermissionServiceHelper.getDataRuleForBdProp((String)"/UHMBBGZQ65X", (String)"hsas_payschedule", (String)CALPERIODTYPE);
                if (periodTypeForBdProp == null) break;
                logger.info("\u671f\u95f4\u7c7b\u578b \u6570\u636e\u6743\u9650\u53ca\u6570\u636e\u89c4\u5219\u6743\u9650 periodTypeForBdProp {}", (Object)periodTypeForBdProp);
                ((ListShowParameter)event.getFormShowParameter()).getListFilterParameter().setFilter(periodTypeForBdProp);
                break;
            }
        }
    }

    private void clickPayrollSceneF7(BeforeF7SelectEvent event, IDataModel dataModel) {
        HasPermOrgResult permOrgs;
        SWCDataServiceHelper grpvHelper = new SWCDataServiceHelper("hsas_payrollgrp");
        long payrollGrpvId = dataModel.getDataEntity().getLong("payrollgrpv.id");
        QFilter grpvFilter = new QFilter("id", "=", (Object)payrollGrpvId);
        DynamicObject payrollGrpV = grpvHelper.queryOne("payrollsceneentry,payrollscene.id", grpvFilter.toArray());
        if (payrollGrpV == null) {
            return;
        }
        DynamicObjectCollection payrollSceneEntry = payrollGrpV.getDynamicObjectCollection("payrollsceneentry");
        HashSet<Long> payrollSceneIds = new HashSet<Long>(16);
        for (DynamicObject entry : payrollSceneEntry) {
            long payrollSceneId = entry.getLong("payrollscene.id");
            payrollSceneIds.add(payrollSceneId);
        }
        QFilter payrollSceneFilter = new QFilter("id", "in", payrollSceneIds);
        QFilter payrollSceneForBdProp = SWCPermissionServiceHelper.getDataRuleForBdProp((String)"/UHMBBGZQ65X", (String)"hsas_payschedule", (String)PAYROLLSCENE);
        if (payrollSceneForBdProp != null) {
            logger.info("\u85aa\u8d44\u6838\u7b97\u573a\u666f \u6570\u636e\u6743\u9650\u53ca\u6570\u636e\u89c4\u5219\u6743\u9650 payrollSceneForBdProp {}\uff0cpayrollSceneIds {}", (Object)payrollSceneForBdProp, payrollSceneIds);
            payrollSceneFilter.and(payrollSceneForBdProp);
        }
        if (!(permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)"hsas_payschedule", (String)"47156aff000000ac")).hasAllOrgPerm()) {
            payrollSceneFilter.and("org", "in", (Object)permOrgs.getHasPermOrgs());
        }
        ListShowParameter formShowParameter = (ListShowParameter)event.getFormShowParameter();
        formShowParameter.getListFilterParameter().setFilter(payrollSceneFilter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"donothing_save") && args.getOperationResult().isSuccess()) {
            this.getView().close();
        }
    }
}

