/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.payschedule;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.Html;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class PaySchTplCalendarPlugin
extends SWCDataBaseEdit {
    protected final String KEY_DATE = "date";
    protected final String BTN_LEFT = "btn_left";
    protected final String BTN_RIGHT = "btn_right";
    protected final String KEY_PREVREGION = "KEY_PREVREGION";
    protected static final String BTN_BACK_TODAY = "backtoday";
    private static final Log logger = LogFactory.getLog(PaySchTplCalendarPlugin.class);

    public void afterCreateNewData(EventObject e) {
        Date initDate = new Date();
        this.getModel().setValue("date", (Object)initDate);
        this.setCalendar(initDate);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_left", "btn_right", BTN_BACK_TODAY});
        for (int i = 1; i < 7; ++i) {
            for (int j = 1; j < 8; ++j) {
                this.addClickListeners(new String[]{"flex_" + i + "_" + j});
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Date dateValue;
        if ("date".equals(e.getProperty().getName()) && (dateValue = (Date)this.getModel().getValue("date")) != null) {
            this.setCalendar(dateValue);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Control) {
            String key = ((Control)source).getKey();
            Date currMonth = (Date)this.getModel().getValue("date");
            if (key.startsWith("flex_")) {
                if (currMonth == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f", (String)"PaySchTplCalendarPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    return;
                }
                String[] region = key.replace("flex_", "").split("_");
                if (region.length == 2) {
                    Date currChooseDay = this.getDay(Integer.parseInt(region[0]), Integer.parseInt(region[1]));
                    if (!this.isCurrMonth(currChooseDay)) {
                        this.getModel().setValue("date", (Object)currChooseDay);
                    }
                    this.markItemChosen(currChooseDay);
                }
            } else if ("btn_left".equals(key)) {
                if (currMonth == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f", (String)"PaySchTplCalendarPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getModel().setValue("date", (Object)SWCDateTimeUtils.addMonth((Date)currMonth, (int)-1));
            } else if ("btn_right".equals(key)) {
                if (currMonth == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f", (String)"PaySchTplCalendarPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getModel().setValue("date", (Object)SWCDateTimeUtils.addMonth((Date)currMonth, (int)1));
            }
        }
    }

    protected void markItemChosen(Date day) {
        int[] currRegion = this.getRegion(day);
        if (currRegion != null) {
            this.resetPrevBgColor();
            String currKey = "flex_" + currRegion[0] + "_" + currRegion[1];
            this.getPageCache().put("KEY_PREVREGION", SerializationUtils.toJsonString((Object)currRegion));
            this.updateBgColor(currKey, "rgba(85,130,243,0.1)");
        }
    }

    private int[] getRegion(Date day) {
        if (!this.isCurrMonth(day)) {
            return null;
        }
        Date firstDay = this.getDay(1, 1);
        long diff = (day.getTime() - firstDay.getTime()) / 86400000L;
        int dayDiff = (int)diff;
        return new int[]{dayDiff / 7 + 1, dayDiff % 7 + 1};
    }

    protected void resetPrevBgColor() {
        String prevRegionStr = this.getPageCache().get("KEY_PREVREGION");
        if (prevRegionStr != null) {
            int[] prevRegion = (int[])SerializationUtils.fromJsonString((String)prevRegionStr, int[].class);
            String prevKey = "flex_" + prevRegion[0] + "_" + prevRegion[1];
            if (prevRegion[1] != 1 && prevRegion[1] != 7) {
                this.updateBgColor(prevKey, "rgb(255,255,255)");
            } else {
                this.updateBgColor(prevKey, "rgb(244,244,244)");
            }
        }
    }

    private void updateBgColor(String key, String color) {
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("bc", color);
        this.getView().updateControlMetadata(key, map);
    }

    protected void setCalendar(Date date) {
        this.resetPrevBgColor();
        this.getPageCache().remove("KEY_PREVREGION");
        Calendar current = Calendar.getInstance();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        int weekday = calendar.get(7);
        int maxday = calendar.getActualMaximum(5);
        calendar.add(5, 0 - weekday);
        SimpleDateFormat dfdd = new SimpleDateFormat("dd");
        SimpleDateFormat dfnyr = new SimpleDateFormat("yyyy-MM-dd");
        int index = 0;
        for (int i = 1; i < 7; ++i) {
            for (int j = 1; j < 8; ++j) {
                calendar.add(5, 1);
                Html html = (Html)this.getControl("htmlap_" + i + "_" + j);
                StringBuilder sb = new StringBuilder();
                String currDateStr = dfnyr.format(calendar.getTime());
                String currDayStr = dfdd.format(calendar.getTime());
                ArrayList list = new ArrayList();
                sb.append("<div title=\"").append(String.join((CharSequence)"&#10", list)).append("\"><div style=\"text-align:right;\">").append("<span ").append("style=\"width:28px;").append("font-size:16px;").append("height:28px;").append("color:#333333;").append("border-radius:50%;").append("display:inline-block;").append("line-height:28px;").append("text-align:center;");
                if (index < weekday - 1 || index - weekday - maxday + 2 > 0) {
                    sb.append("color:#999999;");
                }
                if (dfnyr.format(current.getTime()).equals(currDateStr)) {
                    sb.append("background:rgba(95,137,243,1);");
                    sb.append("color:#ffffff;");
                }
                sb.append("\">").append(dfnyr.format(current.getTime()).equals(currDateStr) ? ResManager.loadKDString((String)"\u4eca", (String)"PaySchTplCalendarPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]) : currDayStr).append("</span>").append("</div>");
                for (int k = 0; k < list.size(); ++k) {
                    if (k >= 4) {
                        sb.append("<div style=\"text-align:left\" id=\"item_").append(i).append('_').append(j).append('_').append(k).append("\">");
                        sb.append("<span style=\";width:4px;height:4px;display:inline-block;margin-bottom:2px;\"></span>");
                        sb.append("<span style=\"margin-top:4px;color:rgba(51,51,51,1);margin-left:4px;\">......</span>");
                        sb.append("</div>");
                        break;
                    }
                    sb.append("<div style=\"text-align:left\" id=\"item_").append(i).append('_').append(j).append('_').append(k).append("\">");
                    sb.append("<span style=\"background:green;width:4px;height:4px;display:inline-block;margin-bottom:2px;\"></span>");
                    sb.append("<span style=\"margin-top:4px;color:rgba(51,51,51,1);margin-left:4px;\">").append((String)list.get(k)).append("</span>");
                    sb.append("</div>");
                }
                sb.append("</div></div>");
                html.setConent(sb.toString());
                ++index;
            }
        }
        if (this.isSameMonth(date, new Date())) {
            this.markItemChosen(new Date());
        }
    }

    protected Date getDay(int row, int col) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime((Date)this.getModel().getValue("date"));
        calendar.set(5, 1);
        int weekday = calendar.get(7);
        calendar.add(5, 0 - weekday);
        calendar.add(5, (row - 1) * 7 + col);
        return calendar.getTime();
    }

    protected boolean isCurrMonth(Date day) {
        Date currMonth = (Date)this.getModel().getValue("date");
        return this.isSameMonth(day, currMonth);
    }

    protected boolean isSameMonth(Date date1, Date date2) {
        Calendar currMonthCal = Calendar.getInstance();
        currMonthCal.setTime(date1);
        Calendar currChooseDayCal = Calendar.getInstance();
        currChooseDayCal.setTime(date2);
        int yearDiff = currMonthCal.get(1) - currChooseDayCal.get(1);
        int monthDiff = currMonthCal.get(2) - currChooseDayCal.get(2);
        return yearDiff == 0 && monthDiff == 0;
    }
}

