/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.payschedule;

import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ListboxItem;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.Listbox;
import kd.bos.form.control.Control;
import kd.bos.form.control.Html;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ListboxClickListener;
import kd.bos.form.control.events.ListboxEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.payschedule.PaySchTplHelper;
import kd.swc.hsas.business.payschedule.PayScheduleHelper;
import kd.swc.hsas.formplugin.web.payschedule.PaySchTplCalendarPlugin;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.lang.StringUtils;

public class PaySchTplNewPreviewPlugin
extends PaySchTplCalendarPlugin
implements BeforeF7SelectListener,
ListboxClickListener {
    private static final String ENTRY = "entryentitycard";
    private static final String PAYROLLSCENE = "payrollscene";
    private static final String CAL_PERIOD = "calperiod";
    private static final String PAY_ROLL_GRP = "payrollgrp";
    private static final String SELECT_SCHEME = "selectscheme";
    private static final String PAY_SCHEDULE = "payschedule";
    private static final String PAY_SCHEDULE_NAME = "payschedulename";
    private static final String CAL_PERIOD_NAME = "calperiodname";
    private static final String PAY_SCHEDULE_STATUS = "payschedulestatus";
    private static final String PAY_SCHEDULE_STATUS_ENUM = "payschedulestatusenum";
    private static final String ORG_NAME = "orgname";
    private static final String PAY_ROLLGRP_NAME = "payrollgrpname";
    private static final String PAYROLLSCENE_NAME = "payrollscenename";
    private static final String START_DATE = "rangestartdate";
    private static final String END_DATE = "rangeenddate";
    private static final String KEY_PERIOD = "period";
    private static final String KEY_LISTBOXAP = "listboxap";
    private static final String KEY_LISTFLEXPANELAP = "listflexpanelap";
    private static final String KEY_CALENDARFLEXPANELAP = "calendarflexpanelap";
    private static final String KEY_PROCSTARTDATE = "procstartdate";
    private static final String KEY_PROCENDDATE = "procenddate";
    private static final String KEY_RIGHTFLEXPANELAP = "rightflexpanelap";
    private static final String KEY_PAYBIZACTION = "paybizaction";
    private static final String KEY_STARTDATE = "startdate";
    private static final String KEY_ENDDATE = "enddate";
    private static final String KEY_PREPAYBIZACTION = "prepaybizaction";
    private static final String KEY_CALENDARTABPAGEAP = "calendartabpageap";
    private static final String KEY_CALENDARFLEX = "calendarflex";
    private static final String KEY_DATELABEL = "datelabel";
    private static final String KEY_DATEFILED = "datefield";
    private static final String KEY_DETAILFLEXAP = "detailflexap";
    private static final String KEY_PAYBIZACTIONNAME = "paybizactionname";
    private static final String KEY_PERIODNAME = "periodname";
    private static final String KEY_PAYROLLGRPNAME = "payrollgrpname";
    private static final String KEY_PAYSCHDATE = "payschdate";
    private static final String NODATAFLEX = "nodataflex";
    private static final String PAY_SCH_DATES_CACHE = "paySchDates_cache";
    private SimpleDateFormat YearMonthDayFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static final Log logger = LogFactory.getLog(PaySchTplNewPreviewPlugin.class);

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit periodEdit = (BasedataEdit)this.getControl(KEY_PERIOD);
        periodEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Listbox listboxap = (Listbox)this.getControl(KEY_LISTBOXAP);
        listboxap.addListboxClickListener((ListboxClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_LISTFLEXPANELAP});
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_CALENDARFLEXPANELAP});
        Object periodTypeId = this.getPeriodTypeId();
        DynamicObjectCollection periodTypePeriodDys = PaySchTplHelper.getPeriodDys((Object)periodTypeId);
        HashMap<Long, Map<Long, Map<String, Date>>> periodSchDateMap = new HashMap<Long, Map<Long, Map<String, Date>>>(16);
        Object paySchTplId = this.getView().getFormShowParameter().getCustomParam("paySchTplId");
        DynamicObject paySchTplDy = PaySchTplHelper.queryPaySchTplDy((Object)paySchTplId);
        DynamicObjectCollection payBizProcEntry = paySchTplDy.getDynamicObjectCollection("entryentity");
        ArrayList<DynamicObject> noNextPeriods = new ArrayList<DynamicObject>();
        this.setPeriodSchDateMap((List<DynamicObject>)periodTypePeriodDys, periodTypePeriodDys, periodSchDateMap, payBizProcEntry, paySchTplDy, noNextPeriods);
        this.initCalendarModePage((List<DynamicObject>)periodTypePeriodDys, periodTypePeriodDys, periodSchDateMap, paySchTplDy);
        this.showNoNextPeriodNotify(noNextPeriods);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        Object periodTypeId;
        String fieldKey = event.getProperty().getName();
        if (KEY_PERIOD.equals(fieldKey) && (periodTypeId = this.getPeriodTypeId()) != null) {
            ListShowParameter param = (ListShowParameter)event.getFormShowParameter();
            QFilter qFilter = new QFilter("periodtypeid", "=", periodTypeId);
            param.getListFilterParameter().setFilter(qFilter);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs args) {
        String name;
        switch (name = args.getProperty().getName()) {
            case "period": {
                DynamicObjectCollection dyColl = (DynamicObjectCollection)this.getModel().getValue(KEY_PERIOD);
                if (dyColl == null) break;
                List<DynamicObject> selPeriodDys = this.getPeriodDysFromMulDyColl(dyColl);
                HashMap<Long, Map<Long, Map<String, Date>>> periodSchDateMap = new HashMap<Long, Map<Long, Map<String, Date>>>(16);
                Object paySchTplId = this.getView().getFormShowParameter().getCustomParam("paySchTplId");
                DynamicObject paySchTplDy = PaySchTplHelper.queryPaySchTplDy((Object)paySchTplId);
                DynamicObjectCollection payBizProcEntry = paySchTplDy.getDynamicObjectCollection("entryentity");
                Object periodTypeId = this.getPeriodTypeId();
                DynamicObjectCollection periodTypePeriodDys = PaySchTplHelper.getPeriodDys((Object)periodTypeId);
                ArrayList<DynamicObject> noNextPeriods = new ArrayList<DynamicObject>();
                this.setPeriodSchDateMap(selPeriodDys, periodTypePeriodDys, periodSchDateMap, payBizProcEntry, paySchTplDy, noNextPeriods);
                this.initListModePage(selPeriodDys, periodSchDateMap, payBizProcEntry, paySchTplDy.getString("number"));
                this.showNoNextPeriodNotify(noNextPeriods);
                Boolean empty = dyColl.isEmpty();
                this.getView().setVisible(empty, new String[]{NODATAFLEX});
                this.getView().setVisible(Boolean.valueOf(empty == false), new String[]{KEY_LISTFLEXPANELAP});
                break;
            }
            case "date": {
                String paySchDates;
                Date dateValue = (Date)this.getModel().getValue("date");
                if (dateValue == null || !StringUtils.isNotEmpty((String)(paySchDates = this.getPageCache().get(PAY_SCH_DATES_CACHE)))) break;
                this.setCalendar(dateValue, (Set)SerializationUtils.fromJsonString((String)paySchDates, HashSet.class));
                break;
            }
        }
    }

    public void listboxClick(ListboxEvent listboxEvent) {
        Long periodId = Long.valueOf(listboxEvent.getItemId());
        DynamicObject periodDy = PaySchTplHelper.queryPeriodDy((Object)periodId);
        Object paySchTplId = this.getView().getFormShowParameter().getCustomParam("paySchTplId");
        DynamicObject paySchTplDy = PaySchTplHelper.queryPaySchTplDy((Object)paySchTplId);
        DynamicObjectCollection payBizProcEntry = paySchTplDy.getDynamicObjectCollection("entryentity");
        Map entryPreMap = PaySchTplHelper.getEntryPreMap((DynamicObjectCollection)payBizProcEntry);
        Date selPayTaskDate = PaySchTplHelper.getSelPayTaskDate((DynamicObject)paySchTplDy, (DynamicObject)periodDy, null);
        List workCalendar = PayScheduleHelper.getWorkCalendar((Long)paySchTplDy.getLong("workplan.id"), (int)SWCDateTimeUtils.getYear((Date)selPayTaskDate));
        Map paySchDateMap = PaySchTplHelper.getPaySchDate((DynamicObject)paySchTplDy, (Date)selPayTaskDate, (List)workCalendar, (Map)entryPreMap);
        this.updateListData(paySchDateMap, payBizProcEntry, paySchTplDy.getString("number"));
    }

    @Override
    public void click(EventObject evt) {
        Object source = evt.getSource();
        if (source instanceof Control) {
            String key = ((Control)source).getKey();
            Date currMonth = (Date)this.getModel().getValue("date");
            if (key.startsWith("flex_")) {
                if (currMonth == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f", (String)"PaySchTplNewPreviewPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    return;
                }
                String[] region = key.replace("flex_", "").split("_");
                if (region.length == 2) {
                    Date currChooseDay = this.getDay(Integer.parseInt(region[0]), Integer.parseInt(region[1]));
                    if (!super.isCurrMonth(currChooseDay)) {
                        this.getModel().setValue("date", (Object)currChooseDay);
                    }
                    this.markItemChosen(currChooseDay);
                    this.setPaySchDetailInfo(currChooseDay);
                }
            } else if ("btn_left".equals(key)) {
                if (currMonth == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f", (String)"PaySchTplNewPreviewPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getModel().setValue("date", (Object)SWCDateTimeUtils.addMonth((Date)currMonth, (int)-1));
            } else if ("btn_right".equals(key)) {
                if (currMonth == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f", (String)"PaySchTplNewPreviewPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getModel().setValue("date", (Object)SWCDateTimeUtils.addMonth((Date)currMonth, (int)1));
            } else if (SWCStringUtils.equals((String)"backtoday", (String)key)) {
                this.getModel().setValue("date", (Object)new Date());
                this.getModel().setValue(KEY_DATEFILED, (Object)new Date());
                this.setWeekDayLabelValue(new Date());
                this.setPaySchDetailInfo(new Date());
            }
        }
    }

    private void setPaySchDetailInfo(Date currChooseDay) {
        Long paySchTplId = (Long)this.getView().getFormShowParameter().getCustomParam("paySchTplId");
        DynamicObject paySchTplDy = PaySchTplHelper.queryPaySchTplDy((Object)paySchTplId);
        Object periodTypeId = this.getPeriodTypeId();
        DynamicObjectCollection periodTypePeriodDys = PaySchTplHelper.getPeriodDys((Object)periodTypeId);
        ArrayList selPeriodDys = Lists.newArrayList((Iterable)periodTypePeriodDys);
        if ("1".equals(paySchTplDy.getString("actdatetype")) && "1".equals(paySchTplDy.getString("selperiod"))) {
            if (periodTypePeriodDys.isEmpty()) {
                return;
            }
            selPeriodDys.remove(periodTypePeriodDys.size() - 1);
        }
        this.updateDetailInfo(currChooseDay, selPeriodDys, periodTypePeriodDys, paySchTplDy);
    }

    private void showNoNextPeriodNotify(List<DynamicObject> noNextPeriods) {
        if (!noNextPeriods.isEmpty()) {
            String msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u4e3a\u6700\u540e\u7684\u671f\u95f4\uff0c\u65e0\u4e0b\u4e00\u671f\u95f4\uff0c\u65e0\u6cd5\u6309\u7167\u89c4\u5219\u9884\u89c8\uff0c\u5982\u4ecd\u9700\u9884\u89c8\u8bf7\u5148\u7ef4\u62a4\u8be5\u671f\u95f4\u7684\u4e0b\u4e00\u671f\u95f4\u3002", (String)"PaySchTplNewPreviewPlugin_11", (String)"swc-hsas-formplugin", (Object[])new Object[0]), noNextPeriods.get(0).getString("name"));
            this.getView().showTipNotification(msg);
        }
    }

    private void setPeriodSchDateMap(List<DynamicObject> selPeriodDys, DynamicObjectCollection periodTypePeriodDys, Map<Long, Map<Long, Map<String, Date>>> periodSchDateMap, DynamicObjectCollection paySchTplEntry, DynamicObject paySchTplDy, List<DynamicObject> noNextPeriods) {
        if (selPeriodDys.isEmpty()) {
            return;
        }
        Map entryPreMap = PaySchTplHelper.getEntryPreMap((DynamicObjectCollection)paySchTplEntry);
        int selPayTaskDateYear = -1;
        List workCalendar = null;
        for (DynamicObject periodDy : selPeriodDys) {
            DynamicObject nextPeriod = null;
            if ("1".equals(paySchTplDy.getString("actdatetype")) && "1".equals(paySchTplDy.getString("selperiod"))) {
                DynamicObject periodTypePeriodDy;
                int periodIndex = 0;
                Iterator iterator = periodTypePeriodDys.iterator();
                while (iterator.hasNext() && (periodTypePeriodDy = (DynamicObject)iterator.next()).getLong("id") != periodDy.getLong("id")) {
                    ++periodIndex;
                }
                if (periodIndex + 1 < periodTypePeriodDys.size()) {
                    nextPeriod = (DynamicObject)periodTypePeriodDys.get(periodIndex + 1);
                } else {
                    noNextPeriods.add(periodDy);
                    continue;
                }
            }
            Date selPayTaskDate = PaySchTplHelper.getSelPayTaskDate((DynamicObject)paySchTplDy, (DynamicObject)periodDy, nextPeriod);
            if (workCalendar == null || selPayTaskDateYear != SWCDateTimeUtils.getYear((Date)selPayTaskDate)) {
                selPayTaskDateYear = SWCDateTimeUtils.getYear((Date)selPayTaskDate);
                workCalendar = PayScheduleHelper.getWorkCalendar((Long)paySchTplDy.getLong("workplan.id"), (int)selPayTaskDateYear);
            }
            Map paySchDateMap = PaySchTplHelper.getPaySchDate((DynamicObject)paySchTplDy, (Date)selPayTaskDate, workCalendar, (Map)entryPreMap);
            periodSchDateMap.put(periodDy.getLong("id"), paySchDateMap);
        }
        if (!noNextPeriods.isEmpty()) {
            selPeriodDys.remove(noNextPeriods.get(0));
        }
    }

    private Set<String> getPaySchDateStrs(Map<Long, Map<Long, Map<String, Date>>> periodSchDateMap) {
        HashSet<String> paySchDates = new HashSet<String>(10);
        for (Map.Entry<Long, Map<Long, Map<String, Date>>> periodSchDateMapEntry : periodSchDateMap.entrySet()) {
            Map<Long, Map<String, Date>> paySchDateMap = periodSchDateMapEntry.getValue();
            for (Map.Entry<Long, Map<String, Date>> paySchDateMapEntry : paySchDateMap.entrySet()) {
                Long payBizActId = paySchDateMapEntry.getKey();
                if (1139088596750377984L == payBizActId || 1139088905400819712L == payBizActId) continue;
                Map<String, Date> dateMap = paySchDateMapEntry.getValue();
                this.setPaySchDates(dateMap, paySchDates);
            }
        }
        return paySchDates;
    }

    private void setCalendar(Date date, Set<String> paySchDates) {
        if (paySchDates == null) {
            return;
        }
        this.resetPrevBgColor();
        this.getPageCache().remove("KEY_PREVREGION");
        Calendar current = Calendar.getInstance();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        int weekday = calendar.get(7);
        int maxday = calendar.getActualMaximum(5);
        calendar.add(5, 0 - weekday);
        SimpleDateFormat dfdd = new SimpleDateFormat("dd");
        SimpleDateFormat dfnyr = new SimpleDateFormat("yyyy-MM-dd");
        int index = 0;
        for (int i = 1; i < 7; ++i) {
            for (int j = 1; j < 8; ++j) {
                calendar.add(5, 1);
                Html html = (Html)this.getControl("htmlap_" + i + "_" + j);
                StringBuilder sb = new StringBuilder();
                String currDateStr = dfnyr.format(calendar.getTime());
                String currDayStr = String.valueOf(calendar.get(5));
                sb.append("<div  style=\"height: 46px;\">");
                sb.append(" <div style=\"height: 8px;\"></div>");
                sb.append("<div style=\"height: 22px;\">");
                sb.append("<div style=\"text-align:center;position: relative;top: 50%;left: 50%;transform: translate(-50%, -50%)\">");
                sb.append("<span ").append("style=\"width:22px;").append("font-size:16px;").append("height:22px;").append("color:#333333;").append("border-radius:50%;").append("display:inline-block;").append("line-height:22px;").append("text-align:center;");
                if (index < weekday - 1 || index - weekday - maxday + 2 > 0) {
                    sb.append("color:#999999;");
                }
                if (dfnyr.format(current.getTime()).equals(currDateStr)) {
                    sb.append("background:rgba(95,137,243,1);");
                    sb.append("color:#ffffff;");
                }
                sb.append("\">").append(currDayStr).append("</span>");
                sb.append("</div>");
                sb.append("</div>");
                sb.append(" <div style=\"height: 12px;text-align:center;\">");
                if (paySchDates.contains(this.YearMonthDayFormat.format(calendar.getTime()))) {
                    sb.append("<span ").append("style=\"width:8px;").append("font-size:6px;").append("height:8px;").append("line-height:12px;").append("color:#00A9FF;").append("border-radius:50%;").append("display:inline-block;").append("text-align:center;").append("background:#00A9FF;").append("\">");
                    sb.append("</span>");
                }
                sb.append("</div>");
                sb.append("</div>");
                html.setConent(sb.toString());
                ++index;
            }
        }
        if (this.isSameMonth(date, new Date())) {
            this.markItemChosen(new Date());
        }
    }

    private void updateDetailInfo(Date chooseDate, List<DynamicObject> selPeriodDys, DynamicObjectCollection periodTypePeriodDys, DynamicObject paySchTplDy) {
        this.setWeekDayLabelValue(chooseDate);
        List<Map<String, Object>> paySchInfoMaps = this.getPreGenPaySchMaps(chooseDate, selPeriodDys, periodTypePeriodDys, paySchTplDy);
        paySchInfoMaps.sort(new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                Date startDate2;
                Date startDate1 = (Date)o1.get(PaySchTplNewPreviewPlugin.KEY_STARTDATE);
                if (startDate1.after(startDate2 = (Date)o2.get(PaySchTplNewPreviewPlugin.KEY_STARTDATE))) {
                    return 1;
                }
                if (startDate1.before(startDate2)) {
                    return -1;
                }
                return 0;
            }
        });
        this.fillEntryData(paySchInfoMaps);
    }

    private void setWeekDayLabelValue(Date chooseDate) {
        Label dateLabel = (Label)this.getView().getControl(KEY_DATELABEL);
        dateLabel.setText(this.getDateString(chooseDate));
        this.getModel().setValue(KEY_DATEFILED, (Object)chooseDate);
    }

    private List<Map<String, Object>> getPreGenPaySchMaps(Date chooseDate, List<DynamicObject> selPeriodDys, DynamicObjectCollection periodTypePeriodDys, DynamicObject paySchTplDy) {
        ArrayList<Map<String, Object>> paySchInfoMaps = new ArrayList<Map<String, Object>>(10);
        DynamicObjectCollection paySchTplEntryDyColl = paySchTplDy.getDynamicObjectCollection("entryentity");
        HashMap<Long, String> payBizActInfoMap = new HashMap<Long, String>(paySchTplEntryDyColl.size());
        for (DynamicObject paySchTplEntryDy : paySchTplEntryDyColl) {
            payBizActInfoMap.put(paySchTplEntryDy.getLong("paybizaction.id"), paySchTplEntryDy.getString("paybizaction.name"));
        }
        Map entryPreMap = PaySchTplHelper.getEntryPreMap((DynamicObjectCollection)paySchTplEntryDyColl);
        int selPayTaskDateYear = -1;
        List workCalendar = null;
        for (DynamicObject periodDy : selPeriodDys) {
            DynamicObject periodTypePeriodDy;
            DynamicObject nextPeriod = null;
            int index = 0;
            Iterator iterator = periodTypePeriodDys.iterator();
            while (iterator.hasNext() && !SWCObjectUtils.equals((Object)periodDy, (Object)(periodTypePeriodDy = (DynamicObject)iterator.next()))) {
                ++index;
            }
            if (index + 1 < periodTypePeriodDys.size()) {
                nextPeriod = (DynamicObject)periodTypePeriodDys.get(index + 1);
            }
            Date selPayTaskDate = PaySchTplHelper.getSelPayTaskDate((DynamicObject)paySchTplDy, (DynamicObject)periodDy, nextPeriod);
            if (workCalendar == null || selPayTaskDateYear != SWCDateTimeUtils.getYear((Date)selPayTaskDate)) {
                selPayTaskDateYear = SWCDateTimeUtils.getYear((Date)selPayTaskDate);
                workCalendar = PayScheduleHelper.getWorkCalendar((Long)paySchTplDy.getLong("workplan.id"), (int)selPayTaskDateYear);
            }
            Map paySchDateMap = PaySchTplHelper.getPaySchDate((DynamicObject)paySchTplDy, (Date)selPayTaskDate, workCalendar, (Map)entryPreMap);
            for (Map.Entry entry : paySchDateMap.entrySet()) {
                Long payBizActId = (Long)entry.getKey();
                if (1139088905400819712L == payBizActId || 1139088596750377984L == payBizActId) continue;
                Map dateMap = (Map)entry.getValue();
                Date startDate = (Date)dateMap.get("startDate");
                Date endDate = (Date)dateMap.get("endDate");
                SimpleDateFormat nyrFormate = new SimpleDateFormat("yyyy-MM-dd");
                String chooseDateStr = nyrFormate.format(chooseDate);
                if ((chooseDate.after(endDate) || chooseDate.before(startDate)) && !chooseDateStr.equals(nyrFormate.format(startDate)) && !chooseDateStr.equals(nyrFormate.format(endDate))) continue;
                HashMap<String, Object> paySchInfoMap = new HashMap<String, Object>(16);
                paySchInfoMap.put("calperiod.name", periodDy.getString("name"));
                paySchInfoMap.put("payrollgrp.name", paySchTplDy.getString("payrollgrp.name"));
                paySchInfoMap.put("payrollscene.name", paySchTplDy.getString("payrollscene.name"));
                paySchInfoMap.put("org.name", paySchTplDy.getString("org.name"));
                paySchInfoMap.put("name", payBizActInfoMap.get(payBizActId));
                paySchInfoMap.put(KEY_ENDDATE, endDate);
                paySchInfoMap.put(KEY_STARTDATE, startDate);
                paySchInfoMaps.add(paySchInfoMap);
            }
        }
        return paySchInfoMaps;
    }

    private void fillEntryData(List<Map<String, Object>> paySchInfoMaps) {
        this.getModel().deleteEntryData(ENTRY);
        if (paySchInfoMaps != null && !paySchInfoMaps.isEmpty()) {
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField(PAY_SCHEDULE_NAME, new Object[0]);
            vs.addField(CAL_PERIOD_NAME, new Object[0]);
            vs.addField("payrollgrpname", new Object[0]);
            vs.addField(PAYROLLSCENE_NAME, new Object[0]);
            vs.addField(ORG_NAME, new Object[0]);
            vs.addField(START_DATE, new Object[0]);
            vs.addField(END_DATE, new Object[0]);
            for (Map<String, Object> paySchedule : paySchInfoMaps) {
                vs.addRow(new Object[]{paySchedule.get("name"), paySchedule.get("calperiod.name"), paySchedule.get("payrollgrp.name"), paySchedule.get("payrollscene.name"), paySchedule.get("org.name"), paySchedule.get(KEY_STARTDATE), paySchedule.get(KEY_ENDDATE)});
            }
            ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow(ENTRY, vs);
        }
    }

    private void initCalendarModePage(List<DynamicObject> selPeriodDys, DynamicObjectCollection periodTypePeriodDys, Map<Long, Map<Long, Map<String, Date>>> periodSchDateMap, DynamicObject paySchTplDy) {
        Set<String> paySchDates = this.getPaySchDateStrs(periodSchDateMap);
        this.getPageCache().put(PAY_SCH_DATES_CACHE, SerializationUtils.toJsonString(paySchDates));
        this.setCalendar(new Date(), paySchDates);
        this.updateDetailInfo(new Date(), selPeriodDys, periodTypePeriodDys, paySchTplDy);
        if (selPeriodDys.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_CALENDARFLEXPANELAP});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_CALENDARFLEXPANELAP});
        }
    }

    private void initListModePage(List<DynamicObject> selPeriodDys, Map<Long, Map<Long, Map<String, Date>>> periodSchDateMap, DynamicObjectCollection payBizProcEntry, String paySchTplNumber) {
        Listbox listboxap = (Listbox)this.getControl(KEY_LISTBOXAP);
        listboxap.addItems(null);
        if (selPeriodDys.size() > 0 && periodSchDateMap.size() > 0) {
            ArrayList<ListboxItem> listboxItems = new ArrayList<ListboxItem>(selPeriodDys.size());
            for (DynamicObject periodDy : selPeriodDys) {
                ListboxItem listboxItem = new ListboxItem();
                listboxItem.setId(periodDy.getString("id"));
                listboxItem.setContent(periodDy.getString("name"));
                listboxItems.add(listboxItem);
            }
            listboxap.addItems(listboxItems);
            String periodId = selPeriodDys.get(0).getString("id");
            listboxap.activeItem(periodId);
            this.updateListData(periodSchDateMap.get(Long.valueOf(periodId)), payBizProcEntry, paySchTplNumber);
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_LISTFLEXPANELAP});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_LISTFLEXPANELAP});
        }
    }

    private void updateListData(Map<Long, Map<String, Date>> paySchDateMap, DynamicObjectCollection payBizProcEntry, String paySchNumber) {
        Map<String, Date> endInfoMap = paySchDateMap.get(1139088905400819712L);
        Map<String, Date> startInfoMap = paySchDateMap.get(1139088596750377984L);
        Date procEndTime = SWCDateTimeUtils.addDay((Date)endInfoMap.get("startDate"), (long)-1L);
        Date procStartTime = SWCDateTimeUtils.addDay((Date)startInfoMap.get("startDate"), (long)1L);
        this.getView().getModel().setValue(KEY_PROCSTARTDATE, (Object)procStartTime);
        this.getView().getModel().setValue(KEY_PROCENDDATE, (Object)procEndTime);
        this.getModel().deleteEntryData("entryentity");
        for (DynamicObject dyObj : payBizProcEntry) {
            int newEntryRow = this.getModel().createNewEntryRow("entryentity");
            long payBizActionId = dyObj.getLong("paybizaction.id");
            Map<String, Date> stringDateMap = paySchDateMap.get(payBizActionId);
            this.getModel().setValue(KEY_PAYBIZACTION, (Object)payBizActionId, newEntryRow);
            this.getModel().setValue(KEY_STARTDATE, (Object)stringDateMap.get("startDate"), newEntryRow);
            this.getModel().setValue(KEY_ENDDATE, (Object)stringDateMap.get("endDate"), newEntryRow);
            this.getModel().setValue(KEY_PREPAYBIZACTION, (Object)dyObj.getDynamicObjectCollection(KEY_PREPAYBIZACTION), newEntryRow);
            if (payBizActionId == 1139088596750377984L) {
                this.getModel().setValue(KEY_STARTDATE, (Object)procStartTime, newEntryRow);
                this.getModel().setValue(KEY_ENDDATE, null, newEntryRow);
                continue;
            }
            if (payBizActionId != 1139088905400819712L) continue;
            this.getModel().setValue(KEY_STARTDATE, null, newEntryRow);
            this.getModel().setValue(KEY_ENDDATE, (Object)procEndTime, newEntryRow);
        }
    }

    private String getDateString(Date chooseDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(chooseDate);
        int dayOfWeek = calendar.get(7);
        String dayOfWeekStr = "";
        switch (dayOfWeek) {
            case 1: {
                dayOfWeekStr = ResManager.loadKDString((String)"\u5468\u65e5", (String)"PaySchTplNewPreviewPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                break;
            }
            case 2: {
                dayOfWeekStr = ResManager.loadKDString((String)"\u5468\u4e00", (String)"PaySchTplNewPreviewPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                break;
            }
            case 3: {
                dayOfWeekStr = ResManager.loadKDString((String)"\u5468\u4e8c", (String)"PaySchTplNewPreviewPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                break;
            }
            case 4: {
                dayOfWeekStr = ResManager.loadKDString((String)"\u5468\u4e09", (String)"PaySchTplNewPreviewPlugin_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                break;
            }
            case 5: {
                dayOfWeekStr = ResManager.loadKDString((String)"\u5468\u56db", (String)"PaySchTplNewPreviewPlugin_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                break;
            }
            case 6: {
                dayOfWeekStr = ResManager.loadKDString((String)"\u5468\u4e94", (String)"PaySchTplNewPreviewPlugin_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                break;
            }
            case 7: {
                dayOfWeekStr = ResManager.loadKDString((String)"\u5468\u516d", (String)"PaySchTplNewPreviewPlugin_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                break;
            }
        }
        return dayOfWeekStr;
    }

    private List<DynamicObject> getPeriodDysFromMulDyColl(DynamicObjectCollection dyColl) {
        if (dyColl == null || dyColl.isEmpty()) {
            return new ArrayList<DynamicObject>();
        }
        ArrayList<DynamicObject> periodDys = new ArrayList<DynamicObject>(dyColl.size());
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_calperiod");
        for (DynamicObject dyObj : dyColl) {
            DynamicObject periodDy = dyObj.getDynamicObject("fbasedataid");
            DynamicObject dynamicObject = helper.generateEmptyDynamicObject();
            dynamicObject.set("id", (Object)periodDy.getLong("masterid"));
            dynamicObject.set("name", (Object)periodDy.getString("name"));
            dynamicObject.set(KEY_STARTDATE, (Object)periodDy.getDate(KEY_STARTDATE));
            dynamicObject.set(KEY_ENDDATE, (Object)periodDy.getDate(KEY_ENDDATE));
            periodDys.add(dynamicObject);
        }
        return periodDys;
    }

    private void setPaySchDates(Map<String, Date> paySchDateMap, Set<String> paySchDates) {
        Date startDate = paySchDateMap.get("startDate");
        Date endDate = paySchDateMap.get("endDate");
        this.setBetweenDates(startDate, endDate, paySchDates);
    }

    private void setBetweenDates(Date fromDate, Date toDate, Set<String> stamps) {
        while (fromDate.getTime() <= toDate.getTime()) {
            stamps.add(this.YearMonthDayFormat.format(fromDate));
            fromDate = SWCDateTimeUtils.addDay((Date)fromDate, (long)1L);
        }
    }

    private Object getPeriodTypeId() {
        return this.getView().getFormShowParameter().getCustomParam("periodTypeId");
    }
}

