/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.payschedule;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.swc.hsas.business.payschedule.PaySchTplHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.formplugin.web.SWCDataBaseList;
import org.apache.commons.lang3.StringUtils;

public class PayScheduleList
extends SWCDataBaseList {
    private static final String HSAS_PAYSCHCUSNEWSCH = "hsas_payschcusnewsch";
    private static final String SCHEDULE_STATUS = "schedulestatus";
    private static final String OVERDUE = "overdue";

    public void packageData(PackageDataEvent e) {
        super.packageData(e);
        String fieldKey = ((ColumnDesc)e.getSource()).getFieldKey();
        DynamicObject rowData = e.getRowData();
        if (OVERDUE.equals(fieldKey)) {
            Date endDate = rowData.getDate("enddate");
            LocalDate endLocalDate = endDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            LocalDate finishTime = Optional.ofNullable(rowData.getDate("finishtime")).map(date -> date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate()).orElse(null);
            String formatValue = ResManager.loadKDString((String)"\u903e", (String)"PayScheduleList_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            if (Objects.nonNull(finishTime) && finishTime.isAfter(endLocalDate)) {
                e.setFormatValue((Object)formatValue);
            }
            if (Objects.isNull(finishTime) && LocalDate.now().isAfter(endLocalDate)) {
                e.setFormatValue((Object)formatValue);
            }
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>(rows.size());
                for (DynamicObject row : rows) {
                    if ("3".equals(row.getString(PayScheduleList.SCHEDULE_STATUS))) {
                        row.set(PayScheduleList.SCHEDULE_STATUS, (Object)"0");
                    }
                    if ("4".equals(row.getString(PayScheduleList.SCHEDULE_STATUS))) {
                        row.set(PayScheduleList.SCHEDULE_STATUS, (Object)"2");
                    }
                    cellStyles.add(PayScheduleList.this.getListUnitStyle(PayScheduleList.OVERDUE, start + row.getInt("fseq") - 1, "red"));
                }
                BillList billList = (BillList)PayScheduleList.this.getView().getControl("billlistap");
                billList.setCellStyle(cellStyles);
                return rows;
            }
        });
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        String fieldName = args.getFieldName();
        List filters = args.getQFilters();
        switch (fieldName) {
            case "payrollscene.id": 
            case "payrollscene.name": 
            case "payrollgrp.id": 
            case "payrollgrp.name": {
                HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)"hsas_payschedule", (String)"47150e89000000ac");
                if (permOrgs == null || permOrgs.hasAllOrgPerm()) break;
                filters.add(new QFilter("org.id", "in", (Object)permOrgs.getHasPermOrgs()));
                break;
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        List filters = args.getQfilters();
        switch (fieldName) {
            case "payrollgrp.id": 
            case "payrollgrp.name": 
            case "payrollscene.id": 
            case "payrollscene.name": {
                HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)"hsas_payschedule", (String)"47150e89000000ac");
                if (permOrgs == null || permOrgs.hasAllOrgPerm()) break;
                filters.add(new QFilter("org.id", "in", (Object)permOrgs.getHasPermOrgs()));
                break;
            }
            case "calperiodtype.id": 
            case "calperiodtype.name": {
                QFilter baseDataFilter;
                HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)"hsas_payschedule", (String)"47150e89000000ac");
                if (permOrgs == null || permOrgs.hasAllOrgPerm() || (baseDataFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsbs_calperiodtype", (List)permOrgs.getHasPermOrgs(), (boolean)true)) == null) break;
                filters.add(baseDataFilter);
                break;
            }
            case "prepaybizaction.fbasedataid.id": 
            case "prepaybizaction.fbasedataid.name": {
                QFilter baseDataFilter;
                HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)"hsas_payschedule", (String)"47150e89000000ac");
                if (permOrgs == null || permOrgs.hasAllOrgPerm() || (baseDataFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsbs_paybizaction", (List)permOrgs.getHasPermOrgs(), (boolean)true)) == null) break;
                filters.add(baseDataFilter);
                break;
            }
        }
    }

    private CellStyle getListUnitStyle(String fieldKey, int rowNum, String foreColor) {
        CellStyle cellStyle = new CellStyle();
        cellStyle.setFieldKey(fieldKey);
        cellStyle.setRow(rowNum);
        cellStyle.setForeColor(foreColor);
        return cellStyle;
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey;
        super.afterDoOperation(e);
        switch (operateKey = e.getOperateKey()) {
            case "donothing_unstarted": 
            case "donothing_processing": 
            case "donothing_finished": {
                this.getView().invokeOperation("refresh");
                if (!e.getOperationResult().isSuccess()) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"PayScheduleList_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                break;
            }
            case "donothing_tplnew": {
                PayScheduleList.showTplNewPage("hsas_payschtplnewsch", (AbstractFormPlugin)this);
                break;
            }
            case "donothing_new": {
                this.showCusNewPage(null);
                break;
            }
        }
    }

    public void showCusNewPage(String data) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(HSAS_PAYSCHCUSNEWSCH);
        showParameter.setShowTitle(false);
        if (StringUtils.isNotEmpty((CharSequence)data)) {
            showParameter.setCustomParam("data", (Object)data);
        }
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack(this.getPluginName(), "action_create_success"));
        this.getView().showForm(showParameter);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        SWCDataServiceHelper swcDataServiceHelper = new SWCDataServiceHelper("hsas_payschedule");
        DynamicObject paySchDy = swcDataServiceHelper.queryOne(this.getFocusRowPkId());
        if (paySchDy == null) {
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u6570\u636e\u5df2\u88ab\u5220\u9664\u3002", (String)"PayScheduleList_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
            return;
        }
        if ("1".equals(paySchDy.getString("generatesource"))) {
            args.setCancel(true);
            this.showCusNewPage(SerializationUtils.serializeToBase64((Object)paySchDy));
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId = event.getActionId();
        if ("action_create_success".equals(actionId)) {
            String generateBatch = (String)event.getReturnData();
            PaySchTplHelper.showFilterListPage((String)generateBatch, (AbstractFormPlugin)this);
            this.getView().invokeOperation("refresh");
        }
    }

    public static void showTplNewPage(String formId, AbstractFormPlugin iFormPlugin) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack(iFormPlugin.getPluginName(), "action_create_success"));
        iFormPlugin.getView().showForm(showParameter);
    }
}

