/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.payschedule;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.swc.hsas.business.payschedule.PayScheduleHelper;
import kd.swc.hsas.common.enums.PayScheduleStatusEnum;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class PayScheduleStatusMarkPlugin
extends SWCDataBaseEdit {
    private static final String OP_MARK = "donothing_mark";
    private static final String KEY_UNSTARTED = "unstarted";
    private static final String KEY_PROCESSING = "processing";
    private static final String KEY_FINISHED = "finished";
    private static final String KEY_MARKSTATUS = "markstatus";
    private static final String PAGE_CACHE_PRESCHEDULE_INFO = "page_cache_preschedule_info";
    private static final String CONFIRMBACK_ID = "confirmback_id";
    private static final String YES_OR_NO = "yes_or_no";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.validateStatusAndSetEnable();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (OP_MARK.equals(operateKey)) {
            List<Map<String, String>> maps;
            if (formOperate.getOption().tryGetVariableValue(YES_OR_NO, new RefObject())) {
                return;
            }
            String markStatus = this.getModel().getDataEntity().getString(KEY_MARKSTATUS);
            if (SWCObjectUtils.isEmpty((Object)markStatus)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6807\u8bb0\u7684\u72b6\u6001\u3002", (String)"PayScheduleStatusMarkPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (PayScheduleStatusEnum.FINISHED.getCode().equals(markStatus) && (maps = this.validatePrePayScheduleStatus()) != null && !maps.isEmpty()) {
                args.setCancel(true);
                StringBuilder sb = new StringBuilder();
                for (Map<String, String> map : maps) {
                    String name = map.get("name");
                    String startDate = map.get("startdate");
                    String endDate = map.get("enddate");
                    sb.append(name).append(':').append(startDate).append('~').append(endDate).append("\r\n");
                }
                String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u4ee5\u4e0b\u524d\u5e8f\u65e5\u7a0b\u672a\u5b8c\u6210\uff0c\u662f\u5426\u5168\u90e8\u6807\u8bb0\uff1f", (String)"PayScheduleStatusMarkPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CONFIRMBACK_ID, (IFormPlugin)this);
                HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
                btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u5426", (String)"PayScheduleStatusMarkPlugin_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u662f", (String)"PayScheduleStatusMarkPlugin_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                MessageBoxOptions options = MessageBoxOptions.OKCancel;
                this.getView().showConfirm(msg, sb.toString(), options, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        OperateOption option = formOperate.getOption();
        String operateKey = args.getOperateKey();
        if (OP_MARK.equals(operateKey)) {
            String yesOrNo;
            String markStatus = this.getModel().getDataEntity().getString(KEY_MARKSTATUS);
            HashSet<Long> payScheduleIds = new HashSet<Long>(16);
            payScheduleIds.add(this.getPayScheduleId());
            if (option.tryGetVariableValue(YES_OR_NO, new RefObject()) && SWCObjectUtils.equals((Object)(yesOrNo = option.getVariableValue(YES_OR_NO)), (Object)"yes")) {
                String str = this.getView().getPageCache().get(PAGE_CACHE_PRESCHEDULE_INFO);
                List cacheMapInfo = (List)SerializationUtils.fromJsonString((String)str, List.class);
                for (Map map : cacheMapInfo) {
                    payScheduleIds.add(Long.parseLong((String)map.get("id")));
                }
            }
            DynamicObject[] payScheduleDys = null;
            if (PayScheduleStatusEnum.UNSTARTED.getCode().equals(markStatus)) {
                payScheduleDys = this.markPayScheduleStatus(payScheduleIds, "donothing_unstarted");
            } else if (PayScheduleStatusEnum.PROCESSING.getCode().equals(markStatus)) {
                payScheduleDys = this.markPayScheduleStatus(payScheduleIds, "donothing_processing");
            } else if (PayScheduleStatusEnum.FINISHED.getCode().equals(markStatus)) {
                payScheduleDys = this.markPayScheduleStatus(payScheduleIds, "donothing_finished");
            }
            this.getView().returnDataToParent((Object)payScheduleDys);
            this.getView().close();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId = event.getCallBackId();
        MessageBoxResult result = event.getResult();
        switch (callBackId) {
            case "confirmback_id": {
                OperateOption markOperate = OperateOption.create();
                if (MessageBoxResult.Cancel.equals((Object)result)) {
                    markOperate.setVariableValue(YES_OR_NO, "no");
                } else {
                    markOperate.setVariableValue(YES_OR_NO, "yes");
                }
                this.getView().invokeOperation(OP_MARK, markOperate);
                break;
            }
        }
    }

    private void validateStatusAndSetEnable() {
        Long payScheduleId = this.getPayScheduleId();
        if (payScheduleId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u85aa\u8d44\u65e5\u7a0b\u6570\u636e\u4e22\u5931\u3002", (String)"PayScheduleStatusMarkPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        SWCDataServiceHelper paySchHelper = new SWCDataServiceHelper("hsas_payschedule");
        String selProps = "schedulestatus";
        QFilter qFilter = new QFilter("id", "=", (Object)payScheduleId);
        DynamicObject payScheduleDy = paySchHelper.queryOne(selProps, qFilter.toArray());
        if (payScheduleDy == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u85aa\u8d44\u65e5\u7a0b\u6570\u636e\u4e22\u5931\u3002", (String)"PayScheduleStatusMarkPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        String scheduleStatus = payScheduleDy.getString("schedulestatus");
        if (PayScheduleStatusEnum.OVERDUE_FINISHED.getCode().equals(scheduleStatus)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{KEY_UNSTARTED, KEY_PROCESSING, KEY_FINISHED});
        } else if (PayScheduleStatusEnum.PROCESSING.getCode().equals(scheduleStatus)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{KEY_PROCESSING});
        } else if (PayScheduleStatusEnum.FINISHED.getCode().equals(scheduleStatus)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{KEY_FINISHED});
        } else if (PayScheduleStatusEnum.OVERDUE.getCode().equals(scheduleStatus)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{KEY_UNSTARTED, KEY_PROCESSING});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{KEY_UNSTARTED});
        }
    }

    private List<Map<String, String>> validatePrePayScheduleStatus() {
        Long payScheduleId = this.getPayScheduleId();
        if (payScheduleId == null) {
            return null;
        }
        SWCDataServiceHelper paySchHelper = new SWCDataServiceHelper("hsas_payschedule");
        String selProps = "payschtpl,calperiod,prepaybizaction,schedulestatus";
        QFilter qFilter = new QFilter("id", "=", (Object)payScheduleId);
        DynamicObject payScheduleDy = paySchHelper.queryOne(selProps, qFilter.toArray());
        if (payScheduleDy == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u85aa\u8d44\u65e5\u7a0b\u6570\u636e\u4e22\u5931\u3002", (String)"PayScheduleStatusMarkPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return null;
        }
        SWCDataServiceHelper paySchTplHelper = new SWCDataServiceHelper("hsas_payscheduletpl");
        selProps = "entryentity,paybizaction,prepaybizaction";
        long paySchTplId = payScheduleDy.getLong("payschtpl.id");
        QFilter filter = new QFilter("id", "=", (Object)paySchTplId);
        DynamicObject payScheduleTplDy = paySchTplHelper.queryOne(selProps, filter.toArray());
        if (payScheduleTplDy == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u85aa\u8d44\u65e5\u7a0b\u6a21\u677f\u6570\u636e\u4e22\u5931\u3002", (String)"PayScheduleStatusMarkPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return null;
        }
        DynamicObjectCollection prePayBizActions = payScheduleDy.getDynamicObjectCollection("prepaybizaction");
        HashSet<Long> curPreIds = new HashSet<Long>(16);
        for (DynamicObject prePayBizAction : prePayBizActions) {
            curPreIds.add(prePayBizAction.getLong("fbasedataid_id"));
        }
        if (curPreIds.size() == 1 && curPreIds.contains(1139088596750377984L)) {
            return null;
        }
        DynamicObjectCollection dyColl = payScheduleTplDy.getDynamicObjectCollection("entryentity");
        HashSet<Long> allPreIds = new HashSet<Long>(16);
        allPreIds.addAll(curPreIds);
        this.setAllPreMap(this.getEntryPreMap(dyColl), curPreIds, allPreIds);
        QFilter actFilter = new QFilter("paybizaction", "in", allPreIds);
        QFilter periodFilter = new QFilter("calperiod", "=", (Object)payScheduleDy.getLong("calperiod.id"));
        QFilter tplFilter = new QFilter("payschtpl", "=", (Object)paySchTplId);
        selProps = "id,name,startdate,enddate,schedulestatus";
        DynamicObject[] payScheduleDys = paySchHelper.query(selProps, new QFilter[]{actFilter, periodFilter, tplFilter});
        ArrayList<Map<String, String>> cacheMapInfo = new ArrayList<Map<String, String>>(payScheduleDys.length);
        for (DynamicObject dyObj : payScheduleDys) {
            String scheduleStatus = dyObj.getString("schedulestatus");
            if (PayScheduleStatusEnum.FINISHED.getCode().equals(scheduleStatus) || PayScheduleStatusEnum.OVERDUE_FINISHED.getCode().equals(scheduleStatus)) continue;
            HashMap<String, String> map = new HashMap<String, String>(16);
            map.put("id", dyObj.getString("id"));
            map.put("name", dyObj.getString("name"));
            map.put("startdate", HRInteDateTimeUtil.formatDate((String)"hsas_payschedule", (String)"startdate", (Date)dyObj.getDate("startdate")));
            map.put("enddate", HRInteDateTimeUtil.formatDate((String)"hsas_payschedule", (String)"enddate", (Date)dyObj.getDate("enddate")));
            cacheMapInfo.add(map);
        }
        this.getView().getPageCache().put(PAGE_CACHE_PRESCHEDULE_INFO, SerializationUtils.toJsonString(cacheMapInfo));
        return cacheMapInfo;
    }

    private DynamicObject[] markPayScheduleStatus(Set<Long> payScheduleIds, String markOp) {
        SWCDataServiceHelper paySchHelper = new SWCDataServiceHelper("hsas_payschedule");
        String selProps = "id,schedulestatus,markuser,finishtime";
        QFilter qFilter = new QFilter("id", "in", payScheduleIds);
        DynamicObject[] payScheduleDys = paySchHelper.query(selProps, qFilter.toArray());
        PayScheduleHelper.markPayScheduleStatus((String)markOp, (DynamicObject[])payScheduleDys);
        paySchHelper.save(payScheduleDys);
        return payScheduleDys;
    }

    private Map<Long, List<Long>> getEntryPreMap(DynamicObjectCollection dyColl) {
        HashMap<Long, List<Long>> nodeMap = new HashMap<Long, List<Long>>(dyColl.size());
        for (DynamicObject dyObj : dyColl) {
            ArrayList<Long> prePayTasks = new ArrayList<Long>(10);
            DynamicObjectCollection mulBaseData = dyObj.getDynamicObjectCollection("prepaybizaction");
            for (DynamicObject prepaybizaction : mulBaseData) {
                prePayTasks.add(prepaybizaction.getLong("fbasedataid_id"));
            }
            nodeMap.put(dyObj.getLong("paybizaction.id"), prePayTasks);
        }
        return nodeMap;
    }

    private void setAllPreMap(Map<Long, List<Long>> preMap, Set<Long> curSet, Set<Long> preSet) {
        HashSet<Long> prePayBizActionIds = new HashSet<Long>(16);
        for (Map.Entry<Long, List<Long>> entry : preMap.entrySet()) {
            if (!curSet.contains(entry.getKey())) continue;
            List<Long> preIds = entry.getValue();
            preSet.addAll(preIds);
            for (Long preId : preIds) {
                if (curSet.contains(preId)) continue;
                prePayBizActionIds.add(preId);
            }
        }
        if (prePayBizActionIds.isEmpty()) {
            return;
        }
        this.setAllPreMap(preMap, prePayBizActionIds, preSet);
    }

    private Long getPayScheduleId() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String payScheduleIdStr = (String)formShowParameter.getCustomParam("payScheduleId");
        if (SWCObjectUtils.isEmpty((Object)payScheduleIdStr)) {
            return null;
        }
        return Long.parseLong(payScheduleIdStr.trim());
    }
}

