/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.payschedule;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.swc.hsas.business.payschedule.PaySchTplHelper;
import kd.swc.hsas.business.payschedule.PayScheduleHelper;
import kd.swc.hsas.common.enums.PayScheduleStatusEnum;
import kd.swc.hsbp.business.coderule.CodeRuleHelper;
import kd.swc.hsbp.business.log.SWCOpLogServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCInteDateTimeUtil;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class PayScheduleTplNewSchPlugin
extends SWCDataBaseEdit
implements BeforeF7SelectListener {
    private static final String KEY_PAYSCHTPL = "payschtpl";
    private static final String KEY_STARTPERIOD = "startperiod";
    private static final String KEY_PERIODCOUNT = "periodcount";
    private static final String LABEL_PERIODNAME = "periodname";
    private static final String LABEL_PERIODCOUNTLABEL = "periodcountlabel";
    private static final String TIP_FLEX_PANEL = "tipflexpanelap";
    private static final String LABEL_FIRSTPERIODNAME = "firstperiodname";
    private static final String LABEL_FIRSTPERIODDATE = "firstperioddate";
    private static final String LABEL_LASTPERIODNAME = "lastperiodname";
    private static final String LABEL_LASTPERIODDATE = "lastperioddate";
    private static final String OP_NEW_SCHEDULE = "donothing_newsch";
    private static final String QXX_CREATURE_PAYSCH = "1T5CUVT4+S+A";
    private static final String ACTION_CLOSE_CALLBACK_CHECK = "action_close_callback_check";
    private static final String ACTION_CLOSE_CALLBACK_KNOW = "action_close_callback_know";
    private static final String HSAS_CREATEPAYSCHRESULT = "hsas_createpayschresult";
    private static ThreadLocal<String> thBatch = new ThreadLocal();
    private static final Log logger = LogFactory.getLog(PayScheduleTplNewSchPlugin.class);

    public void registerListener(EventObject e) {
        BasedataEdit startPeriodEdit = (BasedataEdit)this.getControl(KEY_STARTPERIOD);
        startPeriodEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit payschTpl = (BasedataEdit)this.getControl(KEY_PAYSCHTPL);
        if (payschTpl != null) {
            payschTpl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeBindData(EventObject e) {
        Long paySchTplId;
        super.beforeBindData(e);
        DynamicObject startPeriodDys = this.getModel().getDataEntity().getDynamicObject(KEY_STARTPERIOD);
        String periodCount = this.getModel().getDataEntity().getString(KEY_PERIODCOUNT);
        if (SWCObjectUtils.isEmpty((Object)startPeriodDys) || SWCObjectUtils.isEmpty((Object)periodCount)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{TIP_FLEX_PANEL});
        }
        if ((paySchTplId = (Long)this.getView().getFormShowParameter().getCustomParam("paySchTplId")) == null || paySchTplId == 0L) {
            this.getView().setEnable(Boolean.FALSE, new String[]{KEY_STARTPERIOD});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_PAYSCHTPL});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String fieldKey = event.getProperty().getName();
        if (KEY_STARTPERIOD.equals(fieldKey)) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Object periodTypeId = this.getPeriodTypeId(formShowParameter);
            if (periodTypeId != null) {
                ListShowParameter param = (ListShowParameter)event.getFormShowParameter();
                QFilter qFilter = new QFilter("periodtypeid", "=", periodTypeId);
                QFilter periodForBdProp = SWCPermissionServiceHelper.getDataRuleForBdProp((String)"/UHMBBGZQ65X", (String)"hsas_payschedule", (String)"calperiod");
                if (periodForBdProp != null) {
                    logger.info("\u671f\u95f4 \u6570\u636e\u6743\u9650\u53ca\u6570\u636e\u89c4\u5219\u6743\u9650 periodForBdProp {}", (Object)periodForBdProp);
                    qFilter.and(periodForBdProp);
                }
                param.getListFilterParameter().setFilter(qFilter);
                SWCDataServiceHelper swcDataServiceHelper = new SWCDataServiceHelper("hsbs_calperiodtype");
                DynamicObject periodType = swcDataServiceHelper.queryOne("name", periodTypeId);
                if (periodType != null) {
                    this.getView().getPageCache().put("periodtypename", periodType.getString("name"));
                }
            }
        } else if (KEY_PAYSCHTPL.equals(fieldKey)) {
            HasPermOrgResult permOrgs;
            QFilter tplForBdProp = SWCPermissionServiceHelper.getDataRuleForBdProp((String)"/UHMBBGZQ65X", (String)"hsas_payschedule", (String)KEY_PAYSCHTPL);
            if (tplForBdProp != null) {
                logger.info("\u85aa\u8d44\u65e5\u7a0b\u4e0a\u7684\u85aa\u8d44\u65e5\u7a0b\u6a21\u677f \u6570\u636e\u6743\u9650\u8fc7\u6ee4 tplForBdProp {}", (Object)tplForBdProp);
                ((ListShowParameter)event.getFormShowParameter()).getListFilterParameter().setFilter(tplForBdProp);
            }
            if (!(permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)"hsas_payschedule", (String)"47156aff000000ac")).hasAllOrgPerm()) {
                QFilter qFilter = new QFilter("org", "in", (Object)permOrgs.getHasPermOrgs());
                ((ListShowParameter)event.getFormShowParameter()).getListFilterParameter().setFilter(qFilter);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "donothing_newsch": {
                this.clickSureToCreateSchedule(operate);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldName;
        switch (fieldName = e.getProperty().getName()) {
            case "payschtpl": {
                this.getModel().setValue(KEY_STARTPERIOD, null);
                this.getView().setEnable(Boolean.valueOf(Objects.nonNull(e.getChangeSet()[0].getNewValue())), new String[]{KEY_STARTPERIOD});
                break;
            }
            case "startperiod": {
                this.checkNextPeriod();
                this.setLabelInfo();
                break;
            }
            case "periodcount": {
                this.setLabelInfo();
                break;
            }
        }
    }

    private Object getPaySchTplId(FormShowParameter parameter) {
        Long paySchTplId = (Long)parameter.getCustomParam("paySchTplId");
        if (paySchTplId == null || paySchTplId == 0L) {
            return this.getModel().getDataEntity().get("payschtpl.id");
        }
        return paySchTplId;
    }

    private Object getPeriodTypeId(FormShowParameter parameter) {
        Long periodTypeId = (Long)parameter.getCustomParam("periodTypeId");
        if (periodTypeId == null || periodTypeId == 0L) {
            return this.getModel().getDataEntity().get("payschtpl.calperiodtype.id");
        }
        return periodTypeId;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId;
        super.confirmCallBack(messageBoxClosedEvent);
        switch (callBackId = messageBoxClosedEvent.getCallBackId()) {
            case "action_close_callback_check": {
                int result = messageBoxClosedEvent.getResult().getValue();
                OperateOption operateOption = OperateOption.create();
                if (MessageBoxResult.Yes.getValue() == result) {
                    operateOption.setVariableValue(OP_NEW_SCHEDULE, "true");
                    this.getView().invokeOperation(OP_NEW_SCHEDULE, operateOption);
                    break;
                }
                if (MessageBoxResult.No.getValue() != result) break;
                operateOption.setVariableValue(OP_NEW_SCHEDULE, "false");
                this.getView().invokeOperation(OP_NEW_SCHEDULE, operateOption);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId;
        super.closedCallBack(event);
        switch (actionId = event.getActionId()) {
            case "action_close_callback_know": {
                this.getView().returnDataToParent(event.getReturnData());
                this.getView().close();
                break;
            }
        }
    }

    private void clickSureToCreateSchedule(FormOperate operate) {
        DynamicObject periodDy;
        DynamicObject startPeriodDy = this.getModel().getDataEntity().getDynamicObject(KEY_STARTPERIOD);
        String periodCount = this.getModel().getDataEntity().getString(KEY_PERIODCOUNT);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Object paySchTplId = this.getPaySchTplId(parameter);
        Object periodTypeId = this.getPeriodTypeId(this.getView().getFormShowParameter());
        DynamicObjectCollection periodDys = PaySchTplHelper.getPeriodDys((Object)periodTypeId);
        int index = 0;
        Iterator iterator = periodDys.iterator();
        while (iterator.hasNext() && !SWCObjectUtils.equals((Object)startPeriodDy, (Object)(periodDy = (DynamicObject)iterator.next()))) {
            ++index;
        }
        int periodCountInt = Integer.parseInt(periodCount);
        DynamicObject paySchTplDy = PaySchTplHelper.queryPaySchTplDy((Object)paySchTplId);
        HashMap<String, List<Long>> existSchMap = new HashMap(16);
        boolean isRecover = false;
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u6309\u6a21\u677f\u65b0\u589e", "PayScheduleTplNewSchPlugin_14", "swc-hsas-formplugin");
        if (!operate.getOption().tryGetVariableValue(OP_NEW_SCHEDULE, new RefObject())) {
            if ("1".equals(paySchTplDy.getString("actdatetype")) && "1".equals(paySchTplDy.getString("selperiod")) && index + periodCountInt + 1 > periodDys.size()) {
                String msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6309\u5f53\u524d\u671f\u95f4\u7684\u4e0b\u4e00\u671f\u95f4\u751f\u6210\uff0c\u751f\u6210\u671f\u6570\u8fc7\u5927\uff0c\u5f53\u524d\u6240\u9009\u671f\u95f4\u6700\u5927\u751f\u6210%s\u671f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PayScheduleTplNewSchPlugin_15", (String)"swc-hsas-formplugin", (Object[])new Object[0]), periodDys.size() - index - 1);
                this.getView().showErrorNotification(msg);
                MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u6309\u5f53\u524d\u671f\u95f4\u7684\u4e0b\u4e00\u671f\u95f4\u751f\u6210\uff0c\u751f\u6210\u671f\u6570\u8fc7\u5927\uff0c\u5f53\u524d\u6240\u9009\u671f\u95f4\u6700\u5927\u751f\u6210%s\u671f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", "PayScheduleTplNewSchPlugin_15", "swc-hsas-formplugin");
                SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)"new by template", (MultiLangEnumBridge)opName, (String)"", (MultiLangEnumBridge)opDesc, (String[])new String[]{periodDys.size() - index - 1 + ""});
                return;
            }
            if (index + periodCountInt > periodDys.size()) {
                String msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u671f\u95f4\u6700\u591a\u53ef\u751f\u6210%s\u671f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PayScheduleTplNewSchPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]), periodDys.size() - index);
                this.getView().showErrorNotification(msg);
                MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u5f53\u524d\u6240\u9009\u671f\u95f4\u6700\u591a\u53ef\u751f\u6210%s\u671f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", "PayScheduleTplNewSchPlugin_0", "swc-hsas-formplugin");
                SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)"new by template", (MultiLangEnumBridge)opName, (String)"", (MultiLangEnumBridge)opDesc, (String[])new String[]{periodDys.size() - index + ""});
                return;
            }
            long payRollGrpvId = paySchTplDy.getLong("payrollgrpv.id");
            SWCDataServiceHelper payRollGrpHelper = new SWCDataServiceHelper("hsas_payrollgrp");
            QFilter payRollGrpFilter = new QFilter("id", "=", (Object)payRollGrpvId);
            payRollGrpFilter.and("datastatus", "in", (Object)new String[]{"2", "-2"});
            boolean isPayRollGrpInvalid = payRollGrpHelper.isExists(payRollGrpFilter.toArray());
            if (isPayRollGrpInvalid) {
                String msg = ResManager.loadKDString((String)"\u8be5\u6a21\u677f\u7684\u85aa\u8d44\u6838\u7b97\u7ec4\u7248\u672c\u5df2\u5931\u6548\uff0c\u8bf7\u4fee\u6539\u85aa\u8d44\u65e5\u7a0b\u6a21\u677f\u7684\u85aa\u8d44\u6838\u7b97\u7ec4\u7248\u672c\u540e\u518d\u751f\u6210\u65e5\u7a0b\u3002", (String)"PayScheduleTplNewSchPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
                MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u8be5\u6a21\u677f\u7684\u85aa\u8d44\u6838\u7b97\u7ec4\u7248\u672c\u5df2\u5931\u6548\uff0c\u8bf7\u4fee\u6539\u85aa\u8d44\u65e5\u7a0b\u6a21\u677f\u7684\u85aa\u8d44\u6838\u7b97\u7ec4\u7248\u672c\u540e\u518d\u751f\u6210\u65e5\u7a0b\u3002", "PayScheduleTplNewSchPlugin_3", "swc-hsas-formplugin");
                SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)"new by template", (MultiLangEnumBridge)opName, (String)"", (MultiLangEnumBridge)opDesc, (String[])new String[]{periodDys.size() - index + ""});
                return;
            }
            DynamicObject[] existPaySchDys = this.getExistPaySchDys(periodDys, index, periodCountInt, paySchTplDy);
            if (existPaySchDys != null && existPaySchDys.length > 0) {
                String msg = ResManager.loadKDString((String)"\u4e0b\u5217\u671f\u95f4\u5df2\u5b58\u5728\u65e5\u7a0b\uff0c\u662f\u5426\u8986\u76d6\u539f\u65e5\u7a0b\uff1f", (String)"PayScheduleTplNewSchPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                String msgPrefix = ResManager.loadKDString((String)"\u671f\u95f4\u540d\u79f0", (String)"PayScheduleTplNewSchPlugin_16", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                StringBuilder moreInfo = new StringBuilder();
                int indexStr = 1;
                HashMap<Long, String> existPeriodIdNameMap = new HashMap<Long, String>(16);
                for (DynamicObject paySchDy : existPaySchDys) {
                    existPeriodIdNameMap.put(paySchDy.getLong("calperiod.id"), paySchDy.getString("calperiod.name"));
                }
                for (Map.Entry entry : existPeriodIdNameMap.entrySet()) {
                    moreInfo.append('(').append(indexStr).append(')').append(msgPrefix).append(": ");
                    moreInfo.append((String)entry.getValue()).append("\r\n");
                    ++indexStr;
                }
                HashMap<Integer, String> map = new HashMap<Integer, String>(3);
                map.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u662f", (String)"PayScheduleTplNewSchPlugin_9", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                map.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u5426", (String)"PayScheduleTplNewSchPlugin_10", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                this.getView().showConfirm(msg, moreInfo.toString(), MessageBoxOptions.YesNoCancel, ConfirmTypes.Default, new ConfirmCallBackListener(ACTION_CLOSE_CALLBACK_CHECK, (IFormPlugin)this), map);
                return;
            }
        } else {
            existSchMap = this.validateExistPaySchDys(periodDys, index, periodCountInt, paySchTplDy);
            if (SWCStringUtils.equals((String)"true", (String)operate.getOption().getVariableValue(OP_NEW_SCHEDULE))) {
                isRecover = true;
            }
        }
        if (!SWCPermissionServiceHelper.hasPerm((String)"/UHMBBGZQ65X", (String)"hsas_payschedule", (String)"47156aff000000ac")) {
            String msg = ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u6ca1\u6709\u201c\u85aa\u8d44\u65e5\u7a0b\u201d\u65b0\u589e\u6743\u9650\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\u3002", (String)"PayScheduleTplNewSchPlugin_12", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u5bf9\u4e0d\u8d77\uff0c\u60a8\u6ca1\u6709\u201c\u85aa\u8d44\u65e5\u7a0b\u201d\u65b0\u589e\u6743\u9650\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\u3002", "PayScheduleTplNewSchPlugin_12", "swc-hsas-formplugin");
            SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)"new by template", (MultiLangEnumBridge)opName, (String)"", (MultiLangEnumBridge)opDesc, (String[])new String[]{periodDys.size() - index + ""});
            return;
        }
        ArrayList<String> errorMsg = new ArrayList<String>(10);
        HashMap<String, Integer> statisticsMap = new HashMap<String, Integer>(16);
        String generateBatch = String.valueOf(DB.genGlobalLongId());
        thBatch.set(generateBatch);
        this.createSchedules(startPeriodDy, periodDys, index, periodCountInt, paySchTplDy, existSchMap, isRecover, errorMsg, statisticsMap);
        if ((Integer)statisticsMap.get("success") > 0) {
            PayScheduleHelper.clearTreeNodeInCache();
        }
        this.showErrorMsg(errorMsg, statisticsMap);
        thBatch.remove();
    }

    private Map<String, List<Long>> validateExistPaySchDys(DynamicObjectCollection periodDys, int index, int periodCountInt, DynamicObject paySchTplDy) {
        HashMap<String, List<Long>> existSchMap = new HashMap<String, List<Long>>(16);
        DynamicObject[] existPaySchDys = this.getExistPaySchDys(periodDys, index, periodCountInt, paySchTplDy);
        if (existPaySchDys != null && existPaySchDys.length > 0) {
            HashMap<Long, String> existPeriodIdNameMap = new HashMap<Long, String>(16);
            for (DynamicObject paySchDy : existPaySchDys) {
                existPeriodIdNameMap.put(paySchDy.getLong("calperiod.id"), paySchDy.getString("calperiod.name"));
            }
            for (Map.Entry entry : existPeriodIdNameMap.entrySet()) {
                Long existPeriodId = (Long)entry.getKey();
                ArrayList<Long> paySchIds = new ArrayList<Long>(10);
                for (DynamicObject paySchDy : existPaySchDys) {
                    if (paySchDy.getLong("calperiod.id") != existPeriodId.longValue()) continue;
                    paySchIds.add(paySchDy.getLong("id"));
                    existSchMap.put(String.valueOf(existPeriodId), paySchIds);
                }
            }
        }
        return existSchMap;
    }

    private void createSchedules(DynamicObject startPeriod, DynamicObjectCollection periodDys, int index, int periodCountInt, DynamicObject paySchTplDy, Map<String, List<Long>> existPaySchMap, boolean isRecover, List<String> errorMsg, Map<String, Integer> statisticsMap) {
        Map subEntryMap = PaySchTplHelper.queryTplSubEntryInfoMap((DynamicObject)paySchTplDy);
        MainEntityType paySchType = EntityMetadataCache.getDataEntityType((String)"hsas_payschedule");
        long userId = RequestContext.get().getCurrUserId();
        Date createDate = new Date();
        DynamicObjectCollection payScheduleDyColls = new DynamicObjectCollection();
        DynamicObject logDy = this.getLogDy(startPeriod, periodCountInt, paySchTplDy, userId, createDate);
        statisticsMap.put("total", 0);
        statisticsMap.put("success", 0);
        statisticsMap.put("fail", 0);
        if (existPaySchMap.isEmpty()) {
            for (int i = 0; i < periodCountInt; ++i) {
                DynamicObject nextPeriod = null;
                if (index + i + 1 < periodDys.size()) {
                    nextPeriod = (DynamicObject)periodDys.get(index + i + 1);
                }
                DynamicObjectCollection payScheduleDyColl = this.getPayScheduleDyColl(paySchTplDy, (DynamicObject)periodDys.get(index + i), nextPeriod, subEntryMap, createDate, userId, (DynamicObjectType)paySchType, logDy, errorMsg, statisticsMap);
                payScheduleDyColls.addAll((Collection)payScheduleDyColl);
            }
        } else if (isRecover) {
            ArrayList<Long> schIdList = new ArrayList<Long>(10);
            for (int i = 0; i < periodCountInt; ++i) {
                DynamicObject periodDy = (DynamicObject)periodDys.get(index + i);
                String periodId = periodDy.getString("id");
                List<Long> list = existPaySchMap.get(periodId);
                if (list != null && !list.isEmpty()) {
                    schIdList.addAll(list);
                }
                DynamicObject nextPeriod = null;
                if (index + i + 1 < periodDys.size()) {
                    nextPeriod = (DynamicObject)periodDys.get(index + i + 1);
                }
                DynamicObjectCollection payScheduleDyColl = this.getPayScheduleDyColl(paySchTplDy, periodDy, nextPeriod, subEntryMap, createDate, userId, (DynamicObjectType)paySchType, logDy, errorMsg, statisticsMap);
                payScheduleDyColls.addAll((Collection)payScheduleDyColl);
            }
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_payschedule");
            QFilter filter = new QFilter("id", "in", schIdList);
            helper.deleteByFilter(filter.toArray());
        } else {
            for (int i = 0; i < periodCountInt; ++i) {
                DynamicObject periodDy = (DynamicObject)periodDys.get(index + i);
                if (existPaySchMap.containsKey(periodDy.getString("id"))) continue;
                DynamicObject nextPeriod = null;
                if (index + i + 1 < periodDys.size()) {
                    nextPeriod = (DynamicObject)periodDys.get(index + i + 1);
                }
                DynamicObjectCollection payScheduleDyColl = this.getPayScheduleDyColl(paySchTplDy, periodDy, nextPeriod, subEntryMap, createDate, userId, (DynamicObjectType)paySchType, logDy, errorMsg, statisticsMap);
                payScheduleDyColls.addAll((Collection)payScheduleDyColl);
            }
        }
        SWCDataServiceHelper paySchHelper = new SWCDataServiceHelper("hsas_payschedule");
        SWCDataServiceHelper logHelper = new SWCDataServiceHelper("hsas_payschtpllog");
        if (payScheduleDyColls.size() > 0) {
            TXHandle txHandle = TX.required();
            try {
                paySchHelper.save(payScheduleDyColls);
            }
            catch (Exception e) {
                txHandle.markRollback();
                logDy.set("createstatus", (Object)"1");
                throw e;
            }
            finally {
                txHandle.close();
                logHelper.saveOne(logDy);
            }
        }
    }

    private DynamicObject getLogDy(DynamicObject startPeriod, int periodCountInt, DynamicObject paySchTplDy, long userId, Date createDate) {
        MainEntityType paySchTplLogType = EntityMetadataCache.getDataEntityType((String)"hsas_payschtpllog");
        DynamicObject logDy = (DynamicObject)paySchTplLogType.createInstance();
        String logNumber = this.getLogNumber(paySchTplDy.getString("name"), createDate, periodCountInt);
        logDy.set("number", (Object)logNumber);
        logDy.set("creator", (Object)userId);
        logDy.set("modifier", (Object)userId);
        logDy.set("createtime", (Object)createDate);
        logDy.set("modifytime", (Object)createDate);
        logDy.set("period", (Object)startPeriod.getLong("id"));
        String batch = thBatch.get();
        logDy.set("generatebatch", (Object)batch);
        logDy.set("periodnum", (Object)periodCountInt);
        logDy.set(KEY_PAYSCHTPL, (Object)paySchTplDy.getLong("id"));
        logDy.set("createstatus", (Object)"0");
        return logDy;
    }

    private String getLogNumber(String paySchTplName, Date createDate, int i) {
        return "Create-" + paySchTplName + "-" + SWCDateTimeUtils.format((Date)createDate) + "-" + String.format(Locale.ROOT, "%03d", i);
    }

    private DynamicObject[] getExistPaySchDys(DynamicObjectCollection periodDys, int index, int periodCountInt, DynamicObject paySchTplDy) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_payschedule");
        ArrayList<Long> periodIds = new ArrayList<Long>(10);
        for (int i = 0; i < periodCountInt; ++i) {
            DynamicObject periodDy = (DynamicObject)periodDys.get(index + i);
            periodIds.add(periodDy.getLong("id"));
        }
        QFilter filter = new QFilter("calperiod", "in", periodIds);
        filter.and("org", "=", (Object)paySchTplDy.getLong("org.id"));
        filter.and("payrollgrpv", "=", (Object)paySchTplDy.getLong("payrollgrpv.id"));
        filter.and("payrollscene", "=", (Object)paySchTplDy.getLong("payrollscene.id"));
        filter.and("calperiodtype", "=", (Object)paySchTplDy.getLong("calperiodtype.id"));
        DynamicObjectCollection dyColl = paySchTplDy.getDynamicObjectCollection("entryentity");
        ArrayList<Long> payBizActIds = new ArrayList<Long>(10);
        for (DynamicObject dyObj : dyColl) {
            payBizActIds.add(dyObj.getLong("paybizaction.id"));
        }
        filter.and("paybizaction", "in", payBizActIds);
        return helper.queryOriginalArray("id,calperiod.id,calperiod.name", filter.toArray());
    }

    private DynamicObjectCollection getPayScheduleDyColl(DynamicObject paySchTplDy, DynamicObject startPeriod, DynamicObject nextPeriod, Map<Long, List<Map<String, Object>>> subEntryMap, Date createDate, long userId, DynamicObjectType type, DynamicObject logDy, List<String> errorMsg, Map<String, Integer> statisticsMap) {
        DynamicObjectCollection paySchDyColl = new DynamicObjectCollection();
        DynamicObjectCollection paySchTplEntryDyColl = paySchTplDy.getDynamicObjectCollection("entryentity");
        Date selPayTaskDate = PaySchTplHelper.getSelPayTaskDate((DynamicObject)paySchTplDy, (DynamicObject)startPeriod, (DynamicObject)nextPeriod);
        List workCalendar = PayScheduleHelper.getWorkCalendar((Long)paySchTplDy.getLong("workplan.id"), (int)SWCDateTimeUtils.getYear((Date)selPayTaskDate));
        long payBizProcId = paySchTplDy.getLong("paybizproc.id");
        DynamicObjectCollection payBizProcEntry = paySchTplDy.getDynamicObjectCollection("entryentity");
        Map entryPreMap = PaySchTplHelper.getEntryPreMap((DynamicObjectCollection)payBizProcEntry);
        Map paySchDate = PaySchTplHelper.getPaySchDate((DynamicObject)paySchTplDy, (Date)selPayTaskDate, (List)workCalendar, (Map)entryPreMap);
        int serialNum = 1;
        for (DynamicObject dyObj : paySchTplEntryDyColl) {
            DynamicObject paySchDy;
            long bizActId = dyObj.getLong("paybizaction.id");
            if (1139088596750377984L == bizActId || 1139088905400819712L == bizActId || !this.setPaySchDy(paySchTplDy, startPeriod, createDate, userId, payBizProcId, entryPreMap, dyObj, bizActId, paySchDy = (DynamicObject)type.createInstance(), subEntryMap, paySchDate, logDy, errorMsg, serialNum, statisticsMap)) continue;
            paySchDyColl.add((Object)paySchDy);
            ++serialNum;
        }
        return paySchDyColl;
    }

    private boolean setPaySchDy(DynamicObject paySchTplDy, DynamicObject startPeriod, Date createDate, long userId, long payBizProcId, Map<Long, List<Long>> entryPreMap, DynamicObject paySchTplEntryDyObj, long bizActId, DynamicObject paySchDy, Map<Long, List<Map<String, Object>>> subEntryMap, Map<Long, Map<String, Date>> paySchDate, DynamicObject logDy, List<String> errorMsg, int serialNum, Map<String, Integer> statisticsMap) {
        Integer total = statisticsMap.get("total");
        statisticsMap.put("total", total + 1);
        Map<String, Date> dateMap = paySchDate.get(bizActId);
        Date endDate = dateMap.get("endDate");
        if (new Date(System.currentTimeMillis()).after(endDate)) {
            Integer fail = statisticsMap.get("fail");
            statisticsMap.put("fail", fail + 1);
            String periodName = ResManager.loadKDString((String)"\u85aa\u8d44\u671f\u95f4", (String)"PayScheduleTplNewSchPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            String payBizActName = ResManager.loadKDString((String)"\u7b97\u53d1\u85aa\u6b65\u9aa4", (String)"PayScheduleTplNewSchPlugin_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            StringBuilder msgSb = new StringBuilder();
            msgSb.append(payBizActName).append(": ").append(paySchTplEntryDyObj.getString("paybizaction.name"));
            msgSb.append(',').append(periodName).append(": ").append(startPeriod.getString("name"));
            msgSb.append("\r\n");
            errorMsg.add(msgSb.toString());
            logDy.set("createstatus", (Object)"1");
            return false;
        }
        Integer success = statisticsMap.get("success");
        statisticsMap.put("success", success + 1);
        List<Map<String, Object>> subEntryList = subEntryMap.get(bizActId);
        String number = CodeRuleHelper.getNumber((DynamicObject)paySchDy, null);
        number = number + "-" + String.format(Locale.ROOT, "%03d", serialNum);
        paySchDy.set("number", (Object)number);
        paySchDy.set("name", (Object)paySchTplEntryDyObj.getString("paybizaction.name"));
        paySchDy.set("generatesource", (Object)"0");
        paySchDy.set("generatebatch", (Object)thBatch.get());
        paySchDy.set("paybizaction", (Object)bizActId);
        paySchDy.set("startdate", (Object)dateMap.get("startDate"));
        paySchDy.set("enddate", (Object)endDate);
        this.copyMulBaseDataField(paySchTplEntryDyObj, paySchDy, "tracker");
        paySchDy.set("description", paySchTplEntryDyObj.get("paybizactiondesc"));
        paySchDy.set("createtime", (Object)createDate);
        paySchDy.set("creator", (Object)userId);
        paySchDy.set("modifytime", (Object)createDate);
        paySchDy.set("modifier", (Object)userId);
        paySchDy.set("status", (Object)"A");
        paySchDy.set("disabler", (Object)0L);
        paySchDy.set("index", (Object)0);
        paySchDy.set("enable", (Object)"1");
        paySchDy.set("issyspreset", (Object)"0");
        paySchDy.set("org", (Object)paySchTplDy.getLong("org.id"));
        paySchDy.set("payrollgrp", (Object)paySchTplDy.getLong("payrollgrp.id"));
        paySchDy.set("payrollgrpv", (Object)paySchTplDy.getLong("payrollgrpv.id"));
        paySchDy.set("calperiodtype", (Object)paySchTplDy.getLong("calperiodtype.id"));
        paySchDy.set("calperiod", (Object)startPeriod.getLong("id"));
        paySchDy.set("prepaybizaction", (Object)SWCHisBaseDataHelper.getMulBaseDataDyColl((String)"hsas_payschedule", entryPreMap.get(bizActId), (String)"prepaybizaction", (String)"hsbs_paybizaction"));
        paySchDy.set("calfrequency", (Object)paySchTplDy.getLong("calfrequency.id"));
        paySchDy.set("paybizproc", (Object)payBizProcId);
        paySchDy.set("payrollscene", (Object)paySchTplDy.getLong("payrollscene.id"));
        paySchDy.set(KEY_PAYSCHTPL, (Object)paySchTplDy.getLong("id"));
        paySchDy.set("schedulestatus", (Object)PayScheduleStatusEnum.UNSTARTED.getCode());
        DynamicObjectCollection schEntryDyColl = paySchDy.getDynamicObjectCollection("entryentity");
        DynamicObjectType entryType = schEntryDyColl.getDynamicObjectType();
        for (Map<String, Object> subEntryInfo : subEntryList) {
            DynamicObject entry = new DynamicObject(entryType);
            entry.set("isenable", subEntryInfo.get("isenable"));
            entry.set("msgtpl", subEntryInfo.get("msgtpl"));
            entry.set("msgpushstep", subEntryInfo.get("msgpushstep"));
            entry.set("msgpushnum", subEntryInfo.get("msgpushnum"));
            entry.set("msgpushdaytype", subEntryInfo.get("msgpushdaytype"));
            entry.set("msgpushtime", subEntryInfo.get("msgpushtime"));
            entry.set("receiver", (Object)SWCHisBaseDataHelper.getMulBaseDataDyColl((String)"hsas_payschedule", (List)((List)subEntryInfo.get("receiver")), (String)"tracker", (String)"bos_user"));
            schEntryDyColl.add((Object)entry);
        }
        return true;
    }

    private void copyMulBaseDataField(DynamicObject oldDyObj, DynamicObject newDyObj, String mulBaseDataField) {
        DynamicObjectCollection newMulBasedataColl = new DynamicObjectCollection();
        DynamicObjectCollection mulBasedataColl = oldDyObj.getDynamicObjectCollection(mulBaseDataField);
        for (DynamicObject mulBasedataDy : mulBasedataColl) {
            DynamicObject copyDynObj = (DynamicObject)OrmUtils.clone((IDataEntityBase)mulBasedataDy, (boolean)false, (boolean)true);
            copyDynObj.getDataEntityState().setDirty(true);
            newMulBasedataColl.add((Object)copyDynObj);
        }
        newDyObj.set(mulBaseDataField, (Object)newMulBasedataColl);
    }

    private void showErrorMsg(List<String> errorMsg, Map<String, Integer> statisticsMap) {
        int total = statisticsMap.get("total");
        int success = statisticsMap.get("success");
        int fail = statisticsMap.get("fail");
        StringBuilder stringBuilder = new StringBuilder();
        if (!errorMsg.isEmpty()) {
            String reasonMsg = ResManager.loadKDString((String)"\u4e0d\u80fd\u521b\u5efa\u8fc7\u53bb\u65e5\u671f\u7684\u85aa\u8d44\u65e5\u7a0b\uff1a", (String)"PayScheduleTplNewSchPlugin_13", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            stringBuilder.append(reasonMsg);
            stringBuilder.append("\r\n");
        }
        for (String msg : errorMsg) {
            stringBuilder.append(msg);
        }
        String title = MessageFormat.format(ResManager.loadKDString((String)"\u5171{0}\u6761\u65e5\u7a0b\uff0c{1}\u6761\u521b\u5efa\u6210\u529f\uff0c{2}\u6761\u521b\u5efa\u5931\u8d25\u3002", (String)"PayScheduleTplNewSchPlugin_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]), total, success, fail);
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setShowTitle(false);
        parameter.setFormId(HSAS_CREATEPAYSCHRESULT);
        parameter.setCustomParam("generatebatch", (Object)thBatch.get());
        parameter.setCustomParam("title", (Object)title);
        parameter.setCustomParam("errorMsg", (Object)stringBuilder.toString());
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTION_CLOSE_CALLBACK_KNOW));
        this.getView().showForm(parameter);
        MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u5171{0}\u6761\u65e5\u7a0b\uff0c{1}\u6761\u521b\u5efa\u6210\u529f\uff0c{2}\u6761\u521b\u5efa\u5931\u8d25\u3002", "PayScheduleTplNewSchPlugin_7", "swc-hsas-formplugin");
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u6309\u6a21\u677f\u65b0\u589e", "PayScheduleTplNewSchPlugin_14", "swc-hsas-formplugin");
        SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)"new by template", (MultiLangEnumBridge)opName, (String)"", (MultiLangEnumBridge)opDesc, (String[])new String[]{total + "", success + "", fail + ""});
    }

    private void checkNextPeriod() {
        DynamicObject startPeriodDy = this.getModel().getDataEntity().getDynamicObject(KEY_STARTPERIOD);
        if (!SWCObjectUtils.isEmpty((Object)startPeriodDy)) {
            FormShowParameter parameter = this.getView().getFormShowParameter();
            Object periodTypeId = this.getPeriodTypeId(parameter);
            SWCDataServiceHelper paySchTplHelper = new SWCDataServiceHelper("hsas_payscheduletpl");
            Object paySchTplId = this.getPaySchTplId(parameter);
            DynamicObject paySchTplDy = paySchTplHelper.queryOriginalOne("actdatetype, selperiod", paySchTplId);
            if (paySchTplDy != null && "1".equals(paySchTplDy.getString("actdatetype")) && "1".equals(paySchTplDy.getString("selperiod"))) {
                DynamicObject periodDy;
                DynamicObjectCollection periodDys = PaySchTplHelper.getPeriodDys((Object)periodTypeId);
                int index = 0;
                Iterator iterator = periodDys.iterator();
                while (iterator.hasNext() && !SWCObjectUtils.equals((Object)startPeriodDy, (Object)(periodDy = (DynamicObject)iterator.next()))) {
                    ++index;
                }
                if (index + 1 >= periodDys.size()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u671f\u95f4\u4e3a\u6700\u540e\u7684\u671f\u95f4\uff0c\u65e0\u6cd5\u6309\u7167\u89c4\u5219\u751f\u6210\uff0c\u5982\u4ecd\u9700\u521b\u5efa\u8bf7\u5148\u7ef4\u62a4\u671f\u95f4\u3002", (String)"PayScheduleTplNewSchPlugin_8", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    this.getModel().beginInit();
                    this.getModel().setValue(KEY_STARTPERIOD, null);
                    this.getModel().endInit();
                }
            }
        }
    }

    private void setLabelInfo() {
        DynamicObject periodDy;
        DynamicObject startPeriodDys = this.getModel().getDataEntity().getDynamicObject(KEY_STARTPERIOD);
        String periodCount = this.getModel().getDataEntity().getString(KEY_PERIODCOUNT);
        if (SWCObjectUtils.isEmpty((Object)startPeriodDys) || SWCObjectUtils.isEmpty((Object)periodCount)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{TIP_FLEX_PANEL});
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{TIP_FLEX_PANEL});
        Label periodName = (Label)this.getControl(LABEL_PERIODNAME);
        Label countLab = (Label)this.getControl(LABEL_PERIODCOUNTLABEL);
        Label firstName = (Label)this.getControl(LABEL_FIRSTPERIODNAME);
        Label firstDate = (Label)this.getControl(LABEL_FIRSTPERIODDATE);
        Label lastName = (Label)this.getControl(LABEL_LASTPERIODNAME);
        Label lastDate = (Label)this.getControl(LABEL_LASTPERIODDATE);
        periodName.setText(startPeriodDys.getString("name"));
        firstName.setText(startPeriodDys.getString("name"));
        Date startDate = startPeriodDys.getDate("startdate");
        Date endDate = startPeriodDys.getDate("enddate");
        firstDate.setText(SWCInteDateTimeUtil.formateDate((Date)startDate) + "~" + SWCInteDateTimeUtil.formateDate((Date)endDate));
        countLab.setText(periodCount);
        int periodCountInt = Integer.parseInt(periodCount);
        Object periodTypeId = this.getPeriodTypeId(this.getView().getFormShowParameter());
        DynamicObjectCollection periodDys = PaySchTplHelper.getPeriodDys((Object)periodTypeId);
        int index = 0;
        Iterator iterator = periodDys.iterator();
        while (iterator.hasNext() && !SWCObjectUtils.equals((Object)startPeriodDys, (Object)(periodDy = (DynamicObject)iterator.next()))) {
            ++index;
        }
        DynamicObject lastPeriodDy = null;
        if (periodCountInt + index <= periodDys.size() && periodDys.size() > 0) {
            lastPeriodDy = (DynamicObject)periodDys.get(periodCountInt + index - 1);
            if (lastPeriodDy != null) {
                lastName.setText(lastPeriodDy.getString("name"));
                Date lstartDate = lastPeriodDy.getDate("startdate");
                Date lendDate = lastPeriodDy.getDate("enddate");
                lastDate.setText(SWCInteDateTimeUtil.formateDate((Date)lstartDate) + "~" + SWCInteDateTimeUtil.formateDate((Date)lendDate));
            }
        } else {
            String msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u671f\u95f4\u6700\u591a\u53ef\u751f\u6210%s\u671f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PayScheduleTplNewSchPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]), periodDys.size() - index);
            this.getView().showTipNotification(msg);
            this.getModel().setValue(KEY_PERIODCOUNT, (Object)(periodDys.size() - index));
        }
    }
}

