/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.personchange;

import java.text.MessageFormat;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.column.ListOperationColumnDesc;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.personchange.PersonChangeServiceHelper;
import kd.swc.hsas.business.prorationevent.ProrationEventUtils;
import kd.swc.hsas.business.salaryfile.SWCSalaryFileServiceHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;

public class PersonChangeListPlugin
extends AbstractListPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"abandon"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("abandon".equals(key)) {
            int selectedRowSize = ((ListView)this.getView()).getSelectedRows().size();
            if (0 == selectedRowSize) {
                return;
            }
            this.getView().showConfirm(MessageFormat.format(ResManager.loadKDString((String)"\u5e9f\u5f03\u9009\u4e2d\u7684{0}\u6761\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u8981\u5e9f\u5f03\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"PersonChangeListPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]), ((ListView)this.getView()).getSelectedRows().size()), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("do_abanbdon_confirm"));
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent evt) {
        String fieldName;
        switch (fieldName = evt.getFieldName()) {
            case "salaryfile.number": 
            case "salaryfile.name": {
                evt.addCustomQFilter(BaseDataHisHelper.getHisCurrFilter());
                evt.addCustomQFilter(PersonChangeServiceHelper.getFilterHasPermOrg((String)"org.id"));
                break;
            }
            case "salaryfile.org.id": 
            case "salaryfile.org.name": {
                evt.addCustomQFilter(PersonChangeServiceHelper.getFilterHasPermOrg((String)"id"));
                break;
            }
            case "salaryfile.payrollgroup.id": 
            case "salaryfile.payrollgroup.name": {
                evt.addCustomQFilter(PersonChangeServiceHelper.getFilterHasPermOrg((String)"org.id"));
                break;
            }
        }
    }

    public void packageData(PackageDataEvent event) {
        super.packageData(event);
        DynamicObject rowData = event.getRowData();
        if (event.getSource() instanceof ListOperationColumnDesc) {
            List operationColItems = (List)event.getFormatValue();
            if (!"1".equals(rowData.getString("generatedstatus"))) {
                operationColItems.forEach(item -> item.setVisible(false));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult result = args.getOperationResult();
        switch (operateKey) {
            case "do_abandon": {
                if (result.isSuccess()) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5e9f\u5f03\u6210\u529f\u3002", (String)"PersonChangeListPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                }
                this.getView().invokeOperation("refresh");
                break;
            }
            case "viewlog": {
                this.openPersonChangeLogPage();
                break;
            }
            case "generateevent": {
                if (result.isSuccess()) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u751f\u6210\u5206\u6bb5\u4e8b\u4ef6\u6210\u529f\u3002", (String)"PersonChangeListPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                }
                this.getView().invokeOperation("refresh");
                break;
            }
            case "viewprorationevent": {
                Long id = (Long)((FormOperate)args.getSource()).getListFocusRow().getPrimaryKeyValue();
                this.openProrationEventList(id);
                break;
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldKey;
        switch (fieldKey = args.getHyperLinkClickEvent().getFieldName()) {
            case "salaryfile_number": {
                args.setCancel(true);
                this.openSalaryFilePage(args);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        switch (callBackId) {
            case "do_abanbdon_confirm": {
                if (!MessageBoxResult.Yes.equals((Object)result)) break;
                this.getView().invokeOperation("do_abandon");
                break;
            }
        }
    }

    public void setFilter(SetFilterEvent event) {
        QFilter orgFilter = PersonChangeServiceHelper.getFilterHasPermOrg((String)"salaryfile.org.id");
        event.getQFilters().add(orgFilter);
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        String fieldName;
        super.filterColumnSetFilter(args);
        switch (fieldName = args.getFieldName()) {
            case "salaryfile.org.name": {
                args.getQFilters().add(PersonChangeServiceHelper.getFilterHasPermOrg((String)"id"));
                break;
            }
            case "salaryfile.payrollgroup.name": {
                args.getQFilters().add(PersonChangeServiceHelper.getFilterHasPermOrg((String)"org.id"));
                break;
            }
        }
    }

    private void openPersonChangeLogPage() {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId("hsas_personchangelog");
        parameter.setParentPageId(this.getView().getPageId());
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void openSalaryFilePage(HyperLinkClickArgs args) {
        BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
        Long pkId = (Long)billList.getFocusRowPkId();
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_personchange");
        DynamicObject dy = helper.queryOne((Object)pkId);
        Long salaryFileId = dy.getLong("salaryfile.id");
        SWCSalaryFileServiceHelper.assembleSalaryFileDataAndOpenFormView((Long)salaryFileId, (IFormView)this.getView());
    }

    private void openProrationEventList(Long id) {
        ListShowParameter parameter = ProrationEventUtils.createEventListShowParameter((Long)id);
        this.getView().showForm((FormShowParameter)parameter);
    }
}

