/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.personchange;

import java.util.List;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.swc.hsas.business.personchange.PersonChangeServiceHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;

public class PersonChangeLogListPlugin
extends AbstractListPlugin {
    public static final Log logger = LogFactory.getLog(PersonChangeLogListPlugin.class);

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"source"});
    }

    public void setFilter(SetFilterEvent e) {
        QFilter orgFilter = PersonChangeServiceHelper.getFilterHasPermOrg((String)"salaryfile.org.id");
        e.getQFilters().add(orgFilter);
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        String fieldName;
        super.filterColumnSetFilter(args);
        switch (fieldName = args.getFieldName()) {
            case "salaryfile.org.name": {
                args.getQFilters().add(PersonChangeServiceHelper.getFilterHasPermOrg((String)"id"));
                break;
            }
            case "salaryfile.payrollgroup.name": {
                args.getQFilters().add(PersonChangeServiceHelper.getFilterHasPermOrg((String)"org.id"));
                break;
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent evt) {
        String fieldName;
        switch (fieldName = evt.getFieldName()) {
            case "salaryfile.number": 
            case "salaryfile.name": {
                evt.addCustomQFilter(BaseDataHisHelper.getHisCurrFilter());
                evt.addCustomQFilter(PersonChangeServiceHelper.getFilterHasPermOrg((String)"org.id"));
                break;
            }
            case "salaryfile.org.id": 
            case "salaryfile.org.name": {
                evt.addCustomQFilter(PersonChangeServiceHelper.getFilterHasPermOrg((String)"id"));
                break;
            }
            case "salaryadjustrsn.name": {
                HasPermOrgResult permOrgResult = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)"hsas_personchangelog", (String)"47150e89000000ac");
                if (permOrgResult.hasAllOrgPerm()) {
                    logger.info("********************salaryadjustrsn has all perm");
                    break;
                }
                List orgIds = permOrgResult.getHasPermOrgs();
                QFilter filter = null == orgIds ? new QFilter("1", "!=", (Object)1) : SWCPermissionServiceHelper.getBaseDataFilter((String)"hsbs_salaryadjustrsn", (List)orgIds, (boolean)true);
                logger.info("********************salaryadjustrsn useOrgFilter is :{}", (Object)filter);
                evt.addCustomQFilter(filter);
                break;
            }
            case "salaryfile.payrollgroup.name": {
                evt.addCustomQFilter(PersonChangeServiceHelper.getFilterHasPermOrg((String)"org.id"));
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("genchangerecord".equals(operateKey)) {
            this.getView().invokeOperation("refresh");
        }
    }
}

