/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.report;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.base.BaseShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.core.ctrl.common.util.StringUtil;
import kd.bos.report.events.FormatShowFilterEvent;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.swc.hsas.formplugin.web.report.SalaryRptCiteBaseForm;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.business.util.MultiLangHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class SalaryDiffFormRpt
extends SalaryRptCiteBaseForm {
    private static Log LOGGER = LogFactory.getLog(SalaryDiffFormRpt.class);
    private static final Set<String> CTRL_NAME_FOR_PERIOD_WAY = Sets.newHashSet((Object[])new String[]{"payrolldatetar", "payrolldatesrc", "startpayrolldatetar", "endpayrolldatetar", "startpayrolldatesrc", "endpayrolldatesrc", "periodtype", "calperiodtar", "calperiodsrc", "calperiodstar", "calperiodssrc"});
    private static final Map<String, Set<String>> CTRL_NAMES_OF_PERIOD_WAY;

    @Override
    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        this.resetPeriodCtrlForPeriodWay(this.getModel().getDataEntity().getString("period"));
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit periodType = (BasedataEdit)this.getControl("periodtype");
        periodType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit calPeriod = (BasedataEdit)this.getControl("calperiodtar");
        calPeriod.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        calPeriod = (BasedataEdit)this.getControl("calperiodsrc");
        calPeriod.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        calPeriod = (BasedataEdit)this.getControl("calperiodstar");
        calPeriod.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        calPeriod = (BasedataEdit)this.getControl("calperiodssrc");
        calPeriod.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
    }

    @Override
    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        String queryTraceId = RequestContext.get().getTraceId();
        Map customParam = queryParam.getCustomParam();
        customParam.put("queryTraceId", queryTraceId);
        SWCPageCache pageCache = new SWCPageCache(this.getView().getPageId());
        pageCache.put("currentQueryTraceId", (Object)queryTraceId);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs event) {
        IDataEntityProperty property = event.getProperty();
        String key = property.getName();
        Object newValue = event.getChangeSet()[0].getNewValue();
        switch (key) {
            case "period": {
                this.resetPeriodCtrlForPeriodWay((String)ObjectConverter.convert((Object)newValue, String.class, (boolean)true));
                break;
            }
            case "payrolldatetar": {
                this.updatePayRollDateSrc(newValue);
                break;
            }
            case "payrolldatesrc": {
                this.comparePayRollDate("payrolldatesrc", "payrolldatetar");
                break;
            }
            case "startpayrolldatetar": {
                this.comparePayRollDate("startpayrolldatetar", "endpayrolldatetar");
                this.comparePayRollDate("endpayrolldatesrc", "startpayrolldatetar");
                break;
            }
            case "endpayrolldatetar": {
                this.comparePayRollDate("startpayrolldatetar", "endpayrolldatetar");
                break;
            }
            case "startpayrolldatesrc": {
                this.comparePayRollDate("startpayrolldatesrc", "endpayrolldatesrc");
                break;
            }
            case "endpayrolldatesrc": {
                this.comparePayRollDate("startpayrolldatesrc", "endpayrolldatesrc");
                this.comparePayRollDate("endpayrolldatesrc", "startpayrolldatetar");
                break;
            }
            case "periodtype": {
                this.getModel().setValue("calperiodtar", null);
                this.getModel().setValue("calperiodsrc", null);
                this.getModel().setValue("calperiodstar", null);
                this.getModel().setValue("calperiodssrc", null);
                break;
            }
            case "calperiodtar": {
                this.updateCalPeriod(newValue);
                this.comparePayRollDate("calperiodsrc.enddate", "calperiodtar.startdate");
                break;
            }
            case "calperiodsrc": {
                this.comparePayRollDate("calperiodsrc.enddate", "calperiodtar.startdate");
                break;
            }
            case "calperiodstar": {
                this.compareCalPeriods();
                this.getView().updateView("calperiodstar");
                break;
            }
            case "calperiodssrc": {
                this.compareCalPeriods();
                this.getView().updateView("calperiodssrc");
                break;
            }
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent args) {
        super.beforeF7Select(args);
        switch (args.getProperty().getName()) {
            case "calperiodtar": 
            case "calperiodsrc": 
            case "calperiodstar": 
            case "calperiodssrc": {
                this.filterPeriodF7(args);
                break;
            }
        }
    }

    @Override
    protected void decorateSchemeShowParameter(BaseShowParameter showParameter) {
        showParameter.setFormId("hsas_sadiffrptdipschm");
    }

    @Override
    protected boolean validPeriod(FilterInfo filterInfo) {
        String periodWay = filterInfo.getString("period");
        if (SWCStringUtils.isEmpty((String)periodWay)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9{0}\u3002", (String)"SalaryDiffFormRpt_0", (String)"swc-hsas-formplugin", (Object[])new Object[]{this.getModel().getProperty("period").getDisplayName()}));
            return false;
        }
        String msg = this.validPeriodMust(periodWay, filterInfo);
        if (!StringUtil.isEmptyString((String)msg)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9{0}\u3002", (String)"SalaryDiffFormRpt_0", (String)"swc-hsas-formplugin", (Object[])new Object[]{msg}));
            return false;
        }
        switch (periodWay) {
            case "11": {
                return this.comparePayRollDate("payrolldatesrc", "payrolldatetar");
            }
            case "12": {
                if (!this.comparePayRollDate("startpayrolldatetar", "endpayrolldatetar")) {
                    return false;
                }
                return this.comparePayRollDate("endpayrolldatesrc", "startpayrolldatetar");
            }
            case "21": {
                return this.comparePayRollDate("calperiodsrc.enddate", "calperiodtar.startdate");
            }
            case "22": {
                return this.compareCalPeriods();
            }
        }
        return true;
    }

    @Override
    public void formatDisplayFilterField(FormatShowFilterEvent evt) {
        String[] formatFilterStr = evt.getFormatedFilterString().split(";");
        int len = formatFilterStr.length;
        String calPeriodTar = ResManager.loadKDString((String)"\u3010\u672c\u671f\u3011\u671f\u95f4", (String)"SalaryDiffFormRpt_9", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        String calPeriodSrc = ResManager.loadKDString((String)"\u3010\u5f80\u671f\u3011\u671f\u95f4", (String)"SalaryDiffFormRpt_10", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        StringBuilder formatStringBuilder = new StringBuilder();
        int calPeroidCount = 0;
        for (int i = 0; i < len; ++i) {
            String filterStr = formatFilterStr[i];
            if (filterStr.contains(calPeriodTar) || filterStr.contains(calPeriodSrc)) {
                calPeroidCount = 0;
            }
            if (++calPeroidCount > 3) continue;
            formatStringBuilder = formatStringBuilder.append(filterStr).append("; ");
        }
        evt.setFormatedFilterString(formatStringBuilder.toString());
    }

    private boolean compareCalPeriods() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObjectCollection calPeriodsTar = dataEntity.getDynamicObjectCollection("calperiodstar");
        DynamicObjectCollection calPeriodsSrc = dataEntity.getDynamicObjectCollection("calperiodssrc");
        int calPeriodsTarSize = calPeriodsTar.size();
        int calPeriodsSrcSize = calPeriodsSrc.size();
        if (calPeriodsTarSize == 0 || calPeriodsSrcSize == 0) {
            return true;
        }
        if (calPeriodsTarSize != calPeriodsSrcSize) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u3010\u5f80\u671f\u3011\u9009\u7684\u671f\u95f4\u4e2a\u6570\u5e94\u7b49\u4e8e\u3010\u672c\u671f\u3011\u9009\u62e9\u671f\u95f4\u4e2a\u6570\u3002", (String)"SalaryDiffFormRpt_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return false;
        }
        calPeriodsTar.sort(Comparator.comparing(o -> o.getDynamicObject("fbasedataid").getDate("startdate")));
        calPeriodsSrc.sort(Comparator.comparing(o -> o.getDynamicObject("fbasedataid").getDate("enddate")));
        Date earlyDateTar = ((DynamicObject)calPeriodsTar.get(0)).getDynamicObject("fbasedataid").getDate("startdate");
        Date latestDateSrc = ((DynamicObject)calPeriodsSrc.get(calPeriodsSrcSize - 1)).getDynamicObject("fbasedataid").getDate("enddate");
        if (latestDateSrc.compareTo(earlyDateTar) >= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u3010\u5f80\u671f\u3011\u6700\u665a\u671f\u95f4\u5e94\u65e9\u4e8e\u3010\u672c\u671f\u3011\u671f\u95f4\u6700\u65e9\u671f\u95f4\u3002", (String)"SalaryDiffFormRpt_8", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void updateCalPeriod(Object newValue) {
        if (newValue == null) {
            return;
        }
        DynamicObject periodTarDyn = (DynamicObject)newValue;
        Date startdate = periodTarDyn.getDate("startdate");
        long periodTypeId = periodTarDyn.getLong("periodtypeid");
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)"1");
        filter.and("startdate", "<", (Object)startdate);
        filter.and("periodtypeid", "=", (Object)periodTypeId);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hsbs_calperiod");
        String selectProperties = SWCHisBaseDataHelper.getSelectProperties((String)"hsbs_calperiod");
        DynamicObject periodSrcDyn = serviceHelper.queryOne(selectProperties, new QFilter[]{filter}, "startdate desc");
        if (periodSrcDyn == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u3010\u672c\u671f\u3011\u85aa\u8d44\u671f\u95f4\u4e3a\u85aa\u8d44\u671f\u95f4\u5217\u8868\u4e2d\u6700\u65e9\u7684\u4e00\u4e2a\uff0c\u65e0\u6cd5\u627e\u5230\u4e0a\u4e00\u4e2a\u85aa\u8d44\u671f\u95f4\u3002", (String)"SalaryDiffFormRpt_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue("calperiodsrc", (Object)periodSrcDyn);
        this.getView().updateView("calperiodsrc");
    }

    private boolean comparePayRollDate(String startField, String endField) {
        DynamicObject data = this.getModel().getDataEntity();
        Date startDate = data.getDate(startField);
        Date endDate = data.getDate(endField);
        if (startDate == null || endDate == null) {
            return true;
        }
        int compareTo = endDate.compareTo(startDate);
        if (compareTo <= 0) {
            switch (startField) {
                case "payrolldatesrc": {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u3010\u5f80\u671f\u3011\u85aa\u8d44\u6240\u5c5e\u5e74\u6708\u5e94\u5c0f\u4e8e\u3010\u672c\u671f\u3011\u85aa\u8d44\u6240\u5c5e\u5e74\u6708\u3002", (String)"SalaryDiffFormRpt_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    return false;
                }
                case "startpayrolldatetar": {
                    if (compareTo >= 0) break;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u3010\u672c\u671f\u3011\u85aa\u8d44\u622a\u6b62\u5e74\u6708\u5e94\u5927\u4e8e\u7b49\u4e8e\u3010\u672c\u671f\u3011\u85aa\u8d44\u8d77\u59cb\u5e74\u6708\u3002", (String)"SalaryDiffFormRpt_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    return false;
                }
                case "startpayrolldatesrc": {
                    if (compareTo >= 0) break;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u3010\u5f80\u671f\u3011\u85aa\u8d44\u622a\u6b62\u5e74\u6708\u5e94\u5927\u4e8e\u7b49\u4e8e\u3010\u5f80\u671f\u3011\u85aa\u8d44\u8d77\u59cb\u5e74\u6708\u3002", (String)"SalaryDiffFormRpt_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    return false;
                }
                case "endpayrolldatesrc": {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u3010\u5f80\u671f\u3011\u85aa\u8d44\u622a\u6b62\u5e74\u6708\u5e94\u5c0f\u4e8e\u3010\u672c\u671f\u3011\u85aa\u8d44\u8d77\u59cb\u5e74\u6708\u3002", (String)"SalaryDiffFormRpt_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    return false;
                }
                case "calperiodsrc.enddate": {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u3010\u672c\u671f\u3011\u671f\u95f4\u5e94\u665a\u4e8e\u3010\u5f80\u671f\u3011\u671f\u95f4\u3002", (String)"SalaryDiffFormRpt_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    return false;
                }
            }
        }
        return true;
    }

    private void updatePayRollDateSrc(Object newValue) {
        if (newValue == null) {
            return;
        }
        Date payRollDateTar = (Date)newValue;
        Date payRollDateSrc = SWCDateTimeUtils.addMonth((Date)payRollDateTar, (int)-1);
        this.getModel().setValue("payrolldatesrc", (Object)payRollDateSrc);
        this.getView().updateView("payrolldatesrc");
    }

    @Override
    protected String displaySchemeEntity() {
        return "hsas_sadiffrptdipschm";
    }

    private void resetPeriodCtrlForPeriodWay(String periodWay) {
        if (SWCStringUtils.isEmpty((String)periodWay)) {
            this.resetPeriodCtrlForPeriodWay(CTRL_NAME_FOR_PERIOD_WAY, Boolean.FALSE);
        } else {
            HashSet ctrlCopy = Sets.newHashSet(CTRL_NAME_FOR_PERIOD_WAY);
            Set<String> showCtrlSet = CTRL_NAMES_OF_PERIOD_WAY.get(periodWay);
            if (!CollectionUtils.isEmpty(showCtrlSet)) {
                this.resetPeriodCtrlForPeriodWay(showCtrlSet, Boolean.TRUE);
                ctrlCopy.removeAll(showCtrlSet);
                this.resetPeriodCtrlForPeriodWay(ctrlCopy, Boolean.FALSE);
            } else {
                this.resetPeriodCtrlForPeriodWay(CTRL_NAME_FOR_PERIOD_WAY, Boolean.FALSE);
            }
        }
        this.updateCtrlValueForPeriodWay();
    }

    private void updateCtrlValueForPeriodWay() {
        for (String ctrl : CTRL_NAME_FOR_PERIOD_WAY) {
            this.getView().updateView(ctrl);
        }
    }

    private void resetPeriodCtrlForPeriodWay(Set<String> ctrlSet, Boolean isCanEdit) {
        if (CollectionUtils.isEmpty(ctrlSet)) {
            return;
        }
        String[] ctrlArr = ctrlSet.toArray(new String[0]);
        this.getView().setEnable(isCanEdit, ctrlArr);
        this.getView().setVisible(isCanEdit, ctrlArr);
        if (!isCanEdit.booleanValue()) {
            for (String ctrl : ctrlSet) {
                this.getModel().setValue(ctrl, null);
            }
        } else {
            for (String ctrl : ctrlSet) {
                FieldEdit control = (FieldEdit)this.getView().getControl(ctrl);
                control.setMustInput(true);
            }
        }
    }

    private String validPeriodMust(String periodWay, FilterInfo filterInfo) {
        Set<String> showCtrlList = CTRL_NAMES_OF_PERIOD_WAY.get(periodWay);
        if (!CollectionUtils.isEmpty(showCtrlList)) {
            String delimiter = MultiLangHelper.getMultiLangSlightDelimiter();
            StringBuilder query = new StringBuilder();
            for (String ctrl : showCtrlList) {
                Object value = filterInfo.getValue(ctrl);
                if (!ObjectUtils.isEmpty((Object)value)) continue;
                query.append(this.getModel().getProperty(ctrl).getDisplayName()).append(delimiter);
            }
            if (query.length() > 0) {
                query.delete(query.length() - delimiter.length(), query.length());
                return query.toString();
            }
        }
        return "";
    }

    static {
        HashMap temp = Maps.newHashMapWithExpectedSize((int)4);
        temp.put("11", ImmutableSet.of((Object)"payrolldatetar", (Object)"payrolldatesrc"));
        temp.put("12", ImmutableSet.of((Object)"startpayrolldatetar", (Object)"endpayrolldatetar", (Object)"startpayrolldatesrc", (Object)"endpayrolldatesrc"));
        temp.put("21", ImmutableSet.of((Object)"periodtype", (Object)"calperiodtar", (Object)"calperiodsrc"));
        temp.put("22", ImmutableSet.of((Object)"periodtype", (Object)"calperiodstar", (Object)"calperiodssrc"));
        CTRL_NAMES_OF_PERIOD_WAY = ImmutableMap.copyOf((Map)temp);
    }
}

