/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.report;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.swc.hsas.business.salaryrpt.SalaryRptService;
import kd.swc.hsas.formplugin.web.report.SalarySummaryReportSchemeHandler;
import kd.swc.hsbp.common.entity.RptDisplayColumnEntity;
import kd.swc.hsbp.formplugin.report.AbstractRptDisplayPlugin;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class SalaryDiffReportSchemeHandler
extends SalarySummaryReportSchemeHandler {
    public SalaryDiffReportSchemeHandler(IFormView formView, AbstractRptDisplayPlugin formPlugin, SalaryRptService salaryRptService) {
        super(formView, formPlugin, salaryRptService);
    }

    @Override
    public String getReportFormId() {
        return "hsas_salarydiffrpt";
    }

    @Override
    public boolean beforeDoSaveOperation() {
        DynamicObject dataEntity = this.formView.getModel().getDataEntity();
        DynamicObjectCollection columns = dataEntity.getDynamicObjectCollection("entryentity");
        HashSet mainPersonColumns = Sets.newHashSet((Object[])new String[]{"empnumber", "name", "filenumber"});
        boolean isContainRelField = false;
        boolean isContainMainPersonField = false;
        HashSet fieldNameSet = Sets.newHashSetWithExpectedSize((int)columns.size());
        for (DynamicObject column : columns) {
            String isDimension = column.getString("isdimension");
            String fieldTag = column.getString("fieldtag");
            if (!StringUtils.isEmpty((CharSequence)isDimension) && !StringUtils.equals((CharSequence)isDimension, (CharSequence)"0") && StringUtils.isEmpty((CharSequence)fieldTag)) {
                fieldNameSet.add(column.getString("fieldname"));
                continue;
            }
            if (StringUtils.equals((CharSequence)fieldTag, (CharSequence)"2")) {
                isContainRelField = true;
                continue;
            }
            if (!mainPersonColumns.contains(column.getString("fieldalias"))) continue;
            isContainMainPersonField = true;
        }
        if (!CollectionUtils.isEmpty((Collection)fieldNameSet)) {
            String msg = String.join((CharSequence)"\u3001", fieldNameSet);
            this.formView.showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c%s\u201d\u5b57\u6bb5\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SalaryDiffReportSchemeHandler_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]), msg));
            return false;
        }
        if (!isContainMainPersonField && isContainRelField) {
            this.formView.showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u9009\u62e9\u5173\u952e\u4eba\u5458\u7ef4\u5ea6\u65f6\uff0c\u624d\u80fd\u9009\u62e9\u8054\u67e5\u4fe1\u606f\uff08\u8054\u67e5\u672c\u671f\u6700\u65b0\u4eba\u5458\u4fe1\u606f\uff09\u3002", (String)"SalaryDiffReportSchemeHandler_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    public Map<String, Object> getExtendFieldValue(RptDisplayColumnEntity rowData) {
        Map customParams = rowData.getCustomParams();
        String isDimension = MapUtils.getString((Map)customParams, (Object)"isdimension");
        if (!StringUtils.isEmpty((CharSequence)isDimension) && !StringUtils.equals((CharSequence)isDimension, (CharSequence)"0")) {
            customParams.put("fieldtag", isDimension);
        }
        return customParams;
    }

    @Override
    protected void addNoNumItemNodes(RptDisplayColumnEntity groupDimNode, Map<String, DynamicObjectCollection> noNumItemMap) {
    }

    @Override
    public void afterClosedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        switch (actionId = evt.getActionId()) {
            case "handleMoveToCallback": 
            case "handleSortCallback": {
                SalaryRptService.setFieldTagEnable((IFormView)this.formView);
                break;
            }
        }
    }
}

