/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.report;

import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.report.events.FormatShowFilterEvent;
import kd.swc.hsas.business.salaryrpt.SalaryRptService;
import kd.swc.hsas.formplugin.web.report.SalaryRptAbstractForm;
import kd.swc.hsbp.business.report.AdminOrgHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class SalaryDptMonthSumFormRpt
extends SalaryRptAbstractForm {
    private static final Log LOGGER = LogFactory.getLog(SalaryDptMonthSumFormRpt.class);
    private static final String KEY_TYPES = "types";
    private static final String KEY_CUSTOM = "A";
    private static final String KEY_CURRENT = "B";
    private static final String KEY_LAST = "C";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String period = this.getModel().getDataEntity().getString("period");
        if (StringUtils.equals((CharSequence)period, (CharSequence)KEY_CURRENT) || StringUtils.equals((CharSequence)period, (CharSequence)KEY_LAST)) {
            this.setPeriodValue(period);
        }
        this.setPeriodStyle(period);
        Object countStructure = this.getModel().getValue("countstructure");
        if (countStructure == null) {
            countStructure = "1";
            this.getModel().setValue("countstructure", countStructure);
        }
        Object value = this.getModel().getValue("adminorg");
        switch ((String)countStructure) {
            case "1": {
                value = this.getModel().getValue("adminorg");
                break;
            }
            case "2": {
                value = this.getModel().getValue("attachadminorg");
                break;
            }
        }
        if (value instanceof DynamicObject) {
            this.setLevel((DynamicObject)value);
        }
        this.setPayRollGroupAndSalaryItemStyle(value, "lastlevel");
        this.resetAdminOrgControl(countStructure);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        Object value = e.getChangeSet()[0].getNewValue();
        switch (propertyName) {
            case "period": {
                this.setPeriodValue((String)value);
                break;
            }
            case "startperiod": {
                this.compareDate();
                break;
            }
            case "endperiod": {
                this.compareDate();
                break;
            }
            case "adminorg": 
            case "attachadminorg": {
                if (value instanceof DynamicObject) {
                    this.getModel().setValue("lastlevel", (Object)this.setLevel((DynamicObject)value));
                    this.getView().setEnable(Boolean.TRUE, new String[]{"lastlevel"});
                    break;
                }
                if (value != null) break;
                this.getModel().setValue("lastlevel", null);
                this.getView().setEnable(Boolean.FALSE, new String[]{"lastlevel"});
                break;
            }
            case "countstructure": {
                this.resetAdminOrgControl(value);
                break;
            }
        }
    }

    private void resetAdminOrgControl(Object value) {
        switch ((String)value) {
            case "1": {
                this.resetControl(new String[]{"adminorg"}, new String[]{"attachadminorg"});
                break;
            }
            case "2": {
                this.resetControl(new String[]{"attachadminorg"}, new String[]{"adminorg"});
                break;
            }
        }
    }

    public int[] getOrgLevel(Long id) {
        Map adminOrgDataMap = AdminOrgHelper.getAdminOrgDataMap((Long)id);
        String longNumber = MapUtils.getString((Map)adminOrgDataMap, (Object)"longnumber");
        int startIndex = AdminOrgHelper.getAdminOrgLevel((String)longNumber);
        int endIndex = 0;
        Set adminOrgIds = new HashSet(16);
        Boolean isSuperUser = SWCPermissionServiceHelper.isSuperUser();
        if (!isSuperUser.booleanValue()) {
            adminOrgIds = SWCPermissionServiceHelper.getAdminOrgSetByPermItem((String)"/UHMBBGZQ65X", (String)"hsas_monthdeptsalsumrptquery", (String)"47150e89000000ac", (String)"adminorg");
            LOGGER.info("kd.swc.hsas.formplugin.web.report.SalaryDptMonthSumFormRpt.getOrgLevel:adminOrgIds= {}", (Object)JSONObject.toJSONString(adminOrgIds));
        }
        List list = AdminOrgHelper.getAllSubAdminOrg((Long)id);
        for (Map orgInfo : list) {
            Long orgId = MapUtils.getLong((Map)orgInfo, (Object)"orgId");
            if (!isSuperUser.booleanValue() && adminOrgIds != null && !adminOrgIds.contains(orgId)) continue;
            String orglongNumber = MapUtils.getString((Map)orgInfo, (Object)"structLongNumber");
            int orgLevel = AdminOrgHelper.getAdminOrgLevel((String)orglongNumber);
            endIndex = endIndex < orgLevel ? orgLevel : endIndex;
        }
        endIndex = endIndex < startIndex ? startIndex : endIndex;
        return new int[]{startIndex, endIndex};
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObject schemeObj;
        DynamicObject rptDisplaySchemeObj;
        FilterInfo filterInfo = queryParam.getFilter();
        String countStructure = filterInfo.getString("countstructure");
        if (SWCStringUtils.isEmpty((String)filterInfo.getString("org"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7\u3002", (String)"MonthDeptSalarySumFormRpt_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (StringUtils.equals((CharSequence)countStructure, (CharSequence)"1") && filterInfo.getLong("adminorg") == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u884c\u653f\u7ec4\u7ec7\u3002", (String)"MonthDeptSalarySumFormRpt_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (StringUtils.equals((CharSequence)countStructure, (CharSequence)"2") && filterInfo.getLong("attachadminorg") == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6302\u9760\u884c\u653f\u7ec4\u7ec7\u3002", (String)"MonthDeptSalarySumFormRpt_10", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (filterInfo.getInt("lastlevel") == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6700\u672b\u663e\u793a\u5c42\u7ea7\u3002", (String)"MonthDeptSalarySumFormRpt_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (filterInfo.getLong("calcurrency") == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u5e01\u79cd\u3002", (String)"MonthDeptSalarySumFormRpt_20", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (filterInfo.getDate("startperiod") == null || filterInfo.getDate("endperiod") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u85aa\u8d44\u8d77\u59cb\u5e74\u6708\u548c\u85aa\u8d44\u622a\u6b62\u5e74\u6708\u5747\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MonthDeptSalarySumFormRpt_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (filterInfo.getDate("endperiod").before(filterInfo.getDate("startperiod"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u85aa\u8d44\u622a\u6b62\u5e74\u6708\u4e0d\u80fd\u65e9\u4e8e\u85aa\u8d44\u8d77\u59cb\u5e74\u6708\u3002", (String)"MonthDeptSalarySumFormRpt_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (SWCStringUtils.isEmpty((String)filterInfo.getString("displayscheme"))) {
            this.getView().getModel().setValue("displayscheme", null);
            this.getView().updateView("displayscheme");
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u663e\u793a\u65b9\u6848\u3002", (String)"SalarySumFormRpt_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (!Objects.isNull(filterInfo.getDynamicObject("displayscheme")) && (rptDisplaySchemeObj = SalaryRptService.queryRptDisplaySchemeObj((Long)(schemeObj = filterInfo.getDynamicObject("displayscheme")).getLong("id"))) == null) {
            this.getView().getModel().setValue("displayscheme", null);
            this.getView().updateView("displayscheme");
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u663e\u793a\u65b9\u6848\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u65b0\u7684\u65b9\u6848\u3002", (String)"SalarySumFormRpt_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    @Override
    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        Map displaySetMap = SalaryRptService.getDisplaySetting((IFormView)this.getView(), (int)this.getSalaryRptTypeEnum().getCode());
        this.addTotalSet(queryParam, displaySetMap);
        this.addSubTotalSet(queryParam, displaySetMap);
    }

    private int setLevel(DynamicObject value) {
        ComboEdit comboEdit = (ComboEdit)this.getControl("lastlevel");
        if (value == null) {
            this.getModel().setValue("lastlevel", null);
            comboEdit.setComboItems(null);
            return 0;
        }
        DynamicObject adminOrgValue = value;
        int[] index = this.getOrgLevel(adminOrgValue.getLong(0));
        int startIndexArr = 0;
        int endIndexArr = 1;
        int startIndex = index[startIndexArr];
        int endIndex = index[endIndexArr];
        ArrayList<ComboItem> itemList = new ArrayList<ComboItem>(10);
        for (int curIndex = startIndex; curIndex <= endIndex; ++curIndex) {
            String item = curIndex + "";
            itemList.add(new ComboItem(new LocaleString(item), item));
        }
        comboEdit.setComboItems(itemList);
        return startIndex;
    }

    private boolean compareDate() {
        Date startPeriod = (Date)this.getModel().getValue("startperiod");
        Date endPeriod = (Date)this.getModel().getValue("endperiod");
        if (startPeriod == null || endPeriod == null) {
            return true;
        }
        startPeriod = this.getMonthFirstDay(startPeriod, 0);
        if ((endPeriod = this.getMonthFirstDay(endPeriod, 0)).before(startPeriod)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u85aa\u8d44\u622a\u6b62\u5e74\u6708\u4e0d\u80fd\u65e9\u4e8e\u85aa\u8d44\u8d77\u59cb\u5e74\u6708\u3002", (String)"MonthDeptSalarySumFormRpt_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        }
        return false;
    }

    private void setPeriodValue(String period) {
        LocalDate startPeriod = null;
        LocalDate endPeriod = null;
        LocalDate nowDate = LocalDate.now();
        nowDate = nowDate.minusDays(nowDate.getDayOfMonth() - 1);
        switch (period) {
            case "A": {
                break;
            }
            case "B": {
                startPeriod = nowDate;
                endPeriod = nowDate;
                break;
            }
            case "C": {
                startPeriod = nowDate.minusMonths(1L);
                endPeriod = nowDate.minusMonths(1L);
                break;
            }
        }
        this.setPeriodStyle(period);
        this.getModel().beginInit();
        this.getModel().setValue("startperiod", (Object)startPeriod);
        this.getModel().setValue("endperiod", (Object)endPeriod);
        this.getModel().endInit();
        this.getView().updateView("endperiod");
        this.getView().updateView("startperiod");
    }

    private void setPayRollGroupAndSalaryItemStyle(Object value, String key) {
        if (value != null) {
            if (value instanceof MulBasedataDynamicObjectCollection && ((MulBasedataDynamicObjectCollection)value).size() == 0) {
                this.getView().setEnable(Boolean.FALSE, new String[]{key});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{key});
            }
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{key});
        }
    }

    private void setPeriodStyle(String value) {
        switch (value) {
            case "A": {
                this.getView().setEnable(Boolean.TRUE, new String[]{"startperiod"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"endperiod"});
                break;
            }
            case "B": {
                this.getView().setEnable(Boolean.FALSE, new String[]{"startperiod"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"endperiod"});
                break;
            }
            case "C": {
                this.getView().setEnable(Boolean.FALSE, new String[]{"startperiod"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"endperiod"});
                break;
            }
        }
    }

    public void formatDisplayFilterField(FormatShowFilterEvent evt) {
        String[] formatFilterStr = evt.getFormatedFilterString().split(";");
        int len = formatFilterStr.length;
        String startPeroidStr = ResManager.loadKDString((String)"\u85aa\u8d44\u8d77\u59cb\u5e74\u6708", (String)"MonthDeptSalarySumFormRpt_18", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        String endPeroidStr = ResManager.loadKDString((String)"\u85aa\u8d44\u622a\u6b62\u5e74\u6708", (String)"MonthDeptSalarySumFormRpt_19", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        StringBuilder formatStringBuilder = new StringBuilder();
        FilterInfo filterInfo = evt.getFilter();
        SimpleDateFormat format = new SimpleDateFormat("yyyy/MM");
        for (int i = 0; i < len; ++i) {
            Date startPeroid;
            if (formatFilterStr[i].contains(startPeroidStr)) {
                startPeroid = filterInfo.getDate("startperiod");
                formatFilterStr[i] = startPeroidStr + " : " + format.format(startPeroid);
            } else if (formatFilterStr[i].contains(endPeroidStr)) {
                startPeroid = filterInfo.getDate("endperiod");
                formatFilterStr[i] = endPeroidStr + " : " + format.format(startPeroid);
            }
            formatStringBuilder = formatStringBuilder.append(formatFilterStr[i]).append("; ");
        }
        String formatFilterString = formatStringBuilder.delete(formatStringBuilder.lastIndexOf("; "), formatStringBuilder.length()).toString();
        evt.setFormatedFilterString(formatFilterString);
    }
}

