/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.report;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.IFormView;
import kd.bos.orm.util.StringUtils;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.swc.hsas.formplugin.extpoint.salaryrpt.ISalaryDisplaySchemeExtPlugin;
import kd.swc.hsas.business.salaryrpt.SalaryRptItemService;
import kd.swc.hsas.business.salaryrpt.SalaryRptService;
import kd.swc.hsas.common.enums.AttBizItemtypeEnum;
import kd.swc.hsas.common.enums.SalaryRptItemTypeEnum;
import kd.swc.hsas.formplugin.web.report.ISalaryReportSchemeHandler;
import kd.swc.hsbp.business.report.RptDisplayService;
import kd.swc.hsbp.business.report.RptTypeHelper;
import kd.swc.hsbp.business.report.RptTypeVo;
import kd.swc.hsbp.business.servicehelper.SWCSalaryParameterServiceHelper;
import kd.swc.hsbp.common.constants.WtcInteCfgConstants;
import kd.swc.hsbp.common.entity.RptDisplayColumnEntity;
import kd.swc.hsbp.formplugin.report.AbstractRptDisplayPlugin;

public abstract class SalaryReportSchemeBaseHandler
implements ISalaryReportSchemeHandler {
    protected IFormView formView;
    protected AbstractRptDisplayPlugin formPlugin;
    protected SalaryRptService salaryRptService;

    protected List<RptDisplayColumnEntity> buildItemTreeNode(Map<String, DynamicObjectCollection> itemMap, boolean isDimItem) {
        int defaultColWidth = RptDisplayService.getDefaultColWidth((String)this.getReportFormId());
        Map<String, RptDisplayColumnEntity> firstNodeMap = this.buildItemFirstNodes(isDimItem, defaultColWidth);
        List<RptDisplayColumnEntity> nodeList = firstNodeMap.entrySet().stream().map(obj -> (RptDisplayColumnEntity)obj.getValue()).collect(Collectors.toList());
        if (itemMap == null) {
            return nodeList;
        }
        String disableStr = ResManager.loadKDString((String)"\uff08\u5df2\u7981\u7528\uff09", (String)"SalaryReportSchemeBaseHandler_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        HashSet disableItemIds = Sets.newHashSetWithExpectedSize((int)16);
        for (Map.Entry<String, DynamicObjectCollection> itemEntry : itemMap.entrySet()) {
            String entityCode = itemEntry.getKey();
            DynamicObjectCollection itemDyns = itemEntry.getValue();
            if ("hsbs_statisticstag".equals(entityCode)) {
                SalaryRptItemService.buildStatisticstagNodes(firstNodeMap, itemEntry, (int)defaultColWidth);
                continue;
            }
            String itemPre = SalaryRptItemTypeEnum.getCodeByEntityCode((String)entityCode) + "_";
            ArrayList secondNodeList = Lists.newArrayListWithExpectedSize((int)itemDyns.size());
            LinkedHashMap secondNodeMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
            HashMap<Long, String> secondNodeNameMap = new HashMap<Long, String>(16);
            HashSet<Long> itemIdSet = new HashSet<Long>(16);
            boolean isAutoAddFlag = false;
            if ("hsbs_salaryitem".equals(entityCode)) {
                isAutoAddFlag = this.isAutoAddSalaryItemType();
            }
            String itemGroupFieldCode = SalaryRptItemService.getItemGroupFieldCode((String)entityCode);
            String itemGroupName = itemGroupFieldCode + ".name";
            for (DynamicObject itemDyn : itemDyns) {
                Long id = itemDyn.getLong("id");
                if (!itemIdSet.add(id)) continue;
                RptDisplayColumnEntity itemNode = new RptDisplayColumnEntity();
                itemNode.setFieldValue(itemPre + id);
                String enable = itemDyn.getString("enable");
                String fieldName = itemDyn.getString("name");
                if ("0".equals(enable)) {
                    fieldName = fieldName + disableStr;
                    disableItemIds.add(itemNode.getFieldValue());
                }
                itemNode.setFieldName(fieldName);
                this.setDefaultFieldValue(itemNode, defaultColWidth);
                itemNode.setFieldType((String)SalaryRptService.getRlsMap().get(itemDyn.getString("datatype.showtype")));
                if (isDimItem) {
                    itemNode.addCustomParam("isdimension", (Object)"1");
                }
                if (isAutoAddFlag) {
                    itemNode.setSecondaryHeader(itemDyn.getString(itemGroupName));
                }
                if (StringUtils.isEmpty((Object)itemGroupFieldCode)) {
                    secondNodeList.add(itemNode);
                    continue;
                }
                Long itemGroupId = itemDyn.getLong(itemGroupFieldCode);
                secondNodeNameMap.put(itemGroupId, itemDyn.getString(itemGroupName));
                List thirdNodeList2 = (List)secondNodeMap.get(itemGroupId);
                if (thirdNodeList2 == null) {
                    thirdNodeList2 = Lists.newArrayListWithExpectedSize((int)10);
                    secondNodeMap.put(itemGroupId, thirdNodeList2);
                }
                thirdNodeList2.add(itemNode);
            }
            secondNodeMap.forEach((secondNodeId, thirdNodeList) -> {
                RptDisplayColumnEntity secondNode = new RptDisplayColumnEntity();
                secondNode.setFieldName((String)secondNodeNameMap.get(secondNodeId));
                this.setDefaultFieldValue(secondNode, defaultColWidth);
                secondNode.setChildren(thirdNodeList);
                String fieldVal = String.valueOf(secondNodeId);
                if (isDimItem) {
                    secondNode.setFieldValue("text_type_" + fieldVal);
                    secondNode.addCustomParam("isdimension", (Object)"1");
                    if ("hsbs_attbizitem".equals(entityCode)) {
                        secondNode.setFieldName(AttBizItemtypeEnum.getDesc((String)fieldVal));
                        secondNode.setFieldValue("text_type_" + AttBizItemtypeEnum.getSign((String)fieldVal));
                    }
                } else {
                    secondNode.setFieldValue(fieldVal);
                    if ("hsbs_attbizitem".equals(entityCode)) {
                        secondNode.setFieldName(AttBizItemtypeEnum.getDesc((String)fieldVal));
                        secondNode.setFieldValue(AttBizItemtypeEnum.getSign((String)fieldVal));
                    }
                }
                secondNodeList.add(secondNode);
            });
            RptDisplayColumnEntity itemTypeNode = firstNodeMap.get(entityCode);
            itemTypeNode.setChildren((List)secondNodeList);
        }
        List<RptDisplayColumnEntity> finalNodeList = this.getFinalNodeList(defaultColWidth, nodeList);
        this.formView.getPageCache().put("DISABLEITEMIDS", SerializationUtils.serializeToBase64((Object)disableItemIds));
        return finalNodeList;
    }

    private List<RptDisplayColumnEntity> getFinalNodeList(int defaultColWidth, List<RptDisplayColumnEntity> nodeList) {
        ArrayList<RptDisplayColumnEntity> finalNodeList = new ArrayList<RptDisplayColumnEntity>(nodeList.size());
        ArrayList<RptDisplayColumnEntity> bizItemNodeList = new ArrayList<RptDisplayColumnEntity>(2);
        for (RptDisplayColumnEntity rptDisplayColumnEntity : nodeList) {
            String fieldValue = rptDisplayColumnEntity.getFieldValue();
            if ("hsbs_attbizitem".equals(fieldValue) || "hsbs_bizitem".equals(fieldValue) || fieldValue.endsWith("hsbs_attbizitem") || fieldValue.endsWith("hsbs_bizitem")) {
                if (SalaryReportSchemeBaseHandler.isEnableWtcInte()) {
                    bizItemNodeList.add(rptDisplayColumnEntity);
                    RptDisplayColumnEntity itemTypeNode = new RptDisplayColumnEntity();
                    itemTypeNode.setFieldName(ResManager.loadKDString((String)"\u4e1a\u52a1\u9879\u76ee", (String)"FormulaItemOrFuncTreeHelper_13", (String)"swc-hsas-business", (Object[])new Object[0]));
                    itemTypeNode.setAlignment("default");
                    itemTypeNode.setColumnWidth(defaultColWidth);
                    itemTypeNode.setFieldValue(fieldValue + "_all");
                    itemTypeNode.setFieldAlias(fieldValue + "_all");
                    itemTypeNode.setChildren(bizItemNodeList);
                    rptDisplayColumnEntity = itemTypeNode;
                }
                if ("hsbs_attbizitem".equals(fieldValue) || fieldValue.endsWith("hsbs_attbizitem")) continue;
            }
            finalNodeList.add(rptDisplayColumnEntity);
        }
        return finalNodeList;
    }

    private boolean isAutoAddSalaryItemType() {
        ISalaryDisplaySchemeExtPlugin defaultPlugin = new ISalaryDisplaySchemeExtPlugin(){

            public boolean isAutoAddSalaryItemType() {
                return false;
            }
        };
        AtomicBoolean isAutoSum = new AtomicBoolean(false);
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)defaultPlugin, ISalaryDisplaySchemeExtPlugin.class, (String)"kd.sdk.swc.hsas.formplugin.extpoint.salaryrpt.ISalaryDisplaySchemeExtPlugin#isAutoAddSalaryItemType", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            isAutoSum.set(proxy.isAutoAddSalaryItemType());
            return null;
        });
        return isAutoSum.get();
    }

    private Map<String, RptDisplayColumnEntity> buildItemFirstNodes(boolean isDimItem, int defaultColWidth) {
        LinkedHashMap itemTypeNodeMap = Maps.newLinkedHashMapWithExpectedSize((int)4);
        for (Map.Entry itemEntityEntry : SalaryRptItemService.getItemEntityToFieldMap().entrySet()) {
            String entityCode = (String)itemEntityEntry.getKey();
            if (isDimItem && "hsbs_statisticstag".equals(entityCode)) continue;
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityCode);
            RptDisplayColumnEntity itemTypeNode = new RptDisplayColumnEntity();
            if (isDimItem) {
                itemTypeNode.setFieldValue("text_type_" + entityCode);
            } else {
                itemTypeNode.setFieldValue(entityCode);
            }
            itemTypeNode.setFieldName(dataEntityType.getDisplayName().toString());
            this.setDefaultFieldValue(itemTypeNode, defaultColWidth);
            itemTypeNodeMap.put(entityCode, itemTypeNode);
        }
        return itemTypeNodeMap;
    }

    protected void setDefaultFieldValue(RptDisplayColumnEntity entity, int defaultColWidth) {
        entity.setAlignment("default");
        entity.setColumnWidth(defaultColWidth);
        entity.setFieldAlias(entity.getFieldValue());
    }

    protected String getReportPermEntityCode() {
        RptTypeVo rptTypeVo = RptTypeHelper.querytRptTypeVo((String)this.getReportFormId());
        if (rptTypeVo == null) {
            return null;
        }
        return rptTypeVo.getPermEntityNum();
    }

    private static boolean isEnableWtcInte() {
        Map paramMap = SWCSalaryParameterServiceHelper.getSalaryParam((String)"wtcinte");
        boolean enableWtcInte = Boolean.FALSE;
        if (paramMap != null) {
            Boolean wtcinte = (Boolean)paramMap.get("enableWtcInte");
            Integer scheme = paramMap.getOrDefault("scheme", WtcInteCfgConstants.FIELD_SCHEME_THREE);
            if (wtcinte.booleanValue() && (WtcInteCfgConstants.FIELD_SCHEME_ONE.equals(scheme) || WtcInteCfgConstants.FIELD_SCHEME_TWO.equals(scheme))) {
                enableWtcInte = Boolean.TRUE;
            }
        }
        return enableWtcInte;
    }
}

