/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.report;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.base.BaseShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.FormRoot;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.report.ReportView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.swc.hsas.business.salaryrpt.SalaryRptService;
import kd.swc.hsas.common.enums.SalaryRptTypeEnum;
import kd.swc.hsbp.business.report.RptShowNodeVo;
import kd.swc.hsbp.business.report.RptTypeVo;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class SalaryRptAbstractForm
extends AbstractReportFormPlugin
implements ItemClickListener,
BeforeF7SelectListener,
BeforeFilterF7SelectListener {
    private static Log LOGGER = LogFactory.getLog(SalaryRptAbstractForm.class);

    public void initialize() {
        this.getView().addCustomControls(new String[]{"reportlistap"});
        RptTypeVo rptTypeVo = this.getRptTypeVo();
        String queryEntityCode = rptTypeVo.getQueryEntityNum();
        this.formatFilterGrid();
        FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
        filterGrid.setEntityNumber(queryEntityCode);
        this.setFilterFields(filterGrid);
        String permEntityCode = rptTypeVo.getPermEntityNum();
        this.getView().getFormShowParameter().setCustomParam("customHREntityNumber", (Object)permEntityCode);
        this.getView().getFormShowParameter().setCustomParam("customHRPermItemId", (Object)"47150e89000000ac");
        this.getView().getFormShowParameter().setCustomParam("custom_parent_f7_prop", (Object)"adminorg");
    }

    public void onGetControl(OnGetControlArgs e) {
        switch (e.getKey()) {
            case "reportlistap": {
                ReportList report = this.buildCustomerReport();
                e.setControl((Control)report);
                break;
            }
        }
    }

    public void registerListener(EventObject e) {
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit empgroup = (BasedataEdit)this.getControl("empgroup");
        empgroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit payRollGroup = (BasedataEdit)this.getControl("payrollgroup");
        payRollGroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit payRollScene = (BasedataEdit)this.getControl("payrollscene");
        payRollScene.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
        filterGrid.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
        BasedataEdit rptScheme = (BasedataEdit)this.getControl("displayscheme");
        rptScheme.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"lbl_display", "imgdisplay"});
    }

    public void afterBindData(EventObject e) {
        this.formatFilterGrid();
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject defaultSchemeObj = SalaryRptService.queryDefaultScheme((String)this.getView().getFormShowParameter().getFormId());
        this.getModel().setValue("displayscheme", Objects.isNull(defaultSchemeObj) ? null : Long.valueOf(defaultSchemeObj.getLong("id")));
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        String eventKey = eventArgs.getOperateKey();
        if ("donothing_setting".equals(eventKey)) {
            FormShowParameter currFormShowParameter = this.getView().getFormShowParameter();
            Map customParams = currFormShowParameter.getCustomParams();
            FormShowParameter showParameter = new FormShowParameter();
            customParams.put("isChange", Boolean.FALSE);
            customParams.put("reporttype", SalaryRptTypeEnum.getEnumByEntityCode((String)currFormShowParameter.getFormId()).getCode());
            showParameter.setFormId("hsas_salaryrptdisset");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "dispalySetting"));
            showParameter.setCustomParams(customParams);
            this.getView().showForm(showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        switch (event.getActionId()) {
            case "dispalySetting": {
                Map returnData = (Map)event.getReturnData();
                boolean isChange = MapUtils.getBooleanValue((Map)returnData, (Object)"isChange");
                if (!isChange) {
                    return;
                }
                this.getView().refresh();
                break;
            }
            case "rptSchemeApply": {
                SWCPageCache pageCache = new SWCPageCache((IFormView)this.getView());
                Boolean isChanged = (Boolean)pageCache.get("isChanged", Boolean.class);
                if (Objects.isNull(isChanged) || !isChanged.booleanValue()) {
                    return;
                }
                pageCache.remove("isChanged");
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent args) {
        ListShowParameter formShowParameter = (ListShowParameter)args.getFormShowParameter();
        formShowParameter.setCustomParam("isShowUsed", (Object)Boolean.FALSE);
        String permEntity = this.getRptTypeVo().getPermEntityNum();
        switch (args.getProperty().getName()) {
            case "org": {
                HasPermOrgResult hasPermOrgResult = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)permEntity, (String)"47150e89000000ac");
                if (hasPermOrgResult.hasAllOrgPerm()) break;
                formShowParameter.setCustomParam("range", (Object)hasPermOrgResult.getHasPermOrgs());
                break;
            }
            case "empgroup": {
                QFilter empGroupQfilter = this.getEmpgrpQfilter("hsas", "/UHMBBGZQ65X", permEntity);
                if (empGroupQfilter == null) break;
                formShowParameter.getListFilterParameter().setFilter(empGroupQfilter);
                break;
            }
            case "payrollgroup": {
                HasPermOrgResult orgResult = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)permEntity, (String)"47150e89000000ac");
                if (orgResult == null || orgResult.hasAllOrgPerm()) break;
                formShowParameter.getListFilterParameter().setFilter(new QFilter("org.id", "in", (Object)orgResult.getHasPermOrgs()));
                Set payRollIds = SWCPermissionServiceHelper.getPayrollGrpSetByPermItem((String)"/UHMBBGZQ65X", (String)permEntity, (String)"47150e89000000ac");
                if (null == payRollIds) break;
                QFilter payRollFilter = new QFilter("id", "in", (Object)payRollIds);
                formShowParameter.getListFilterParameter().setFilter(payRollFilter);
                break;
            }
            case "payrollscene": {
                HasPermOrgResult orgRst = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)permEntity, (String)"47150e89000000ac");
                if (orgRst == null || orgRst.hasAllOrgPerm()) break;
                formShowParameter.getListFilterParameter().setFilter(new QFilter("org.id", "in", (Object)orgRst.getHasPermOrgs()));
                Set payRollSceneIds = SWCPermissionServiceHelper.getPayrollSceneSetByPermItem((String)"/UHMBBGZQ65X", (String)permEntity, (String)"47150e89000000ac");
                if (null == payRollSceneIds) break;
                formShowParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)payRollSceneIds));
                break;
            }
            case "displayscheme": {
                QFilter qFilter = new QFilter("creator", "=", (Object)Long.valueOf(RequestContext.get().getUserId()));
                qFilter.and(new QFilter("reportformid", "=", (Object)this.getView().getFormShowParameter().getFormId()));
                formShowParameter.setCaption(ResManager.loadKDString((String)"\u62a5\u8868\u663e\u793a\u65b9\u6848", (String)"SalaryDetailFormRpt_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                formShowParameter.getListFilterParameter().setFilter(qFilter);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent arg0) {
        String permEntity = this.getRptTypeVo().getPermEntityNum();
        switch (arg0.getFieldName()) {
            case "caltask.name": {
                this.addOrgQFilter(permEntity, arg0);
                List calTaskFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"/UHMBBGZQ65X", (String)"hsas_calpayrolltask", (String)"47150e89000000ac");
                if (calTaskFilter != null) {
                    calTaskFilter.forEach(obj -> arg0.addCustomQFilter(obj));
                }
                arg0.addCustomParam("callFromRefBillEdit", (Object)Boolean.TRUE);
                break;
            }
            case "caltask.calrule.name": {
                arg0.addCustomParam("isShowUsed", (Object)Boolean.FALSE);
                HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)permEntity, (String)"47150e89000000ac");
                if (permOrgs == null || permOrgs.hasAllOrgPerm()) break;
                QFilter baseDataFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsas_calrule", (List)permOrgs.getHasPermOrgs(), (boolean)true);
                arg0.addCustomQFilter(baseDataFilter);
                break;
            }
            case "salaryfilev.salarycalcstyle.name": {
                QFilter salaryCalcStyleFilter;
                HasPermOrgResult hasPermOrgResult = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)permEntity, (String)"47150e89000000ac");
                if (hasPermOrgResult.hasAllOrgPerm() || (salaryCalcStyleFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsas_salarycalcstyle", (List)hasPermOrgResult.getHasPermOrgs(), (boolean)true)) == null) break;
                arg0.addCustomQFilter(salaryCalcStyleFilter);
                break;
            }
            case "empentrelv.enterprise.name": {
                QFilter enterPriseFilter;
                HasPermOrgResult orgResult = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)permEntity, (String)"47150e89000000ac");
                if (!orgResult.hasAllOrgPerm() && (enterPriseFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hbss_enterprise", (List)orgResult.getHasPermOrgs(), (boolean)true)) != null) {
                    arg0.addCustomQFilter(enterPriseFilter);
                }
                QFilter defaultFilter = new QFilter("status", "=", (Object)"C");
                defaultFilter.and("enable", "!=", (Object)"10");
                arg0.addCustomQFilter(defaultFilter);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "lbl_display": 
            case "imgdisplay": {
                BaseShowParameter showParameter = new BaseShowParameter();
                showParameter.setFormId(this.displaySchemeEntity());
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                DynamicObject schemeObj = (DynamicObject)this.getModel().getValue("displayscheme");
                if (!Objects.isNull(schemeObj)) {
                    showParameter.setPkId((Object)schemeObj.getString("id"));
                }
                showParameter.setCustomParam("reportformid", (Object)this.getView().getFormShowParameter().getFormId());
                showParameter.setCustomParam("schmview_hide", (Object)"false");
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "rptSchemeApply");
                showParameter.setCloseCallBack(closeCallBack);
                this.decorateSchemeShowParameter(showParameter);
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
        }
    }

    protected String displaySchemeEntity() {
        return "hsas_salaryrptdisplayschm";
    }

    protected void decorateSchemeShowParameter(BaseShowParameter showParameter) {
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        ReportView view = (ReportView)this.getView();
        Map customParam = queryParam.getCustomParam();
        customParam.put("pageid", view.getPageId());
        customParam.put("formid", this.getView().getFormShowParameter().getFormId());
        this.addCustomParamBeforeQuery(customParam);
        LOGGER.info("cyh: getFilterItems= {}", (Object)queryParam.getFilter().getFilterItems());
        LOGGER.info("cyh: getCommFilter= {}", (Object)queryParam.getFilter().getCommFilter());
        LOGGER.info("cyh: customParam= {}", (Object)customParam);
    }

    protected void addOrgQFilter(String permEntity, BeforeFilterF7SelectEvent arg0) {
        HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)permEntity, (String)"47150e89000000ac");
        if (permOrgs != null && !permOrgs.hasAllOrgPerm()) {
            arg0.addCustomQFilter(new QFilter("org.id", "in", (Object)permOrgs.getHasPermOrgs()));
        }
    }

    protected void addCustomParamBeforeQuery(Map<String, Object> customParam) {
    }

    protected void formatFilterGrid() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String openWay = (String)showParameter.getCustomParam("openway");
        if ("2".equals(openWay)) {
            return;
        }
        FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
        if (StringUtils.isEmpty((CharSequence)filterGrid.getEntityNumber())) {
            return;
        }
        Map<String, Object> nameMap = this.buildNameMap();
        List fieldColumns = filterGrid.getFilterColumns();
        for (Map map : fieldColumns) {
            String fieldName = (String)map.get("fieldName");
            String fieldCaption = (String)map.get("fieldCaption");
            Object nameObj = nameMap.get(fieldName);
            if (nameObj != null) {
                map.put("fieldCaption", nameObj);
                continue;
            }
            if (fieldCaption.indexOf(46) < 0) continue;
            int pointIndex = fieldCaption.indexOf(46);
            map.put("fieldCaption", fieldCaption.substring(0, pointIndex));
        }
    }

    private Map<String, Object> buildNameMap() {
        HashMap nameMap = Maps.newHashMapWithExpectedSize((int)16);
        List<RptShowNodeVo> moreFilterNodes = this.getMoreFilterNodes();
        if (CollectionUtils.isEmpty(moreFilterNodes)) {
            return nameMap;
        }
        for (RptShowNodeVo nodeVo : moreFilterNodes) {
            nameMap.put(nodeVo.getNumber(), nodeVo.getMoreFilterName());
        }
        return nameMap;
    }

    private void setFilterFields(FilterGrid filterGrid) {
        ArrayList<String> filterFileds = new ArrayList<String>();
        List<RptShowNodeVo> moreFilterNodes = this.getMoreFilterNodes();
        if (!CollectionUtils.isEmpty(moreFilterNodes)) {
            for (RptShowNodeVo nodeVo : moreFilterNodes) {
                filterFileds.add(nodeVo.getNumber());
            }
        }
        filterGrid.setFilterFieldKeys(filterFileds);
    }

    protected ReportList buildCustomerReport() {
        ReportList reportList = new ReportList();
        FormRoot rootControl = (FormRoot)this.getView().getRootControl();
        List items = rootControl.getItems();
        for (Control item : items) {
            if (!"reportlistap".equals(item.getKey())) continue;
            reportList = (ReportList)item;
            reportList.setHasSettingRow(false);
            break;
        }
        return reportList;
    }

    protected void addTotalSet(ReportQueryParam queryParam, Map<String, Object> displaySetMap) {
        boolean isShowTotal = MapUtils.getBooleanValue(displaySetMap, (Object)"isshowtotal", (boolean)true);
        FilterItemInfo totalItem = queryParam.getFilter().getFilterItem("isshowtotal");
        if (totalItem != null) {
            totalItem.setValue((Object)isShowTotal);
        } else {
            queryParam.getFilter().addFilterItem("isshowtotal", (Object)isShowTotal);
        }
    }

    protected void addSubTotalSet(ReportQueryParam queryParam, Map<String, Object> displaySetMap) {
        int sumType = MapUtils.getInteger(displaySetMap, (Object)"sumtype", (Integer)2);
        FilterItemInfo item = queryParam.getFilter().getFilterItem("sumtypesign");
        if (item != null) {
            item.setValue((Object)sumType);
        } else {
            queryParam.getFilter().addFilterItem("sumtypesign", (Object)sumType);
        }
    }

    protected SalaryRptTypeEnum getSalaryRptTypeEnum() {
        return SalaryRptTypeEnum.getEnumByEntityCode((String)this.getView().getFormShowParameter().getFormId());
    }

    protected Date getMonthFirstDay(Date period, int monthAmount) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(period);
        cal.add(2, monthAmount);
        cal.set(5, 1);
        return cal.getTime();
    }

    protected void resetControl(String[] openKeys, String[] offKeys) {
        for (String openKey : openKeys) {
            this.getView().setVisible(Boolean.TRUE, new String[]{openKey});
            ((FieldEdit)this.getControl(openKey)).setMustInput(true);
        }
        for (String offKey : offKeys) {
            this.getView().setVisible(Boolean.FALSE, new String[]{offKey});
            ((FieldEdit)this.getControl(offKey)).setMustInput(false);
            this.setValue(offKey, null);
        }
    }

    protected void setValue(String key, Object object) {
        this.getModel().setValue(key, object);
        this.getView().updateView(key);
    }

    protected QFilter getEmpgrpQfilter(String appNumber, String appId, String entityNumber) {
        Set empGroupSet;
        HRBaseServiceHelper hbssAppBusinessType = new HRBaseServiceHelper("hbss_appbusinesstype");
        QFilter appQFliter = new QFilter("app.number", "=", (Object)appNumber);
        QFilter typeEnableQFliter = new QFilter("enable", "=", (Object)"1");
        DynamicObject dynamicObject = hbssAppBusinessType.queryOriginalOne("businesstype", new QFilter[]{appQFliter.and(typeEnableQFliter)});
        QFilter empGroupQfilter = null;
        if (dynamicObject != null) {
            empGroupQfilter = new QFilter("bussinessfield", "=", (Object)dynamicObject.getLong("businesstype"));
        }
        if ((empGroupSet = SWCPermissionServiceHelper.getEmpgrpSetByPermItem((String)"/UHMBBGZQ65X", (String)entityNumber, (String)"47150e89000000ac")) != null) {
            if (empGroupQfilter == null) {
                empGroupQfilter = new QFilter("id", "in", (Object)empGroupSet);
            } else {
                empGroupQfilter.and("id", "in", (Object)empGroupSet);
            }
        }
        return empGroupQfilter;
    }

    protected RptTypeVo getRptTypeVo() {
        return SalaryRptService.getRptTypeVo((IPageCache)this.getView().getPageCache(), (String)this.getView().getFormShowParameter().getFormId());
    }

    protected List<RptShowNodeVo> getMoreFilterNodes() {
        return SalaryRptService.getMoreFilterNodes((IPageCache)this.getView().getPageCache(), (String)this.getView().getFormShowParameter().getFormId());
    }
}

