/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.report;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.salaryrpt.SalaryRptService;
import kd.swc.hsas.formplugin.web.report.SalarySchemeRptBaseForm;

public abstract class SalaryRptCiteBaseForm
extends SalarySchemeRptBaseForm {
    private static Log LOGGER = LogFactory.getLog(SalaryRptCiteBaseForm.class);
    private static Set<String> hasSubCountRptCodes = Sets.newHashSet((Object[])new String[]{"hsas_salarydetailrpt", "hsas_salarydetailrpt_inh"});

    @Override
    protected void addCustomParamBeforeQuery(Map<String, Object> customParam) {
        FormShowParameter showParam = this.getView().getFormShowParameter();
        String openWay = (String)showParam.getCustomParam("openway");
        if (openWay.equals("2")) {
            String formId;
            switch (formId = this.getView().getFormShowParameter().getFormId()) {
                case "hsas_salarydetailrpt_inh": {
                    customParam.put("formid", "hsas_salarydetailrpt");
                    break;
                }
                case "hsas_salarysumrpt_inh": {
                    customParam.put("formid", "hsas_salarysumrpt");
                    break;
                }
            }
        }
    }

    @Override
    protected boolean citeVerifyQuery(ReportQueryParam queryParam, FormShowParameter showParam) {
        QFilter filter;
        FilterInfo filterInfo = new FilterInfo();
        Long displaySchemeId = (Long)showParam.getCustomParam("displayscheme");
        if (displaySchemeId == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u663e\u793a\u65b9\u6848\u3002", (String)"SalarySumFormRpt_22", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject displayScheme = SalaryRptService.queryRptDisplaySchemeObj((Long)displaySchemeId);
        if (displayScheme == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8be5\u663e\u793a\u65b9\u6848\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u65b0\u7684\u65b9\u6848\u3002", (String)"SalarySumFormRpt_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return false;
        }
        Boolean isShowTotal = (Boolean)showParam.getCustomParam("isshowtotal");
        if (isShowTotal == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u662f\u5426\u663e\u793a\u603b\u8ba1\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SalarySumFormRpt_23", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return false;
        }
        Object currencyParam = showParam.getCustomParam("calcurrency");
        if (null == currencyParam) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6838\u7b97\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SalarySumFormRpt_57", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject calCurrency = (DynamicObject)SerializationUtils.deSerializeFromBase64((String)((String)currencyParam));
        if (hasSubCountRptCodes.contains(this.getView().getFormShowParameter().getFormId())) {
            String sumTypeSign = (String)showParam.getCustomParam("sumtypesign");
            if (StringUtils.isEmpty((CharSequence)sumTypeSign)) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u5c0f\u8ba1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SalaryDetailFormRpt_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                return false;
            }
            filterInfo.addFilterItem("sumtypesign", (Object)sumTypeSign);
        }
        if ((filter = (QFilter)SerializationUtils.fromJsonString((String)((String)showParam.getCustomParam("filter")), QFilter.class)) == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u67e5\u8be2\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SalarySumFormRpt_25", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return false;
        }
        filterInfo.addFilterItem("openway", showParam.getCustomParam("openway"));
        filterInfo.addFilterItem("displayscheme", (Object)displaySchemeId);
        filterInfo.addFilterItem("isshowtotal", (Object)isShowTotal);
        filterInfo.addFilterItem("calcurrency", (Object)calCurrency);
        filterInfo.setQFilters((List)Lists.newArrayList((Object[])new QFilter[]{filter}));
        queryParam.getCustomParam().put("queryItemIds", showParam.getCustomParam("queryItemIds"));
        queryParam.setFilter(filterInfo);
        LOGGER.info(filterInfo.toString());
        return true;
    }

    public void afterQuery(ReportQueryParam queryParam) {
        FormShowParameter showParam = this.getView().getFormShowParameter();
        String openWay = (String)showParam.getCustomParam("openway");
        if (openWay.equals("2")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"toolbarap"});
        }
    }
}

