/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.report;

import java.lang.constant.Constable;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.salaryrpt.SalaryRptService;
import kd.swc.hsas.common.enums.SalaryRptTypeEnum;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import org.apache.commons.collections.MapUtils;

public class SalaryRptDisplaySettingEdit
extends AbstractBasePlugIn {
    private static final String KEY_APPLY = "apply";
    private static final String KEY_APPLYANDSAVE = "applyandsave";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"hsas_salaryrptdisset");
        e.setNewEntityType(mainType);
    }

    public void afterCreateNewData(EventObject eo) {
        DynamicObject oldInfo;
        super.afterCreateNewData(eo);
        DynamicObject info = this.getModel().getDataEntity();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        int reportType = MapUtils.getIntValue((Map)customParams, (Object)"reporttype", (int)0);
        this.setTips(reportType);
        if (SalaryRptTypeEnum.SALARYSUMRPT.getCode() == reportType || SalaryRptTypeEnum.SALARYDIFFRPT.getCode() == reportType) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"sumtype"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexshowtotal"});
        }
        if (info.get("sumtype") == null) {
            info.set("sumtype", (Object)2);
        }
        if (info.get("reporttype") == null) {
            info.set("reporttype", (Object)reportType);
        }
        if (info.get("isshowtotal") == null) {
            info.set("isshowtotal", (Object)Boolean.TRUE);
        }
        if ((oldInfo = this.getCurrentUserSetting(reportType)) != null) {
            info.set("sumtype", oldInfo.get("sumtype"));
            info.set("reporttype", oldInfo.get("reporttype"));
            info.set("operateuser", oldInfo.get("operateuser"));
            info.set("isshowtotal", oldInfo.get("isshowtotal"));
        }
    }

    private void setTips(int reportType) {
        String content = null;
        switch (reportType) {
            case 1: {
                content = ResManager.loadKDString((String)"\u5c0f\u8ba1\uff1a\u5c06\u76f8\u540c\u90e8\u95e8\u7f16\u7801\u7684\u6570\u636e\u8fdb\u884c\u5408\u8ba1\uff0c\u5e76\u4f5c\u4e3a\u5c0f\u8ba1\u884c\u663e\u793a\u3002", (String)"SalaryRptDisplaySettingEdit_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                break;
            }
            case 2: {
                content = ResManager.loadKDString((String)"\u5c0f\u8ba1\uff1a\u5c06\u76f8\u540c\u5de5\u53f7\u7684\u6570\u636e\u8fdb\u884c\u5408\u8ba1\uff0c\u5e76\u4f5c\u4e3a\u5c0f\u8ba1\u884c\u663e\u793a\uff08\u67e5\u770b\u5c0f\u8ba1\u65f6\u4f1a\u4f7f\u7528\u7cfb\u7edf\u9ed8\u8ba4\u6392\u5e8f\uff09\u3002", (String)"SalaryRptDisplaySettingEdit_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                break;
            }
        }
        ComboEdit tipsControl = (ComboEdit)this.getControl("sumtype");
        Tips tips = new Tips("text", null, new LocaleString(content), false, null);
        tips.setTriggerType("hover");
        tipsControl.addTips(tips);
    }

    private DynamicObject getCurrentUserSetting(int reportType) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salaryrptdisset");
        String userIdStr = RequestContext.get().getUserId();
        Long userId = Long.valueOf(userIdStr);
        String field = "id,reporttype,sumtype,operateuser,isshowtotal";
        QFilter reporttype = new QFilter("reporttype", "=", (Object)String.valueOf(reportType));
        QFilter userFilter = new QFilter("operateuser.id", "=", (Object)userId);
        QFilter[] filters = new QFilter[]{userFilter, reporttype};
        DynamicObject oldInfo = helper.queryOne(field, filters);
        return oldInfo;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String button = evt.getItemKey();
        if (KEY_APPLY.equals(button)) {
            this.apply();
        }
        if (KEY_APPLYANDSAVE.equals(button)) {
            this.applyandsave();
        }
    }

    private boolean apply() {
        DynamicObject info = this.getModel().getDataEntity();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        int reportType = MapUtils.getIntValue((Map)customParams, (Object)"reporttype", (int)0);
        int sumtype = Integer.parseInt(info.get("sumtype") + "");
        boolean isShowTotal = Boolean.parseBoolean(info.get("isshowtotal") + "");
        HashMap<String, Constable> map = new HashMap<String, Constable>();
        map.put("reporttype", Integer.valueOf(reportType));
        map.put("sumtype", Integer.valueOf(sumtype));
        map.put("isshowtotal", Boolean.valueOf(isShowTotal));
        map.put("isLoad", Boolean.TRUE);
        SalaryRptService.updateDisplaySettingCache((IFormView)this.getView().getParentView(), map, (int)reportType);
        Map parentCustomParams = this.getView().getParentView().getFormShowParameter().getCustomParams();
        parentCustomParams.put("isChange", Boolean.TRUE);
        this.getView().returnDataToParent((Object)parentCustomParams);
        this.getView().close();
        return true;
    }

    private void applyandsave() {
        if (this.apply()) {
            this.save();
        }
    }

    private void save() {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salaryrptdisset");
        String userIdStr = RequestContext.get().getUserId();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        int reporttype = MapUtils.getIntValue((Map)customParams, (Object)"reporttype", (int)0);
        Long userId = Long.valueOf(userIdStr);
        DynamicObject info = this.getCurrentUserSetting(reporttype);
        if (info == null) {
            info = helper.generateEmptyDynamicObject();
        }
        IDataModel model = this.getModel();
        int sumtype = Integer.parseInt(model.getValue("sumtype") + "");
        boolean isShowTotal = Boolean.parseBoolean(model.getValue("isshowtotal") + "");
        info.set("reporttype", (Object)reporttype);
        info.set("sumtype", (Object)sumtype);
        info.set("operateuser", (Object)userId);
        info.set("isshowtotal", (Object)isShowTotal);
        helper.saveOne(info);
    }
}

