/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.salarydetailresult.mark;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.swc.hsas.business.salarydeatilresult.helper.SalaryDetailResultMarkListHelper;
import kd.swc.hsbp.business.log.SWCOpLogServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class SalaryDetailResultMarkListViewPlugin
extends SWCDataBaseEdit
implements HyperLinkClickListener {
    private static final String MARK_LIST_ENTRY = "marklistentry";
    private static final String DEL_MARK = "donothing_delmark";
    private static final String SAVE_MARK = "donothing_savemark";
    private static final String DEL_MARK_CALL_BACK = "delMarkCallBack";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(MARK_LIST_ENTRY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        this.loadMarkInfoToEntry();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String optKey = formOperate.getOperateKey();
        if (SWCStringUtils.equals((String)optKey, (String)DEL_MARK)) {
            this.delMarkCheck(args);
        } else if (SWCStringUtils.equals((String)optKey, (String)SAVE_MARK)) {
            this.saveMarkCheck(args);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String optKey = formOperate.getOperateKey();
        if (SWCStringUtils.equals((String)optKey, (String)SAVE_MARK)) {
            this.doSave();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId = event.getCallBackId();
        MessageBoxResult result = event.getResult();
        if (SWCStringUtils.equals((String)callBackId, (String)DEL_MARK_CALL_BACK) && MessageBoxResult.Yes.equals((Object)result)) {
            this.delSelectedMarkInfo();
            MultiLangEnumBridge enumBridge = new MultiLangEnumBridge("\u5220\u9664\u6807\u8bb0\u6210\u529f", "CalPersonMarkListPlugin_7", "swc-hsas-formplugin");
            SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)DEL_MARK, (String)"", (MultiLangEnumBridge)enumBridge, (String[])new String[0]);
        }
    }

    private void doSave() {
        DynamicObjectCollection markColl = this.getModel().getEntryEntity(MARK_LIST_ENTRY);
        int size = markColl.size();
        long[] markIds = new long[size];
        HashMap<Long, DynamicObject> updateMap = new HashMap<Long, DynamicObject>(16);
        for (int i = 0; i < size; ++i) {
            long markId;
            DynamicObject markObj = (DynamicObject)markColl.get(i);
            markIds[i] = markId = markObj.getLong("markid");
            updateMap.put(markId, markObj);
        }
        SalaryDetailResultMarkListHelper helper = new SalaryDetailResultMarkListHelper();
        helper.saveMarkInfo(markIds, updateMap);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"SalaryDetailResultMarkListViewPlugin_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        this.getView().updateView();
    }

    private void saveMarkCheck(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection markColl = this.getModel().getEntryEntity(MARK_LIST_ENTRY);
        if (markColl == null || markColl.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\uff0c\u65e0\u6cd5\u6267\u884c\u8be5\u64cd\u4f5c\u3002", (String)"SalaryDetailResultMarkListViewPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        int size = markColl.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject markObj = (DynamicObject)markColl.get(i);
            String markReason = markObj.getString("markreason").trim();
            if (!SWCStringUtils.isEmpty((String)markReason)) continue;
            String confirmTip = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7b2c%s\u884c\u6807\u8bb0\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SalaryDetailResultMarkListViewPlugin_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]), i + 1);
            this.getView().showErrorNotification(confirmTip);
            args.setCancel(true);
            return;
        }
    }

    private void delSelectedMarkInfo() {
        EntryGrid grid = (EntryGrid)this.getView().getControl(MARK_LIST_ENTRY);
        int[] selectRows = grid.getSelectRows();
        int size = selectRows.length;
        if (size == 0) {
            return;
        }
        DynamicObjectCollection markList = this.getModel().getEntryEntity(MARK_LIST_ENTRY);
        if (markList == null) {
            return;
        }
        long[] markIds = new long[size];
        for (int i = 0; i < size; ++i) {
            int index = selectRows[i];
            DynamicObject markObj = (DynamicObject)markList.get(index);
            markIds[i] = markObj.getLong("markid");
        }
        this.getModel().deleteEntryRows(MARK_LIST_ENTRY, selectRows);
        SalaryDetailResultMarkListHelper helper = new SalaryDetailResultMarkListHelper();
        helper.delMarkInfo(markIds);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"SalaryDetailResultMarkListViewPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
    }

    private void delMarkCheck(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection markColl = this.getModel().getEntryEntity(MARK_LIST_ENTRY);
        if (markColl == null || markColl.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\uff0c\u65e0\u6cd5\u6267\u884c\u8be5\u64cd\u4f5c\u3002", (String)"SalaryDetailResultMarkListViewPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        EntryGrid grid = (EntryGrid)this.getView().getControl(MARK_LIST_ENTRY);
        int[] selectRows = grid.getSelectRows();
        int size = selectRows.length;
        if (size == 0) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\u3002", (String)"SalaryDetailResultMarkListViewPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        args.setCancel(true);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u6807\u8bb0\u540e\u65e0\u6cd5\u6062\u590d\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5220\u9664\u6807\u8bb0\uff1f", (String)"SalaryDetailResultMarkListViewPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DEL_MARK_CALL_BACK));
    }

    private void loadMarkInfoToEntry() {
        Long calTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("calTaskId");
        if (calTaskId == null) {
            return;
        }
        SalaryDetailResultMarkListHelper helper = new SalaryDetailResultMarkListHelper();
        DynamicObject[] markColl = helper.getMarkInfoByCalTaskId(calTaskId);
        if (markColl == null || markColl.length == 0) {
            return;
        }
        Set calPersonIds = helper.getCalPersonIds(calTaskId);
        if (calPersonIds == null || calPersonIds.size() == 0) {
            return;
        }
        this.getModel().deleteEntryData(MARK_LIST_ENTRY);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("markreason", new Object[0]);
        vs.addField("marknum", new Object[0]);
        vs.addField("marktime", new Object[0]);
        vs.addField("isapproveshow", new Object[0]);
        vs.addField("markid", new Object[0]);
        for (DynamicObject dataObj : markColl) {
            String markReason = dataObj.getString("markreason");
            int markNum = 0;
            DynamicObjectCollection calPersonIdColl = dataObj.getDynamicObjectCollection("calpersonentry");
            for (DynamicObject calPersonIdObj : calPersonIdColl) {
                long calPersonId = calPersonIdObj.getLong("calpersonid");
                if (!calPersonIds.contains(calPersonId)) continue;
                ++markNum;
            }
            if (markNum == 0) continue;
            Date markTime = dataObj.getDate("createtime");
            String isApproveShow = dataObj.getString("isapproveshow");
            long markId = dataObj.getLong("id");
            vs.addRow(new Object[]{markReason, markNum, markTime, isApproveShow, markId});
        }
        model.batchCreateNewEntryRow(MARK_LIST_ENTRY, vs);
        model.endInit();
        this.getView().updateView(MARK_LIST_ENTRY);
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        String field = arg0.getFieldName();
        if (SWCStringUtils.equals((String)field, (String)"marknum")) {
            int index = arg0.getRowIndex();
            this.markNumClickEvent(index);
        }
    }

    private void markNumClickEvent(int rowIndex) {
        DynamicObjectCollection dataColl = this.getModel().getEntryEntity(MARK_LIST_ENTRY);
        if (rowIndex > dataColl.size() - 1) {
            return;
        }
        SalaryDetailResultMarkListHelper helper = new SalaryDetailResultMarkListHelper();
        DynamicObject dataObj = (DynamicObject)dataColl.get(rowIndex);
        long markId = dataObj.getLong("markid");
        DynamicObject calPersonInfo = helper.getCalPersonIdsByMarkId(markId);
        if (calPersonInfo == null) {
            return;
        }
        DynamicObjectCollection calPersonEntryColl = calPersonInfo.getDynamicObjectCollection("calpersonentry");
        if (calPersonEntryColl == null || calPersonEntryColl.size() == 0) {
            return;
        }
        ArrayList<Long> calPersonIdList = new ArrayList<Long>(10);
        for (DynamicObject calPersonObj : calPersonEntryColl) {
            calPersonIdList.add(calPersonObj.getLong("calpersonid"));
        }
        IFormView parentView = this.getView().getParentView();
        SWCPageCache pageCache = new SWCPageCache(parentView);
        pageCache.put(parentView.getPageId() + "_cacheCalPersonIds", (Object)((Object)calPersonIdList).toString());
        this.getView().close();
    }
}

