/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.salaryfile;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsas.business.salaryfile.SalaryFileEmpPosOrgRelHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCJSONUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class EmpPosOrgRelEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(EmpPosOrgRelEdit.class);
    private static final String CALLBACKID_BEFOREEMPSTARTDATE = "callback_beforeEmpStartDate_save";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        SWCPageCache pageCache = new SWCPageCache(this.getView().getParentView());
        Map pageIds = (Map)pageCache.get("pageids", Map.class);
        if (pageIds != null) {
            String filepageid = (String)pageIds.get("hsas_salaryfile");
            SWCPermissionServiceHelper.checkCancelDataAndFunctionRightWithException((IFormView)this.getView().getView(filepageid), (boolean)true);
        }
        BasedataEdit workrole = (BasedataEdit)this.getView().getControl("workrole");
        workrole.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String status = (String)this.getView().getFormShowParameter().getCustomParam("status");
        String isOnlyView = (String)this.getView().getFormShowParameter().getCustomParam("isOnlyView");
        if ("true".equals(isOnlyView) || !"C".equalsIgnoreCase(status)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"modify"});
        }
        this.updateEntryEntityView();
    }

    private void updateEntryEntityView() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return;
        }
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
            String isMainWorkRole = dynamicObject.getString("ismainworkrole");
            if (!"1".equals(isMainWorkRole)) continue;
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"workrole"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        FormOperate source = (FormOperate)args.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "donothing_modifyentry": {
                this.modifyEntry(args);
                break;
            }
            case "donothing_cancel": {
                this.cancelEntry(args);
                break;
            }
            case "donothing_addnew": {
                this.showAddNewF7(args);
                break;
            }
            case "save": {
                this.onBeforeSave(args);
                break;
            }
        }
    }

    private void onBeforeSave(BeforeDoOperationEventArgs args) {
        Save source1 = (Save)args.getSource();
        OperateOption option = source1.getOption();
        option.setVariableValue("isValidate", "false");
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity("entryentity");
        Boolean validate = Boolean.TRUE;
        for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(i);
            Date payStartDate = dynamicObject.getDate("paystartdate");
            Date payEndDate = dynamicObject.getDate("payenddate");
            validate = this.validatePayStartDate(payStartDate, i) != false && validate != false;
            validate = this.validatePayEndDate(payEndDate, i) != false && validate != false;
        }
        args.setCancel(validate == false);
        if (args.isCancel()) {
            return;
        }
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        Boolean isContinue = (Boolean)pageCache.get(CALLBACKID_BEFOREEMPSTARTDATE, Boolean.class);
        if (isContinue != null && isContinue.booleanValue()) {
            pageCache.remove(CALLBACKID_BEFOREEMPSTARTDATE);
            return;
        }
        StringBuilder sb = new StringBuilder();
        String confirmMsgTpl = ResManager.loadKDString((String)"{0}\uff1a\u7b97\u85aa\u5f00\u59cb\u65e5\u671f\u8d85\u51fa\u6240\u9009\u5c97\u4f4d\u7684\u65e5\u671f\u8303\u56f4\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"EmpPosOrgRelEdit_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(i);
            if ("1".equals(dynamicObject.getString("ismainworkrole"))) continue;
            Date payStartDate = dynamicObject.getDate("paystartdate");
            DynamicObject workRole = (DynamicObject)this.getModel().getValue("workrole", i);
            Date startDate = workRole.getDate("startdate");
            Date endDate = workRole.getDate("enddate");
            startDate = startDate != null ? SalaryFileEmpPosOrgRelHelper.getDateDay((Date)startDate) : startDate;
            endDate = endDate != null ? SalaryFileEmpPosOrgRelHelper.getDateDay((Date)endDate) : endDate;
            Boolean overFlag = Boolean.FALSE;
            if (payStartDate != null && startDate != null && endDate != null && (SWCDateTimeUtils.dayBefore((Date)payStartDate, (Date)startDate) || SWCDateTimeUtils.dayAfter((Date)payStartDate, (Date)endDate))) {
                overFlag = Boolean.TRUE;
            }
            if (!overFlag.booleanValue()) continue;
            if (sb.length() >= 1) {
                sb.append(ResManager.loadKDString((String)"\u3001", (String)"PersonImportEntityMapping_8", (String)"swc-hsas-business", (Object[])new Object[0]));
            }
            sb.append(workRole.getString("number"));
        }
        if (sb.length() >= 1) {
            String confirmMsg = MessageFormat.format(confirmMsgTpl, sb.toString());
            this.getView().showConfirm(confirmMsg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CALLBACKID_BEFOREEMPSTARTDATE, (IFormPlugin)this));
            args.setCancel(true);
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        EntryProp entryProp = e.getEntryProp();
        if ("entryentity".equals(entryProp.getName())) {
            // empty if block
        }
    }

    private void onBeforeEntryEntityDeleteRow(BeforeDeleteRowEventArgs e) {
        int[] rowIndexs = e.getRowIndexs();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        HashMap<Long, Integer> mainWorkRoleCount = new HashMap<Long, Integer>(entryEntity.size());
        for (DynamicObject dynamicObject : entryEntity) {
            long workRoleId;
            if (!"1".equals(dynamicObject.getString("ismainworkrole")) || (workRoleId = dynamicObject.getLong("workrole.id")) == 0L) continue;
            Integer count = mainWorkRoleCount.getOrDefault(workRoleId, 0);
            count = count + 1;
            mainWorkRoleCount.put(workRoleId, count);
        }
        for (Object rowIndex : (Object)rowIndexs) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get((int)rowIndex);
            if (!"1".equals(dynamicObject.getString("ismainworkrole")) || 1 != (Integer)mainWorkRoleCount.get(dynamicObject.getLong("workrole.id"))) continue;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u884c\u653f\u7ec4\u7ec7\u4e3a\u4e3b\u8981\u5c97\u4f4d\uff0c\u4e0d\u80fd\u5220\u9664\uff1b\u82e5\u9700\u8981\u5220\u9664\uff0c\u8bf7\u4fee\u6539\u85aa\u8d44\u6863\u6848\u57fa\u7840\u4fe1\u606f\u3002", (String)"EmpPosOrgRelEdit_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            break;
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId;
        super.closedCallBack(event);
        switch (actionId = event.getActionId()) {
            case "CALLBACK_ADD_NEW_DEPEMP_ENTRY": {
                this.onDepempF7Closed(event);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        IDataEntityProperty property = e.getProperty();
        switch (name = property.getName()) {
            case "paystartdate": {
                this.onPayStartDateChanged(e);
                break;
            }
            case "payenddate": {
                this.onPayEndDateChanged(e);
                break;
            }
            case "workrole": {
                this.onWorkRoleChanged(e);
                break;
            }
        }
    }

    private void onWorkRoleChanged(PropertyChangedArgs e) {
        ChangeData changeSet = e.getChangeSet()[0];
        DynamicObject newValue = (DynamicObject)changeSet.getNewValue();
        DynamicObject oldValue = (DynamicObject)changeSet.getOldValue();
        if (oldValue == null) {
            this.getModel().setValue("paystartdate", (Object)newValue.getDate("startdate"));
            return;
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("oldValue", oldValue);
        data.put("newValue", newValue);
        data.put("newStartDateValue", newValue == null ? null : newValue.getDate("startdate"));
        data.put("rowIndex", changeSet.getRowIndex());
        try {
            this.getView().getPageCache().put("CACHE_CALLBACK_WORK_ROLE_CHANGED_DATA", SWCJSONUtils.toString(data));
        }
        catch (IOException ex) {
            LOGGER.info("parse json error.", (Object)ex);
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u66f4\u6539\u5c97\u4f4d\uff0c\u4f1a\u66f4\u65b0\u201c\u7b97\u85aa\u5f00\u59cb\u65e5\u671f\u201d\u548c\u201c\u7b97\u85aa\u7ed3\u675f\u65e5\u671f\u201d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"EmpPosOrgRelEdit_9", (String)"swc-hsas-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("CALLBACK_WORK_ROLE_CHANGED"));
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("CALLBACK_WORK_ROLE_CHANGED".equals(callBackId)) {
            this.onWorkRoleConfirmCallBack(messageBoxClosedEvent);
        }
        if (CALLBACKID_BEFOREEMPSTARTDATE.equals(callBackId)) {
            this.confirmAfterBeforeEmpStartDate(messageBoxClosedEvent);
        }
    }

    private void confirmAfterBeforeEmpStartDate(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            SWCPageCache pageCache = new SWCPageCache(this.getView());
            pageCache.put(CALLBACKID_BEFOREEMPSTARTDATE, (Object)Boolean.TRUE);
            String callBackId = messageBoxClosedEvent.getCallBackId();
            if (CALLBACKID_BEFOREEMPSTARTDATE.equals(callBackId)) {
                this.getView().invokeOperation("save");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onWorkRoleConfirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        Map cast = null;
        try {
            String workRoleDataStr = this.getView().getPageCache().get("CACHE_CALLBACK_WORK_ROLE_CHANGED_DATA");
            if (SWCStringUtils.isEmpty((String)workRoleDataStr)) {
                return;
            }
            cast = (Map)SWCJSONUtils.cast((String)workRoleDataStr, Map.class);
        }
        catch (IOException e) {
            LOGGER.info("parse json error.");
        }
        finally {
            this.getView().getPageCache().remove("CACHE_CALLBACK_WORK_ROLE_CHANGED_DATA");
        }
        if (CollectionUtils.isEmpty(cast)) {
            return;
        }
        Integer rowIndex = (Integer)cast.get("rowIndex");
        if (MessageBoxResult.Yes.equals((Object)result)) {
            Map newValue = (Map)cast.get("newValue");
            this.getModel().beginInit();
            if (newValue == null) {
                this.getModel().setValue("ismainworkrole", null, rowIndex.intValue());
            } else {
                Long id = (Long)newValue.get("id");
                Set<Long> mainWorkRoleIdSet = this.getMainWorkRoleIdSet();
                this.getModel().setValue("ismainworkrole", (Object)Character.valueOf(mainWorkRoleIdSet.contains(id) ? (char)'1' : '0'), rowIndex.intValue());
            }
            this.getModel().endInit();
            Long newStartDateValue = (Long)cast.get("newStartDateValue");
            this.getModel().setValue("paystartdate", (Object)(newStartDateValue == null ? null : new Date(newStartDateValue)), rowIndex.intValue());
            this.getModel().setValue("payenddate", null, rowIndex.intValue());
        } else {
            Map oldValue = (Map)cast.get("oldValue");
            this.getModel().beginInit();
            if (oldValue == null) {
                this.getModel().setValue("workrole", null, rowIndex.intValue());
            } else {
                this.getModel().setValue("workrole", oldValue.get("id"), rowIndex.intValue());
            }
            this.getModel().endInit();
        }
        this.getView().updateView("entryentity");
        this.updateEntryEntityView();
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String name;
        IDataEntityProperty property = event.getProperty();
        switch (name = property.getName()) {
            case "workrole": {
                List customQFilters = event.getCustomQFilters();
                customQFilters.add(this.getAddNewQfilter());
                break;
            }
        }
    }

    private void onPayEndDateChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        Date oldValue = (Date)changeSet[0].getOldValue();
        Date newValue = (Date)changeSet[0].getNewValue();
        int rowIndex = changeSet[0].getRowIndex();
        this.validatePayEndDate(newValue, rowIndex);
    }

    private Boolean validatePayEndDate(Date newValue, int rowIndex) {
        Date payStartDate = (Date)this.getModel().getValue("paystartdate", rowIndex);
        DynamicObject workRole = (DynamicObject)this.getModel().getValue("workrole", rowIndex);
        Boolean result = Boolean.TRUE;
        if (workRole == null) {
            return result;
        }
        newValue = newValue != null ? SalaryFileEmpPosOrgRelHelper.getDateDay((Date)newValue) : null;
        payStartDate = payStartDate != null ? SalaryFileEmpPosOrgRelHelper.getDateDay((Date)payStartDate) : null;
        result = this.validateBeforeAndNotify(newValue, payStartDate, "payenddate", ResManager.loadKDString((String)"{0}\uff1a\u7b97\u85aa\u7ed3\u675f\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u7b97\u85aa\u5f00\u59cb\u65e5\u671f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"EmpPosOrgRelEdit_0", (String)"swc-hsas-formplugin", (Object[])new Object[]{workRole.getString("number")})) != false && result != false;
        Date startDate = workRole.getDate("startdate");
        startDate = startDate != null ? SalaryFileEmpPosOrgRelHelper.getDateDay((Date)startDate) : null;
        result = this.validateBeforeAndNotify(newValue, startDate, "payenddate", ResManager.loadKDString((String)"{0}\uff1a\u7b97\u85aa\u7ed3\u675f\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u5f00\u59cb\u65e5\u671f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"EmpPosOrgRelEdit_1", (String)"swc-hsas-formplugin", (Object[])new Object[]{workRole.getString("number")})) != false && result != false;
        Date earliestBsedDate = this.getEarliestBsedDate();
        result = this.validateBeforeAndNotify(newValue, earliestBsedDate, "payenddate", ResManager.loadKDString((String)"{0}\uff1a\u7b97\u85aa\u7ed3\u675f\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u85aa\u8d44\u6863\u6848\u7684\u6700\u65e9\u751f\u6548\u65e5\u671f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"EmpPosOrgRelEdit_2", (String)"swc-hsas-formplugin", (Object[])new Object[]{workRole.getString("number")})) != false && result != false;
        return result;
    }

    private void onPayStartDateChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        Date oldValue = (Date)changeSet[0].getOldValue();
        Date newValue = (Date)changeSet[0].getNewValue();
        int rowIndex = changeSet[0].getRowIndex();
        this.validatePayStartDate(newValue, rowIndex);
    }

    private Boolean validatePayStartDate(Date newValue, int rowIndex) {
        Boolean result = Boolean.TRUE;
        DynamicObject workRole = (DynamicObject)this.getModel().getValue("workrole", rowIndex);
        if (workRole == null) {
            return result;
        }
        newValue = newValue != null ? SalaryFileEmpPosOrgRelHelper.getDateDay((Date)newValue) : null;
        Date payEndDate = (Date)this.getModel().getValue("payenddate", rowIndex);
        payEndDate = payEndDate != null ? SalaryFileEmpPosOrgRelHelper.getDateDay((Date)payEndDate) : null;
        result = this.validateAfterAndNotify(newValue, payEndDate, "paystartdate", ResManager.loadKDString((String)"{0}\uff1a\u7b97\u85aa\u7ed3\u675f\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u7b97\u85aa\u5f00\u59cb\u65e5\u671f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"EmpPosOrgRelEdit_3", (String)"swc-hsas-formplugin", (Object[])new Object[]{workRole.getString("number")})) != false && result != false;
        Date earliestBsedDate = this.getEarliestBsedDate();
        result = this.validateBeforeAndNotify(newValue, earliestBsedDate, "paystartdate", ResManager.loadKDString((String)"{0}\uff1a\u7b97\u85aa\u5f00\u59cb\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u85aa\u8d44\u6863\u6848\u7684\u6700\u65e9\u751f\u6548\u65e5\u671f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"EmpPosOrgRelEdit_4", (String)"swc-hsas-formplugin", (Object[])new Object[]{workRole.getString("number")})) != false && result != false;
        return result;
    }

    private Boolean validateBeforeAndNotify(Date first, Date second, String fieldName, String msg) {
        if (first == null || second == null) {
            return Boolean.TRUE;
        }
        if (first.before(second)) {
            this.getView().showErrorNotification(msg);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Boolean validateAfterAndNotify(Date first, Date second, String fieldName, String msg) {
        if (first == null || second == null) {
            return Boolean.TRUE;
        }
        if (first.after(second)) {
            this.getView().showErrorNotification(msg);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Date getEarliestBsedDate() {
        Date date = this.getModel().getDataEntity().getDate("salaryfile.firstbsed");
        return SalaryFileEmpPosOrgRelHelper.getDateDay((Date)date);
    }

    private DynamicObject[] getSalaryFiles() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String salaryFileId = (String)customParams.get("salaryfileid");
        if (SWCStringUtils.isEmpty((String)salaryFileId)) {
            return null;
        }
        SWCDataServiceHelper swcDataServiceHelper = new SWCDataServiceHelper("hsas_salaryfile");
        DynamicObject[] query = swcDataServiceHelper.query("id,name,number,bsed", new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(salaryFileId))}, "bsed asc");
        return query;
    }

    private void onDepempF7Closed(ClosedCallBackEvent event) {
        ListSelectedRowCollection returnDatas = (ListSelectedRowCollection)event.getReturnData();
        if (CollectionUtils.isEmpty((Collection)returnDatas)) {
            return;
        }
        List<Long> selectIds = returnDatas.stream().map(item -> (Long)item.getPrimaryKeyValue()).collect(Collectors.toList());
        this.addSubEntryEntity(selectIds);
    }

    private void addSubEntryEntity(List<Long> selectIds) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        Set<Long> mainWorkRoleIdSet = this.getMainWorkRoleIdSet();
        SWCDataServiceHelper depEmpOrm = new SWCDataServiceHelper("hsas_depemp");
        DynamicObject[] query = depEmpOrm.query("id,number,startdate", new QFilter[]{new QFilter("id", "in", selectIds)});
        Map depEmpIdMap = Arrays.stream(query).collect(Collectors.toMap(item -> item.getLong("id"), Function.identity(), (first, second) -> first));
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("workrole", new Object[0]);
        setter.addField("ismainworkrole", new Object[0]);
        setter.addField("paystartdate", new Object[0]);
        for (Long selectId : selectIds) {
            DynamicObject depEmp = (DynamicObject)depEmpIdMap.get(selectId);
            if (depEmp == null) continue;
            setter.addRow(new Object[]{selectId, Character.valueOf(mainWorkRoleIdSet.contains(selectId) ? (char)'1' : '0'), depEmp.getDate("startdate")});
        }
        model.batchCreateNewEntryRow("entryentity", setter);
        model.endInit();
        this.getView().updateView("entryentity");
        this.updateEntryEntityView();
    }

    private Set<Long> getMainWorkRoleIdSet() {
        Set mainWorkRoleIdSet = null;
        long salaryFileId = this.getModel().getDataEntity().getLong("salaryfile.id");
        Map mainWorkRoleBySalaryFileIds = SalaryFileEmpPosOrgRelHelper.getMainWorkRoleBySalaryFileIds(Collections.singletonList(salaryFileId));
        if (!CollectionUtils.isEmpty((Map)mainWorkRoleBySalaryFileIds)) {
            mainWorkRoleIdSet = (Set)mainWorkRoleBySalaryFileIds.get(salaryFileId);
        }
        if (mainWorkRoleIdSet == null) {
            return Collections.emptySet();
        }
        return mainWorkRoleIdSet;
    }

    private void showAddNewF7(BeforeDoOperationEventArgs args) {
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"hsas_depemp", (boolean)true, (int)2, (boolean)true);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "CALLBACK_ADD_NEW_DEPEMP_ENTRY"));
        ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
        listFilterParameter.getQFilters().add(this.getAddNewQfilter());
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private QFilter getAddNewQfilter() {
        String personIdStr = (String)this.getView().getFormShowParameter().getCustomParam("personhrid");
        if (SWCStringUtils.isEmpty((String)personIdStr)) {
            return null;
        }
        QFilter classifyNumberFilter = new QFilter("otclassify.id", "in", (Object)new Long[]{1010L});
        QFilter personIdQFilter = new QFilter("person.id", "=", (Object)Long.valueOf(personIdStr));
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        ArrayList<Long> workRoleIds = new ArrayList<Long>(10);
        workRoleIds.addAll(entryEntity.stream().map(item -> item.getLong("workrole.id")).collect(Collectors.toList()));
        workRoleIds.addAll(this.getMainWorkRoleIdSet());
        QFilter existWorkRoleIdQFilter = new QFilter("id", "in", workRoleIds);
        QFilter timeRemainedQFilter = new QFilter("istimeremained", "!=", (Object)"0");
        return classifyNumberFilter.and(personIdQFilter).and(existWorkRoleIdQFilter.or(timeRemainedQFilter));
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "save": {
                this.saveEntry(args);
                break;
            }
        }
    }

    private void modifyEntry(BeforeDoOperationEventArgs args) {
        this.setStatusEdit();
    }

    private void saveEntry(AfterDoOperationEventArgs args) {
        if (args.getOperationResult().isSuccess()) {
            this.setStatusView();
        }
    }

    private void cancelEntry(BeforeDoOperationEventArgs args) {
        this.setStatusView();
    }

    private void setStatusView() {
        this.setStatus(OperationStatus.VIEW);
    }

    private void setStatusEdit() {
        this.setStatus(OperationStatus.EDIT);
    }

    private void setStatus(OperationStatus view) {
        this.getView().getFormShowParameter().setStatus(view);
        this.getView().invokeOperation("refresh");
    }
}

