/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.salaryfile;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsas.business.salaryfile.ImportRowEntity;
import kd.swc.hsas.business.salaryfile.SalaryFileImportDataOperate;
import kd.swc.hsas.formplugin.web.salaryfile.SalaryFileBlockBatchImportPlugin;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class PaySettingBatchImportPlugin
extends BatchImportPlugin {
    private static final Log LOGGER = LogFactory.getLog(PaySettingBatchImportPlugin.class);
    private static final String IMPORT_TYPE_NEW = "new";
    private static final String IMPORT_TYPE_OVERRIDE = "override";
    private static final String IMPORT_TYPE_OVERRIDENEW = "overridenew";
    private static final String SALARYFILE = "salaryfile";
    private static final String ENTRYENTITY = "entryentity";
    private static final String KEYFIELDS = "KeyFields";
    private static final String IMPORTTYPE = "importtype";
    private static final int BATCH_IMPORT_SIZE = 500;
    private long totalSpendTime = 0L;
    private long totalImportCount = 0L;

    public String getBillFormId() {
        return super.getBillFormId();
    }

    protected boolean isForceBatch() {
        return true;
    }

    protected int getBatchImportSize() {
        return 500;
    }

    public List<ComboItem> getOverrideFieldsConfig() {
        String billFormId = this.getBillFormId();
        String displayName = "";
        if (SWCStringUtils.equals((String)"hsas_paysetting", (String)billFormId)) {
            displayName = ResManager.loadKDString((String)"\u85aa\u8d44\u53d1\u653e\u8bbe\u7f6e", (String)"PaySettingBatchImportPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        }
        LOGGER.info("PaySettingBatchImportPlugin displayName:{}", (Object)displayName);
        return Collections.singletonList(new ComboItem(new LocaleString(displayName), "number"));
    }

    protected ApiResult save(List<ImportBillData> bills, ImportLogger logger) {
        LOGGER.error("-----------save()-----------------");
        HashMap<String, ImportRowEntity> rightBillMaps = new HashMap<String, ImportRowEntity>(16);
        HashSet<String> repeatBills = new HashSet<String>(16);
        ImportRowEntity rowInfo = null;
        for (ImportBillData rowData : bills) {
            String errorMsg;
            int index;
            Map logCache = logger.getLogCache();
            List logList = (List)logCache.get(index = rowData.getStartIndex());
            if (logList != null && logList.size() > 0) {
                logger.tick();
                logger.fail();
                continue;
            }
            JSONObject rowDataData = rowData.getData();
            JSONObject jsonSalaryFile = rowDataData.getJSONObject(SALARYFILE);
            if (jsonSalaryFile == null) {
                errorMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4eba\u5458\u85aa\u8d44\u6863\u6848\u4e3a\u7a7a,\u5bfc\u5165\u5931\u8d25\u3002", (String)"PaySettingBatchImportPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]), this.mainEntityType.getDisplayName());
                SalaryFileImportDataOperate.log((int)index, (String)errorMsg, (ImportLogger)logger);
                continue;
            }
            JSONObject data = new JSONObject(new LinkedHashMap());
            data.put(SALARYFILE, (Object)jsonSalaryFile);
            data.put(ENTRYENTITY, rowDataData.get((Object)ENTRYENTITY));
            data.put("rowNum", rowDataData.get((Object)"rowNum"));
            rowData.setData(data);
            String salaryFileNumber = jsonSalaryFile.getString("number");
            if (!rightBillMaps.containsKey(salaryFileNumber)) {
                rowInfo = new ImportRowEntity(rowData.getStartIndex(), rowData.getEndIndex(), data);
                rightBillMaps.put(salaryFileNumber, rowInfo);
                continue;
            }
            repeatBills.add(salaryFileNumber);
            errorMsg = String.format(ResManager.loadKDString((String)"\u4e00\u4efd\u4eba\u5458\u85aa\u8d44\u6863\u6848\u4e00\u6b21\u53ea\u80fd\u5bfc\u5165\u4e00\u4efd\u6570\u636e\u3002\u6863\u6848\u201c%s\u201d\u5b58\u5728\u591a\u4efd\u6570\u636e\uff0c\u5bfc\u5165\u5931\u8d25\u3002", (String)"PaySettingBatchImportPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]), salaryFileNumber, this.mainEntityType.getDisplayName());
            SalaryFileImportDataOperate.log((int)index, (String)errorMsg, (ImportLogger)logger);
            SalaryFileImportDataOperate.log((int)((ImportRowEntity)rightBillMaps.get(salaryFileNumber)).getRowIndex(), (String)errorMsg, (ImportLogger)logger);
        }
        for (String number : repeatBills) {
            rightBillMaps.remove(number);
        }
        List<ImportRowEntity> rightBills = rightBillMaps.values().stream().collect(Collectors.toList());
        int rightBillsSize = rightBills.size();
        RequestContext rc = RequestContext.get();
        MainEntityType mainEntityType = super.buildMainEntityType(null);
        if (rightBillsSize > 0) {
            LOGGER.info("PaySettingBatchImportPlugin MutiThreadValidator begin 1-1");
            Future futureResult = SWCThreadPoolFactory.getCommonImportThreadpool().submit((Callable)new SalaryFileBlockBatchImportPlugin.MutiThreadValidator(mainEntityType, rightBills, logger, this.ctx, rc));
            try {
                List rowInfos = (List)futureResult.get();
                LOGGER.info("PaySettingBatchImportPlugin filterImportableData begin 1-2");
                SalaryFileImportDataOperate.filterImportableData((MainEntityType)mainEntityType, (List)rowInfos, (ImportLogger)logger);
                LOGGER.info("PaySettingBatchImportPlugin verifyAddOrUpdateImport begin 1-3");
                this.verifyAddOrUpdateImport(rowInfos, mainEntityType, logger);
                LOGGER.info("PaySettingBatchImportPlugin executeImportData begin 1-4");
                SalaryFileImportDataOperate.executeImportData((MainEntityType)mainEntityType, (List)rowInfos, (ImportContext)this.ctx, (ImportLogger)logger);
                LOGGER.info("PaySettingBatchImportPlugin wrapLineErrorInfo begin 1-5");
                this.wrapLineErrorInfo(logger);
                LOGGER.info("PaySettingBatchImportPlugin wrapLineErrorInfo end 1-6");
            }
            catch (InterruptedException | ExecutionException e) {
                LOGGER.error("mutil thread validate error : ", (Throwable)e);
            }
        }
        return null;
    }

    private void wrapLineErrorInfo(ImportLogger logger) {
        Map logCache = logger.getLogCache();
        if (CollectionUtils.isEmpty((Map)logCache)) {
            return;
        }
        for (Map.Entry entry : logCache.entrySet()) {
            List value = (List)entry.getValue();
            String strip = StringUtils.strip((String)value.toString(), (String)"[]");
            strip = strip.replaceAll(";", "\r\n");
            ArrayList<ImportLogger.ImportLog> importLogs = new ArrayList<ImportLogger.ImportLog>(10);
            importLogs.add(new ImportLogger.ImportLog(strip));
            entry.setValue(importLogs);
        }
    }

    private void verifyAddOrUpdateImport(List<ImportRowEntity> rowInfos, MainEntityType mainEntityType, ImportLogger logger) {
        String importType;
        switch (importType = (String)this.ctx.getOption().get(IMPORTTYPE)) {
            case "new": {
                this.verifyUpdateNewAddImport(rowInfos, mainEntityType, logger);
                break;
            }
        }
    }

    private void verifyUpdateNewAddImport(List<ImportRowEntity> rowInfos, MainEntityType mainEntityType, ImportLogger logger) {
        String entityId = mainEntityType.getName();
        Map<Long, List<DynamicObject>> salaryfileSubordinateMap = SalaryFileBlockBatchImportPlugin.getSalaryfileSubordinate(rowInfos, mainEntityType);
        for (ImportRowEntity rowInfo : rowInfos) {
            DynamicObject entityDyobj = rowInfo.getEntityDyobj(entityId);
            this.setEntityFiledValue(entityDyobj);
            DynamicObject salaryfileDyObj = entityDyobj.getDynamicObject(SALARYFILE);
            if (salaryfileDyObj == null) continue;
            String salaryfileNumber = salaryfileDyObj.getString("number");
            Long salaryfileId = salaryfileDyObj.getLong("id");
            List<DynamicObject> salaryfileSubordinates = salaryfileSubordinateMap.get(salaryfileId);
            if (salaryfileSubordinates != null && salaryfileSubordinates.size() > 1) {
                String errorMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u85aa\u8d44\u6863\u6848\uff1a%s\u5b58\u5728\u591a\u6761\u8bb0\u5f55\u3002", (String)"SalaryFileBlockBatchImportPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]), salaryfileNumber);
                SalaryFileImportDataOperate.log((int)rowInfo.getRowIndex(), (String)errorMsg, (ImportLogger)logger);
                continue;
            }
            if (salaryfileSubordinates == null || salaryfileSubordinates.size() != 1) continue;
            DynamicObject salaryfileSubordinateDyObj = salaryfileSubordinates.get(0);
            rowInfo.putEntityDyobj(salaryfileNumber, salaryfileSubordinateDyObj);
            rowInfo.putStoreMap("isLastVersion", (Object)Boolean.TRUE);
        }
    }

    private void setEntityFiledValue(DynamicObject entityDyobj) {
        entityDyobj.set("ismanuallymodify", (Object)Boolean.TRUE);
        DynamicObjectCollection collection = entityDyobj.getDynamicObjectCollection(ENTRYENTITY);
        for (int index = 0; index < collection.size(); ++index) {
            DynamicObject payObj = (DynamicObject)collection.get(index);
            String salaryItemName = payObj.getString("salaryitem.name");
            String salaryItemMark = payObj.getString("salaryitemmark");
            if ("1".equals(salaryItemMark)) {
                payObj.set("salaryitemshow", (Object)(SWCStringUtils.isEmpty((String)salaryItemName) ? salaryItemMark : salaryItemName));
            } else {
                payObj.set("salaryitemshow", (Object)salaryItemMark);
            }
            payObj.set("seq", (Object)(index + 1));
        }
    }
}

