/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.salaryfile;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.salaryfile.ImportRowEntity;
import kd.swc.hsas.business.salaryfile.SalaryFileImportDataOperate;
import kd.swc.hsas.formplugin.web.salaryfile.SalaryFileBlockBatchImportPlugin;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import kd.swc.hsbp.common.util.SWCMServiceUtils;

public class PersonBankCardImportPlugin
extends BatchImportPlugin {
    private static final Log LOGGER = LogFactory.getLog(PersonBankCardImportPlugin.class);
    private static final int BATCH_IMPORT_SIZE = 500;
    private static final String KEY_ID = "id";
    private static final String KEY_USER_NAME = "username";
    private static final String KEY_ACCOUNT_NAME = "accountname";
    private static final String KEY_BANK_DEPOSIT_ID = "bankdeposit.id";
    private static final String KEY_CARD_PURPOSE = "cardpurpose";
    private static final String KEY_CARD_PURPOSE_ID = "cardpurpose.id";
    private static final String KEY_ACCOUNT_RELATION_ID = "accountrelation.id";
    private static final String KEY_BANK_CARD_NUM = "bankcardnum";
    private static final String KEY_DESCRIPTION = "description";
    private static final String KEY_EMPLOYEE_ID = "employee.id";
    private static final String KEY_PERSON_ID = "person.id";
    private static final String KEY_NUMBER = "number";
    private static final String KEY_HRPI = "hrpi";
    private static final String KEY_HRPI_PER_BANK_CARD = "hrpi_perbankcard";
    private static final String KEY_PER_BANK_CARD_SERVICE = "IHRPIPerBankCardService";
    private static final String KEY_ADD_PER_BANK_CARD_NO_PER = "addPerBankCardNoPer";

    public String getBillFormId() {
        return super.getBillFormId();
    }

    protected boolean isForceBatch() {
        return true;
    }

    protected int getBatchImportSize() {
        return 500;
    }

    protected ApiResult save(List<ImportBillData> bills, ImportLogger logger) {
        LOGGER.error("-----------save()-----------------");
        ArrayList<ImportRowEntity> rightBills = new ArrayList<ImportRowEntity>(10);
        for (ImportBillData rowData : bills) {
            int index;
            Map logCache = logger.getLogCache();
            List logList = (List)logCache.get(index = rowData.getStartIndex());
            if (logList != null && logList.size() > 0) {
                logger.tick();
                logger.fail();
                continue;
            }
            ImportRowEntity rowInfo = new ImportRowEntity(rowData.getStartIndex(), rowData.getEndIndex(), rowData.getData());
            rightBills.add(rowInfo);
        }
        RequestContext rc = RequestContext.get();
        MainEntityType mainEntityType = super.buildMainEntityType(null);
        Future futureResult = SWCThreadPoolFactory.getCommonImportThreadpool().submit((Callable)new SalaryFileBlockBatchImportPlugin.MutiThreadValidator(mainEntityType, rightBills, logger, this.ctx, rc));
        try {
            List rowInfos = (List)futureResult.get();
            List importableRowInfos = SalaryFileImportDataOperate.filterImportableData((MainEntityType)mainEntityType, (List)rowInfos, (ImportLogger)logger);
            PersonBankCardImportPlugin.dealImportableData(importableRowInfos, mainEntityType, logger);
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.error("mutil thread validate error : ", (Throwable)e);
        }
        return null;
    }

    private static void dealImportableData(List<ImportRowEntity> importableRowInfos, MainEntityType mainEntityType, ImportLogger logger) {
        Long employeeId;
        ORM orm = ORM.create();
        long[] perBankCardIds = orm.genLongIds(KEY_HRPI_PER_BANK_CARD, importableRowInfos.size());
        int index = 0;
        String currEntity = mainEntityType.getName();
        ArrayList<int[]> rows = new ArrayList<int[]>(10);
        ArrayList bankCardList = new ArrayList(16);
        HashMap<Long, Long> employeePersonMap = new HashMap<Long, Long>(16);
        List employeeIdList = importableRowInfos.stream().map(importableRowInfo -> importableRowInfo.getEntityDyobj(currEntity).getLong(KEY_EMPLOYEE_ID)).collect(Collectors.toList());
        SWCDataServiceHelper emlployeeHelper = new SWCDataServiceHelper("hrpi_employee");
        QFilter employeeFilter = new QFilter(KEY_ID, "in", employeeIdList);
        employeeFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        DynamicObject[] employeeResults = emlployeeHelper.query("id,person.id", new QFilter[]{employeeFilter});
        for (DynamicObject employeeResult : employeeResults) {
            employeeId = employeeResult.getLong(KEY_ID);
            Long personId = employeeResult.getLong(KEY_PERSON_ID);
            employeePersonMap.put(employeeId, personId);
        }
        for (ImportRowEntity importableRowInfo2 : importableRowInfos) {
            HashMap<String, Object> variableMap = new HashMap<String, Object>(16);
            DynamicObject dynamicObject = importableRowInfo2.getEntityDyobj(currEntity);
            employeeId = dynamicObject.getLong(KEY_EMPLOYEE_ID);
            rows.add(new int[]{importableRowInfo2.getRowIndex(), importableRowInfo2.getEndRowIndex()});
            variableMap.put(KEY_ID, perBankCardIds[index++]);
            variableMap.put(KEY_USER_NAME, dynamicObject.getString(KEY_ACCOUNT_NAME));
            variableMap.put(KEY_BANK_DEPOSIT_ID, dynamicObject.getLong(KEY_BANK_DEPOSIT_ID));
            List cardPurposeList = dynamicObject.getDynamicObjectCollection(KEY_CARD_PURPOSE).stream().map(obj -> obj.getLong(KEY_ID)).collect(Collectors.toList());
            variableMap.put(KEY_CARD_PURPOSE_ID, cardPurposeList);
            variableMap.put(KEY_ACCOUNT_RELATION_ID, dynamicObject.getLong(KEY_ACCOUNT_RELATION_ID));
            variableMap.put(KEY_BANK_CARD_NUM, dynamicObject.getString(KEY_BANK_CARD_NUM));
            variableMap.put(KEY_DESCRIPTION, dynamicObject.getString(KEY_DESCRIPTION));
            variableMap.put(KEY_EMPLOYEE_ID, employeeId);
            variableMap.put(KEY_PERSON_ID, employeePersonMap.get(employeeId));
            bankCardList.add(variableMap);
        }
        try {
            boolean isSuccess = (Boolean)SWCMServiceUtils.invokeHRMPService((String)KEY_HRPI, (String)KEY_PER_BANK_CARD_SERVICE, (String)KEY_ADD_PER_BANK_CARD_NO_PER, (Object[])new Object[]{bankCardList});
            if (isSuccess) {
                List delRows = logger.getDelRows();
                delRows.addAll(rows);
                logger.setDelRows(delRows);
            } else {
                SalaryFileImportDataOperate.log((int)0, (String)ResManager.loadKDString((String)"\u5bfc\u5165\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PersonBankCardImportPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]), (ImportLogger)logger);
            }
        }
        catch (Exception e) {
            LOGGER.error("import data error, msg: ", (Throwable)e);
            SalaryFileImportDataOperate.log((int)0, (String)e.getMessage(), (ImportLogger)logger);
        }
    }
}

