/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.salaryfile;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.swc.hsas.business.bankoffer.vo.BaseDataConverter;
import kd.swc.hsas.business.salaryfile.SalaryTaxFileRelServiceHelper;
import kd.swc.hsas.business.salaryfile.SalaryTaxFileRelViewHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;

public class SalaryTaxFileRelList
extends HRDataBaseList {
    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        ListShowParameter listShowParameter = (ListShowParameter)e.getSource();
        listShowParameter.setMultiSelect(false);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        long taxFileId;
        args.setCancel(true);
        ListView listView = (ListView)this.getView();
        if (!SalaryTaxFileRelViewHelper.hasTaxFileQueryPerm()) {
            listView.getParentView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u4eba\u5458\u4e2a\u7a0e\u6863\u6848\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\u3002", (String)"TaxFileEdit_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            listView.sendFormAction(listView.getParentView());
            return;
        }
        SWCDataServiceHelper dataServiceHelper = new SWCDataServiceHelper("hsas_salarytaxfilerel");
        String pkId = String.valueOf(listView.getFocusRowPkId());
        DynamicObject dynamicObject = dataServiceHelper.queryOne("id,taxfile,salaryfile.payrollregion", (Object)pkId);
        long l = taxFileId = dynamicObject == null ? 0L : dynamicObject.getLong("taxfile");
        if (taxFileId == 0L) {
            listView.getParentView().showErrorNotification(ResManager.loadKDString((String)"\u5173\u8054\u5173\u7cfb\u5df2\u88ab\u5220\u9664\u3002", (String)"TaxFileEdit_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            listView.sendFormAction(listView.getParentView());
            return;
        }
        SalaryTaxFileRelViewHelper.showTaxFilePreview((long)taxFileId, (long)dynamicObject.getLong("salaryfile.payrollregion.id"), (int)0, (IFormView)listView, (boolean)false);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new DataProviderImpl());
    }

    private class DataProviderImpl
    extends ListDataProvider {
        private DataProviderImpl() {
        }

        public List<ListField> getListFields() {
            List result = super.getListFields();
            Map<String, ListField> fieldMap = result.stream().collect(Collectors.toMap(ListField::getKey, e -> e, (k1, k2) -> k1));
            if (!fieldMap.containsKey("taxfile")) {
                ListField taxFile = new ListField();
                taxFile.setKey("taxfile");
                taxFile.setListFieldKey("taxfile");
                taxFile.setFieldName("taxfile");
                DynamicProperty property = EntityMetadataCache.getDataEntityType((String)"hsas_salarytaxfilerel").getProperty("taxfile");
                taxFile.setSrcFieldProp((IDataEntityProperty)property);
                taxFile.setEntityName("hsas_salarytaxfilerel");
                result.add(taxFile);
            }
            return result;
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection data = super.getData(0, this.getMaxCount());
            if (CollectionUtils.isEmpty((Collection)data)) {
                return data;
            }
            Long regionId = (Long)BaseDataConverter.convert((Object)SalaryTaxFileRelList.this.getView().getFormShowParameter().getCustomParam("regionId"), Long.class);
            List fileIds = data.stream().map(e -> e.getLong("taxfile")).collect(Collectors.toList());
            boolean isShowStopTax = (Boolean)SalaryTaxFileRelList.this.getView().getFormShowParameter().getCustomParam("isShowStopTax");
            List<ListField> listFields = this.getListFields();
            Set props = listFields.stream().filter(e -> e.getListFieldKey().startsWith("taxfiletmp.")).map(e -> e.getListFieldKey().substring(11)).map(e -> {
                int index = e.indexOf(46);
                if (index > 0) {
                    return e.substring(0, index);
                }
                return e;
            }).collect(Collectors.toSet());
            BasedataProp taxFileTmpProp = (BasedataProp)data.getDynamicObjectType().getProperty("taxfiletmp");
            IDataEntityType type = taxFileTmpProp.getComplexType();
            DataEntityPropertyCollection properties = type.getProperties();
            Map fileInfos = SalaryTaxFileRelServiceHelper.findTaxFiles((long)regionId, fileIds, props, (boolean)isShowStopTax, (boolean)false);
            Iterator iterator = data.iterator();
            while (iterator.hasNext()) {
                DynamicObject next = (DynamicObject)iterator.next();
                DynamicObject object = (DynamicObject)fileInfos.get(next.getLong("taxfile"));
                if (object == null) {
                    iterator.remove();
                    continue;
                }
                if (!isShowStopTax && "0".equals(object.getString("taxstatus"))) {
                    iterator.remove();
                    continue;
                }
                Object instance = type.createInstance();
                for (IDataEntityProperty property : properties) {
                    Object value = property.getValue((Object)object);
                    if (value instanceof DynamicObject && property instanceof BasedataProp) {
                        this.copyProp((BasedataProp)property, (DynamicObject)value, instance);
                        continue;
                    }
                    property.setValue(instance, value);
                }
                taxFileTmpProp.setValue((Object)next, instance);
            }
            this.getQueryResult().setCollection(data);
            this.getQueryResult().setDataCount(data.size());
            if (start > 0 || data.size() > limit) {
                int index = 0;
                int end = start + limit;
                Iterator filterIter = data.iterator();
                while (filterIter.hasNext()) {
                    filterIter.next();
                    if (index < start || index > end) {
                        iterator.remove();
                    }
                    ++index;
                }
            }
            return data;
        }

        private void copyProp(BasedataProp property, DynamicObject value, Object instance) {
            IDataEntityType complexType = property.getComplexType();
            Object val = complexType.createInstance();
            property.setValue(instance, val);
            DataEntityPropertyCollection properties = complexType.getProperties();
            for (IDataEntityProperty prop : properties) {
                Object tempVal = prop.getValue((Object)value);
                if (tempVal instanceof DynamicObject && prop instanceof BasedataProp) {
                    this.copyProp((BasedataProp)prop, (DynamicObject)tempVal, val);
                    continue;
                }
                prop.setValue(val, tempVal);
            }
        }
    }
}

